/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.swt.event.mouse;

import com.metsci.glimpse.canvas.GlimpseCanvas;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.event.mouse.GlimpseMouseEvent;
import com.metsci.glimpse.event.mouse.MouseWrapper;
import com.metsci.glimpse.event.mouse.Mouseable;
import com.metsci.glimpse.swt.event.mouse.GlimpseMouseWrapper;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class MouseWrapperSWT
extends MouseWrapper<MouseEvent>
implements MouseListener,
MouseMoveListener,
MouseTrackListener,
MouseWheelListener {
    public MouseWrapperSWT(GlimpseCanvas canvas) {
        super(canvas);
    }

    protected boolean isInterior(MouseEvent e, GlimpseBounds bounds) {
        GlimpseBounds canvasBounds = this.canvas.getTargetBounds();
        return bounds.contains(e.x, canvasBounds.getHeight() - e.y);
    }

    protected boolean isButtonDown(MouseEvent e) {
        return (e.stateMask & SWT.BUTTON_MASK) > 0;
    }

    protected boolean isValid(MouseEvent e, GlimpseBounds bounds) {
        return e.getSource() instanceof Control;
    }

    protected MouseEvent toLocalCoords(MouseEvent e, GlimpseTargetStack stack) {
        if (stack == null) {
            return null;
        }
        GlimpseBounds bounds = stack.getBounds();
        if (bounds == null) {
            return null;
        }
        if (!(e.getSource() instanceof Control)) {
            return null;
        }
        Rectangle parentBounds = ((Control)e.getSource()).getBounds();
        int parentHeight = parentBounds.height;
        Event localEvent = new Event();
        localEvent.x = e.x - bounds.getX();
        localEvent.y = e.y - (parentHeight - (bounds.getY() + bounds.getHeight()));
        localEvent.button = e.button;
        localEvent.count = e.count;
        localEvent.display = e.display;
        localEvent.stateMask = e.stateMask;
        localEvent.time = e.time;
        localEvent.widget = e.widget;
        localEvent.data = stack;
        return new MouseEvent(localEvent);
    }

    protected GlimpseMouseEvent toGlimpseEvent(MouseEvent event) {
        return GlimpseMouseWrapper.fromMouseEvent(event);
    }

    protected GlimpseMouseEvent toLocalGlimpseWheelEvent(MouseEvent e, GlimpseTargetStack stack) {
        return GlimpseMouseWrapper.fromMouseWheelEvent(this.toLocalCoords(e, stack));
    }

    public void mouseEnter(MouseEvent event) {
        List list = this.getContainingTargets(event);
        if (list == null) {
            return;
        }
        for (GlimpseTargetStack stack : list) {
            Mouseable mouseTarget = this.getMouseTarget(stack);
            if (mouseTarget == null) {
                return;
            }
            GlimpseMouseEvent glimpseEvent = this.toLocalGlimpseEvent(event, stack);
            mouseTarget.mouseEntered(glimpseEvent);
        }
    }

    public void mouseExit(MouseEvent event) {
        List list = this.getContainingTargets(event);
        if (list == null) {
            return;
        }
        for (GlimpseTargetStack stack : list) {
            Mouseable mouseTarget = this.getMouseTarget(stack);
            if (mouseTarget == null) {
                return;
            }
            GlimpseMouseEvent glimpseEvent = this.toLocalGlimpseEvent(event, stack);
            mouseTarget.mouseExited(glimpseEvent);
        }
    }

    public void mouseHover(MouseEvent e) {
    }

    public void mouseMove(MouseEvent event) {
        if (!this.isButtonDown(event)) {
            this.clearHovered();
        }
        this.getContainingTargets(event);
        if (this.isHovered()) {
            Set hoveredList = this.getHovered();
            for (GlimpseTargetStack hoveredStack : hoveredList) {
                Mouseable mouseHoveredTarget = this.getMouseTarget(hoveredStack);
                GlimpseMouseEvent glimpseHoveredEvent = this.toLocalGlimpseEvent(event, hoveredStack);
                if (mouseHoveredTarget == null) continue;
                mouseHoveredTarget.mouseMoved(glimpseHoveredEvent);
            }
        }
    }

    public void mouseScrolled(MouseEvent event) {
        List list = this.getContainingTargets(event);
        if (list == null) {
            return;
        }
        for (GlimpseTargetStack stack : list) {
            Mouseable mouseTarget = this.getMouseTarget(stack);
            if (mouseTarget == null) {
                return;
            }
            GlimpseMouseEvent glimpseEvent = this.toLocalGlimpseWheelEvent(event, stack);
            mouseTarget.mouseWheelMoved(glimpseEvent);
        }
    }

    public void mouseDoubleClick(MouseEvent event) {
    }

    public void mouseDown(MouseEvent event) {
        List list = this.getContainingTargets(event);
        if (list == null) {
            return;
        }
        this.setHovered(list);
        for (GlimpseTargetStack stack : list) {
            Mouseable mouseTarget = this.getMouseTarget(stack);
            if (mouseTarget == null) {
                return;
            }
            GlimpseMouseEvent glimpseEvent = this.toLocalGlimpseEvent(event, stack);
            mouseTarget.mousePressed(glimpseEvent);
        }
    }

    public void mouseUp(MouseEvent event) {
        if (this.isHovered()) {
            Set hoveredList = this.getHovered();
            for (GlimpseTargetStack hoveredStack : hoveredList) {
                Mouseable mouseTarget = this.getMouseTarget(hoveredStack);
                GlimpseMouseEvent glimpseEvent = this.toLocalGlimpseEvent(event, hoveredStack);
                if (mouseTarget == null) continue;
                mouseTarget.mouseReleased(glimpseEvent);
            }
        }
        this.getContainingTargets(event);
    }
}

