/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.swt.event.mouse;

import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.event.mouse.GlimpseMouseEvent;
import com.metsci.glimpse.event.mouse.ModifierKey;
import com.metsci.glimpse.event.mouse.MouseButton;
import java.util.EnumSet;
import org.eclipse.swt.events.MouseEvent;

public class GlimpseMouseWrapper {
    private GlimpseMouseWrapper() {
    }

    public static GlimpseMouseEvent fromMouseEvent(MouseEvent event) {
        int x = event.x;
        int y = event.y;
        int clickCount = event.count;
        EnumSet<MouseButton> buttons = GlimpseMouseWrapper.getMouseButtons(event);
        EnumSet<ModifierKey> modifiers = GlimpseMouseWrapper.getModifierKeys(event);
        GlimpseTargetStack stack = null;
        if (event.data instanceof GlimpseTargetStack) {
            stack = (GlimpseTargetStack)event.data;
        }
        return new GlimpseMouseEvent(stack, modifiers, buttons, x, y, 0, clickCount);
    }

    public static GlimpseMouseEvent fromMouseWheelEvent(MouseEvent event) {
        int x = event.x;
        int y = event.y;
        int clickCount = -event.count / 3;
        EnumSet<MouseButton> buttons = GlimpseMouseWrapper.getMouseButtons(event);
        EnumSet<ModifierKey> modifiers = GlimpseMouseWrapper.getModifierKeys(event);
        GlimpseTargetStack stack = null;
        if (event.data instanceof GlimpseTargetStack) {
            stack = (GlimpseTargetStack)event.data;
        }
        return new GlimpseMouseEvent(stack, modifiers, buttons, x, y, clickCount, 0);
    }

    public static EnumSet<MouseButton> getMouseButtons(MouseEvent event) {
        EnumSet<MouseButton> buttons;
        switch (event.button) {
            case 1: {
                buttons = EnumSet.of(MouseButton.Button1);
                break;
            }
            case 2: {
                buttons = EnumSet.of(MouseButton.Button2);
                break;
            }
            case 3: {
                buttons = EnumSet.of(MouseButton.Button3);
                break;
            }
            default: {
                buttons = EnumSet.noneOf(MouseButton.class);
            }
        }
        if ((event.stateMask & 0x80000) != 0) {
            buttons.add(MouseButton.Button1);
        }
        if ((event.stateMask & 0x100000) != 0) {
            buttons.add(MouseButton.Button2);
        }
        if ((event.stateMask & 0x200000) != 0) {
            buttons.add(MouseButton.Button3);
        }
        return buttons;
    }

    public static EnumSet<ModifierKey> getModifierKeys(MouseEvent event) {
        EnumSet<ModifierKey> modifiers = EnumSet.noneOf(ModifierKey.class);
        if ((event.stateMask & 0x10000) != 0) {
            modifiers.add(ModifierKey.Alt);
        }
        if ((event.stateMask & 0x40000) != 0) {
            modifiers.add(ModifierKey.Ctrl);
        }
        if ((event.stateMask & 0x400000) != 0) {
            modifiers.add(ModifierKey.Meta);
        }
        if ((event.stateMask & 0x20000) != 0) {
            modifiers.add(ModifierKey.Shift);
        }
        return modifiers;
    }
}

