/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.swt.canvas;

import com.metsci.glimpse.canvas.GlimpseCanvas;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.context.GlimpseContextImpl;
import com.metsci.glimpse.context.GlimpseTarget;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.gl.GLListenerInfo;
import com.metsci.glimpse.gl.GLSimpleListener;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.support.settings.LookAndFeel;
import com.metsci.glimpse.swt.canvas.GLSimpleSwtCanvas;
import com.metsci.glimpse.swt.event.mouse.MouseWrapperSWT;
import com.metsci.glimpse.swt.misc.CursorUtil;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.media.opengl.GLContext;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SwtGlimpseCanvas
extends GLSimpleSwtCanvas
implements GlimpseCanvas {
    protected Composite parent;
    protected Cursor canvasCursor;
    protected List<GlimpseTarget> unmodifiableList;
    protected List<GlimpseLayout> layoutList;
    protected MouseWrapperSWT mouseHelper;
    protected boolean isEventConsumer = true;
    protected boolean isEventGenerator = true;

    public SwtGlimpseCanvas(Composite _parent) {
        this(_parent, null, 262144);
    }

    public SwtGlimpseCanvas(Composite _parent, GLContext _context) {
        this(_parent, _context, 262144);
    }

    public SwtGlimpseCanvas(Composite _parent, GLContext _context, int options) {
        super(_parent, _context, options, new GLSimpleListener[0]);
        this.parent = _parent;
        this.layoutList = new ArrayList<GlimpseLayout>();
        this.unmodifiableList = Collections.unmodifiableList(this.layoutList);
        this.mouseHelper = new MouseWrapperSWT(this);
        this.addMouseListener(this.mouseHelper);
        this.addMouseMoveListener(this.mouseHelper);
        this.addMouseWheelListener(this.mouseHelper);
        this.addMouseTrackListener(this.mouseHelper);
        this.addFocusListener((Control)this);
        this.setPlotAreaCursor(CursorUtil.crosshairs(_parent.getDisplay()));
        this.addListener(new GLSimpleListener(){

            public void init(GLContext context) {
            }

            public void display(GLContext context) {
                for (GlimpseLayout layout : SwtGlimpseCanvas.this.layoutList) {
                    layout.paintTo(SwtGlimpseCanvas.this.getGlimpseContext());
                }
            }

            public void reshape(GLContext context, int x, int y, int width, int height) {
                for (GlimpseLayout layout : SwtGlimpseCanvas.this.layoutList) {
                    layout.layoutTo(SwtGlimpseCanvas.this.getGlimpseContext());
                }
            }

            public void displayChanged(GLContext context, boolean modeChanged, boolean deviceChanged) {
            }

            public void dispose(GLContext context) {
            }

            public boolean isDisposed() {
                return false;
            }

            public GLListenerInfo getInfo() {
                return null;
            }
        });
    }

    public GlimpseContext getGlimpseContext() {
        return new GlimpseContextImpl((GlimpseCanvas)this);
    }

    public void setLookAndFeel(LookAndFeel laf) {
        for (GlimpseLayout layout : this.layoutList) {
            layout.setLookAndFeel(laf);
        }
    }

    public void addLayout(GlimpseLayout layout) {
        this.layoutList.add(layout);
    }

    public void removeLayout(GlimpseLayout layout) {
        this.layoutList.remove(layout);
    }

    public List<GlimpseTarget> getTargetChildren() {
        return this.unmodifiableList;
    }

    public Dimension getDimension() {
        if (!this.isDisposed()) {
            Rectangle rect = this.getClientArea();
            return new Dimension(rect.width, rect.height);
        }
        return null;
    }

    public GlimpseBounds getTargetBounds(GlimpseTargetStack stack) {
        Dimension dimension = this.getDimension();
        if (dimension != null) {
            return new GlimpseBounds(this.getDimension());
        }
        return null;
    }

    public GlimpseBounds getTargetBounds() {
        return this.getTargetBounds(null);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.canvasCursor.dispose();
    }

    public void paint() {
        if (!this.parent.isDisposed()) {
            this.parent.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!SwtGlimpseCanvas.this.parent.isDisposed()) {
                        SwtGlimpseCanvas.this.draw();
                    }
                }
            });
        }
    }

    public void setPlotAreaCursor(Cursor cursor) {
        this.canvasCursor = cursor;
        this.setCursor(this.canvasCursor);
    }

    protected void addFocusListener(final Control control) {
        control.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
                control.setFocus();
            }

            public void mouseExit(MouseEvent e) {
            }

            public void mouseHover(MouseEvent e) {
            }
        });
    }

    public String toString() {
        return SwtGlimpseCanvas.class.getSimpleName();
    }

    public boolean isEventConsumer() {
        return this.isEventConsumer;
    }

    public void setEventConsumer(boolean consume) {
        this.isEventConsumer = consume;
    }

    public boolean isEventGenerator() {
        return this.isEventGenerator;
    }

    public void setEventGenerator(boolean generate) {
        this.isEventGenerator = generate;
    }
}

