/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.swt.canvas;

import com.metsci.glimpse.canvas.GlimpseCanvas;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.context.GlimpseContextImpl;
import com.metsci.glimpse.context.GlimpseTarget;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.support.settings.LookAndFeel;
import com.metsci.glimpse.swt.canvas.SwtGlimpseCanvas;
import com.metsci.glimpse.swt.event.mouse.MouseWrapperSWTBridge;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLEventListener;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class SwtBridgeGlimpseCanvas
extends Composite
implements GlimpseCanvas {
    protected Frame glFrame;
    protected GLCanvas glCanvas;
    protected Composite parent;
    protected List<GlimpseTarget> unmodifiableList;
    protected List<GlimpseLayout> layoutList;
    protected MouseWrapperSWTBridge mouseHelper;
    protected boolean isEventConsumer = true;
    protected boolean isEventGenerator = true;

    public SwtBridgeGlimpseCanvas(Composite parent) {
        this(parent, null);
    }

    public SwtBridgeGlimpseCanvas(Composite parent, GLContext context) {
        this(parent, context, 0x1000000);
    }

    public SwtBridgeGlimpseCanvas(Composite parent, GLContext context, int style) {
        super(parent, style | 0x1000000);
        try {
            System.setProperty("sun.awt.noerasebackground", "true");
        }
        catch (SecurityException e) {
            // empty catch block
        }
        this.parent = parent;
        this.glCanvas = context == null ? new GLCanvas() : new GLCanvas(null, null, context, null);
        this.layoutList = new ArrayList<GlimpseLayout>();
        this.unmodifiableList = Collections.unmodifiableList(this.layoutList);
        this.mouseHelper = new MouseWrapperSWTBridge(this);
        this.glCanvas.addMouseListener((MouseListener)((Object)this.mouseHelper));
        this.glCanvas.addMouseMotionListener((MouseMotionListener)((Object)this.mouseHelper));
        this.glCanvas.addMouseWheelListener((MouseWheelListener)((Object)this.mouseHelper));
        this.addFocusListener();
        this.glFrame = SWT_AWT.new_Frame((Composite)this);
        this.glFrame.add((Component)this.glCanvas);
        this.addGLEventListener((GLAutoDrawable)this.glCanvas);
    }

    public GLCanvas getGLCanvas() {
        return this.glCanvas;
    }

    public GlimpseContext getGlimpseContext() {
        return new GlimpseContextImpl((GlimpseCanvas)this);
    }

    public void setLookAndFeel(LookAndFeel laf) {
        for (GlimpseLayout layout : this.layoutList) {
            layout.setLookAndFeel(laf);
        }
    }

    public void addLayout(GlimpseLayout layout) {
        this.layoutList.add(layout);
    }

    public void removeLayout(GlimpseLayout layout) {
        this.layoutList.remove(layout);
    }

    public List<GlimpseTarget> getTargetChildren() {
        return this.unmodifiableList;
    }

    public String toString() {
        return SwtGlimpseCanvas.class.getSimpleName();
    }

    public boolean isEventConsumer() {
        return this.isEventConsumer;
    }

    public void setEventConsumer(boolean consume) {
        this.isEventConsumer = consume;
    }

    public boolean isEventGenerator() {
        return this.isEventGenerator;
    }

    public void setEventGenerator(boolean generate) {
        this.isEventGenerator = generate;
    }

    public GlimpseBounds getTargetBounds(GlimpseTargetStack stack) {
        Dimension dimension = this.getDimension();
        if (dimension != null) {
            return new GlimpseBounds(this.getDimension());
        }
        return null;
    }

    public Dimension getDimension() {
        return this.glCanvas.getSize();
    }

    public GlimpseBounds getTargetBounds() {
        return this.getTargetBounds(null);
    }

    public GLContext getGLContext() {
        return this.glCanvas.getContext();
    }

    public void paint() {
        this.glCanvas.display();
    }

    protected void addFocusListener() {
        this.glCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void requestFocus() {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        SwtBridgeGlimpseCanvas.this.forceFocus();
                    }
                });
                SwtBridgeGlimpseCanvas.this.glCanvas.requestFocus();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.requestFocus();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.requestFocus();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.requestFocus();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.requestFocus();
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                this.requestFocus();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.requestFocus();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this.requestFocus();
            }
        });
    }

    private void addGLEventListener(GLAutoDrawable drawable) {
        drawable.addGLEventListener(new GLEventListener(){

            public void init(GLAutoDrawable drawable) {
            }

            public void display(GLAutoDrawable drawable) {
                for (GlimpseLayout layout : SwtBridgeGlimpseCanvas.this.layoutList) {
                    layout.paintTo(SwtBridgeGlimpseCanvas.this.getGlimpseContext());
                }
            }

            public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
                for (GlimpseLayout layout : SwtBridgeGlimpseCanvas.this.layoutList) {
                    layout.layoutTo(SwtBridgeGlimpseCanvas.this.getGlimpseContext());
                }
            }

            public void displayChanged(GLAutoDrawable drawable, boolean modeChanged, boolean deviceChanged) {
            }
        });
    }
}

