/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.swt.canvas;

import com.metsci.glimpse.gl.GLSimpleListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.opengl.GLCanvas;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class GLSimpleSwtCanvas
extends GLCanvas {
    private static final Logger logger = Logger.getLogger(GLSimpleSwtCanvas.class.getName());
    private final GLContext context;
    private final List<ListenerEntry> listeners;

    private static GLData glData() {
        GLData data = new GLData();
        data.doubleBuffer = true;
        return data;
    }

    public GLSimpleSwtCanvas(Composite parent, GLContext _context, int options, GLSimpleListener ... listeners) {
        super(parent, options, GLSimpleSwtCanvas.glData());
        this.setCurrent();
        if (_context == null) {
            this.context = GLDrawableFactory.getFactory().createExternalGLContext();
        } else {
            GLDrawable drawable = GLDrawableFactory.getFactory().createExternalGLDrawable();
            this.context = drawable.createContext(_context);
        }
        this.listeners = new CopyOnWriteArrayList<ListenerEntry>();
        for (GLSimpleListener l : listeners) {
            this.listeners.add(new ListenerEntry(l));
        }
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                GLSimpleSwtCanvas.this.handleResize();
            }
        });
    }

    public GLSimpleSwtCanvas(Composite parent, int options, GLSimpleListener ... listeners) {
        this(parent, null, options, listeners);
    }

    public GLSimpleSwtCanvas(Composite parent, GLSimpleListener ... listeners) {
        this(parent, null, 0, listeners);
    }

    public void addListener(GLSimpleListener listener) {
        this.listeners.add(new ListenerEntry(listener));
    }

    public void removeListener(GLSimpleListener listener) {
        this.listeners.remove(listener);
    }

    private void handleResize() {
        for (ListenerEntry l : this.listeners) {
            l.requireReshape();
        }
    }

    public void draw(GLContext glContext) {
        int status = glContext.makeCurrent();
        if (status == 0) {
            logger.warning("Unable to make correct context current.  Skipping draw.");
            return;
        }
        Rectangle bounds = this.getBounds();
        for (ListenerEntry l : this.listeners) {
            l.draw(this.context, bounds);
        }
        glContext.getGL().glFlush();
    }

    public void draw() {
        this.setCurrent();
        this.draw(this.getGLContext());
        this.swapBuffers();
        this.getGLContext().release();
    }

    public GLContext getGLContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.setCurrent();
        this.getGLContext().makeCurrent();
        try {
            for (ListenerEntry entry : this.listeners) {
                entry.listener.dispose(this.context);
            }
        }
        finally {
            this.getGLContext().release();
        }
        super.dispose();
    }

    private static class ListenerEntry {
        private final GLSimpleListener listener;
        private boolean needsInit;
        private boolean needsReshape;
        private boolean warnOnException;

        public ListenerEntry(GLSimpleListener listener) {
            this.listener = listener;
            this.needsInit = true;
            this.needsReshape = true;
            this.warnOnException = true;
        }

        public void requireReshape() {
            this.needsReshape = true;
        }

        public void draw(GLContext context, Rectangle bounds) {
            block4: {
                try {
                    if (this.needsInit) {
                        this.listener.init(context);
                        this.needsInit = false;
                    }
                    if (this.needsReshape) {
                        GL gl = context.getGL();
                        gl.glViewport(0, 0, bounds.width, bounds.height);
                        this.listener.reshape(context, 0, 0, bounds.width, bounds.height);
                        this.needsReshape = false;
                    }
                    this.listener.display(context);
                    this.warnOnException = true;
                }
                catch (Exception e) {
                    if (!this.warnOnException) break block4;
                    logger.log(Level.WARNING, "Listener failed to draw", e);
                    this.warnOnException = false;
                }
            }
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof ListenerEntry) {
                ListenerEntry l = (ListenerEntry)o;
                return this.listener.equals(l.listener);
            }
            return false;
        }
    }
}

