/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.spacenav;

import com.metsci.glimpse.spacenav.SpaceNavDevice;
import com.metsci.glimpse.spacenav.SpaceNavException;
import com.metsci.glimpse.spacenav.SpaceNavListener;
import com.metsci.glimpse.spacenav.SpaceNavState;
import com.metsci.glimpse.util.logging.LoggerUtils;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;

public class SpaceNavPoller {
    public static final long POLL_INTERVAL = 20L;
    protected static final Logger logger = Logger.getLogger(SpaceNavPoller.class.getName());
    private List<SpaceNavListener> listeners;
    private Timer timer;
    private TimerTask task;
    private SpaceNavDevice device;
    private boolean terminated = false;

    private SpaceNavPoller(SpaceNavDevice device, long period) {
        this.device = device;
        this.listeners = new CopyOnWriteArrayList<SpaceNavListener>();
        this.task = new TimerTask(){

            @Override
            public void run() {
                if (!SpaceNavPoller.this.terminated) {
                    try {
                        SpaceNavState state = SpaceNavPoller.this.device.poll();
                        try {
                            for (SpaceNavListener listener : SpaceNavPoller.this.listeners) {
                                listener.update(state);
                            }
                        }
                        catch (Exception e) {
                            SpaceNavPoller.this.terminate();
                            LoggerUtils.logWarning((Logger)logger, (String)"SpaceNavPoller encountered error.", (Throwable)e, (Object[])new Object[0]);
                        }
                    }
                    catch (SpaceNavException e) {
                        SpaceNavPoller.this.terminate();
                        LoggerUtils.logWarning((Logger)logger, (String)"SpaceNavPoller encountered error.", (Throwable)e, (Object[])new Object[0]);
                    }
                }
            }
        };
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(this.task, 0L, period);
    }

    public static SpaceNavPoller create() throws SpaceNavException {
        return new SpaceNavPoller(SpaceNavDevice.getDevice(), 20L);
    }

    public void terminate() {
        this.terminated = true;
        this.listeners.clear();
        this.listeners = null;
        this.task.cancel();
        this.task = null;
        this.timer.cancel();
        this.timer = null;
        SpaceNavDevice.releaseDevice(this.device);
    }

    public void addListener(SpaceNavListener listener) {
        this.listeners.add(listener);
    }

    public void clearListeners() {
        this.listeners.clear();
    }
}

