/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.spacenav;

import com.metsci.glimpse.spacenav.JInputDriver;
import com.metsci.glimpse.spacenav.SpaceNavException;
import com.metsci.glimpse.spacenav.SpaceNavState;
import java.util.logging.Logger;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;

public class SpaceNavDevice {
    public static final int NUM_BUTTONS = 2;
    private static final Logger logger = Logger.getLogger(SpaceNavDevice.class.getSimpleName());
    private int xAxisIdx;
    private int yAxisIdx;
    private int zAxisIdx;
    private int rxAxisIdx;
    private int ryAxisIdx;
    private int rzAxisIdx;
    private int[] buttonsIdx;
    private Controller controller;
    private Component[] components;
    private boolean terminated = false;
    private static SpaceNavDevice instance;
    private static boolean instanceInUse;

    private SpaceNavDevice(Controller controller) {
        this.controller = controller;
        this.findCompIndices(controller);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized SpaceNavDevice getDevice() throws SpaceNavException {
        JInputDriver.init();
        if (instance == null) {
            ControllerEnvironment ce = ControllerEnvironment.getDefaultEnvironment();
            Controller[] cs = ce.getControllers();
            Controller c = SpaceNavDevice.findSpaceNavigator(cs);
            if (c == null) throw new SpaceNavException("Space Navigator not found.");
            instance = new SpaceNavDevice(c);
            instanceInUse = false;
        } else if (instanceInUse) {
            throw new SpaceNavException("Device already in use.");
        }
        instanceInUse = true;
        return instance;
    }

    public static synchronized void releaseDevice(SpaceNavDevice device) {
        if (device == instance) {
            instance.terminate();
            instanceInUse = false;
            instance = null;
        }
    }

    public synchronized SpaceNavState poll() throws SpaceNavException {
        if (this.terminated) {
            throw new SpaceNavException("Device instance terminated.");
        }
        long systemTimeMillis = System.currentTimeMillis();
        this.controller.poll();
        float xTranslation = this.components[this.xAxisIdx].getPollData();
        float yTranslation = this.components[this.yAxisIdx].getPollData();
        float zTranslation = this.components[this.zAxisIdx].getPollData();
        float xRotation = this.components[this.rxAxisIdx].getPollData();
        float yRotation = this.components[this.ryAxisIdx].getPollData();
        float zRotation = this.components[this.rzAxisIdx].getPollData();
        return new SpaceNavState(systemTimeMillis, xTranslation, yTranslation, zTranslation, xRotation, yRotation, zRotation);
    }

    private synchronized void terminate() {
        this.terminated = true;
    }

    private static Controller findSpaceNavigator(Controller[] cs) {
        for (int i = 0; i < cs.length; ++i) {
            logger.info("Controller: " + cs[i]);
            if (cs[i].getType() != Controller.Type.STICK && !cs[i].getName().equals("3Dconnexion SpaceNavigator")) continue;
            return cs[i];
        }
        return null;
    }

    private void findCompIndices(Controller controller) {
        this.components = controller.getComponents();
        if (this.components.length == 0) {
            logger.info("No Components found");
            System.exit(0);
        } else {
            logger.info("Num. Components: " + this.components.length);
        }
        this.xAxisIdx = this.findCompIndex(this.components, (Component.Identifier)Component.Identifier.Axis.X, "x");
        this.yAxisIdx = this.findCompIndex(this.components, (Component.Identifier)Component.Identifier.Axis.Y, "y");
        this.zAxisIdx = this.findCompIndex(this.components, (Component.Identifier)Component.Identifier.Axis.Z, "z");
        this.rxAxisIdx = this.findCompIndex(this.components, (Component.Identifier)Component.Identifier.Axis.RY, "rx");
        this.ryAxisIdx = this.findCompIndex(this.components, (Component.Identifier)Component.Identifier.Axis.RX, "ry");
        this.rzAxisIdx = this.findCompIndex(this.components, (Component.Identifier)Component.Identifier.Axis.RZ, "rz");
        if (this.rxAxisIdx == -1) {
            this.rxAxisIdx = 5;
        }
        if (this.ryAxisIdx == -1) {
            this.ryAxisIdx = 6;
        }
        if (this.rzAxisIdx == -1) {
            this.rzAxisIdx = 7;
        }
        this.findButtons(this.components);
    }

    private int findCompIndex(Component[] comps, Component.Identifier id, String nm) {
        for (int i = 0; i < comps.length; ++i) {
            Component c = comps[i];
            if (c.getIdentifier() != id) continue;
            logger.info("Found " + c.getName() + "; index: " + i);
            return i;
        }
        logger.info("No " + nm + " component found");
        return -1;
    }

    private void findButtons(Component[] comps) {
        this.buttonsIdx = new int[2];
        int numButtons = 0;
        for (int i = 0; i < comps.length; ++i) {
            Component c = comps[i];
            if (!this.isButton(c)) continue;
            if (numButtons == 2) {
                logger.info("Found an extra button; index: " + i + ". Ignoring it");
                continue;
            }
            this.buttonsIdx[numButtons] = i;
            logger.info("Found " + c.getName() + "; index: " + i);
            ++numButtons;
        }
        if (numButtons < 2) {
            logger.info("Too few buttons (" + numButtons + "); expecting " + 2);
            while (numButtons < 2) {
                this.buttonsIdx[numButtons] = -1;
                ++numButtons;
            }
        }
    }

    private boolean isButton(Component c) {
        String className;
        return !c.isAnalog() && !c.isRelative() && (className = c.getIdentifier().getClass().getName()).endsWith("Button");
    }

    protected boolean[] getButtons() {
        boolean[] buttons = new boolean[2];
        for (int i = 0; i < 2; ++i) {
            float value = this.components[this.buttonsIdx[i]].getPollData();
            buttons[i] = value != 0.0f;
        }
        return buttons;
    }

    protected boolean isButtonPressed(int pos) {
        if (pos > 2) {
            logger.info("Button position out of range (1-2): " + pos);
            return false;
        }
        if (this.buttonsIdx[pos - 1] == -1) {
            return false;
        }
        float value = this.components[this.buttonsIdx[pos - 1]].getPollData();
        return value != 0.0f;
    }

    static {
        instanceInUse = false;
    }
}

