/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.spacenav;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.spacenav.SpaceNavListener;
import com.metsci.glimpse.spacenav.SpaceNavState;

public class AxisNavigator
implements SpaceNavListener {
    protected SpaceNavState lastState;
    protected Axis1D xAxis;
    protected Axis1D yAxis;
    protected Axis1D zAxis;
    double zoomRate = 0.01;
    double panRate = 0.6666666666666666;

    public AxisNavigator(Axis1D xTrans, Axis1D yTrans, Axis1D zTrans) {
        this.xAxis = xTrans;
        this.yAxis = yTrans;
        this.zAxis = zTrans;
    }

    @Override
    public void update(SpaceNavState state) {
        if (this.lastState == null) {
            this.lastState = state;
            return;
        }
        double dt = (double)(state.systemTimeMillis - this.lastState.systemTimeMillis) / 1000.0;
        if (dt > 0.04) {
            this.lastState = state;
        } else {
            if (this.xAxis != null) {
                AxisNavigator.panAxis(this.xAxis, this.panRate, AxisNavigator.getIntensity(-state.xTranslation, 20.0));
            }
            if (this.yAxis != null) {
                AxisNavigator.panAxis(this.yAxis, this.panRate, AxisNavigator.getIntensity(state.yTranslation, 20.0));
            }
            if (this.xAxis != null) {
                AxisNavigator.zoomAxis(this.xAxis, this.zoomRate, AxisNavigator.getIntensity(state.zTranslation, 20.0));
            }
            if (this.yAxis != null) {
                AxisNavigator.zoomAxis(this.yAxis, this.zoomRate, AxisNavigator.getIntensity(state.zTranslation, 20.0));
            }
            if (this.zAxis != null) {
                AxisNavigator.panAxis(this.zAxis, this.panRate, AxisNavigator.getIntensity(state.zRotation, 20.0));
            }
            this.lastState = state;
        }
    }

    private static double getIntensity(double state, double interval) {
        if (state > 350.0) {
            return 1.0;
        }
        if (state < -350.0) {
            return -1.0;
        }
        return state / 350.0;
    }

    private static void panAxis(Axis1D axis, double panRate, double intensity) {
        if (Math.abs(intensity) < 0.01) {
            return;
        }
        double axisWidth = axis.getMin() - axis.getMax();
        double panDistance = axisWidth * panRate * intensity * 20.0 / 1000.0;
        axis.setMin(axis.getMin() + panDistance);
        axis.setMax(axis.getMax() + panDistance);
        axis.validate();
        axis.updateLinkedAxes();
    }

    private static void zoomAxis(Axis1D axis, double zoomRate, double intensity) {
        if (Math.abs(intensity) < 0.1) {
            return;
        }
        double minValue = axis.getMin();
        double maxValue = axis.getMax();
        double axisWidth = maxValue - minValue;
        double updatedMin = minValue + axisWidth * zoomRate * intensity;
        double updatedMax = maxValue - axisWidth * zoomRate * intensity;
        axis.setMin(updatedMin);
        axis.setMax(updatedMax);
        axis.validate();
        axis.updateLinkedAxes();
    }
}

