/*
 * Copyright (c) 2012, Metron, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Metron, Inc. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL METRON, INC. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
//
// This file was generated by the JavaTM Architecture for XML Binding(JAXB) Reference Implementation, v2.2.3-hudson-jaxb-ri-2.2.3-3-
// See <a href="http://java.sun.com/xml/jaxb">http://java.sun.com/xml/jaxb</a>
// Any modifications to this file will be lost upon recompilation of the source schema.
// Generated on: 2011.12.05 at 11:09:09 AM EST
//


package com.metsci.glimpse.dspl.schema;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 *
 *         A slice describes a combination of concepts for which data
 *         exists.  Metrics are the concepts that provide values, while
 *         dimensions are the concepts used to access these values. More
 *         precisely, the dimensions are a primary key for the data of
 *         the slice. That is, for any combination of values of the
 *         dimensions, there is at most one data row in the slice.
 *
 *         Slices in a dataset must follow the following requirements:
 *
 *         - No two dimensions or metrics in a slice may refer to the
 *         same concept.
 *
 *         - No two slices in the dataset may have the same dimensions
 *         and metrics.
 *
 *         TODO (benjello): Add syntax for dense cubes.
 *
 *
 *
 * <p>Java class for Slice complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="Slice">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="info" type="{http://schemas.google.com/dspl/2010}Info" minOccurs="0"/>
 *         &lt;element name="dimension" type="{http://schemas.google.com/dspl/2010}SliceConceptRef" maxOccurs="unbounded"/>
 *         &lt;element name="metric" type="{http://schemas.google.com/dspl/2010}SliceConceptRef" maxOccurs="unbounded"/>
 *         &lt;choice>
 *           &lt;element name="table" type="{http://schemas.google.com/dspl/2010}SliceTableMapping"/>
 *           &lt;element name="data">
 *             &lt;complexType>
 *               &lt;complexContent>
 *                 &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                   &lt;sequence>
 *                     &lt;element name="table" type="{http://schemas.google.com/dspl/2010}SliceTableMapping"/>
 *                   &lt;/sequence>
 *                 &lt;/restriction>
 *               &lt;/complexContent>
 *             &lt;/complexType>
 *           &lt;/element>
 *         &lt;/choice>
 *       &lt;/sequence>
 *       &lt;attribute name="id" use="required" type="{http://schemas.google.com/dspl/2010}Id" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 *
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Slice", propOrder = {
    "info",
    "dimension",
    "metric",
    "tableMapping",
    "data"
})
public class Slice {

    protected Info info;
    @XmlElement(required = true)
    protected List<SliceConceptRef> dimension;
    @XmlElement(required = true)
    protected List<SliceConceptRef> metric;
    @XmlElement(name = "table")
    protected SliceTableMapping tableMapping;
    protected Slice.Data data;
    @XmlAttribute(name = "id", required = true)
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlID
    protected String id;

    /**
     * Gets the value of the info property.
     *
     * @return
     *     possible object is
     *     {@link Info }
     *
     */
    public Info getInfo() {
        return info;
    }

    /**
     * Sets the value of the info property.
     *
     * @param value
     *     allowed object is
     *     {@link Info }
     *
     */
    public void setInfo(Info value) {
        this.info = value;
    }

    /**
     * Gets the value of the dimension property.
     *
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the dimension property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDimension().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SliceConceptRef }
     *
     *
     */
    public List<SliceConceptRef> getDimension() {
        if (dimension == null) {
            dimension = new ArrayList<SliceConceptRef>();
        }
        return this.dimension;
    }

    /**
     * Gets the value of the metric property.
     *
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the metric property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getMetric().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SliceConceptRef }
     *
     *
     */
    public List<SliceConceptRef> getMetric() {
        if (metric == null) {
            metric = new ArrayList<SliceConceptRef>();
        }
        return this.metric;
    }

    /**
     * Gets the value of the tableMapping property.
     *
     * @return
     *     possible object is
     *     {@link SliceTableMapping }
     *
     */
    public SliceTableMapping getTableMapping() {
        return tableMapping;
    }

    /**
     * Sets the value of the tableMapping property.
     *
     * @param value
     *     allowed object is
     *     {@link SliceTableMapping }
     *
     */
    public void setTableMapping(SliceTableMapping value) {
        this.tableMapping = value;
    }

    /**
     * Gets the value of the data property.
     *
     * @return
     *     possible object is
     *     {@link Slice.Data }
     *
     */
    public Slice.Data getData() {
        return data;
    }

    /**
     * Sets the value of the data property.
     *
     * @param value
     *     allowed object is
     *     {@link Slice.Data }
     *
     */
    public void setData(Slice.Data value) {
        this.data = value;
    }

    /**
     * Gets the value of the id property.
     *
     * @return
     *     possible object is
     *     {@link String }
     *
     */
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     *
     * @param value
     *     allowed object is
     *     {@link String }
     *
     */
    public void setId(String value) {
        this.id = value;
    }


    /**
     * <p>Java class for anonymous complex type.
     *
     * <p>The following schema fragment specifies the expected content contained within this class.
     *
     * <pre>
     * &lt;complexType>
     *   &lt;complexContent>
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       &lt;sequence>
     *         &lt;element name="table" type="{http://schemas.google.com/dspl/2010}SliceTableMapping"/>
     *       &lt;/sequence>
     *     &lt;/restriction>
     *   &lt;/complexContent>
     * &lt;/complexType>
     * </pre>
     *
     *
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "table"
    })
    public static class Data {

        @XmlElement(required = true)
        protected SliceTableMapping table;

        /**
         * Gets the value of the table property.
         *
         * @return
         *     possible object is
         *     {@link SliceTableMapping }
         *
         */
        public SliceTableMapping getTable() {
            return table;
        }

        /**
         * Sets the value of the table property.
         *
         * @param value
         *     allowed object is
         *     {@link SliceTableMapping }
         *
         */
        public void setTable(SliceTableMapping value) {
            this.table = value;
        }

    }


    @javax.xml.bind.annotation.XmlTransient
    protected DataSet parentDataset;

    @javax.xml.bind.annotation.XmlTransient
    protected com.metsci.glimpse.dspl.parser.table.SliceTableData tableData;

    public DataSet getDataSet( )
    {
        return parentDataset;
    }

    public void setDataSet( DataSet dataSet )
    {
        this.parentDataset = dataSet;
    }

    public Table getTable( ) throws javax.xml.bind.JAXBException, java.io.IOException, com.metsci.glimpse.dspl.util.DsplException
    {
        return com.metsci.glimpse.dspl.util.DsplHelper.getTable( this );
    }

    public com.metsci.glimpse.dspl.parser.table.SliceTableData getTableData( ) throws javax.xml.bind.JAXBException, java.io.IOException, com.metsci.glimpse.dspl.util.DsplException
    {
        if ( tableData != null )
            return tableData;

        tableData = com.metsci.glimpse.dspl.util.DsplHelper.getTableData( this );

        return tableData;
    }

    public Concept getCompatibleDimension( Concept superConcept ) throws javax.xml.bind.JAXBException, java.io.IOException, com.metsci.glimpse.dspl.util.DsplException
    {
        return com.metsci.glimpse.dspl.util.DsplHelper.getCompatibleConceptRef( this, superConcept, getDimension( ) );
    }

    public Concept getCompatibleMetric( Concept superConcept ) throws javax.xml.bind.JAXBException, java.io.IOException, com.metsci.glimpse.dspl.util.DsplException
    {
        return com.metsci.glimpse.dspl.util.DsplHelper.getCompatibleConceptRef( this, superConcept, getMetric( ) );
    }


}
