/*
 * Copyright (c) 2012, Metron, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Metron, Inc. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL METRON, INC. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
//
// This file was generated by the JavaTM Architecture for XML Binding(JAXB) Reference Implementation, v2.2.3-hudson-jaxb-ri-2.2.3-3-
// See <a href="http://java.sun.com/xml/jaxb">http://java.sun.com/xml/jaxb</a>
// Any modifications to this file will be lost upon recompilation of the source schema.
// Generated on: 2011.12.05 at 11:09:09 AM EST
//


package com.metsci.glimpse.dspl.schema;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;


/**
 *
 *         An attribute of a dataset or a concept.
 *
 *
 * <p>Java class for Attribute complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="Attribute">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="info" type="{http://schemas.google.com/dspl/2010}Info" minOccurs="0"/>
 *         &lt;element name="type" minOccurs="0">
 *           &lt;complexType>
 *             &lt;complexContent>
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 &lt;attribute name="ref" use="required" type="{http://schemas.google.com/dspl/2010}DataType" />
 *                 &lt;attribute name="format" type="{http://www.w3.org/2001/XMLSchema}string" />
 *               &lt;/restriction>
 *             &lt;/complexContent>
 *           &lt;/complexType>
 *         &lt;/element>
 *         &lt;group ref="{http://schemas.google.com/dspl/2010}ValuesGroup" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="id" type="{http://schemas.google.com/dspl/2010}LocalId" />
 *       &lt;attribute name="concept" type="{http://www.w3.org/2001/XMLSchema}QName" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 *
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Attribute", propOrder = {
    "info",
    "type",
    "value",
    "conceptValue"
})
public class Attribute {

    protected Info info;
    protected Attribute.Type type;
    protected List<Value> value;
    protected Attribute.ConceptValue conceptValue;
    @XmlAttribute(name = "id")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String id;
    @XmlAttribute(name = "concept")
    protected QName conceptRef;

    /**
     * Gets the value of the info property.
     *
     * @return
     *     possible object is
     *     {@link Info }
     *
     */
    public Info getInfo() {
        return info;
    }

    /**
     * Sets the value of the info property.
     *
     * @param value
     *     allowed object is
     *     {@link Info }
     *
     */
    public void setInfo(Info value) {
        this.info = value;
    }

    /**
     * Gets the value of the type property.
     *
     * @return
     *     possible object is
     *     {@link Attribute.Type }
     *
     */
    public Attribute.Type getType() {
        return type;
    }

    /**
     * Sets the value of the type property.
     *
     * @param value
     *     allowed object is
     *     {@link Attribute.Type }
     *
     */
    public void setType(Attribute.Type value) {
        this.type = value;
    }

    /**
     * Gets the value of the value property.
     *
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the value property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getValue().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Value }
     *
     *
     */
    public List<Value> getValue() {
        if (value == null) {
            value = new ArrayList<Value>();
        }
        return this.value;
    }

    /**
     * Gets the value of the conceptValue property.
     *
     * @return
     *     possible object is
     *     {@link Attribute.ConceptValue }
     *
     */
    public Attribute.ConceptValue getConceptValue() {
        return conceptValue;
    }

    /**
     * Sets the value of the conceptValue property.
     *
     * @param value
     *     allowed object is
     *     {@link Attribute.ConceptValue }
     *
     */
    public void setConceptValue(Attribute.ConceptValue value) {
        this.conceptValue = value;
    }

    /**
     * Gets the value of the id property.
     *
     * @return
     *     possible object is
     *     {@link String }
     *
     */
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     *
     * @param value
     *     allowed object is
     *     {@link String }
     *
     */
    public void setId(String value) {
        this.id = value;
    }

    /**
     * Gets the value of the conceptRef property.
     *
     * @return
     *     possible object is
     *     {@link QName }
     *
     */
    public QName getConceptRef() {
        return conceptRef;
    }

    /**
     * Sets the value of the conceptRef property.
     *
     * @param value
     *     allowed object is
     *     {@link QName }
     *
     */
    public void setConceptRef(QName value) {
        this.conceptRef = value;
    }


    /**
     * <p>Java class for anonymous complex type.
     *
     * <p>The following schema fragment specifies the expected content contained within this class.
     *
     * <pre>
     * &lt;complexType>
     *   &lt;complexContent>
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       &lt;attribute name="concept" use="required" type="{http://www.w3.org/2001/XMLSchema}QName" />
     *     &lt;/restriction>
     *   &lt;/complexContent>
     * &lt;/complexType>
     * </pre>
     *
     *
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    public static class ConceptValue {

        @XmlAttribute(name = "concept", required = true)
        protected QName concept;

        /**
         * Gets the value of the concept property.
         *
         * @return
         *     possible object is
         *     {@link QName }
         *
         */
        public QName getConcept() {
            return concept;
        }

        /**
         * Sets the value of the concept property.
         *
         * @param value
         *     allowed object is
         *     {@link QName }
         *
         */
        public void setConcept(QName value) {
            this.concept = value;
        }

    }


    /**
     * <p>Java class for anonymous complex type.
     *
     * <p>The following schema fragment specifies the expected content contained within this class.
     *
     * <pre>
     * &lt;complexType>
     *   &lt;complexContent>
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       &lt;attribute name="ref" use="required" type="{http://schemas.google.com/dspl/2010}DataType" />
     *       &lt;attribute name="format" type="{http://www.w3.org/2001/XMLSchema}string" />
     *     &lt;/restriction>
     *   &lt;/complexContent>
     * &lt;/complexType>
     * </pre>
     *
     *
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    public static class Type {

        @XmlAttribute(name = "ref", required = true)
        protected DataType ref;
        @XmlAttribute(name = "format")
        protected String format;

        /**
         * Gets the value of the ref property.
         *
         * @return
         *     possible object is
         *     {@link DataType }
         *
         */
        public DataType getRef() {
            return ref;
        }

        /**
         * Sets the value of the ref property.
         *
         * @param value
         *     allowed object is
         *     {@link DataType }
         *
         */
        public void setRef(DataType value) {
            this.ref = value;
        }

        /**
         * Gets the value of the format property.
         *
         * @return
         *     possible object is
         *     {@link String }
         *
         */
        public String getFormat() {
            return format;
        }

        /**
         * Sets the value of the format property.
         *
         * @param value
         *     allowed object is
         *     {@link String }
         *
         */
        public void setFormat(String value) {
            this.format = value;
        }

    }


    @javax.xml.bind.annotation.XmlTransient
    protected Concept parentConcept;

    public static class AttributeProperties
    {
        protected int index;
        protected com.metsci.glimpse.dspl.parser.table.PropertyTableData table;

        public AttributeProperties( Attribute attribute ) throws javax.xml.bind.JAXBException, java.io.IOException, com.metsci.glimpse.dspl.util.DsplException
        {
            this( attribute.getPropertyIndex( ), attribute.getConcept( ).getTableData( ) );
        }

        public AttributeProperties( int index, com.metsci.glimpse.dspl.parser.table.PropertyTableData table )
        {
            this.index = index;
            this.table = table;
        }

        public com.metsci.glimpse.dspl.parser.table.PropertyTableData getPropertyTableData( )
        {
            return this.table;
        }

        public int getIndex( )
        {
            return this.index;
        }

        public String getStringData( String ref )
        {
            return this.table.getColumn( ref ).getStringData( this.index );
        }

        public int getIntegerData( String ref )
        {
            return this.table.getColumn( ref ).getIntegerData( this.index );
        }

        public float getFloatData( String ref )
        {
            return this.table.getColumn( ref ).getFloatData( this.index );
        }

        public boolean getBooleanData( String ref )
        {
            return this.table.getColumn( ref ).getBooleanData( this.index );
        }

        public long getDateData( String ref )
        {
            return this.table.getColumn( ref ).getDateData( this.index );
        }

        public String getStringData( Concept ref )
        {
            return this.table.getColumn( ref ).getStringData( this.index );
        }

        public int getIntegerData( Concept ref )
        {
            return this.table.getColumn( ref ).getIntegerData( this.index );
        }

        public float getFloatData( Concept ref )
        {
            return this.table.getColumn( ref ).getFloatData( this.index );
        }

        public boolean getBooleanData( Concept ref )
        {
            return this.table.getColumn( ref ).getBooleanData( this.index );
        }

        public long getDateData( Concept ref )
        {
            return this.table.getColumn( ref ).getDateData( this.index );
        }
    }

    public AttributeProperties getAttributeProperties( ) throws javax.xml.bind.JAXBException, java.io.IOException, com.metsci.glimpse.dspl.util.DsplException
    {
        return new AttributeProperties( this );
    }

    protected int getPropertyIndex( ) throws javax.xml.bind.JAXBException, java.io.IOException, com.metsci.glimpse.dspl.util.DsplException
    {
        if ( getType( ).getRef( ) != DataType.CONCEPT )
        {
            throw new com.metsci.glimpse.dspl.util.DsplException( "Cannot retrieve TableColumn index for non-Concept Attribute." );
        }

        String value = getValueEnglish( );
        Concept concept = getConcept( );
        com.metsci.glimpse.dspl.parser.table.PropertyTableData tableData = concept.getTableData( );
        com.metsci.glimpse.dspl.parser.column.TableColumn keyColumn = tableData.getColumn( concept );

        int size = keyColumn.getSize( );

        for ( int i = 0; i < size; i++ )
        {
            String row = keyColumn.getStringData( i );

            if ( value.equals( row ) ) return i;
        }

        throw new com.metsci.glimpse.dspl.util.DsplException( "Concept %s does not have key %s in its property data table.", concept.getNameEnglish( ), value );
    }

    public Concept getParentConcept( )
    {
        return parentConcept;
    }

    public void setParentConcept( Concept parentConcept )
    {
        this.parentConcept = parentConcept;
    }

    public Concept getConcept( ) throws javax.xml.bind.JAXBException, java.io.IOException, com.metsci.glimpse.dspl.util.DsplException
    {
        DataSet dataset = this.parentConcept.getDataSet( );
        return dataset.getConcept( this.conceptRef );
    }

    public String getNameEnglish( )
    {
        if ( info != null )
        {
            String englishName = info.getNameEnglish( );

            if ( englishName != null )
                return englishName;
        }

        // if no name is provided use the id
        return id;
    }

    public String getValueEnglish( )
    {
        return com.metsci.glimpse.dspl.util.DsplHelper.getValueEnglish( getValue( ) );
    }


}
