/*
 * Copyright (c) 2012, Metron, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Metron, Inc. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL METRON, INC. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.metsci.glimpse.charts.vector.parser.autogen;

import java.io.DataInput;
import java.util.HashMap;
import java.io.DataOutputStream;
import java.io.IOException;

public enum ENCAttributeValues{
     BeaconShape_StakePolePerchPost  (2, 1),
     BeaconShape_Whity  (2, 2),
     BeaconShape_BeaconTower  (2, 3),
     BeaconShape_LatticeBeacon  (2, 4),
     BeaconShape_PileBeacon  (2, 5),
     BeaconShape_Cairn  (2, 6),
     BeaconShape_BuoyantBeacon  (2, 7),
     BuildingShape_HighRiseBuilding  (3, 5),
     BuildingShape_Pyramid  (3, 6),
     BuildingShape_Cylindrical  (3, 7),
     BuildingShape_Spherical  (3, 8),
     BuildingShape_Cubic  (3, 9),
     BuoyShape_ConicalNunOgival  (4, 1),
     BuoyShape_CanCylindrical  (4, 2),
     BuoyShape_Spherical  (4, 3),
     BuoyShape_Pillar  (4, 4),
     BuoyShape_SparSpindle  (4, 5),
     BuoyShape_BarrelTun  (4, 6),
     BuoyShape_SuperBuoy  (4, 7),
     BuoyShape_IceBuoy  (4, 8),
     CategoryOfAirportAirfield_MilitaryAeroplaneAirport  (7, 1),
     CategoryOfAirportAirfield_CivilAeroplaneAirport  (7, 2),
     CategoryOfAirportAirfield_MilitaryHeliport  (7, 3),
     CategoryOfAirportAirfield_CivilHeliport  (7, 4),
     CategoryOfAirportAirfield_GliderAirfield  (7, 5),
     CategoryOfAirportAirfield_SmallPlanesAirfield  (7, 6),
     CategoryOfAirportAirfield_EmergencyAirfield  (7, 8),
     CategoryOfAnchorage_UnrestrictedAnchorage  (8, 1),
     CategoryOfAnchorage_DeepWaterAnchorage  (8, 2),
     CategoryOfAnchorage_TankerAnchorage  (8, 3),
     CategoryOfAnchorage_ExplosivesAnchorage  (8, 4),
     CategoryOfAnchorage_QuarantineAnchorage  (8, 5),
     CategoryOfAnchorage_SeaPlaneAnchorage  (8, 6),
     CategoryOfAnchorage_SmallCraftAnchorage  (8, 7),
     CategoryOfAnchorage_SmallCraftMooringArea  (8, 8),
     CategoryOfAnchorage_AnchorageForPeriodsUpTo24Hours  (8, 9),
     CategoryOfAnchorage_AnchorageForALimitedPeriodOfTime  (8, 10),
     CategoryOfBridge_FixedBridge  (9, 1),
     CategoryOfBridge_OpeningBridge  (9, 2),
     CategoryOfBridge_SwingBridge  (9, 3),
     CategoryOfBridge_LiftingBridge  (9, 4),
     CategoryOfBridge_BasculeBridge  (9, 5),
     CategoryOfBridge_PontoonBridge  (9, 6),
     CategoryOfBridge_DrawBridge  (9, 7),
     CategoryOfBridge_TransporterBridge  (9, 8),
     CategoryOfBridge_Footbridge  (9, 9),
     CategoryOfBridge_Viaduct  (9, 10),
     CategoryOfBridge_Aqueduct  (9, 11),
     CategoryOfBridge_SuspensionBridge  (9, 12),
     CategoryOfBuiltUpArea_UrbanArea  (10, 1),
     CategoryOfBuiltUpArea_Settlement  (10, 2),
     CategoryOfBuiltUpArea_Village  (10, 3),
     CategoryOfBuiltUpArea_Town  (10, 4),
     CategoryOfBuiltUpArea_City  (10, 5),
     CategoryOfBuiltUpArea_HolidayVillage  (10, 6),
     CategoryOfCable_PowerLine  (11, 1),
     CategoryOfCable_TransmissionLine  (11, 3),
     CategoryOfCable_Telephone  (11, 4),
     CategoryOfCable_Telegraph  (11, 5),
     CategoryOfCable_MooringCableChain  (11, 6),
     CategoryOfCanal_Transportation  (12, 1),
     CategoryOfCanal_Drainage  (12, 2),
     CategoryOfCanal_Irrigation  (12, 3),
     CategoryOfCardinalMark_NorthCardinalMark  (13, 1),
     CategoryOfCardinalMark_EastCardinalMark  (13, 2),
     CategoryOfCardinalMark_SouthCardinalMark  (13, 3),
     CategoryOfCardinalMark_WestCardinalMark  (13, 4),
     CategoryOfCheckpoint_Custom  (14, 1),
     CategoryOfCoastline_SteepCoast  (15, 1),
     CategoryOfCoastline_FlatCoast  (15, 2),
     CategoryOfCoastline_SandyShore  (15, 3),
     CategoryOfCoastline_StonyShore  (15, 4),
     CategoryOfCoastline_ShinglyShore  (15, 5),
     CategoryOfCoastline_GlacierSeawardEnd  (15, 6),
     CategoryOfCoastline_Mangrove  (15, 7),
     CategoryOfCoastline_MarshyShore  (15, 8),
     CategoryOfCoastline_CoralReef  (15, 9),
     CategoryOfCoastline_IceCoast  (15, 10),
     CategoryOfConveyor_AerialCablewayTelepheric  (17, 1),
     CategoryOfConveyor_BeltConveyor  (17, 2),
     CategoryOfControlPoint_TriangulationPoint  (16, 1),
     CategoryOfControlPoint_ObservationSpot  (16, 2),
     CategoryOfControlPoint_FixedPoint  (16, 3),
     CategoryOfControlPoint_BenchMark  (16, 4),
     CategoryOfControlPoint_BoundaryMark  (16, 5),
     CategoryOfControlPoint_HorizontalControlMainStation  (16, 6),
     CategoryOfControlPoint_HorizontalControlSecondaryStation  (16, 7),
     CategoryOfCrane_ContainerCraneGantry  (19, 2),
     CategoryOfCrane_Sheerlegs  (19, 3),
     CategoryOfCrane_TravellingCrane  (19, 4),
     CategoryOfCrane_AFrame  (19, 5),
     CategoryOfCoverage_CoverageAvailable  (18, 1),
     CategoryOfCoverage_NoCoverageAvailable  (18, 2),
     CategoryOfDistanceMark_DistanceMarkNotPhysicallyInstalled  (21, 1),
     CategoryOfDistanceMark_VisibleMarkPole  (21, 2),
     CategoryOfDistanceMark_VisibleMarkBoard  (21, 3),
     CategoryOfDistanceMark_VisibleMarkUnknownShape  (21, 4),
     CategoryOfDam_Weir  (20, 1),
     CategoryOfDam_Dam  (20, 2),
     CategoryOfDam_FloodBarrage  (20, 3),
     CategoryOfDumpingGround_ChemicalWasteDumpingGround  (23, 2),
     CategoryOfDumpingGround_NuclearWasteDumpingGround  (23, 3),
     CategoryOfDumpingGround_ExplosivesDumpingGround  (23, 4),
     CategoryOfDumpingGround_SpoilGround  (23, 5),
     CategoryOfDumpingGround_VesselDumpingGround  (23, 6),
     CategoryOfDock_Tidal  (22, 1),
     CategoryOfDock_NonTidalWetDock  (22, 2),
     CategoryOfFerry_FreeMovingFerry  (25, 1),
     CategoryOfFerry_CableFerry  (25, 2),
     CategoryOfFerry_IceFerry  (25, 3),
     CategoryOfFenceWall_Fence  (24, 1),
     CategoryOfFenceWall_Hedge  (24, 3),
     CategoryOfFenceWall_Wall  (24, 4),
     CategoryOfFogSignal_Explosive  (27, 1),
     CategoryOfFogSignal_Diaphone  (27, 2),
     CategoryOfFogSignal_Siren  (27, 3),
     CategoryOfFogSignal_Nautophone  (27, 4),
     CategoryOfFogSignal_Reed  (27, 5),
     CategoryOfFogSignal_Tyfon  (27, 6),
     CategoryOfFogSignal_Bell  (27, 7),
     CategoryOfFogSignal_Whistle  (27, 8),
     CategoryOfFogSignal_Gong  (27, 9),
     CategoryOfFogSignal_Horn  (27, 10),
     CategoryOfFishingFacility_FishingStake  (26, 1),
     CategoryOfFishingFacility_FishTrap  (26, 2),
     CategoryOfFishingFacility_FishWeir  (26, 3),
     CategoryOfFishingFacility_TunnyNet  (26, 4),
     CategoryOfGate_FloodBarrageGate  (29, 2),
     CategoryOfGate_Caisson  (29, 3),
     CategoryOfGate_LockGate  (29, 4),
     CategoryOfGate_DykeGate  (29, 5),
     CategoryOfGate_Sluice  (29, 6),
     CategoryOfFortifiedStructure_Castle  (28, 1),
     CategoryOfFortifiedStructure_Fort  (28, 2),
     CategoryOfFortifiedStructure_Battery  (28, 3),
     CategoryOfFortifiedStructure_Blockhouse  (28, 4),
     CategoryOfFortifiedStructure_MartelloTower  (28, 5),
     CategoryOfHulk_FloatingRestaurant  (31, 1),
     CategoryOfHulk_HistoricShip  (31, 2),
     CategoryOfHulk_Museum  (31, 3),
     CategoryOfHulk_Accomodation  (31, 4),
     CategoryOfHulk_FloatingBreakwater  (31, 5),
     CategoryOfHarbourFacility_RoroTerminal  (30, 1),
     CategoryOfHarbourFacility_FerryTerminal  (30, 3),
     CategoryOfHarbourFacility_FishingHarbour  (30, 4),
     CategoryOfHarbourFacility_YachtHarbourMarina  (30, 5),
     CategoryOfHarbourFacility_NavalBase  (30, 6),
     CategoryOfHarbourFacility_TankerTerminal  (30, 7),
     CategoryOfHarbourFacility_PassengerTerminal  (30, 8),
     CategoryOfHarbourFacility_Shipyard  (30, 9),
     CategoryOfHarbourFacility_ContainerTerminal  (30, 10),
     CategoryOfHarbourFacility_BulkTerminal  (30, 11),
     CategoryOfHarbourFacility_Syncrolift  (30, 12),
     CategoryOfHarbourFacility_StraddleCarrier  (30, 13),
     CategoryOfLandRegion_Fen  (34, 1),
     CategoryOfLandRegion_Marsh  (34, 2),
     CategoryOfLandRegion_MoorBog  (34, 3),
     CategoryOfLandRegion_Heathland  (34, 4),
     CategoryOfLandRegion_MountainRange  (34, 5),
     CategoryOfLandRegion_Lowlands  (34, 6),
     CategoryOfLandRegion_CanyonLands  (34, 7),
     CategoryOfLandRegion_PaddyField  (34, 8),
     CategoryOfLandRegion_AgriculturalLand  (34, 9),
     CategoryOfLandRegion_SavannaGrassland  (34, 10),
     CategoryOfLandRegion_Parkland  (34, 11),
     CategoryOfLandRegion_Swamp  (34, 12),
     CategoryOfLandRegion_Landslide  (34, 13),
     CategoryOfLandRegion_LavaFlow  (34, 14),
     CategoryOfLandRegion_SaltPan  (34, 15),
     CategoryOfLandRegion_Crater  (34, 17),
     CategoryOfLandRegion_Moraine  (34, 16),
     CategoryOfLandRegion_RockColumnOrPinnacle  (34, 19),
     CategoryOfLandRegion_Cave  (34, 18),
     CategoryOfLandRegion_Cay  (34, 20),
     CategoryOfLandmark_Cairn  (35, 1),
     CategoryOfLandmark_Cemetery  (35, 2),
     CategoryOfLandmark_Chimney  (35, 3),
     CategoryOfLandmark_DishAerial  (35, 4),
     CategoryOfLandmark_FlagstaffFlagpole  (35, 5),
     CategoryOfLandmark_FlareStack  (35, 6),
     CategoryOfLandmark_Mast  (35, 7),
     CategoryOfLandmark_Windsock  (35, 8),
     CategoryOfLandmark_Monument  (35, 9),
     CategoryOfLandmark_ColumnPillar  (35, 10),
     CategoryOfLandmark_MemorialPlaque  (35, 11),
     CategoryOfLandmark_Obelisk  (35, 12),
     CategoryOfLandmark_Statue  (35, 13),
     CategoryOfLandmark_Cross  (35, 14),
     CategoryOfLandmark_Dome  (35, 15),
     CategoryOfLandmark_Tower  (35, 17),
     CategoryOfLandmark_RadarScanner  (35, 16),
     CategoryOfLandmark_Windmotor  (35, 19),
     CategoryOfLandmark_Windmill  (35, 18),
     CategoryOfLandmark_LargeRockOrBoulderOnLand  (35, 21),
     CategoryOfLandmark_SpireMinaret  (35, 20),
     CategoryOfLandmark_RockPinnacle  (35, 22),
     CategoryOfIce_FastIce  (32, 1),
     CategoryOfIce_Glacier  (32, 5),
     CategoryOfIce_PolarIce  (32, 8),
     CategoryOfInstallationBuoy_CatenaryAnchorLegMooringCalm  (33, 1),
     CategoryOfInstallationBuoy_SingleBuoyMooringSbmOrSpm  (33, 2),
     CategoryOfMarineFarmCulture_Crustaceans  (38, 1),
     CategoryOfMarineFarmCulture_OysterMussels  (38, 2),
     CategoryOfMarineFarmCulture_Fish  (38, 3),
     CategoryOfMarineFarmCulture_Seaweed  (38, 4),
     CategoryOfMilitaryPracticeArea_TorpedoExerciseArea  (39, 2),
     CategoryOfMilitaryPracticeArea_SubmarineExerciseArea  (39, 3),
     CategoryOfMilitaryPracticeArea_FiringDangerArea  (39, 4),
     CategoryOfMilitaryPracticeArea_MineLayingPracticeArea  (39, 5),
     CategoryOfMilitaryPracticeArea_SmallArmsFiringRange  (39, 6),
     CategoryOfLateralMark_PortHandLateralMark  (36, 1),
     CategoryOfLateralMark_StarboardHandLateralMark  (36, 2),
     CategoryOfLateralMark_PreferredChannelToStarboardLateralMark  (36, 3),
     CategoryOfLateralMark_PreferredChannelToPortLateralMark  (36, 4),
     CategoryOfLight_DirectionalFunction  (37, 1),
     CategoryOfLight_LeadingLight  (37, 4),
     CategoryOfLight_AeroLight  (37, 5),
     CategoryOfLight_AirObstructionLight  (37, 6),
     CategoryOfLight_FogDetectorLight  (37, 7),
     CategoryOfLight_FloodLight  (37, 8),
     CategoryOfLight_StripLight  (37, 9),
     CategoryOfLight_SubsidiaryLight  (37, 10),
     CategoryOfLight_Spotlight  (37, 11),
     CategoryOfLight_Front  (37, 12),
     CategoryOfLight_Rear  (37, 13),
     CategoryOfLight_Lower  (37, 14),
     CategoryOfLight_Upper  (37, 15),
     CategoryOfLight_Emergency  (37, 17),
     CategoryOfLight_MoirEffect  (37, 16),
     CategoryOfLight_HorizontallyDisposed  (37, 19),
     CategoryOfLight_BearingLight  (37, 18),
     CategoryOfLight_VerticallyDisposed  (37, 20),
     CategoryOfObstruction_SnagStump  (42, 1),
     CategoryOfObstruction_Wellhead  (42, 2),
     CategoryOfObstruction_Diffuser  (42, 3),
     CategoryOfObstruction_Crib  (42, 4),
     CategoryOfObstruction_FishHaven  (42, 5),
     CategoryOfObstruction_FoulArea  (42, 6),
     CategoryOfObstruction_FoulGround  (42, 7),
     CategoryOfObstruction_IceBoom  (42, 8),
     CategoryOfObstruction_GroundTackle  (42, 9),
     CategoryOfObstruction_Boom  (42, 10),
     CategoryOfOffshorePlatform_OilDerrickRig  (43, 1),
     CategoryOfOffshorePlatform_ProductionPlatform  (43, 2),
     CategoryOfOffshorePlatform_ObservationResearchPlatform  (43, 3),
     CategoryOfOffshorePlatform_ArticulatedLoadingPlatformAlp  (43, 4),
     CategoryOfOffshorePlatform_SingleAnchorLegMooringSalm  (43, 5),
     CategoryOfOffshorePlatform_MooringTower  (43, 6),
     CategoryOfOffshorePlatform_ArtificialIsland  (43, 7),
     CategoryOfOffshorePlatform_FloatingProductionStorageAndOffLoadingVesselFpso  (43, 8),
     CategoryOfOffshorePlatform_AccomodationPlatform  (43, 9),
     CategoryOfOffshorePlatform_NavigationCommunicationAndControlBuoyNccb  (43, 10),
     CategoryOfMooringWarpingFacility_Dolphin  (40, 1),
     CategoryOfMooringWarpingFacility_DeviationDolphin  (40, 2),
     CategoryOfMooringWarpingFacility_Bollard  (40, 3),
     CategoryOfMooringWarpingFacility_TieUpWall  (40, 4),
     CategoryOfMooringWarpingFacility_PostOrPile  (40, 5),
     CategoryOfMooringWarpingFacility_ChainWireCable  (40, 6),
     CategoryOfMooringWarpingFacility_MooringBuoy  (40, 7),
     CategoryOfNavigationLine_ClearingLine  (41, 1),
     CategoryOfNavigationLine_TransitLine  (41, 2),
     CategoryOfNavigationLine_LeadingLineBearingARecommendedTrack  (41, 3),
     CategoryOfPilotBoardingPlace_BoardingByPilotCruisingVessel  (46, 1),
     CategoryOfPilotBoardingPlace_BoardingByHelicopter  (46, 2),
     CategoryOfPilotBoardingPlace_PilotComesOutFromShore  (46, 3),
     CategoryOfPipelinePipe_PipelineInGeneral  (47, 1),
     CategoryOfPipelinePipe_OutfallPipe  (47, 2),
     CategoryOfPipelinePipe_IntakePipe  (47, 3),
     CategoryOfPipelinePipe_Sewer  (47, 4),
     CategoryOfPipelinePipe_BubblerSystem  (47, 5),
     CategoryOfPipelinePipe_SupplyPipe  (47, 6),
     CategoryOfOilBarrier_OilRetentionHighPressurePipe  (44, 1),
     CategoryOfOilBarrier_FloatingOilBarrier  (44, 2),
     CategoryOfPile_Stake  (45, 1),
     CategoryOfPile_Post  (45, 3),
     CategoryOfPile_Tripodal  (45, 4),
     CategoryOfRadarStation_RadarSurveillanceStation  (51, 1),
     CategoryOfRadarStation_CoastRadarStation  (51, 2),
     CategoryOfQualityOfData_DataQualityA  (50, 1),
     CategoryOfQualityOfData_DataQualityB  (50, 2),
     CategoryOfQualityOfData_DataQualityC  (50, 3),
     CategoryOfQualityOfData_DataQualityD  (50, 4),
     CategoryOfQualityOfData_DataQualityE  (50, 5),
     CategoryOfQualityOfData_QualityNotEvaluated  (50, 6),
     CategoryOfPylon_PowerTransmissionPylonPole  (49, 1),
     CategoryOfPylon_TelephoneTelegraphPylonPole  (49, 2),
     CategoryOfPylon_AerialCablewaySkyPylon  (49, 3),
     CategoryOfPylon_BridgePylonTower  (49, 4),
     CategoryOfPylon_BridgePier  (49, 5),
     CategoryOfProductionArea_Quarry  (48, 1),
     CategoryOfProductionArea_Mine  (48, 2),
     CategoryOfProductionArea_Stockpile  (48, 3),
     CategoryOfProductionArea_PowerStationArea  (48, 4),
     CategoryOfProductionArea_RefineryArea  (48, 5),
     CategoryOfProductionArea_TimberYard  (48, 6),
     CategoryOfProductionArea_FactoryArea  (48, 7),
     CategoryOfProductionArea_TankFarm  (48, 8),
     CategoryOfProductionArea_WindFarm  (48, 9),
     CategoryOfRescueStation_RescueStationWithLifeboat  (55, 1),
     CategoryOfRescueStation_RescueStationWithRocket  (55, 2),
     CategoryOfRescueStation_RefugeForShipwreckedMariners  (55, 4),
     CategoryOfRescueStation_RefugeForIntertidalAreaWalkers  (55, 5),
     CategoryOfRescueStation_LifeboatLyingAtAMooring  (55, 6),
     CategoryOfRecommendedTrack_BasedOnASystemOfFixedMarks  (54, 1),
     CategoryOfRecommendedTrack_NotBasedOnASystemOfFixedMarks  (54, 2),
     CategoryOfRadioStation_CircularNonDirectionalMarineOrAeroMarineRadiobeacon  (53, 1),
     CategoryOfRadioStation_DirectionalRadiobeacon  (53, 2),
     CategoryOfRadioStation_RotatingPatternRadiobeacon  (53, 3),
     CategoryOfRadioStation_ConsolBeacon  (53, 4),
     CategoryOfRadioStation_RadioDirectionFindingStation  (53, 5),
     CategoryOfRadioStation_CoastRadioStationProvidingQtgService  (53, 6),
     CategoryOfRadioStation_AeronauticalRadiobeacon  (53, 7),
     CategoryOfRadioStation_Decca  (53, 8),
     CategoryOfRadioStation_LoranC  (53, 9),
     CategoryOfRadioStation_DifferentialGps  (53, 10),
     CategoryOfRadioStation_Toran  (53, 11),
     CategoryOfRadioStation_Omega  (53, 12),
     CategoryOfRadioStation_Syledis  (53, 13),
     CategoryOfRadioStation_ChaikaChayka  (53, 14),
     CategoryOfRadarTransponderBeacon_RamarkRadarBeaconTransmittingContinuously  (52, 1),
     CategoryOfRadarTransponderBeacon_RaconRadarTransponderBeacon  (52, 2),
     CategoryOfRadarTransponderBeacon_LeadingRaconRadarTransponderBeacon  (52, 3),
     CategoryOfSeaArea_Gat  (59, 2),
     CategoryOfSeaArea_Bank  (59, 3),
     CategoryOfSeaArea_Deep  (59, 4),
     CategoryOfSeaArea_Bay  (59, 5),
     CategoryOfSeaArea_Trench  (59, 6),
     CategoryOfSeaArea_Basin  (59, 7),
     CategoryOfSeaArea_MudFlats  (59, 8),
     CategoryOfSeaArea_Reef  (59, 9),
     CategoryOfSeaArea_Ledge  (59, 10),
     CategoryOfSeaArea_Canyon  (59, 11),
     CategoryOfSeaArea_Narrows  (59, 12),
     CategoryOfSeaArea_Shoal  (59, 13),
     CategoryOfSeaArea_Knoll  (59, 14),
     CategoryOfSeaArea_Ridge  (59, 15),
     CategoryOfSeaArea_Pinnacle  (59, 17),
     CategoryOfSeaArea_Seamount  (59, 16),
     CategoryOfSeaArea_Plateau  (59, 19),
     CategoryOfSeaArea_AbyssalPlain  (59, 18),
     CategoryOfSeaArea_Shelf  (59, 21),
     CategoryOfSeaArea_Spur  (59, 20),
     CategoryOfSeaArea_Saddle  (59, 23),
     CategoryOfSeaArea_Trough  (59, 22),
     CategoryOfSeaArea_Apron  (59, 25),
     CategoryOfSeaArea_AbyssalHills  (59, 24),
     CategoryOfSeaArea_Borderland  (59, 27),
     CategoryOfSeaArea_ArchipelagicApron  (59, 26),
     CategoryOfSeaArea_ContinentalRise  (59, 29),
     CategoryOfSeaArea_ContinentalMargin  (59, 28),
     CategoryOfSeaArea_Fan  (59, 31),
     CategoryOfSeaArea_Escarpment  (59, 30),
     CategoryOfSeaArea_Guyot  (59, 34),
     CategoryOfSeaArea_Hill  (59, 35),
     CategoryOfSeaArea_FractureZone  (59, 32),
     CategoryOfSeaArea_Gap  (59, 33),
     CategoryOfSeaArea_MedianValley  (59, 38),
     CategoryOfSeaArea_Moat  (59, 39),
     CategoryOfSeaArea_Hole  (59, 36),
     CategoryOfSeaArea_Levee  (59, 37),
     CategoryOfSeaArea_Province  (59, 42),
     CategoryOfSeaArea_Rise  (59, 43),
     CategoryOfSeaArea_Mountains  (59, 40),
     CategoryOfSeaArea_Peak  (59, 41),
     CategoryOfSeaArea_ShelfEdge  (59, 46),
     CategoryOfSeaArea_Sill  (59, 47),
     CategoryOfSeaArea_Seachannel  (59, 44),
     CategoryOfSeaArea_SeamountChain  (59, 45),
     CategoryOfSeaArea_Canal  (59, 51),
     CategoryOfSeaArea_Valley  (59, 50),
     CategoryOfSeaArea_Terrace  (59, 49),
     CategoryOfSeaArea_Slope  (59, 48),
     CategoryOfSeaArea_Reach  (59, 54),
     CategoryOfSeaArea_River  (59, 53),
     CategoryOfSeaArea_Lake  (59, 52),
     CategoryOfRunway_Aeroplane  (58, 1),
     CategoryOfRunway_HelicopterLandingPad  (58, 2),
     CategoryOfRoad_Motorway  (57, 1),
     CategoryOfRoad_MajorRoad  (57, 2),
     CategoryOfRoad_MinorRoad  (57, 3),
     CategoryOfRoad_TrackPath  (57, 4),
     CategoryOfRoad_MajorStreet  (57, 5),
     CategoryOfRoad_MinorStreet  (57, 6),
     CategoryOfRoad_Crossing  (57, 7),
     CategoryOfRestrictedArea_OffshoreSafetyZone  (56, 1),
     CategoryOfRestrictedArea_AnchoringProhibitionArea  (56, 2),
     CategoryOfRestrictedArea_FishingProhibitionArea  (56, 3),
     CategoryOfRestrictedArea_NatureReserve  (56, 4),
     CategoryOfRestrictedArea_BirdSanctuary  (56, 5),
     CategoryOfRestrictedArea_GamePreserve  (56, 6),
     CategoryOfRestrictedArea_SealSanctuary  (56, 7),
     CategoryOfRestrictedArea_DegaussingRange  (56, 8),
     CategoryOfRestrictedArea_MilitaryArea  (56, 9),
     CategoryOfRestrictedArea_HistoricWreckArea  (56, 10),
     CategoryOfRestrictedArea_InshoreTrafficZone  (56, 11),
     CategoryOfRestrictedArea_NavigationalAidSafetyZone  (56, 12),
     CategoryOfRestrictedArea_DangerOfStrandingArea  (56, 13),
     CategoryOfRestrictedArea_Minefield  (56, 14),
     CategoryOfRestrictedArea_DivingProhibitionArea  (56, 15),
     CategoryOfRestrictedArea_ProhibitedArea  (56, 17),
     CategoryOfRestrictedArea_AreaToBeAvoided  (56, 16),
     CategoryOfRestrictedArea_WaitingArea  (56, 19),
     CategoryOfRestrictedArea_SwimmingArea  (56, 18),
     CategoryOfRestrictedArea_DredgingArea  (56, 21),
     CategoryOfRestrictedArea_ResearchArea  (56, 20),
     CategoryOfRestrictedArea_EcologicalReserve  (56, 23),
     CategoryOfRestrictedArea_FishSanctuary  (56, 22),
     CategoryOfRestrictedArea_SwingingArea  (56, 25),
     CategoryOfRestrictedArea_NoWakeArea  (56, 24),
     CategoryOfRestrictedArea_EnvironmentallySensitiveSeaArea  (56, 27),
     CategoryOfRestrictedArea_WaterSkiingArea  (56, 26),
     CategoryOfRestrictedArea_ParticularlySensitiveSeaArea  (56, 28),
     CategoryOfSiloTank_SiloInGeneral  (63, 1),
     CategoryOfSiloTank_TankInGeneral  (63, 2),
     CategoryOfSiloTank_GrainElevator  (63, 3),
     CategoryOfSiloTank_WaterTower  (63, 4),
     CategoryOfSignalStationWarning_Danger  (62, 1),
     CategoryOfSignalStationWarning_MaritimeObstruction  (62, 2),
     CategoryOfSignalStationWarning_Cable  (62, 3),
     CategoryOfSignalStationWarning_MilitaryPractice  (62, 4),
     CategoryOfSignalStationWarning_Distress  (62, 5),
     CategoryOfSignalStationWarning_Weather  (62, 6),
     CategoryOfSignalStationWarning_Storm  (62, 7),
     CategoryOfSignalStationWarning_Ice  (62, 8),
     CategoryOfSignalStationWarning_Time  (62, 9),
     CategoryOfSignalStationWarning_Tide  (62, 10),
     CategoryOfSignalStationWarning_TidalStream  (62, 11),
     CategoryOfSignalStationWarning_TideGauge  (62, 12),
     CategoryOfSignalStationWarning_TideScale  (62, 13),
     CategoryOfSignalStationWarning_Diving  (62, 14),
     CategoryOfSignalStationWarning_WaterLevelGauge  (62, 15),
     CategoryOfSignalStationTraffic_PortControl  (61, 1),
     CategoryOfSignalStationTraffic_PortEntryAndDeparture  (61, 2),
     CategoryOfSignalStationTraffic_InternationalPortTraffic  (61, 3),
     CategoryOfSignalStationTraffic_Berthing  (61, 4),
     CategoryOfSignalStationTraffic_Dock  (61, 5),
     CategoryOfSignalStationTraffic_Lock  (61, 6),
     CategoryOfSignalStationTraffic_FloodBarrage  (61, 7),
     CategoryOfSignalStationTraffic_BridgePassage  (61, 8),
     CategoryOfSignalStationTraffic_Dredging  (61, 9),
     CategoryOfSignalStationTraffic_TrafficControlLight  (61, 10),
     CategoryOfShorelineConstruction_Breakwater  (60, 1),
     CategoryOfShorelineConstruction_GroyneGroin  (60, 2),
     CategoryOfShorelineConstruction_Mole  (60, 3),
     CategoryOfShorelineConstruction_PierJetty  (60, 4),
     CategoryOfShorelineConstruction_Promenadepier  (60, 5),
     CategoryOfShorelineConstruction_WharfQuay  (60, 6),
     CategoryOfShorelineConstruction_TrainingWall  (60, 7),
     CategoryOfShorelineConstruction_RipRap  (60, 8),
     CategoryOfShorelineConstruction_Revetment  (60, 9),
     CategoryOfShorelineConstruction_SeaWall  (60, 10),
     CategoryOfShorelineConstruction_LandingSteps  (60, 11),
     CategoryOfShorelineConstruction_Ramp  (60, 12),
     CategoryOfShorelineConstruction_Slipway  (60, 13),
     CategoryOfShorelineConstruction_Fender  (60, 14),
     CategoryOfShorelineConstruction_SolidFaceWharf  (60, 15),
     CategoryOfShorelineConstruction_LogRamp  (60, 17),
     CategoryOfShorelineConstruction_OpenFaceWharf  (60, 16),
     CategoryOfVegetation_Grassland  (68, 1),
     CategoryOfVegetation_Bush  (68, 3),
     CategoryOfVegetation_DeciduousWood  (68, 4),
     CategoryOfVegetation_ConiferousWood  (68, 5),
     CategoryOfVegetation_WoodInGeneralIncMixedWood  (68, 6),
     CategoryOfVegetation_Mangroves  (68, 7),
     CategoryOfVegetation_MixedCrops  (68, 10),
     CategoryOfVegetation_Reed  (68, 11),
     CategoryOfVegetation_Moos  (68, 12),
     CategoryOfVegetation_TreeInGeneral  (68, 13),
     CategoryOfVegetation_EvergreenTree  (68, 14),
     CategoryOfVegetation_ConiferousTree  (68, 15),
     CategoryOfVegetation_NipaPalmTree  (68, 17),
     CategoryOfVegetation_PalmTree  (68, 16),
     CategoryOfVegetation_EucalyptTree  (68, 19),
     CategoryOfVegetation_CasuarinaTree  (68, 18),
     CategoryOfVegetation_MangroveTree  (68, 21),
     CategoryOfVegetation_DeciduousTree  (68, 20),
     CategoryOfVegetation_FilaoTree  (68, 22),
     CategoryOfWaterTurbulence_Breakers  (69, 1),
     CategoryOfWaterTurbulence_Eddies  (69, 2),
     CategoryOfWaterTurbulence_Overfalls  (69, 3),
     CategoryOfWaterTurbulence_TideRips  (69, 4),
     CategoryOfWaterTurbulence_Bombora  (69, 5),
     CategoryOfWeedKelp_Kelp  (70, 1),
     CategoryOfWeedKelp_SeaWeed  (70, 2),
     CategoryOfWeedKelp_SeaGrass  (70, 3),
     CategoryOfWeedKelp_Saragasso  (70, 4),
     CategoryOfWreck_NonDangerousWreck  (71, 1),
     CategoryOfWreck_DangerousWreck  (71, 2),
     CategoryOfWreck_DistributedRemainsOfWreck  (71, 3),
     CategoryOfWreck_WreckShowingMastMasts  (71, 4),
     CategoryOfWreck_WreckShowingAnyPortionOfHullOrSuperstructure  (71, 5),
     CategoryOfSlope_Cutting  (64, 1),
     CategoryOfSlope_Embankment  (64, 2),
     CategoryOfSlope_Dune  (64, 3),
     CategoryOfSlope_Hill  (64, 4),
     CategoryOfSlope_Pingo  (64, 5),
     CategoryOfSlope_Cliff  (64, 6),
     CategoryOfSlope_Scree  (64, 7),
     CategoryOfSmallCraftFacility_VisitorsBerth  (65, 1),
     CategoryOfSmallCraftFacility_NauticalClub  (65, 2),
     CategoryOfSmallCraftFacility_BoatHoist  (65, 3),
     CategoryOfSmallCraftFacility_Sailmaker  (65, 4),
     CategoryOfSmallCraftFacility_Boatyard  (65, 5),
     CategoryOfSmallCraftFacility_PublicInn  (65, 6),
     CategoryOfSmallCraftFacility_Restaurant  (65, 7),
     CategoryOfSmallCraftFacility_Chandler  (65, 8),
     CategoryOfSmallCraftFacility_Provisions  (65, 9),
     CategoryOfSmallCraftFacility_Doctor  (65, 10),
     CategoryOfSmallCraftFacility_Pharmacy  (65, 11),
     CategoryOfSmallCraftFacility_WaterTap  (65, 12),
     CategoryOfSmallCraftFacility_FuelStation  (65, 13),
     CategoryOfSmallCraftFacility_Electricity  (65, 14),
     CategoryOfSmallCraftFacility_BottleGas  (65, 15),
     CategoryOfSmallCraftFacility_Launderette  (65, 17),
     CategoryOfSmallCraftFacility_Showers  (65, 16),
     CategoryOfSmallCraftFacility_PostBox  (65, 19),
     CategoryOfSmallCraftFacility_PublicToilets  (65, 18),
     CategoryOfSmallCraftFacility_RefuseBin  (65, 21),
     CategoryOfSmallCraftFacility_PublicTelephone  (65, 20),
     CategoryOfSmallCraftFacility_ParkingForBoatsAndTrailers  (65, 23),
     CategoryOfSmallCraftFacility_CarPark  (65, 22),
     CategoryOfSmallCraftFacility_CampingSite  (65, 25),
     CategoryOfSmallCraftFacility_CaravanSite  (65, 24),
     CategoryOfSmallCraftFacility_EmergencyTelephone  (65, 27),
     CategoryOfSmallCraftFacility_SeweragePumpOutStation  (65, 26),
     CategoryOfSmallCraftFacility_VisitorsMooring  (65, 29),
     CategoryOfSmallCraftFacility_LandingLaunchingPlaceForBoats  (65, 28),
     CategoryOfSmallCraftFacility_PicnicArea  (65, 31),
     CategoryOfSmallCraftFacility_ScrubbingBerth  (65, 30),
     CategoryOfSmallCraftFacility_MechanicsWorkshop  (65, 32),
     CategoryOfSmallCraftFacility_GuardOrSecurityService  (65, 33),
     CategoryOfSpecialPurposeMark_FiringDangerAreaMark  (66, 1),
     CategoryOfSpecialPurposeMark_TargetMark  (66, 2),
     CategoryOfSpecialPurposeMark_MarkerShipMark  (66, 3),
     CategoryOfSpecialPurposeMark_DegaussingRangeMark  (66, 4),
     CategoryOfSpecialPurposeMark_BargeMark  (66, 5),
     CategoryOfSpecialPurposeMark_CableMark  (66, 6),
     CategoryOfSpecialPurposeMark_SpoilGroundMark  (66, 7),
     CategoryOfSpecialPurposeMark_OutfallMark  (66, 8),
     CategoryOfSpecialPurposeMark_OdasOceanDataAcquisitionSystem  (66, 9),
     CategoryOfSpecialPurposeMark_RecordingMark  (66, 10),
     CategoryOfSpecialPurposeMark_SeaplaneAnchorageMark  (66, 11),
     CategoryOfSpecialPurposeMark_RecreationZoneMark  (66, 12),
     CategoryOfSpecialPurposeMark_PrivateMark  (66, 13),
     CategoryOfSpecialPurposeMark_MooringMark  (66, 14),
     CategoryOfSpecialPurposeMark_LanbyLargeAutomaticNavigationalBuoy  (66, 15),
     CategoryOfSpecialPurposeMark_MeasuredDistanceMark  (66, 17),
     CategoryOfSpecialPurposeMark_LeadingMark  (66, 16),
     CategoryOfSpecialPurposeMark_TssMarkTrafficSeparationScheme  (66, 19),
     CategoryOfSpecialPurposeMark_NoticeMark  (66, 18),
     CategoryOfSpecialPurposeMark_BerthingProhibitedMark  (66, 21),
     CategoryOfSpecialPurposeMark_AnchoringProhibitedMark  (66, 20),
     CategoryOfSpecialPurposeMark_TwoWayTrafficProhibitedMark  (66, 23),
     CategoryOfSpecialPurposeMark_OvertakingProhibitedMark  (66, 22),
     CategoryOfSpecialPurposeMark_SpeedLimitMark  (66, 25),
     CategoryOfSpecialPurposeMark_ReducedWakeMark  (66, 24),
     CategoryOfSpecialPurposeMark_GeneralWarningMark  (66, 27),
     CategoryOfSpecialPurposeMark_StopMark  (66, 26),
     CategoryOfSpecialPurposeMark_RestrictedVerticalClearenceMark  (66, 29),
     CategoryOfSpecialPurposeMark_SoundShipsSirenMark  (66, 28),
     CategoryOfSpecialPurposeMark_RestrictedHorizontalClearanceMark  (66, 31),
     CategoryOfSpecialPurposeMark_MaximumVesselsDraughtMark  (66, 30),
     CategoryOfSpecialPurposeMark_OverheadPowerCableMark  (66, 34),
     CategoryOfSpecialPurposeMark_ChannelEdgeGradientMark  (66, 35),
     CategoryOfSpecialPurposeMark_StrongCurrentWarningMark  (66, 32),
     CategoryOfSpecialPurposeMark_BerthingPermittedMark  (66, 33),
     CategoryOfSpecialPurposeMark_PiplineMark  (66, 39),
     CategoryOfSpecialPurposeMark_TelephoneMark  (66, 36),
     CategoryOfSpecialPurposeMark_FerryCrossingMark  (66, 37),
     CategoryOfSpecialPurposeMark_ControlMark  (66, 42),
     CategoryOfSpecialPurposeMark_DivingMark  (66, 43),
     CategoryOfSpecialPurposeMark_AnchorageMark  (66, 40),
     CategoryOfSpecialPurposeMark_ClearingMark  (66, 41),
     CategoryOfSpecialPurposeMark_YachtingMark  (66, 46),
     CategoryOfSpecialPurposeMark_HeliportMark  (66, 47),
     CategoryOfSpecialPurposeMark_RefugeBeacon  (66, 44),
     CategoryOfSpecialPurposeMark_FoulGroundMark  (66, 45),
     CategoryOfSpecialPurposeMark_WorkInProgressMark  (66, 51),
     CategoryOfSpecialPurposeMark_EntryProhibitedMark  (66, 50),
     CategoryOfSpecialPurposeMark_SeaplaneLandingMark  (66, 49),
     CategoryOfSpecialPurposeMark_GpsMark  (66, 48),
     CategoryOfSpecialPurposeMark_MarineFarmMark  (66, 55),
     CategoryOfSpecialPurposeMark_ChannelSeparationMark  (66, 54),
     CategoryOfSpecialPurposeMark_WellheadMark  (66, 53),
     CategoryOfSpecialPurposeMark_MarkWithUnknownPurpose  (66, 52),
     CategoryOfSpecialPurposeMark_ArtificialReefMark  (66, 56),
     CategoryOfTrafficSeparationScheme_ImoAdopted  (67, 1),
     CategoryOfTrafficSeparationScheme_NotImoAdopted  (67, 2),
     ColourPattern_HorizontalStripes  (76, 1),
     ColourPattern_VerticalStripes  (76, 2),
     ColourPattern_DiagonalStripes  (76, 3),
     ColourPattern_Squared  (76, 4),
     ColourPattern_StripesDirectionUnknown  (76, 5),
     ColourPattern_BorderStripes  (76, 6),
     CategoryOfZoneOfConfidenceData_ZoneOfConfidenceA1  (72, 1),
     CategoryOfZoneOfConfidenceData_ZoneOfConfidenceA2  (72, 2),
     CategoryOfZoneOfConfidenceData_ZoneOfConfidenceB  (72, 3),
     CategoryOfZoneOfConfidenceData_ZoneOfConfidenceC  (72, 4),
     CategoryOfZoneOfConfidenceData_ZoneOfConfidenceD  (72, 5),
     CategoryOfZoneOfConfidenceData_ZoneOfConfidenceUDataNotAssessed  (72, 6),
     CharacterSpacing_ExpandedCondensed  (73, 1),
     CharacterSpacing_Standard  (73, 2),
     Colour_White  (75, 1),
     Colour_Black  (75, 2),
     Colour_Red  (75, 3),
     Colour_Green  (75, 4),
     Colour_Blue  (75, 5),
     Colour_Yellow  (75, 6),
     Colour_Grey  (75, 7),
     Colour_Brown  (75, 8),
     Colour_Amber  (75, 9),
     Colour_Violet  (75, 10),
     Colour_Orange  (75, 11),
     Colour_Magenta  (75, 12),
     Colour_Pink  (75, 13),
     Condition_UnderConstruction  (81, 1),
     Condition_Ruined  (81, 2),
     Condition_UnderReclamation  (81, 3),
     Condition_Wingless  (81, 4),
     Condition_PlannedConstruction  (81, 5),
     ConspicuousVisual_VisualConspicuous  (83, 1),
     ConspicuousVisual_NotVisualConspicuous  (83, 2),
     ConspicuousRadar_RadarConspicuous  (82, 1),
     ConspicuousRadar_NotRadarConspicuous  (82, 2),
     ConspicuousRadar_RadarConspicuousHasRadarReflector  (82, 3),
     ExpositionOfSounding_WithinTheRangeOfDepthOfTheSurroundingDepthArea  (93, 1),
     ExpositionOfSounding_ShoalerThanRangeOfDepthOfTheSurroundingDepthArea  (93, 2),
     ExpositionOfSounding_DeeperThanRangeOfDepthOfTheSurroundingDepthArea  (93, 3),
     ExhibitionConditionOfLight_LightShownWithoutChangeOfCharacter  (92, 1),
     ExhibitionConditionOfLight_DaytimeLight  (92, 2),
     ExhibitionConditionOfLight_FogLight  (92, 3),
     ExhibitionConditionOfLight_NightLight  (92, 4),
     Function_HarbourMastersOffice  (94, 2),
     Function_CustomOffice  (94, 3),
     Function_HealthOffice  (94, 4),
     Function_Hospital  (94, 5),
     Function_PostOffice  (94, 6),
     Function_Hotel  (94, 7),
     Function_RailwayStation  (94, 8),
     Function_PoliceStation  (94, 9),
     Function_WaterPoliceStation  (94, 10),
     Function_PilotOffice  (94, 11),
     Function_PilotLookout  (94, 12),
     Function_BankOffice  (94, 13),
     Function_HeadquartersForDistrictControl  (94, 14),
     Function_TransitShedWarehouse  (94, 15),
     Function_PowerStation  (94, 17),
     Function_Factory  (94, 16),
     Function_EducationalFacility  (94, 19),
     Function_Administrative  (94, 18),
     Function_Chapel  (94, 21),
     Function_Church  (94, 20),
     Function_Pagoda  (94, 23),
     Function_Temple  (94, 22),
     Function_BuddhistTemple  (94, 25),
     Function_ShintoShrine  (94, 24),
     Function_Marabout  (94, 27),
     Function_Mosque  (94, 26),
     Function_Communication  (94, 29),
     Function_Lookout  (94, 28),
     Function_Radio  (94, 31),
     Function_Television  (94, 30),
     Function_Microwave  (94, 34),
     Function_Cooling  (94, 35),
     Function_Radar  (94, 32),
     Function_LightSupport  (94, 33),
     Function_Clock  (94, 38),
     Function_Control  (94, 39),
     Function_Observation  (94, 36),
     Function_Timeball  (94, 37),
     Function_BusStation  (94, 42),
     Function_AirshipMooring  (94, 40),
     Function_Stadium  (94, 41),
     DepthUnits_Metres  (89, 1),
     DepthUnits_FathomsAndFeet  (89, 2),
     DepthUnits_Feet  (89, 3),
     DepthUnits_FathomsAndFractions  (89, 4),
     Jurisdiction_International  (103, 1),
     Jurisdiction_National  (103, 2),
     Jurisdiction_NationalSubDivision  (103, 3),
     HeightLengthUnits_Metres  (96, 1),
     HeightLengthUnits_Feet  (96, 2),
     LightVisibility_HighIntensity  (108, 1),
     LightVisibility_LowIntensity  (108, 2),
     LightVisibility_Faint  (108, 3),
     LightVisibility_Intensified  (108, 4),
     LightVisibility_Unintensified  (108, 5),
     LightVisibility_VisibilityDeliberatelyRestricted  (108, 6),
     LightVisibility_Obscured  (108, 7),
     LightVisibility_PartiallyObscured  (108, 8),
     MarksNavigationalSystemOf_IalaA  (109, 1),
     MarksNavigationalSystemOf_IalaB  (109, 2),
     MarksNavigationalSystemOf_NoSystem  (109, 9),
     MarksNavigationalSystemOf_OtherSytem  (109, 10),
     LightCharacteristic_Fixed  (107, 1),
     LightCharacteristic_Flashing  (107, 2),
     LightCharacteristic_LongFlashing  (107, 3),
     LightCharacteristic_QuickFlashing  (107, 4),
     LightCharacteristic_VeryQuickFlashing  (107, 5),
     LightCharacteristic_UltraQuickFlashing  (107, 6),
     LightCharacteristic_Isophased  (107, 7),
     LightCharacteristic_Occulting  (107, 8),
     LightCharacteristic_InterruptedQuickFlashing  (107, 9),
     LightCharacteristic_InterruptedVeryQuickFlashing  (107, 10),
     LightCharacteristic_InterruptedUltraQuickFlashing  (107, 11),
     LightCharacteristic_Morse  (107, 12),
     LightCharacteristic_FixedFlash  (107, 13),
     LightCharacteristic_FlashLongFlash  (107, 14),
     LightCharacteristic_OccultingFlash  (107, 15),
     LightCharacteristic_OccultingAlternating  (107, 17),
     LightCharacteristic_FixedLongFlash  (107, 16),
     LightCharacteristic_FlashAlternating  (107, 19),
     LightCharacteristic_LongFlashAlternating  (107, 18),
     LightCharacteristic_GroupAlternating  (107, 20),
     LightCharacteristic_QuickFlashPlusLongFlash  (107, 25),
     LightCharacteristic_UltraQuickFlashPlusLongFlash  (107, 27),
     LightCharacteristic_VeryQuickFlashPlusLongFlash  (107, 26),
     LightCharacteristic_FixedAndAlternatingFlashing  (107, 29),
     LightCharacteristic_Alternating  (107, 28),
     JustificationHorizontal_CentreJustified  (104, 1),
     JustificationHorizontal_RightJustified  (104, 2),
     JustificationHorizontal_LeftJustified  (104, 3),
     JustificationVertical_BottomJustified  (105, 1),
     JustificationVertical_CentreJustified  (105, 2),
     JustificationVertical_TopJustified  (105, 3),
     NatureOfSurfaceQualifyingTerms_Fine  (114, 1),
     NatureOfSurfaceQualifyingTerms_Medium  (114, 2),
     NatureOfSurfaceQualifyingTerms_Coarse  (114, 3),
     NatureOfSurfaceQualifyingTerms_Broken  (114, 4),
     NatureOfSurfaceQualifyingTerms_Sticky  (114, 5),
     NatureOfSurfaceQualifyingTerms_Soft  (114, 6),
     NatureOfSurfaceQualifyingTerms_Stiff  (114, 7),
     NatureOfSurfaceQualifyingTerms_Volcanic  (114, 8),
     NatureOfSurfaceQualifyingTerms_Calcareous  (114, 9),
     NatureOfSurfaceQualifyingTerms_Hard  (114, 10),
     NatureOfSurface_Mud  (113, 1),
     NatureOfSurface_Clay  (113, 2),
     NatureOfSurface_Silt  (113, 3),
     NatureOfSurface_Sand  (113, 4),
     NatureOfSurface_Stone  (113, 5),
     NatureOfSurface_Gravel  (113, 6),
     NatureOfSurface_Pebbles  (113, 7),
     NatureOfSurface_Cobbles  (113, 8),
     NatureOfSurface_Rock  (113, 9),
     NatureOfSurface_Lava  (113, 11),
     NatureOfSurface_Coral  (113, 14),
     NatureOfSurface_Shells  (113, 17),
     NatureOfSurface_Boulder  (113, 18),
     NatureOfConstruction_Masonry  (112, 1),
     NatureOfConstruction_Concreted  (112, 2),
     NatureOfConstruction_LooseBoulders  (112, 3),
     NatureOfConstruction_HardSurfaced  (112, 4),
     NatureOfConstruction_Unsurfaced  (112, 5),
     NatureOfConstruction_Wooden  (112, 6),
     NatureOfConstruction_Metal  (112, 7),
     NatureOfConstruction_GlassReinforcedPlasticGrp  (112, 8),
     NatureOfConstruction_Painted  (112, 9),
     QualityOfSoundingMeasurement_DepthKnown  (125, 1),
     QualityOfSoundingMeasurement_DepthUnknown  (125, 2),
     QualityOfSoundingMeasurement_DoubtfulSounding  (125, 3),
     QualityOfSoundingMeasurement_UnreliableSounding  (125, 4),
     QualityOfSoundingMeasurement_NoBottomFoundAtValueShown  (125, 5),
     QualityOfSoundingMeasurement_LeastDepthKnown  (125, 6),
     QualityOfSoundingMeasurement_LeastDepthUnknownSafeClearanceAtValueShown  (125, 7),
     QualityOfSoundingMeasurement_ValueReportedNotSurveyed  (125, 8),
     QualityOfSoundingMeasurement_ValueReportedNotConfirmed  (125, 9),
     QualityOfSoundingMeasurement_MaintainedDepth  (125, 10),
     QualityOfSoundingMeasurement_NotReguralyMaintained  (125, 11),
     Product_Oil  (123, 1),
     Product_Gas  (123, 2),
     Product_Water  (123, 3),
     Product_Stone  (123, 4),
     Product_Coal  (123, 5),
     Product_Ore  (123, 6),
     Product_Chemicals  (123, 7),
     Product_DrinkingWater  (123, 8),
     Product_Milk  (123, 9),
     Product_Bauxite  (123, 10),
     Product_Coke  (123, 11),
     Product_IronIngots  (123, 12),
     Product_Salt  (123, 13),
     Product_Sand  (123, 14),
     Product_Timber  (123, 15),
     Product_ScrapMetal  (123, 17),
     Product_SawdustWoodChips  (123, 16),
     Product_LiquifiedPetroleumGasLpg  (123, 19),
     Product_LiquifiedNaturalGasLng  (123, 18),
     Product_Cement  (123, 21),
     Product_Wine  (123, 20),
     Product_Grain  (123, 22),
     SignalGeneration_Automatically  (140, 1),
     SignalGeneration_ByWaveAction  (140, 2),
     SignalGeneration_ByHand  (140, 3),
     SignalGeneration_ByWind  (140, 4),
     Restriction_AnchoringProhibited  (131, 1),
     Restriction_AnchoringRestricted  (131, 2),
     Restriction_FishingProhibited  (131, 3),
     Restriction_FishingRestricted  (131, 4),
     Restriction_TrawlingProhibited  (131, 5),
     Restriction_TrawlingRestricted  (131, 6),
     Restriction_EntryProhibited  (131, 7),
     Restriction_EntryRestricted  (131, 8),
     Restriction_DredgingProhibited  (131, 9),
     Restriction_DredgingRestricted  (131, 10),
     Restriction_DivingProhibited  (131, 11),
     Restriction_DivingRestricted  (131, 12),
     Restriction_NoWake  (131, 13),
     Restriction_AreaToBeAvoided  (131, 14),
     Restriction_ConstructionProhibited  (131, 15),
     Restriction_DischargingRestricted  (131, 17),
     Restriction_DischargingProhibited  (131, 16),
     Restriction_IndustrialOrMineralExplorationRestricted  (131, 19),
     Restriction_IndustrialOrMineralExplorationProhibited  (131, 18),
     Restriction_DrillingRestricted  (131, 21),
     Restriction_DrillingProhibited  (131, 20),
     Restriction_CargoTransshipmentProhibited  (131, 23),
     Restriction_RemovalOfHistoricalArtifactsProhibited  (131, 22),
     Restriction_StoppingProhibited  (131, 25),
     Restriction_DraggingProhibited  (131, 24),
     Restriction_SpeedRestricted  (131, 27),
     Restriction_LandingProhibited  (131, 26),
     SurveyType_ReconnaissanceSketchSurvey  (153, 1),
     SurveyType_ControlledSurvey  (153, 2),
     SurveyType_ExamintionSurvey  (153, 4),
     SurveyType_PassageSurvey  (153, 5),
     SurveyType_RemotelySensed  (153, 6),
     TechniqueOfSoundingMeasurement_FoundByEchoSounder  (156, 1),
     TechniqueOfSoundingMeasurement_FoundBySideScanSonar  (156, 2),
     TechniqueOfSoundingMeasurement_FoundByMultiBeam  (156, 3),
     TechniqueOfSoundingMeasurement_FoundByDiver  (156, 4),
     TechniqueOfSoundingMeasurement_FoundByLeadLine  (156, 5),
     TechniqueOfSoundingMeasurement_SweptByWireDrag  (156, 6),
     TechniqueOfSoundingMeasurement_FoundByLaser  (156, 7),
     TechniqueOfSoundingMeasurement_SweptByVerticalAcousticSystem  (156, 8),
     TechniqueOfSoundingMeasurement_FoundByElectromagneticSensor  (156, 9),
     TechniqueOfSoundingMeasurement_Photogrammetry  (156, 10),
     TechniqueOfSoundingMeasurement_SateliteImagery  (156, 11),
     TechniqueOfSoundingMeasurement_FoundByLevelling  (156, 12),
     TechniqueOfSoundingMeasurement_SweptBySideScanSonar  (156, 13),
     TechniqueOfSoundingMeasurement_ComputerGenerated  (156, 14),
     Status_Permanent  (149, 1),
     Status_Occasional  (149, 2),
     Status_Recommended  (149, 3),
     Status_Disused  (149, 4),
     Status_PeriodicallyIntermittent  (149, 5),
     Status_Reserved  (149, 6),
     Status_Temporary  (149, 7),
     Status_Private  (149, 8),
     Status_Mandatory  (149, 9),
     Status_Extinguished  (149, 11),
     Status_Illuminated  (149, 12),
     Status_Historic  (149, 13),
     Status_Public  (149, 14),
     Status_Synchronized  (149, 15),
     Status_UnWatched  (149, 17),
     Status_Watched  (149, 16),
     Status_ExistenceDoubtful  (149, 18),
     TopmarkDaymarkShape_ConePointUp  (171, 1),
     TopmarkDaymarkShape_ConePointDown  (171, 2),
     TopmarkDaymarkShape_Sphere  (171, 3),
     TopmarkDaymarkShape_2Sphere  (171, 4),
     TopmarkDaymarkShape_CylinderCan  (171, 5),
     TopmarkDaymarkShape_Board  (171, 6),
     TopmarkDaymarkShape_XShapeStAndrewsCross  (171, 7),
     TopmarkDaymarkShape_UprightCrossStGeorgeCross  (171, 8),
     TopmarkDaymarkShape_CubePointUp  (171, 9),
     TopmarkDaymarkShape_2ConesPointToPoint  (171, 10),
     TopmarkDaymarkShape_2ConesBaseToBase  (171, 11),
     TopmarkDaymarkShape_RhombusDiamond  (171, 12),
     TopmarkDaymarkShape_2ConesPointsUpward  (171, 13),
     TopmarkDaymarkShape_2ConesPointsDownward  (171, 14),
     TopmarkDaymarkShape_BesomPointUpBroomOrPerch  (171, 15),
     TopmarkDaymarkShape_Flag  (171, 17),
     TopmarkDaymarkShape_BesomPointDownBroomOrPerch  (171, 16),
     TopmarkDaymarkShape_Square  (171, 19),
     TopmarkDaymarkShape_SphereOverRhombus  (171, 18),
     TopmarkDaymarkShape_RectangleVertical  (171, 21),
     TopmarkDaymarkShape_RectangleHorizontal  (171, 20),
     TopmarkDaymarkShape_TrapeziumDown  (171, 23),
     TopmarkDaymarkShape_TrapeziumUp  (171, 22),
     TopmarkDaymarkShape_TrianglePointDown  (171, 25),
     TopmarkDaymarkShape_TrianglePointUp  (171, 24),
     TopmarkDaymarkShape_TwoUprightCrossesOneOverTheOther  (171, 27),
     TopmarkDaymarkShape_Circle  (171, 26),
     TopmarkDaymarkShape_TrianglePointingUpOverACircle  (171, 29),
     TopmarkDaymarkShape_TShape  (171, 28),
     TopmarkDaymarkShape_RhombusOverACircle  (171, 31),
     TopmarkDaymarkShape_UprightCrossOverACircle  (171, 30),
     TopmarkDaymarkShape_CircleOverATrianglePointingUp  (171, 32),
     TopmarkDaymarkShape_OtherShapeSeeInform  (171, 33),
     Tint_DarkestBlue  (170, 1),
     Tint_MediumBlue  (170, 2),
     Tint_LightestBlue  (170, 3),
     TrafficFlow_Inbound  (172, 1),
     TrafficFlow_Outbound  (172, 2),
     TrafficFlow_OneWay  (172, 3),
     TrafficFlow_TwoWay  (172, 4),
     TideMethodOfTidalPrediction_SimplifiedHarmonicMethodOfTidalPrediction  (163, 1),
     TideMethodOfTidalPrediction_FullHarmonicMethodOfTidalPrediction  (163, 2),
     TideMethodOfTidalPrediction_HeightAndTimeDifferenceNonHarmonicMethod  (163, 3),
     TideAccuracyOfWaterLevel_BetterThan01mAnd10Minutes  (161, 1),
     TideAccuracyOfWaterLevel_WorseThan01mOr10Minutes  (161, 2),
     WaterLevelEffect_PartlySubmergedAtHighWater  (187, 1),
     WaterLevelEffect_AlwaysDry  (187, 2),
     WaterLevelEffect_AlwaysUnderWaterSubmerged  (187, 3),
     WaterLevelEffect_CoversAndUncovers  (187, 4),
     WaterLevelEffect_Awash  (187, 5),
     WaterLevelEffect_SubjectToInundationOrFlooding  (187, 6),
     WaterLevelEffect_Floating  (187, 7),
     VerticalDatum_MeanLowWaterSprings  (185, 1),
     VerticalDatum_MeanLowerLowWaterSprings  (185, 2),
     VerticalDatum_MeanSeaLevel  (185, 3),
     VerticalDatum_LowestLowWater  (185, 4),
     VerticalDatum_MeanLowWater  (185, 5),
     VerticalDatum_LowestLowWaterSprings  (185, 6),
     VerticalDatum_ApproximateMeanLowWaterSprings  (185, 7),
     VerticalDatum_IndianSpringLowWater  (185, 8),
     VerticalDatum_LowWaterSprings  (185, 9),
     VerticalDatum_ApproximateLowestAstronomicalTide  (185, 10),
     VerticalDatum_NearlyLowestLowWater  (185, 11),
     VerticalDatum_MeanLowerLowWater  (185, 12),
     VerticalDatum_LowWater  (185, 13),
     VerticalDatum_ApproximateMeanLowWater  (185, 14),
     VerticalDatum_ApproximateMeanLowerLowWater  (185, 15),
     VerticalDatum_MeanHighWaterSprings  (185, 17),
     VerticalDatum_MeanHighWater  (185, 16),
     VerticalDatum_ApproximateMeanSeaLevel  (185, 19),
     VerticalDatum_HighWater  (185, 18),
     VerticalDatum_MeanHigherHighWater  (185, 21),
     VerticalDatum_HighWaterSprings  (185, 20),
     VerticalDatum_LowestAstronomicalTide  (185, 23),
     VerticalDatum_EquinoctialSpringLowWater  (185, 22),
     VerticalDatum_InternationalGreatLakesDatum1985  (185, 25),
     VerticalDatum_LocalDatum  (185, 24),
     VerticalDatum_LowerLowWaterLargeTide  (185, 27),
     VerticalDatum_MeanWaterLevel  (185, 26),
     VerticalDatum_NearlyHighestHighWater  (185, 29),
     VerticalDatum_HigherHighWaterLageTide  (185, 28),
     CategoryOfTidalStream_FloodStream  (188, 1),
     CategoryOfTidalStream_EbbStream  (188, 2),
     CategoryOfTidalStream_OtherTidalFlow  (188, 3),
     PositionalAccuracyUnits_Meters  (189, 1),
     PositionalAccuracyUnits_DegreesOfArc  (189, 2),
     PositionalAccuracyUnits_Millimeters  (189, 3),
     PositionalAccuracyUnits_Feet  (189, 4),
     QualityOfPosition_Surveyed  (402, 1),
     QualityOfPosition_Unsurveyed  (402, 2),
     QualityOfPosition_InadequatelySurveyed  (402, 3),
     QualityOfPosition_Approximated  (402, 4),
     QualityOfPosition_PositionDoubtful  (402, 5),
     QualityOfPosition_Unreliable  (402, 6),
     QualityOfPosition_ReportedNotSurveyed  (402, 7),
     QualityOfPosition_ReportedNotConfirmed  (402, 8),
     QualityOfPosition_Estimated  (402, 9),
     QualityOfPosition_PreciselyKnown  (402, 10),
     QualityOfPosition_Calculated  (402, 11),
     HorizontalDatum_Wgs72  (400, 1),
     HorizontalDatum_Wgs84  (400, 2),
     HorizontalDatum_European1950  (400, 3),
     HorizontalDatum_PotsdamDatum  (400, 4),
     HorizontalDatum_Adindan  (400, 5),
     HorizontalDatum_Afgooye  (400, 6),
     HorizontalDatum_AinElAbd1970  (400, 7),
     HorizontalDatum_Anna1Astro1965  (400, 8),
     HorizontalDatum_AntiguaIslandAstro1943  (400, 9),
     HorizontalDatum_Arc1950  (400, 10),
     HorizontalDatum_Arc1960  (400, 11),
     HorizontalDatum_AscensionIsland1958  (400, 12),
     HorizontalDatum_AstroBeaconE1945  (400, 13),
     HorizontalDatum_AstroDos714  (400, 14),
     HorizontalDatum_AstroTernIslandFrig1961  (400, 15),
     HorizontalDatum_AustralianGeodetic1966  (400, 17),
     HorizontalDatum_AstronimicalStation1952  (400, 16),
     HorizontalDatum_AyabelleLighthouse  (400, 19),
     HorizontalDatum_AustralianGeodetic1984  (400, 18),
     HorizontalDatum_Bermuda1957  (400, 21),
     HorizontalDatum_BellevueIgn  (400, 20),
     HorizontalDatum_BogotaObservatory  (400, 23),
     HorizontalDatum_Bissau  (400, 22),
     HorizontalDatum_CampAreaAstro  (400, 25),
     HorizontalDatum_BukitRimpah  (400, 24),
     HorizontalDatum_CantonAstro1966  (400, 27),
     HorizontalDatum_CampoInchauspe1969  (400, 26),
     HorizontalDatum_CapeCanaveral  (400, 29),
     HorizontalDatum_Cape  (400, 28),
     HorizontalDatum_ChatamIslandAstro1971  (400, 31),
     HorizontalDatum_Carthage  (400, 30),
     HorizontalDatum_Dabola  (400, 34),
     HorizontalDatum_DjakartaBatavia  (400, 35),
     HorizontalDatum_ChuaAstro  (400, 32),
     HorizontalDatum_CorregoAlegre  (400, 33),
     HorizontalDatum_European1979  (400, 38),
     HorizontalDatum_FortThomas1955  (400, 39),
     HorizontalDatum_Dos1968  (400, 36),
     HorizontalDatum_EasterIsland1967  (400, 37),
     HorizontalDatum_GraciosaBaseSw1948  (400, 42),
     HorizontalDatum_Guam1963  (400, 43),
     HorizontalDatum_Gan1970  (400, 40),
     HorizontalDatum_GeodeticDatum1949  (400, 41),
     HorizontalDatum_HeratNorth  (400, 46),
     HorizontalDatum_Hjorsey1955  (400, 47),
     HorizontalDatum_GanungSegara  (400, 44),
     HorizontalDatum_Gux1Astro  (400, 45),
     HorizontalDatum_Indian1954  (400, 51),
     HorizontalDatum_Indian  (400, 50),
     HorizontalDatum_HuTzuShan  (400, 49),
     HorizontalDatum_HongKong1963  (400, 48),
     HorizontalDatum_Ists073Astro1969  (400, 55),
     HorizontalDatum_Ists061Astro1968  (400, 54),
     HorizontalDatum_Ireland1965  (400, 53),
     HorizontalDatum_Indian1975  (400, 52),
     HorizontalDatum_Kertau1948  (400, 59),
     HorizontalDatum_KerguelenIsland1949  (400, 58),
     HorizontalDatum_Kandawala  (400, 57),
     HorizontalDatum_JohnstonIsland1961  (400, 56),
     HorizontalDatum_BLANK1  (400, 63),
     HorizontalDatum_BLANK2  (400, 62),
     HorizontalDatum_BLANK3  (400, 61),
     HorizontalDatum_KusaieAstro1951  (400, 60),
     HorizontalDatum_BLANK4  (400, 68),
     HorizontalDatum_BLANK5  (400, 69),
     HorizontalDatum_BLANK6  (400, 70),
     HorizontalDatum_BLANK7  (400, 71),
     HorizontalDatum_BLANK8  (400, 64),
     HorizontalDatum_BLANK9  (400, 65),
     HorizontalDatum_BLANK10  (400, 66),
     HorizontalDatum_BLANK11  (400, 67),
     HorizontalDatum_BLANK12  (400, 76),
     HorizontalDatum_BLANK13  (400, 77),
     HorizontalDatum_BLANK14  (400, 78),
     HorizontalDatum_BLANK15  (400, 79),
     HorizontalDatum_BLANK16  (400, 72),
     HorizontalDatum_BLANK17  (400, 73),
     HorizontalDatum_BLANK18  (400, 74),
     HorizontalDatum_BLANK19  (400, 75),
     HorizontalDatum_BLANK20  (400, 85),
     HorizontalDatum_BLANK21  (400, 84),
     HorizontalDatum_BLANK22  (400, 87),
     HorizontalDatum_BLANK23  (400, 86),
     HorizontalDatum_BLANK24  (400, 81),
     HorizontalDatum_BLANK25  (400, 80),
     HorizontalDatum_BLANK26  (400, 83),
     HorizontalDatum_BLANK27  (400, 82),
     HorizontalDatum_BLANK28  (400, 93),
     HorizontalDatum_BLANK29  (400, 92),
     HorizontalDatum_BLANK30  (400, 95),
     HorizontalDatum_BLANK31  (400, 94),
     HorizontalDatum_BLANK32  (400, 89),
     HorizontalDatum_BLANK33  (400, 88),
     HorizontalDatum_BLANK34  (400, 91),
     HorizontalDatum_BLANK35  (400, 90),
     HorizontalDatum_TananariveObservatory1925  (400, 100),
     HorizontalDatum_BLANK36  (400, 98),
     HorizontalDatum_SouthAsia  (400, 99),
     HorizontalDatum_BLANK37  (400, 96),
     HorizontalDatum_BLANK38  (400, 97);

     private int attributeID;
     private int attributeValueID;
     private static boolean populate = true;
     private static HashMap<Long, ENCAttributeValues> lookupMap = new HashMap<Long, ENCAttributeValues>();

     ENCAttributeValues(int aid, int avid){
         attributeID = aid;
         attributeValueID = avid;
     }

     public static ENCAttributeValues getInstance(int aid, int avid){
         long v1 = aid;
         long v2 = avid;
         if(populate){
             for(ENCAttributeValues p : ENCAttributeValues.values())
                 lookupMap.put(((long)p.attributeID << 32) + (long)p.attributeValueID, p);
             populate = false;
         }
         return lookupMap.get((v1 << 32) + v2);
     }

     public static void write(DataOutputStream fout, ENCAttributeValues attrib) throws IOException{
         fout.writeInt(attrib.attributeID);
         fout.writeInt(attrib.attributeValueID);
     }

     public static ENCAttributeValues read(DataInput fin) throws IOException{
         int _id  = fin.readInt();
         int _vid = fin.readInt();
         return getInstance(_id, _vid);
     }

}

