/*
 * Copyright (c) 2012, Metron, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Metron, Inc. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL METRON, INC. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.metsci.glimpse.charts.vector.parser.autogen;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;

import com.metsci.glimpse.charts.vector.parser.ENCAttributeInterpreter.ENCAttributeHeader;

public class ENCAttributeMaker {

    public ENCAttributeMaker(String pname, String loc){

    }


    public void generateAttribute(ENCAttributeHeader header) throws IOException{

        BufferedWriter _fout = new BufferedWriter(new FileWriter(location + "/" + header.attributeAcronym + ".java"));

        _fout.write("package " + packageName + "\n\n");


        _fout.write("// Autogenerated ENC Enumerated Attribute File \n");
        _fout.write("// " + header.attributeAcronym + " -- " + header.attributeName + "\n");
        _fout.write("public enum " + header.attributeAcronym + " { \n\n");

        Iterator<Integer> _iterator = header.valueTable.keySet().iterator();
        boolean _hasStarted = true;

        while(_iterator.hasNext()){

            int _currentValueID = _iterator.next();

            String _value 		= header.valueTable.get(_currentValueID);

            // Scrub the string
            _value = cleanAttributeValue(_value);

            // Start a new line if necessary
            if(!_hasStarted)
                _fout.write(",\n");
            else
                _hasStarted = false;


            // Create the entry
            _fout.write("\t" + _value + "\t (" + String.valueOf(_currentValueID) + ")");
        }
        _fout.write(";\n\n");


        _fout.write("\t private int id;\n\n");

        _fout.write("\t" + header.attributeAcronym + "(int value){this.id = int;} \n");

        _fout.write("\t public int getID(){return id;}\n");

        _fout.write("\t public static" + header.attributeAcronym + " getInstance(int val) throws Exception{ \n");
        _fout.write("\t \t for(" + header.attributeAcronym + " p : " + header.attributeAcronym + ".values()){\n");
        _fout.write("\t \t \t if(p.getID() == val){return p;}}\n");
        _fout.write("\t throw new Exception(\"Invalid input code: \" + String.valueOf(value));}");

        _fout.write("}\n");
        _fout.close();
    }

    private String cleanAttributeName(String value){

        String _retVal   = new String(value);
        char[] _valArray = null;

        // Make upper case
        _retVal = _retVal.toLowerCase();


        // Remove unwanted contents
        _valArray = _retVal.toCharArray();

        for(int i = 0, n = _valArray.length; i < n; i++){

            // Contents in parenthesis
            if(_valArray[i] == '('){
                _valArray[i] = ' ';

                while(_valArray[i++] != ')'){
                    _valArray[i] = ' ';
                }
                _valArray[i] = ' ';
            }

            // Unwanted characters
            else if(_valArray[i] == '\'' || _valArray[i] == '`'){

                // For apostrophes we perform a backward shift
                for(int j = i; j < _valArray.length - 1; j++){
                    _valArray[j] = _valArray[j + 1];
                }
                _valArray[_valArray.length - 1] = ' ';
            }
            else if(_valArray[i] < 'a' || _valArray[i] > 'z'){
                _valArray[i] = ' ';
            }
        }
        _retVal = new String(_valArray);


        // Remove redundant spaces
        String[] _contents = _retVal.split(" ");

        _retVal = "";

        // Put in canonical form
        for(int i = 0; i < _contents.length; i++){
            if(_contents[i].length() > 0){

                String _firstLetter = "";
                _firstLetter += _contents[i].charAt(0);
                _firstLetter.toUpperCase();
                _firstLetter += _contents[i].substring(1);

                _retVal += _firstLetter;
            }
        }


        return _retVal;
    }


    private String cleanAttributeValue(String value){

        String _retVal   = new String(value);
        char[] _valArray = null;

        // Make upper case
        _retVal = _retVal.toUpperCase();


        // Remove unwanted contents
        _valArray = _retVal.toCharArray();

        for(int i = 0, n = _valArray.length; i < n; i++){

            // Contents in parenthesis
            if(_valArray[i] == '('){
                _valArray[i] = ' ';

                while(_valArray[i++] != ')'){
                    _valArray[i] = ' ';
                }
                _valArray[i] = ' ';
            }

            // Unwanted characters
            else if(_valArray[i] == '\'' || _valArray[i] == '`'){

                // For apostrophes we perform a backward shift
                for(int j = i; j < _valArray.length - 1; j++){
                    _valArray[j] = _valArray[j + 1];
                }
                _valArray[_valArray.length - 1] = ' ';
            }
            else if(_valArray[i] < 'A' || _valArray[i] > 'Z'){
                _valArray[i] = ' ';
            }
        }
        _retVal = new String(_valArray);


        // Remove redundant spaces
        String[] _contents = _retVal.split(" ");

        _retVal = "";

        for(int i = 0; i < _contents.length; i++){
            if(_contents[i].length() > 0){
                // Add some padding space
                if(i != 0)
                    _retVal += '_';

                _retVal += _contents[i];
            }
        }


        return _retVal;
    }

    private String packageName;
    private String location;

}
