/*
 * Copyright (c) 2012, Metron, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Metron, Inc. nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL METRON, INC. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.metsci.glimpse.charts.vector.iteration;

import java.util.ArrayList;
import java.util.List;

import com.metsci.glimpse.charts.vector.parser.objects.GeoObject;


/**
 * A filter that combines multiple filters to act as one.  Use an AND relationship 
 * between filters - if anything is false, false is returned.
 * 
 * @author Cunningham 
 */

public class GeoCompoundFilter<V extends GeoObject> implements GeoFilter<V> {
    private List<GeoFilter<V>> filterList;

    public GeoCompoundFilter() {
        filterList = new ArrayList<GeoFilter<V>>();
    }

    public GeoCompoundFilter(GeoFilter<V> filter) {
        filterList = new ArrayList<GeoFilter<V>>();
        addFilter(filter);
    }

    public GeoCompoundFilter(GeoFilter<V> filter, GeoFilter<V> filter2)  {
        filterList = new ArrayList<GeoFilter<V>>();
        filterList.add(filter);
        filterList.add(filter2);
    }

    public GeoCompoundFilter<V> addFilter(GeoFilter<V> filter) {
        filterList.add(filter);
        return this;
    }

    public boolean passGeoFilter(V geoObj) {
        boolean pass = true;
        for (GeoFilter<V> filter : filterList) {
            if (! filter.passGeoFilter(geoObj)) {
                pass = false;
                break;
            }
        }
        return pass;
    }
}
