/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.parser.objects;

import com.metsci.glimpse.charts.vector.parser.ENCMetaObject;
import com.metsci.glimpse.charts.vector.parser.GenericShape;
import com.metsci.glimpse.charts.vector.parser.attributes.GenericAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GenericObject {
    private static List<ENCMetaObject> metaObjects = new ArrayList<ENCMetaObject>();
    private Map<String, GenericAttribute> attributeMap = new LinkedHashMap<String, GenericAttribute>();
    private List<GenericShape> shapes = new ArrayList<GenericShape>();

    public static GenericAttribute getMetaAttribute(String name) {
        GenericAttribute _retVal = null;
        Iterator<ENCMetaObject> _iterator = metaObjects.iterator();
        while (_retVal == null && _iterator.hasNext()) {
            _retVal = _iterator.next().getAttribute(name);
        }
        System.out.println("resolving meta name: " + name + "; attrib: " + _retVal + " from a list of " + metaObjects.size() + " objects");
        return _retVal;
    }

    public static void linkMetaObject(ENCMetaObject obj) {
        System.out.println("adding meta object " + obj);
        metaObjects.add(obj);
    }

    public static void clearMetaObjects() {
        metaObjects.clear();
    }

    public boolean hasAttribute(String attributeKey) {
        return this.attributeMap.containsKey(attributeKey);
    }

    public GenericAttribute getAttribute(String attributeKey) {
        return this.attributeMap.get(attributeKey);
    }

    public Collection<GenericAttribute> getAttributes() {
        return this.attributeMap.values();
    }

    public void addAttribute(GenericAttribute enca) {
        this.attributeMap.put(enca.getName(), enca);
    }

    public Collection<GenericShape> getShapes() {
        return this.shapes;
    }

    public void addShape(GenericShape encs) {
        this.shapes.add(encs);
    }

    public ENCMetaObject createMetaObject() {
        return new ENCMetaObject(this.attributeMap);
    }

    public String toString() {
        StringBuilder _retVal = new StringBuilder();
        for (GenericAttribute attribute : this.attributeMap.values()) {
            _retVal.append(attribute.toString());
            _retVal.append("\n");
        }
        _retVal.append("\n");
        int n = this.shapes.size();
        for (int i = 0; i < n; ++i) {
            _retVal.append(this.shapes.get(i).toString());
            _retVal.append("\n");
        }
        return _retVal.toString();
    }
}

