/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.parser.objects;

import com.metsci.glimpse.charts.vector.parser.attributes.AttributeDescription;
import com.metsci.glimpse.charts.vector.parser.attributes.ENCAbstractAttribute;
import com.metsci.glimpse.charts.vector.parser.attributes.ENCCodedAttribute;
import com.metsci.glimpse.charts.vector.parser.attributes.ENCEnumAttribute;
import com.metsci.glimpse.charts.vector.parser.attributes.ENCFloatAttribute;
import com.metsci.glimpse.charts.vector.parser.attributes.ENCFreeAttribute;
import com.metsci.glimpse.charts.vector.parser.attributes.ENCIntAttribute;
import com.metsci.glimpse.charts.vector.parser.attributes.ENCListAttribute;
import com.metsci.glimpse.charts.vector.parser.attributes.GeoAttribute;
import com.metsci.glimpse.charts.vector.parser.attributes.GeoIntAttribute;
import com.metsci.glimpse.charts.vector.parser.autogen.ENCAttributeType;
import com.metsci.glimpse.charts.vector.parser.objects.ENCObjectType;
import com.metsci.glimpse.charts.vector.parser.objects.ENCShape;
import com.metsci.glimpse.charts.vector.parser.objects.GeoAttributeType;
import com.metsci.glimpse.charts.vector.parser.objects.GeoFeatureType;
import com.metsci.glimpse.charts.vector.parser.objects.GeoObject;
import com.metsci.glimpse.charts.vector.parser.objects.GeoShape;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ENCObject
implements GeoObject {
    private ENCObjectType objectType;
    private Map<ENCAttributeType, ENCAbstractAttribute> attributes = new HashMap<ENCAttributeType, ENCAbstractAttribute>();
    private List<ENCShape> shapeList = new ArrayList<ENCShape>();
    private int rcid = -1;
    private int rcnm = 100;

    @Override
    public GeoFeatureType getGeoFeatureType() {
        return this.objectType;
    }

    public ENCObjectType getObjectType() {
        return this.objectType;
    }

    public void setObjectType(ENCObjectType type) {
        assert (type != null);
        this.objectType = type;
    }

    public int getRcid() {
        return this.rcid;
    }

    public void setRcid(int rcid) {
        this.rcid = rcid;
    }

    public int getRcnm() {
        return this.rcnm;
    }

    public void setRcnm(int rcnm) {
        this.rcnm = rcnm;
    }

    @Override
    public GeoAttribute getGeoAttribute(GeoAttributeType type) {
        return this.attributes.get(type);
    }

    @Override
    public GeoIntAttribute getGeoIntAttribute(GeoAttributeType type) {
        return (GeoIntAttribute)((Object)this.attributes.get(type));
    }

    public ENCEnumAttribute getEnumAttribute(ENCAttributeType type) {
        return (ENCEnumAttribute)this.attributes.get(type);
    }

    public ENCIntAttribute getIntAttribute(ENCAttributeType type) {
        return (ENCIntAttribute)this.attributes.get(type);
    }

    public ENCFloatAttribute getFloatAttribute(ENCAttributeType type) {
        return (ENCFloatAttribute)this.attributes.get(type);
    }

    public ENCListAttribute getListAttribute(ENCAttributeType type) {
        return (ENCListAttribute)this.attributes.get(type);
    }

    public ENCFreeAttribute getFreeAttribute(ENCAttributeType type) {
        return (ENCFreeAttribute)this.attributes.get(type);
    }

    public ENCCodedAttribute getCodedAttribute(ENCAttributeType type) {
        return (ENCCodedAttribute)this.attributes.get(type);
    }

    public ENCAbstractAttribute getAbstractAttribute(ENCAttributeType type) {
        return this.attributes.get(type);
    }

    public void addAttribute(ENCAbstractAttribute attrib) {
        this.attributes.put(attrib.getAttributeType(), attrib);
    }

    public void addShape(ENCShape shape) {
        this.shapeList.add(shape);
    }

    public List<ENCShape> getShapeList() {
        return this.shapeList;
    }

    @Override
    public Collection<? extends GeoShape> getGeoShapes() {
        return this.shapeList;
    }

    @Override
    public GeoShape getFirstGeoShape() {
        return this.shapeList.get(0);
    }

    public static void write(DataOutputStream fout, ENCObject obj) throws IOException {
        assert (obj.objectType != null);
        ENCObjectType.write(fout, obj.objectType);
        fout.writeInt(-1);
        fout.writeInt(obj.rcnm);
        fout.writeInt(obj.rcid);
        fout.writeInt(obj.attributes.size());
        for (ENCAbstractAttribute attrib : obj.attributes.values()) {
            attrib.write(fout);
        }
        fout.writeInt(obj.shapeList.size());
        Iterator<ENCShape> _shapeIterator = obj.shapeList.iterator();
        while (_shapeIterator.hasNext()) {
            ENCShape.write(fout, _shapeIterator.next());
        }
    }

    public static ENCObject read(DataInput fin) throws IOException {
        int _numOfAttributes;
        ENCObject _retVal = new ENCObject();
        _retVal.objectType = ENCObjectType.read(fin);
        int nextInt = fin.readInt();
        if (nextInt != -1) {
            _numOfAttributes = nextInt;
        } else {
            _retVal.rcnm = fin.readInt();
            _retVal.rcid = fin.readInt();
            _numOfAttributes = fin.readInt();
        }
        for (int i = 0; i < _numOfAttributes; ++i) {
            _retVal.addAttribute(ENCAbstractAttribute.read(fin));
        }
        int _numOfShapes = fin.readInt();
        for (int i = 0; i < _numOfShapes; ++i) {
            _retVal.addShape(ENCShape.read(fin));
        }
        return _retVal;
    }

    public static void main(String[] args) {
        try {
            DataInputStream _fin = new DataInputStream(new BufferedInputStream(new FileInputStream("US2AK70M0_bin.txt")));
            ENCObject _tempObj = null;
            try {
                while (true) {
                    _tempObj = ENCObject.read(_fin);
                    System.out.println(_tempObj.toString());
                }
            }
            catch (EOFException eOFException) {
                _fin.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        StringBuilder _retVal = new StringBuilder();
        _retVal.append("Object Type: ");
        _retVal.append(this.objectType.toString());
        _retVal.append("\nRCNM/RCID:");
        _retVal.append(this.rcnm).append(':').append(this.rcid);
        _retVal.append("\nAttributes:\n");
        for (Map.Entry<ENCAttributeType, ENCAbstractAttribute> entry : this.attributes.entrySet()) {
            AttributeDescription description;
            ENCAttributeType attributeType = entry.getKey();
            ENCAbstractAttribute attribute = entry.getValue();
            if (attribute.isNullValued() || (description = attribute.getDescription()).getValueAsString() == null) continue;
            _retVal.append(description.getAttributeType());
            _retVal.append(": (");
            _retVal.append((Object)description.getAttributeClass());
            _retVal.append(") ");
            _retVal.append(description.getValueAsString());
            _retVal.append('\n');
        }
        return _retVal.toString();
    }
}

