/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.parser.objects;

import com.metsci.glimpse.charts.vector.parser.attributes.DNCAbstractAttribute;
import com.metsci.glimpse.charts.vector.parser.attributes.DNCFloatAttribute;
import com.metsci.glimpse.charts.vector.parser.attributes.DNCFreeAttribute;
import com.metsci.glimpse.charts.vector.parser.attributes.DNCIntAttribute;
import com.metsci.glimpse.charts.vector.parser.attributes.GeoAttribute;
import com.metsci.glimpse.charts.vector.parser.attributes.GeoIntAttribute;
import com.metsci.glimpse.charts.vector.parser.objects.DNCAttributeType;
import com.metsci.glimpse.charts.vector.parser.objects.DNCFeatureCode;
import com.metsci.glimpse.charts.vector.parser.objects.DNCShape;
import com.metsci.glimpse.charts.vector.parser.objects.GeoAttributeType;
import com.metsci.glimpse.charts.vector.parser.objects.GeoFeatureType;
import com.metsci.glimpse.charts.vector.parser.objects.GeoObject;
import com.metsci.glimpse.charts.vector.parser.objects.GeoShape;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DNCObject
implements GeoObject {
    private Map<DNCAttributeType, DNCAbstractAttribute> attributes = new HashMap<DNCAttributeType, DNCAbstractAttribute>();
    private List<DNCShape> shapeList = new ArrayList<DNCShape>();
    private final DNCFeatureCode dncFeatureCode;

    public DNCObject(DNCFeatureCode dncFeatureCode) {
        this.dncFeatureCode = dncFeatureCode;
        assert (dncFeatureCode != null);
        if (dncFeatureCode == null) {
            throw new IllegalStateException("Null feature code");
        }
    }

    public DNCFeatureCode getFeatureCode() {
        return this.dncFeatureCode;
    }

    @Override
    public GeoFeatureType getGeoFeatureType() {
        return this.dncFeatureCode;
    }

    @Override
    public GeoAttribute getGeoAttribute(GeoAttributeType attributeType) {
        return this.attributes.get(attributeType);
    }

    @Override
    public GeoIntAttribute getGeoIntAttribute(GeoAttributeType type) {
        return (GeoIntAttribute)((Object)this.attributes.get(type));
    }

    public DNCIntAttribute getIntAttribute(DNCAttributeType type) {
        return (DNCIntAttribute)this.attributes.get(type);
    }

    public DNCFloatAttribute getFloatAttribute(DNCAttributeType type) {
        return (DNCFloatAttribute)this.attributes.get(type);
    }

    public DNCFreeAttribute getFreeAttribute(DNCAttributeType type) {
        return (DNCFreeAttribute)this.attributes.get(type);
    }

    public DNCAbstractAttribute getAbstractAttribute(DNCAttributeType type) {
        return this.attributes.get(type);
    }

    public void addAttribute(DNCAbstractAttribute attrib) {
        this.attributes.put(attrib.getAttributeType(), attrib);
    }

    public void addShape(DNCShape shape) {
        this.shapeList.add(shape);
    }

    public List<DNCShape> getShapeList() {
        return this.shapeList;
    }

    @Override
    public Collection<? extends GeoShape> getGeoShapes() {
        return this.shapeList;
    }

    @Override
    public GeoShape getFirstGeoShape() {
        return this.shapeList.get(0);
    }

    public static void write(DataOutputStream fout, DNCObject obj) throws IOException {
        obj.write(fout);
    }

    public void write(DataOutputStream fout) throws IOException {
        fout.writeInt(1);
        this.dncFeatureCode.write(fout);
        fout.writeInt(this.attributes.size());
        for (DNCAbstractAttribute attrib : this.attributes.values()) {
            attrib.write(fout);
        }
        fout.writeInt(this.shapeList.size());
        Iterator<DNCShape> _shapeIterator = this.shapeList.iterator();
        while (_shapeIterator.hasNext()) {
            DNCShape.write(fout, _shapeIterator.next());
        }
    }

    public static DNCObject read(DataInput fin) throws IOException {
        int version = fin.readInt();
        if (version != 1) {
            throw new IllegalStateException("Unsupported version " + version + "; expecting value 1");
        }
        DNCFeatureCode featureCode = DNCFeatureCode.read(fin);
        DNCObject _retVal = new DNCObject(featureCode);
        int _numOfAttributes = fin.readInt();
        for (int i = 0; i < _numOfAttributes; ++i) {
            _retVal.addAttribute(DNCAbstractAttribute.read(fin));
        }
        int _numOfShapes = fin.readInt();
        for (int i = 0; i < _numOfShapes; ++i) {
            _retVal.addShape(DNCShape.read(fin));
        }
        return _retVal;
    }

    public String toString() {
        StringBuilder _retVal = new StringBuilder();
        _retVal.append("\nAttributes:\n");
        for (Map.Entry<DNCAttributeType, DNCAbstractAttribute> entry : this.attributes.entrySet()) {
            DNCAttributeType attributeType = entry.getKey();
            DNCAbstractAttribute attribute = entry.getValue();
            if (attribute.isNullValued()) continue;
            _retVal.append(attribute.getAttributeType());
            _retVal.append(": (");
            _retVal.append((Object)attribute.getAttributeClass());
            _retVal.append(") ");
            _retVal.append(attribute.getAttributeValueAsString());
            _retVal.append('\n');
        }
        return _retVal.toString();
    }
}

