/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.parser.objects;

import com.metsci.glimpse.charts.vector.parser.objects.GeoFeatureType;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public enum DNCFeatureCode implements GeoFeatureType
{
    Mine("AA010", "Mine"),
    QuarryMineShearWall("AA011", "Quarry/MineShearWall"),
    Quarry("AA012", "Quarry"),
    Pit("AA013", "Pit"),
    Rig("AA040", "Rig/Superstructure"),
    Well("AA050", "Well"),
    Wellhead("AA051", "Wellhead"),
    OilField("AA052", "Oil/GasField"),
    GradationWorks("AA060", "GradationWorks"),
    DisposalSite("AB000", "DisposalSite/WastePile"),
    WreckingYard("AB010", "WreckingYard/ScrapYard"),
    Burner("AB020", "Burner"),
    Diffuser("AB021", "Diffuser"),
    WasteProcessingFacility("AB030", "WasteProcessingFacility"),
    ProcessingPlant("AC000", "ProcessingPlant/TreatmentPlant"),
    BlastFurnace("AC010", "BlastFurnace"),
    CatalyticCracker("AC020", "CatalyticCracker"),
    SettlingBasin("AC030", "SettlingBasin/SludgePond"),
    Oil("AC040", "Oil/GasFacilities"),
    Works("AC050", "Works"),
    PowerPlant("AD010", "PowerPlant"),
    SolarPanels("AD020", "SolarPanels"),
    Substation("AD030", "Substation/TransformerYard"),
    NuclearReactor("AD040", "NuclearReactor"),
    HeatingPlant("AD050", "HeatingPlant"),
    AssemblyPlant("AE010", "AssemblyPlant"),
    Chimney("AF010", "Chimney/Smokestack"),
    Conveyor("AF020", "Conveyor"),
    CoolingTower("AF030", "CoolingTower"),
    Crane("AF040", "Crane"),
    Sheerlegs("AF041", "Sheerlegs(ShearLegs)"),
    Dredge("AF050", "Dredge/Powershovel/Dragline"),
    EngineTestCell("AF060", "EngineTestCell"),
    FlarePipe("AF070", "FlarePipe"),
    Hopper("AF080", "Hopper"),
    Bastion("AH010", "Bastion/Rampart/Fortification"),
    Trench("AH020", "Trench"),
    Fortification("AH050", "Fortification"),
    UndergroundBunker("AH060", "UndergroundBunker"),
    Checkpoint("AH070", "Checkpoint"),
    MobileHome("AI020", "MobileHome/MobileHomePark"),
    Camp("AI030", "Camp"),
    CircularIrrigationSystem("AJ010", "CircularIrrigationSystem"),
    Siphon("AJ020", "Siphon"),
    FeedLot("AJ030", "FeedLot/Stockyard/HoldingPen"),
    Windmill("AJ050", "Windmill"),
    Windmotor("AJ051", "Windmotor"),
    AmusementParkAttraction("AK020", "AmusementParkAttraction"),
    AmusementPark("AK030", "AmusementPark"),
    AthleticField("AK040", "AthleticField"),
    TennisCourt("AK050", "TennisCourt(s)"),
    Campground("AK060", "Campground/Campsite"),
    PicnicSite("AK061", "PicnicSite"),
    DriveInTheater("AK070", "DriveInTheater"),
    DriveInTheaterScreen("AK080", "DriveInTheaterScreen"),
    Fairgrounds("AK090", "Fairgrounds"),
    ExhibitionGrounds("AK091", "ExhibitionGrounds"),
    GolfCourse("AK100", "GolfCourse"),
    GolfDrivingRange("AK101", "GolfDrivingRange"),
    Grandstand("AK110", "Grandstand"),
    Park("AK120", "Park"),
    Lookout("AK121", "Lookout"),
    RaceTrack("AK130", "RaceTrack"),
    SkiJump("AK150", "SkiJump"),
    SkiTrack("AK155", "SkiTrack"),
    Stadium("AK160", "Stadium/Amphitheater"),
    SwimmingPool("AK170", "SwimmingPool"),
    Zoo("AK180", "Zoo/SafariPark"),
    FishingPier("AK190", "FishingPier/PromenadePier"),
    AnimalSanctuary("AL005", "AnimalSanctuary"),
    ArcheologicalSite("AL012", "ArcheologicalSite"),
    Building("AL015", "Building"),
    BuildingSuperstructureAddition("AL018", "BuildingSuperstructureAddition"),
    Shed("AL019", "Shed"),
    BuiltUpArea("AL020", "Built-UpArea"),
    Cairn("AL025", "Cairn"),
    Cemetery("AL030", "Cemetery"),
    CliffDwelling("AL040", "CliffDwelling"),
    ComplexOutline("AL045", "ComplexOutline"),
    DisplaySign("AL050", "DisplaySign"),
    DragonTeeth("AL060", "DragonTeeth"),
    Fence("AL070", "Fence"),
    Flagstaff("AL073", "Flagstaff/Flagpole"),
    Gallery("AL075", "Gallery"),
    Gantry("AL080", "Gantry"),
    GraveMarker("AL090", "GraveMarker"),
    Hut("AL100", "Hut"),
    Cabin("AL101", "Cabin"),
    Settlement("AL105", "Settlement"),
    LightStandard("AL110", "LightStandard/LightSupport"),
    CalvaryCross("AL116", "CalvaryCross"),
    MissileSite("AL120", "MissileSite"),
    Monument("AL130", "Monument"),
    NativeSettlement("AL135", "NativeSettlement"),
    ParticleAccelerator("AL140", "ParticleAccelerator"),
    Telescope("AL141", "Telescope"),
    OverheadObstructionLocation("AL155", "OverheadObstructionLocation"),
    Plaza("AL170", "Plaza/CitySquare"),
    Ramp("AL195", "Ramp"),
    Ruins("AL200", "Ruins"),
    HistoricSite("AL201", "HistoricSite/PointofInterest"),
    SnowShed("AL210", "SnowShed/RockShed"),
    Steeple("AL220", "Steeple"),
    NonCommunicationTower("AL240", "Tower(Non-Communication)"),
    GeneralTower("AL241", "Tower(General)"),
    UndergroundDwelling("AL250", "UndergroundDwelling"),
    Wall("AL260", "Wall"),
    StorageDepot("AM010", "Depot(Storage)"),
    GrainBin("AM020", "GrainBin/Silo"),
    GrainElevator("AM030", "GrainElevator"),
    TimberYard("AM031", "TimberYard"),
    MineralPile("AM040", "MineralPile"),
    StorageBunker("AM060", "StorageBunker/StorageMound"),
    Tank("AM070", "Tank"),
    WaterTower("AM080", "WaterTower"),
    Railroad("AN010", "Railroad"),
    RailroadSiding("AN050", "RailroadSiding/RailroadSpur"),
    RailroadYard("AN060", "RailroadYard/MarshallingYard"),
    Railhead("AN065", "Railhead"),
    RailroadTurntable("AN075", "RailroadTurntable"),
    RailroadSwitch("AN080", "RailroadSwitch"),
    CartTrack("AP010", "CartTrack"),
    Interchange("AP020", "Interchange"),
    Road("AP030", "Road"),
    Gate("AP040", "Gate"),
    Barrier("AP041", "Barrier"),
    Trail("AP050", "Trail"),
    Drove("AP060", "Drove"),
    AerialCablewayLines("AQ010", "AerialCablewayLines/SkiLiftLines"),
    AerialCablewayPylon("AQ020", "AerialCablewayPylon/SkiPylon"),
    Mast("AQ021", "Mast"),
    Boardwalk("AQ030", "Boardwalk"),
    Bridge("AQ040", "Bridge/Overpass/Viaduct"),
    BridgeSpan("AQ045", "BridgeSpan"),
    BridgeSuperstructure("AQ050", "BridgeSuperstructure"),
    BridgeTower("AQ055", "BridgeTower/BridgePylon"),
    BridgePier("AQ056", "BridgePier"),
    Constriction("AQ058", "Constriction/Expansion"),
    ControlTower("AQ060", "ControlTower"),
    Crossing("AQ062", "Crossing"),
    Causeway("AQ064", "Causeway"),
    Culvert("AQ065", "Culvert"),
    DropGate("AQ068", "DropGate/RollingBlock"),
    FerryCrossing("AQ070", "FerryCrossing"),
    FerrySite("AQ080", "FerrySite"),
    Entrance("AQ090", "Entrance/Exit"),
    LandmarkPost("AQ100", "LandmarkPost/DistancePost"),
    MooringMast("AQ110", "MooringMast"),
    PreparedRaftorFloatBridgeSite("AQ111", "PreparedRaftorFloatBridgeSite"),
    Pipeline("AQ113", "Pipeline/Pipe"),
    PumpingStation("AQ116", "PumpingStation"),
    SharpCurves("AQ118", "SharpCurve(s)"),
    RouteMarker("AQ119", "RouteMarker"),
    SteepGrade("AQ120", "SteepGrade"),
    Station("AQ125", "Station(Miscellaneous)"),
    Tunnel("AQ130", "Tunnel"),
    VehicleStoppingArea("AQ135", "VehicleStoppingArea/RestArea"),
    VehicleStorage("AQ140", "VehicleStorage/ParkingArea"),
    FlightofSteps("AQ150", "FlightofSteps"),
    Cable("AT005", "Cable"),
    OverheadCable("AT006", "OverheadCable"),
    Disk("AT010", "Disk/Dish"),
    EarlyWarningRadarSite("AT020", "EarlyWarningRadarSite"),
    PowerTransmissionLine("AT030", "PowerTransmissionLine"),
    PowerTransmissionPylon("AT040", "PowerTransmissionPylon"),
    Telepheric("AT041", "Telepheric"),
    RadarTransmitter("AT045", "RadarTransmitter"),
    CommunicationBuilding("AT050", "CommunicationBuilding"),
    TelephoneLine("AT060", "TelephoneLine/TelegraphLine"),
    TelephoneTelegraphPylon("AT070", "Telephone-TelegraphPylon/Pole"),
    CommunicationTower("AT080", "CommunicationTower"),
    CoastlineShoreline("BA010", "Coastline/Shoreline"),
    Coastline("BA011", "Coastline"),
    Foreshore("BA020", "Foreshore"),
    Nearshore("BA021", "Nearshore(PreciseIHO)"),
    Backshore("BA022", "Backshore(PreciseIHO)"),
    Foreshore_PreciseIHO("BA023", "Foreshore(PreciseIHO)"),
    Island("BA030", "Island"),
    Water("BA040", "Water(ExceptInland)"),
    Beach("BA050", "Beach"),
    DykeCrown("BA051", "DykeCrown"),
    Harbor("BB005", "Harbor"),
    HarborComplex("BB006", "HarborComplex"),
    ChannelEdge("BB007", "ChannelEdge"),
    Anchorage("BB010", "Anchorage"),
    Anchorage_ComplexFeature("BB011", "Anchorage(ComplexFeature)"),
    Anchor_Berth("BB012", "AnchorBerth"),
    Anchor("BB019", "Anchor"),
    Berth("BB020", "Berth"),
    MooringTrot("BB021", "MooringTrot"),
    Basin("BB022", "Basin"),
    Bollard("BB030", "Bollard"),
    Breakwater_Groyne("BB040", "Breakwater/Groyne"),
    Breakwater("BB041", "Breakwater"),
    Mole("BB042", "Mole"),
    Groin("BB043", "Groin"),
    CallingInPoint("BB050", "Calling-InPoint"),
    Mooring("BB079", "Mooring/WarpingFacility"),
    Dolphin("BB080", "Dolphin"),
    ShorelineConstruction("BB081", "ShorelineConstruction"),
    Drydock("BB090", "Drydock"),
    FishStakes("BB100", "FishStakes"),
    FishingHarbor("BB105", "FishingHarbor"),
    FishTraps("BB110", "FishTraps/FishWeirs"),
    TunnyNetsArea("BB111", "Tunny(Tuna)NetsArea"),
    Gridiron("BB115", "Gridiron"),
    Jetty("BB140", "Jetty"),
    LandingPlace("BB150", "LandingPlace"),
    LandingStairs("BB151", "LandingStairs"),
    MaritimeStation("BB155", "MaritimeStation/MaritimeSignalStation"),
    MooringRing("BB160", "MooringRing"),
    OffshoreLoadingFacility("BB170", "OffshoreLoadingFacility"),
    OysterBed("BB180", "OysterBed/MusselBed"),
    Pier("BB190", "Pier/Wharf/Quay"),
    Fender("BB198", "Fender"),
    FloatingDock("BB199", "FloatingDock"),
    PumpOutFacility("BB200", "PumpOutFacility"),
    SmallCraftFacility("BB201", "SmallCraftFacility"),
    IceBoom("BB202", "IceBoom"),
    MaritimeRamp("BB220", "Ramp(Maritime)"),
    RipRap("BB225", "RipRap"),
    Revetment_ShoreProtection("BB226", "Revetment(ShoreProtection)"),
    Seawall("BB230", "Seawall"),
    Slipway("BB240", "Slipway/PatentSlip"),
    WateringPlace("BB250", "WateringPlace"),
    Beacon("BC010", "Beacon"),
    Buoy("BC020", "Buoy"),
    LeadingLights("BC030", "LeadingLight(s)"),
    NavigationLine("BC031", "NavigationLine"),
    RadarLine("BC032", "RadarLine"),
    RadarRange("BC033", "RadarRange"),
    LightsinLine("BC035", "LightsinLine"),
    Light("BC040", "Light"),
    Lighthouse("BC050", "Lighthouse"),
    Marker("BC055", "Marker"),
    LightSector("BC060", "LightSector"),
    LightVessel("BC070", "LightVessel/Lightship"),
    Perches("BC080", "Perches/Stakes"),
    NavigationalMarkAfloat("BC098", "NavigationalMark,Afloat"),
    NavigationalMarkFixed("BC099", "NavigationalMark,Fixed"),
    LeadingLine("BC100", "LeadingLine"),
    FogSignal("BC101", "FogSignal"),
    DirectionofLateralBuoyage("BC102", "DirectionofLateralBuoyage"),
    UnderwaterDanger("BD000", "UnderwaterDanger/Hazard"),
    Mine_Naval("BD001", "Mine-Naval"),
    MiscellaneousUnderwaterFeature("BD005", "MiscellaneousUnderwaterFeature"),
    Breakers("BD010", "Breakers"),
    Crib("BD020", "Crib"),
    DiscoloredWater("BD030", "DiscoloredWater"),
    Eddies("BD040", "Eddies"),
    FoulGround("BD050", "FoulGround"),
    Kelp("BD060", "Kelp/Seaweed"),
    Obstruction_Nautical("BD070", "Obstruction(Nautical)"),
    LogBoom("BD071", "LogBoom/BoomingGround"),
    Pontoon("BD072", "Pontoon"),
    OilBarrier("BD073", "OilBarrier"),
    Chain("BD074", "Chain/Wire"),
    FishingFacility("BD079", "FishingFacility"),
    Overfalls("BD080", "Overfalls/TideRips"),
    Pile("BD100", "Pile/Piling/Post"),
    Platform("BD110", "Platform"),
    OffshorePlatformSite_Cleared("BD111", "OffshorePlatformSite(cleared)"),
    ProductionInstallation("BD112", "ProductionInstallation"),
    Ledge("BD119", "Ledge"),
    Reef("BD120", "Reef"),
    Pingo("BD121", "Pingo"),
    Rock("BD130", "Rock"),
    Snags("BD140", "Snags/Stumps"),
    Wreck("BD180", "Wreck"),
    Hulk("BD181", "Hulk"),
    DepthCurve("BE010", "DepthCurve"),
    DepthContour("BE015", "DepthContour"),
    DepthArea("BE019", "DepthArea"),
    Sounding("BE020", "Sounding"),
    LowWaterLine("BE021", "DryingLine,LowWaterLine-LWL"),
    SandLine("BE022", "SandLine"),
    MudLine("BE023", "MudLine"),
    BottomReturn("BE029", "BottomReturn"),
    TrackSwath("BE030", "TrackSwath"),
    TrackLine("BE040", "TrackLine"),
    BeachProfile("BE050", "BeachProfile"),
    BottomCharacteristics("BF010", "BottomCharacteristics"),
    BottomFeature("BF011", "BottomFeature"),
    CurrentFlow("BG010", "CurrentFlow"),
    Tideway("BG011", "Tideway"),
    WaterTurbulence("BG012", "WaterTurbulence"),
    TideGauge("BG020", "TideGauge"),
    TideDataPoint("BG030", "TideDataPoint"),
    CurrentDiagram("BG040", "CurrentDiagram"),
    InlandWater("BH000", "InlandWater"),
    Aqueduct("BH010", "Aqueduct"),
    Bog("BH015", "Bog"),
    Canal("BH020", "Canal"),
    Ditch("BH030", "Ditch"),
    FiltrationBeds("BH040", "FiltrationBeds/AerationBeds"),
    FishHatchery("BH050", "FishHatchery/FishFarm/MarineFarm"),
    Flume("BH060", "Flume"),
    Ford("BH070", "Ford"),
    Fountain("BH075", "Fountain"),
    Hummock("BH077", "Hummock"),
    Lake("BH080", "Lake/Pond"),
    LandSubjecttoInundation("BH090", "LandSubjecttoInundation"),
    FloodedArea("BH091", "FloodedArea"),
    Marsh("BH095", "Marsh/Swamp"),
    Moat("BH100", "Moat"),
    Penstock("BH110", "Penstock"),
    UndergroundWater("BH115", "UndergroundWater/PhreaticWater"),
    Rapids("BH120", "Rapids"),
    Reservoir("BH130", "Reservoir"),
    RiceField("BH135", "RiceField"),
    River("BH140", "River/Stream"),
    RiverBank("BH141", "RiverBank"),
    River_StreamVanishingPoint("BH145", "River/StreamVanishingPoint"),
    SaltPan("BH150", "SaltPan"),
    SaltEvaporator("BH155", "SaltEvaporator"),
    Sebkha("BH160", "Sebkha"),
    Spillway("BH165", "Spillway"),
    Spring("BH170", "Spring/WaterHole"),
    Trough("BH175", "Trough"),
    Waterfall("BH180", "Waterfall"),
    Lagoon("BH190", "Lagoon/ReefPool"),
    MiscellaneousSurfaceDrainageFeature("BH200", "MiscellaneousSurfaceDrainageFeature"),
    InlandShoreline("BH210", "InlandShoreline"),
    RiverNavigationRoute("BH501", "RiverNavigationRoute"),
    BoatLift("BI005", "BoatLift"),
    Cistern("BI010", "Cistern"),
    Dam("BI020", "Dam/Weir"),
    Lock("BI030", "Lock"),
    Sluice("BI039", "Sluice"),
    SluiceGate("BI040", "SluiceGate"),
    Gate_Nautical("BI041", "Gate(Nautical)"),
    Caisson("BI042", "Caisson"),
    FloodBarrage("BI043", "FloodBarrage"),
    WaterIntakeTower("BI050", "WaterIntakeTower"),
    FishLadder("BI060", "FishLadder"),
    GaugingStation("BI070", "GaugingStation"),
    BoatTurningBasin("BI080", "BoatTurningBasin"),
    Moraine("BJ020", "Moraine"),
    Glacier("BJ030", "Glacier"),
    IceCliff("BJ040", "IceCliff"),
    IcePeak("BJ060", "IcePeak/Nunatak"),
    IceShelf("BJ065", "IceShelf"),
    PackIce("BJ070", "PackIce"),
    PolarIce("BJ080", "PolarIce"),
    SnowField("BJ100", "SnowField/IceField"),
    Tundra("BJ110", "Tundra"),
    AcousticStation("BK010", "AcousticStation"),
    MagneticStation("BK020", "MagneticStation"),
    OceanographicCollectionDevice("BK030", "OceanographicCollectionDevice"),
    ContourLine("CA010", "ContourLine(Land)"),
    RidgeLine("CA020", "RidgeLine"),
    ValleyBottomLine("CA025", "ValleyBottomLine"),
    Breakline("CA026", "Breakline"),
    SpotElevation("CA030", "SpotElevation"),
    InlandWaterElevation("CA035", "InlandWaterElevation"),
    ContourPolygon("CA040", "ContourPolygon(Land)"),
    AsphaltLake("DA005", "AsphaltLake"),
    AlkaliFlats("DA006", "AlkaliFlats"),
    GroundSurfaceElement("DA010", "GroundSurfaceElement"),
    BarrenGround("DA020", "BarrenGround"),
    LandArea("DA030", "LandArea"),
    LandRegion("DA031", "LandRegion"),
    Bluff("DB010", "Bluff/Cliff/Escarpment"),
    Cave("DB030", "Cave"),
    Hill("DB031", "Hill"),
    Crevice("DB060", "Crevice/Crevasse"),
    Cut("DB070", "Cut"),
    Depression("DB080", "Depression"),
    Embankment("DB090", "Embankment/Fill"),
    Esker("DB100", "Esker"),
    Fault("DB110", "Fault"),
    GeothermalFeature("DB115", "GeothermalFeature"),
    MiscellaneousObstacle("DB145", "MiscellaneousObstacle"),
    MountainPass("DB150", "MountainPass"),
    RockStrata("DB160", "RockStrata/RockFormation"),
    SandDune("DB170", "SandDune/SandHills"),
    SlopeCategory("DB176", "SlopeCategory"),
    Volcano("DB180", "Volcano"),
    VolcanicDike("DB190", "VolcanicDike"),
    Gully("DB200", "Gully/Gorge"),
    PotentialLandslideArea("DB210", "PotentialLandslideArea"),
    Landslide("DB211", "Landslide"),
    UnderminedLand("DB220", "UnderminedLand"),
    Fan("DB230", "Fan"),
    BottomlineofCliff("DB500", "BottomlineofCliff"),
    Toplineofcliff("DB501", "Toplineofcliff"),
    Cropland("EA010", "Cropland"),
    Hedgerow("EA020", "Hedgerow"),
    Nursery("EA030", "Nursery"),
    BotanicalGarden("EA031", "BotanicalGarden"),
    Orchard("EA040", "Orchard/Plantation"),
    Vineyards("EA050", "Vineyards"),
    Hops("EA055", "Hops"),
    Grassland("EB010", "Grassland"),
    Grass("EB015", "Grass/Scrub/Brush"),
    Scrub("EB020", "Scrub/Brush/Bush"),
    LandUse("EB030", "LandUse/LandCover(Vegetation)"),
    Bamboo("EC010", "Bamboo/Cane"),
    Forest("EC015", "Forest"),
    Oasis("EC020", "Oasis"),
    Trees("EC030", "Trees"),
    ClearedWay("EC040", "ClearedWay/CutLine/Firebreak"),
    MiscellaneousVegetation("EE000", "MiscellaneousVegetation"),
    LoggingArea("EE010", "LoggingArea"),
    Landdevoidofvegetation("EE020", "Landdevoidofvegetation"),
    AdministrativeBoundary("FA000", "AdministrativeBoundary"),
    AdministrativeArea("FA001", "AdministrativeArea"),
    AccessZone("FA005", "AccessZone"),
    FiringRange("FA015", "FiringRange/GunneryRange"),
    ArmisticeLine("FA020", "ArmisticeLine"),
    CeaseFireLine("FA030", "Cease-FireLine"),
    ClaimLine("FA040", "ClaimLine"),
    ContactZone("FA041", "ContactZone"),
    MandateLine("FA050", "MandateLine/ConventionLine"),
    DefactoBoundary("FA060", "DefactoBoundary"),
    DemilitarizedZone("FA070", "DemilitarizedZone"),
    NationalPark("FA080", "NationalPark"),
    NatureReserve("FA081", "NatureReserve"),
    ProtectedWaterGatheringGround("FA082", "ProtectedWater,GatheringGround"),
    GeophysicalProspectingGrid("FA090", "GeophysicalProspectingGrid"),
    TestArea("FA100", "TestArea"),
    InternationalDateLine("FA110", "InternationalDateLine"),
    TrainingArea("FA165", "TrainingArea"),
    ZoneofOccupation("FA170", "ZoneofOccupation"),
    MaritimeLimitBoundary("FC021", "MaritimeLimitBoundary"),
    MaritimeArea("FC031", "MaritimeArea"),
    PondPartition("FC035", "PondPartition"),
    RestrictedArea("FC036", "RestrictedArea"),
    TrafficSeparationSchemeSystem("FC040", "TrafficSeparationSchemeSystem"),
    TrafficSeparationScheme("FC041", "TrafficSeparationScheme(TSS)"),
    MeasuredDistanceLine("FC100", "MeasuredDistanceLine"),
    TheodoliteLine("FC101", "TheodoliteLine"),
    RangeCenterline("FC102", "RangeCenterline"),
    RadarReferenceLine("FC130", "RadarReferenceLine"),
    RouteMaritime("FC165", "Route(Maritime)"),
    DeepWaterRoute("FC166", "DeepWaterRoute"),
    DefinedWater("FC167", "DefinedWater"),
    CanalRoute("FC168", "CanalRoute"),
    SafetyFairway("FC170", "SafetyFairway"),
    SweptArea("FC177", "SweptArea"),
    Airspace("GA005", "Airspace"),
    ATSRouteSegment("GA010", "ATSRouteSegment/Leg"),
    SpecialUseAirspace("GA015", "SpecialUseAirspace"),
    AirspaceBoundarySegment("GA020", "AirspaceBoundarySegment"),
    SpecialUseAirspaceSegment("GA025", "SpecialUseAirspaceSegment"),
    OffRouteRadial("GA030", "OffRouteRadial/Bearing"),
    LeadRadial("GA031", "LeadRadial"),
    NAVAIDSAeronautical("GA035", "NAVAIDS(Aeronautical)"),
    RouteAir("GA045", "Route(Air)"),
    ComplexTerminalRoute("GA047", "ComplexTerminalRoute"),
    Waypoint("GA055", "Waypoint/Reporting-CallingInPoint"),
    AirWarningLight("GA065", "AirWarningLight"),
    Airport("GB005", "Airport/Airfield"),
    Airfield("GB006", "Airfield"),
    AirportArea("GB007", "AirportArea"),
    AirportLighting("GB010", "AirportLighting"),
    Apron("GB015", "Apron/Hardstand"),
    ArrestingGear("GB020", "ArrestingGear"),
    BlastBarrier("GB025", "BlastBarrier"),
    HelicopterLandingPad("GB030", "HelicopterLandingPad"),
    Heliport("GB035", "Heliport"),
    LaunchPad("GB040", "LaunchPad"),
    Overrun("GB045", "Overrun/Stopway"),
    Revetment_Airfield("GB050", "Revetment(Airfield/Equipment/Facilities)"),
    Runway("GB055", "Runway"),
    Shoulder("GB057", "Shoulder"),
    RunwayRadarReflector("GB060", "RunwayRadarReflector"),
    SeaplaneBase("GB065", "SeaplaneBase"),
    SeaplaneLanding("GB070", "SeaplaneLanding/SeaplaneTake-OffArea"),
    Taxiway("GB075", "Taxiway"),
    WindIndicator("GB080", "WindIndicator"),
    DecontaminationPad("GB160", "DecontaminationPad"),
    INSAlignmentPad("GB170", "INSAlignmentPad"),
    AirObstruction("GB220", "AirObstruction"),
    MiscellaneousAirObstruction("GB221", "MiscellaneousAirObstruction"),
    MapBoundary("IA010", "MapBoundary"),
    Parcel("IA040", "Parcel"),
    CadastralConstructions("IA050", "CadastralConstructions"),
    CadastralControlPoints("ID010", "CadastralControlPoints"),
    FiducialPoints("ID020", "FiducialPoints"),
    MapSheetFrame("IE010", "MapSheetFrame"),
    Miscellaneous("IE020", "Miscellaneous"),
    MapInfo("IE040", "Map-Info"),
    CommonOpenWater("SA010", "CommonOpenWater"),
    DisturbedSoil("SA020", "DisturbedSoil"),
    ExposedBedrock("SA030", "ExposedBedrock"),
    PermanentSnowfield("SA040", "PermanentSnowfield"),
    SlopePolygon("SA050", "SlopePolygon"),
    CoveredDrainage("SA060", "CoveredDrainage"),
    MilitaryBase("SU001", "MilitaryBase"),
    Subway("SU002", "Subway"),
    PortFacility("SU003", "PortFacility"),
    Benchmark("ZB020", "Benchmark"),
    BoundaryMonument("ZB030", "BoundaryMonument"),
    ControlPoint("ZB035", "ControlPoint/ControlStation"),
    DistanceMark("ZB036", "DistanceMark"),
    DiagnosticPoint("ZB040", "DiagnosticPoint"),
    GeodeticPoint("ZB060", "GeodeticPoint"),
    MagneticDisturbanceArea("ZC040", "MagneticDisturbanceArea"),
    IsogonicLines("ZC050", "IsogonicLines"),
    MagneticPole("ZC051", "MagneticPole"),
    Network("ZD001", "Network"),
    ArtifactLocation("ZD003", "ArtifactLocation"),
    GeographicInformationPoint("ZD012", "GeographicInformationPoint"),
    PointofChange("ZD015", "PointofChange"),
    VoidCollectionArea("ZD020", "VoidCollectionArea"),
    NamedLocation("ZD040", "NamedLocation"),
    TextDescription("ZD045", "TextDescription");

    private final String code;
    private static final DNCFeatureCode[] dncFeatureCodes;
    private static boolean populate;
    private static Map<String, DNCFeatureCode> lookupMap;

    public static DNCFeatureCode fromKey(String c) {
        if (populate) {
            for (DNCFeatureCode p : dncFeatureCodes) {
                lookupMap.put(p.code, p);
            }
            populate = false;
        }
        return lookupMap.get(c);
    }

    private DNCFeatureCode(String code, String full) {
        this.code = code;
    }

    private DNCFeatureCode(String code, String full, String directory, String ... fileNames) {
        this.code = code;
    }

    public static void write(DataOutputStream fout, DNCFeatureCode obj) throws IOException {
        obj.write(fout);
    }

    public void write(DataOutputStream fout) throws IOException {
        fout.writeUTF(this.code);
    }

    public static DNCFeatureCode read(DataInput fin) throws IOException {
        return DNCFeatureCode.fromKey(fin.readUTF());
    }

    @Override
    public int getNumFeatures() {
        return DNCFeatureCode.staticGetNumFeatures();
    }

    public static int staticGetNumFeatures() {
        return dncFeatureCodes.length;
    }

    @Override
    public String code() {
        return this.code;
    }

    @Override
    public String asKey() {
        return this.code;
    }

    static {
        dncFeatureCodes = DNCFeatureCode.values();
        populate = true;
        lookupMap = new HashMap<String, DNCFeatureCode>();
    }
}

