/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.parser.objects;

import com.metsci.glimpse.charts.vector.parser.objects.GeoAttributeType;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DNCAttributeType
implements GeoAttributeType {
    public static DNCAttributeType FACCCode = new DNCAttributeType("f_code");
    public static DNCAttributeType NAM = new DNCAttributeType("nam");
    private static Map<String, DNCAttributeType> lookupMap = new HashMap<String, DNCAttributeType>(){
        {
            this.put(FACCCode.code, FACCCode);
            this.put(NAM.code, NAM);
        }
    };
    private String code;

    public static DNCAttributeType getInstance(String c) {
        DNCAttributeType type = lookupMap.get(c);
        if (type == null) {
            c = c.intern();
            type = new DNCAttributeType(c);
            lookupMap.put(c, type);
        }
        return type;
    }

    private DNCAttributeType(String c) {
        this.code = c;
    }

    @Override
    public String name() {
        return this.code;
    }

    public String toString() {
        return this.code;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof DNCAttributeType)) {
            return false;
        }
        return this.internalEquals(this);
    }

    public boolean equals(DNCAttributeType otherType) {
        if (otherType == null) {
            return false;
        }
        if (this == otherType) {
            return true;
        }
        return this.internalEquals(otherType);
    }

    private boolean internalEquals(DNCAttributeType otherType) {
        return this.code.equals(otherType.code);
    }

    public int hashCode() {
        return this.code.hashCode();
    }

    public void write(DataOutputStream fout) throws IOException {
        fout.writeUTF(this.code);
    }

    public static DNCAttributeType read(DataInput fin) throws IOException {
        String code = fin.readUTF();
        return DNCAttributeType.getInstance(code);
    }
}

