/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.parser.objects;

import com.metsci.glimpse.charts.vector.parser.objects.GeoShape;
import com.metsci.glimpse.charts.vector.parser.objects.GeoShapeType;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public abstract class AbstractGeoShape
implements GeoShape {
    private int pointSize = 0;
    private GeoShapeType type = GeoShapeType.Unspecified;
    private double[] values = null;

    @Override
    public GeoShapeType getShapeType() {
        return this.type;
    }

    @Override
    public double[] getRawVertexArray() {
        return this.values;
    }

    @Override
    public double getVertex(int dim, int index) {
        int arrayIndex = index * this.pointSize + dim;
        return this.values[arrayIndex];
    }

    @Override
    public double[] getVertexes(int index, double[] buffer) {
        if (buffer == null) {
            buffer = new double[this.pointSize];
        }
        int startIndex = index * this.pointSize;
        System.arraycopy(this.values, startIndex, buffer, 0, this.pointSize);
        return buffer;
    }

    @Override
    public int getNumCoordinates() {
        return this.values.length / this.pointSize;
    }

    @Override
    public int getPointSize() {
        return this.pointSize;
    }

    @Override
    public void setShapeType(GeoShapeType t) {
        this.type = t;
    }

    @Override
    public void setVertexPoints(double[] vals) {
        this.values = Arrays.copyOf(vals, vals.length);
    }

    @Override
    public void setPointSize(int s) {
        this.pointSize = s;
    }

    public boolean passSanityCheck() {
        return this.values.length % this.pointSize == 0;
    }

    public static void write(DataOutputStream fout, AbstractGeoShape shape) throws IOException {
        shape.write(fout);
    }

    @Override
    public void write(DataOutputStream fout) throws IOException {
        this.write0(fout);
    }

    public void write0(DataOutputStream fout) throws IOException {
        this.type.write(fout);
        if (this.type == GeoShapeType.Unspecified) {
            return;
        }
        fout.writeInt(this.pointSize);
        fout.writeInt(this.values.length);
        for (int i = 0; i < this.values.length; ++i) {
            fout.writeDouble(this.values[i]);
        }
    }

    protected static void read0(DataInput fin, AbstractGeoShape shape) throws IOException {
        shape.type = shape.type.read(fin);
        if (shape.type != GeoShapeType.Unspecified) {
            shape.pointSize = fin.readInt();
            int _arrayLength = fin.readInt();
            shape.values = new double[_arrayLength];
            for (int i = 0; i < _arrayLength; ++i) {
                shape.values[i] = fin.readDouble();
            }
        }
    }
}

