/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.parser.autogen;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;

public enum ENCUnit {
    Metre_Length(0, 9001),
    Foot_Length(1, 9002),
    UsSurveyFoot_Length(2, 9003),
    ClarkesFoot_Length(3, 9005),
    Fathom_Length(4, 9014),
    NauticalMile_Length(5, 9030),
    GermanLegalMetre_Length(6, 9031),
    UsSurveyChain_Length(7, 9033),
    UsSurveyLink_Length(8, 9034),
    UsSurveyMile_Length(9, 9035),
    Kilometre_Length(10, 9036),
    ClarkesYard_Length(11, 9037),
    ClarkesChain_Length(12, 9038),
    ClarkesLink_Length(13, 9039),
    BritishYardSears1922_Length(14, 9040),
    BritishFootSears1922_Length(15, 9041),
    BritishChainSears1922_Length(16, 9042),
    BritishLinkSears1922_Length(17, 9043),
    BritishYardBenoit1895A_Length(18, 9050),
    BritishFootBenoit1895A_Length(19, 9051),
    BritishChainBenoit1895A_Length(20, 9052),
    BritishLinkBenoit1895A_Length(21, 9053),
    BritishYardBenoit1895B_Length(22, 9060),
    BritishFootBenoit1895B_Length(23, 9061),
    BritishChainBenoit1895B_Length(24, 9062),
    BritishLinkBenoit1895B_Length(25, 9063),
    BritishFoot1865_Length(26, 9070),
    IndianFoot_Length(27, 9080),
    IndianFoot1937_Length(28, 9081),
    IndianFoot1962_Length(29, 9082),
    IndianFoot1975_Length(30, 9083),
    IndianYard_Length(31, 9084),
    IndianYard1937_Length(32, 9085),
    IndianYard1962_Length(33, 9086),
    IndianYard1975_Length(34, 9087),
    StatuteMile_Length(35, 9093),
    GoldCoastFoot_Length(36, 9094),
    BritishFoot1936_Length(37, 9095),
    Yard_Length(38, 9096),
    Chain_Length(39, 9097),
    Link_Length(40, 9098),
    BritishYardSears1922Truncated_Length(41, 9099),
    Radian_Angle(42, 9101),
    Degree_Angle(43, 9102),
    ArcMinute_Angle(44, 9103),
    ArcSecond_Angle(45, 9104),
    Grad_Angle(46, 9105),
    Gon_Angle(47, 9106),
    DegreeMinuteSecond_Angle(48, 9107),
    DegreeMinuteSecondHemisphere_Angle(49, 9108),
    Microradian_Angle(50, 9109),
    SexagesimalDms_Angle(51, 9110),
    SexagesimalDm_Angle(52, 9111),
    CentesimalMinute_Angle(53, 9112),
    CentesimalSecond_Angle(54, 9113),
    Mil6400_Angle(55, 9114),
    DegreeMinute_Angle(56, 9115),
    DegreeHemisphere_Angle(57, 9116),
    HemisphereDegree_Angle(58, 9117),
    DegreeMinuteHemisphere_Angle(59, 9118),
    HemisphereDegreeMinute_Angle(60, 9119),
    HemisphereDegreeMinuteSecond_Angle(61, 9120),
    SexagesimalDmsS_Angle(62, 9121),
    DegreeSupplierToDefineRepresentation_Angle(63, 9122),
    Unity_Scale(64, 9201),
    PartsPerMillion_Scale(65, 9202),
    Coefficient_Scale(66, 9203),
    BinWidth330UsSurveyFeet_Length(67, 9204),
    BinWidth165UsSurveyFeet_Length(68, 9205),
    BinWidth825UsSurveyFeet_Length(69, 9206),
    BinWidth375Metres_Length(70, 9207),
    BinWidth25Metres_Length(71, 9208),
    BinWidth125Metres_Length(72, 9209),
    BinWidth625Metres_Length(73, 9210),
    BinWidth3125Metres_Length(74, 9211),
    BritishFootSears1922Truncated_Length(75, 9300),
    BritishChainSears1922Truncated_Length(76, 9301),
    BritishLinkSears1922Truncated_Length(77, 9302),
    Unitless_Void(78, 10000),
    Millimeter_Length(79, 10001),
    NauticalMilePerHour_Speed(80, 11001),
    Knot_Speed(81, 11002),
    Kilogram_Mass(82, 12001),
    Tonne_Mass(83, 12002),
    Hertz_Frequency(84, 13001),
    Second_Time(85, 13101),
    Minute_Time(86, 13102),
    Hour_Time(87, 13103);

    private int localID;
    private int ENCID;
    private static boolean populate;
    private static HashMap<Integer, ENCUnit> lookupMap;
    private static double[][] conversionMatrixA;
    private static double[][] conversionMatrixB;

    private ENCUnit(int lid, int gid) {
        this.localID = lid;
        this.ENCID = gid;
    }

    public static ENCUnit getInstance(int gid) {
        if (populate) {
            for (ENCUnit p : ENCUnit.values()) {
                lookupMap.put(p.ENCID, p);
            }
            populate = false;
        }
        int _adjValue = gid % 9000 + 9000;
        return lookupMap.get(_adjValue);
    }

    public static ENCUnit read(DataInput fin) throws IOException {
        return ENCUnit.getInstance(fin.readInt());
    }

    public static void write(DataOutputStream fout, ENCUnit unit) throws IOException {
        fout.writeInt(unit.ENCID);
    }

    public double convertTo(double value, ENCUnit type) throws Exception {
        if (conversionMatrixA == null) {
            ENCUnit.populateTableA();
            ENCUnit.populateTableB();
        }
        if (conversionMatrixA[this.localID][type.localID] == 0.0) {
            throw new Exception("Cannot perform conversion.");
        }
        return conversionMatrixB[this.localID][type.localID] * value / conversionMatrixA[this.localID][type.localID];
    }

    public double convertFrom(double value, ENCUnit type) throws Exception {
        if (conversionMatrixA == null) {
            ENCUnit.populateTableA();
            ENCUnit.populateTableB();
        }
        if (conversionMatrixA[type.localID][this.localID] == 0.0) {
            throw new Exception("Cannot perform conversion.");
        }
        return conversionMatrixB[type.localID][this.localID] * value / conversionMatrixA[type.localID][this.localID];
    }

    /*
     * Opcode count of 31421 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static void populateTableA() {
        conversionMatrixA = new double[][]{{1.0, 1.0, 0.025400050800101603, 1.0, 1.0, 1.0, 1.0, 0.025400050800101603, 0.025400050800101603, 0.025400050800101603, 1.0, 1.0, 1.0, 1.0, 0.02539995596155635, 0.02539995596155635, 0.02539995596155635, 0.02539995596155635, 1.0, 0.3333333333333333, 1.0, 1.0, 0.025399977896939232, 0.025399977896939232, 0.025399977896939232, 0.025399977896939232, 0.3333333333333333, 0.025399959187345576, 1.0, 1.0, 1.0, 0.025399959187345576, 1.0, 1.0, 1.0, 1.0, 4.778698245324127E-8, 1.0, 1.0, 1.0, 0.01, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.025400050800101603, 0.025400050800101603, 0.025400050800101603, 1.0, 1.0, 1.0, 1.0, 1.0, 0.3333333333333333, 1.0, 0.01, 0.0, 0.001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.3048, 1.0, 0.08333333333333333, 3.2808693302666354, 0.5468066491688539, 5.399568034557236E-4, 0.9999864036848622, 0.0012626262626262627, 0.12626262626262627, 1.5782828282828283E-5, 0.001, 1.0936231100888785, 0.0497101413676763, 4.9710141367676295, 0.027777777777777776, 0.08333333333333333, 0.0012626262626262627, 0.12626262626262627, 1.0936142551305819, 1.0936142551305819, 0.049709738869571904, 4.97097388695719, 0.027777777777777776, 0.08333333333333333, 0.0012626262626262627, 0.12626262626262627, 1.0936103083707667, 0.08333333333333333, 3.2808570097199654, 3.2808442005829406, 3.2808452769771606, 0.027777777777777776, 1.0936190032399884, 1.093614733527647, 1.0936150923257202, 6.213711922373339E-4, 1.5678158757035574E-7, 3.2808318317876473, 1.0936132983377078, 0.049709695378986715, 0.049709695378986715, 1.093615690323032, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.525252525252525E-4, 5.05050505050505E-4, 0.00101010101010101, 0.02666666666666667, 0.04, 0.08, 0.16, 0.32, 1.093615690323032, 0.04970980410559238, 0.04970980410559238, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {12.0, 11.999976, 1.0, 0.08333424765726787, 0.013888916666722224, 1.3714930237635856E-5, 0.025399705453006412, 3.20707712122495E-5, 0.0032070771212249502, 4.0088464015311875E-7, 2.5400050800101604E-5, 0.02777808255242262, 0.0012626401160192103, 0.12626401160192102, 7.055569666694889E-4, 0.002116670900008467, 3.20707712122495E-5, 0.0032070771212249502, 0.027777857636032056, 0.027777857636032056, 0.0012626298925469115, 0.12626298925469115, 7.055569666694889E-4, 0.002116670900008467, 3.20707712122495E-5, 0.0032070771212249502, 0.027777757388132252, 0.002116670900008467, 0.08333393471475656, 0.08333360936202543, 0.08333363670249329, 7.055569666694889E-4, 0.027777978238252184, 0.02777786978734181, 0.0277778789008311, 1.578285984854798E-5, 3.982260288807614E-9, 0.08333329519399664, 0.027777833333444447, 0.0012626287878838385, 0.0012626287878838385, 0.027777894089993198, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.4141542424499E-6, 1.28283084848998E-5, 2.56566169697996E-5, 6.773346880027095E-4, 0.0010160020320040641, 0.0020320040640081282, 0.0040640081280162565, 0.008128016256032513, 0.027777894089993198, 0.0012626315495451457, 0.0012626315495451457, 0.0, 0.025400050800101603, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.3047972654, 0.3048, 12.0, 1.0, 0.5468066491688539, 5.399568034557236E-4, 0.9999864036848622, 0.0012626262626262627, 0.12626262626262627, 1.5782828282828283E-5, 0.001, 1.0936231100888785, 0.0497101413676763, 4.9710141367676295, 0.027777777777777776, 0.08333333333333333, 0.0012626262626262627, 0.12626262626262627, 1.0936142551305819, 1.0936142551305819, 0.049709738869571904, 4.97097388695719, 0.027777777777777776, 0.08333333333333333, 0.0012626262626262627, 0.12626262626262627, 1.0936103083707667, 0.08333333333333333, 3.2808570097199654, 3.2808442005829406, 3.2808452769771606, 0.027777777777777776, 1.0936190032399884, 1.093614733527647, 1.0936150923257202, 6.213711922373339E-4, 1.5678158757035574E-7, 3.2808318317876473, 1.0936132983377078, 0.049709695378986715, 0.049709695378986715, 1.093615690323032, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.525252525252525E-4, 5.05050505050505E-4, 0.00101010101010101, 0.02666666666666667, 0.04, 0.08, 0.16, 0.32, 1.093615690323032, 0.04970980410559238, 0.04970980410559238, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.8288, 0.3048, 12.0, 0.3047972654, 1.0, 5.399568034557236E-4, 0.9999864036848622, 0.0012626262626262627, 0.12626262626262627, 1.5782828282828283E-5, 0.001, 1.0936231100888785, 0.0497101413676763, 4.9710141367676295, 0.027777777777777776, 0.08333333333333333, 0.0012626262626262627, 0.12626262626262627, 1.0936142551305819, 1.0936142551305819, 0.049709738869571904, 4.97097388695719, 0.027777777777777776, 0.08333333333333333, 0.0012626262626262627, 0.12626262626262627, 1.0936103083707667, 0.08333333333333333, 3.2808570097199654, 3.2808442005829406, 3.2808452769771606, 0.027777777777777776, 1.0936190032399884, 1.093614733527647, 1.0936150923257202, 6.213711922373339E-4, 1.5678158757035574E-7, 3.2808318317876473, 1.0936132983377078, 0.049709695378986715, 0.049709695378986715, 1.093615690323032, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.525252525252525E-4, 5.05050505050505E-4, 0.00101010101010101, 0.02666666666666667, 0.04, 0.08, 0.16, 0.32, 1.093615690323032, 0.04970980410559238, 0.04970980410559238, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1852.0, 0.3048, 12.0, 0.3047972654, 1.8288, 1.0, 0.9999864036848622, 0.0012626262626262627, 0.12626262626262627, 1.5782828282828283E-5, 0.001, 1.0936231100888785, 0.0497101413676763, 4.9710141367676295, 0.027777777777777776, 0.08333333333333333, 0.0012626262626262627, 0.12626262626262627, 1.0936142551305819, 1.0936142551305819, 0.049709738869571904, 4.97097388695719, 0.027777777777777776, 0.08333333333333333, 0.0012626262626262627, 0.12626262626262627, 1.0936103083707667, 0.08333333333333333, 3.2808570097199654, 3.2808442005829406, 3.2808452769771606, 0.027777777777777776, 1.0936190032399884, 1.093614733527647, 1.0936150923257202, 6.213711922373339E-4, 1.5678158757035574E-7, 3.2808318317876473, 1.0936132983377078, 0.049709695378986715, 0.049709695378986715, 1.093615690323032, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.525252525252525E-4, 5.05050505050505E-4, 0.00101010101010101, 0.02666666666666667, 0.04, 0.08, 0.16, 0.32, 1.093615690323032, 0.04970980410559238, 0.04970980410559238, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0000135965, 0.3048, 12.0, 0.3047972654, 1.8288, 1852.0, 1.0, 0.0012626262626262627, 0.12626262626262627, 1.5782828282828283E-5, 0.001, 1.0936231100888785, 0.0497101413676763, 4.9710141367676295, 0.027777777777777776, 0.08333333333333333, 0.0012626262626262627, 0.12626262626262627, 1.0936142551305819, 1.0936142551305819, 0.049709738869571904, 4.97097388695719, 0.027777777777777776, 0.08333333333333333, 0.0012626262626262627, 0.12626262626262627, 1.0936103083707667, 0.08333333333333333, 3.2808570097199654, 3.2808442005829406, 3.2808452769771606, 0.027777777777777776, 1.0936190032399884, 1.093614733527647, 1.0936150923257202, 6.213711922373339E-4, 1.5678158757035574E-7, 3.2808318317876473, 1.0936132983377078, 0.049709695378986715, 0.049709695378986715, 1.093615690323032, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.525252525252525E-4, 5.05050505050505E-4, 0.00101010101010101, 0.02666666666666667, 0.04, 0.08, 0.16, 0.32, 1.093615690323032, 0.04970980410559238, 0.04970980410559238, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {792.0, 11.999976, 472.44, 11.999868338797999, 71.999856, 72913.23999999999, 39.37053529420499, 1.0, 0.0032070771212249502, 4.0088464015311875E-7, 2.5400050800101604E-5, 0.02777808255242262, 0.0012626401160192103, 0.12626401160192102, 7.055569666694889E-4, 0.002116670900008467, 3.20707712122495E-5, 0.0032070771212249502, 0.027777857636032056, 0.027777857636032056, 0.0012626298925469115, 0.12626298925469115, 7.055569666694889E-4, 0.002116670900008467, 3.20707712122495E-5, 0.0032070771212249502, 0.027777757388132252, 0.002116670900008467, 0.08333393471475656, 0.08333360936202543, 0.08333363670249329, 7.055569666694889E-4, 0.027777978238252184, 0.02777786978734181, 0.0277778789008311, 1.578285984854798E-5, 3.982260288807614E-9, 0.08333329519399664, 0.027777833333444447, 0.0012626287878838385, 0.0012626287878838385, 0.027777894089993198, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.4141542424499E-6, 1.28283084848998E-5, 2.56566169697996E-5, 6.773346880027095E-4, 0.0010160020320040641, 0.0020320040640081282, 0.0040640081280162565, 0.008128016256032513, 0.027777894089993198, 0.0012626315495451457, 0.0012626315495451457, 0.0, 0.025400050800101603, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {7.92, 11.999976, 472.44, 11.999868338797999, 71.999856, 72913.23999999999, 39.37053529420499, 31181.039999999994, 1.0, 4.0088464015311875E-7, 2.5400050800101604E-5, 0.02777808255242262, 0.0012626401160192103, 0.12626401160192102, 7.055569666694889E-4, 0.002116670900008467, 3.20707712122495E-5, 0.0032070771212249502, 0.027777857636032056, 0.027777857636032056, 0.0012626298925469115, 0.12626298925469115, 7.055569666694889E-4, 0.002116670900008467, 3.20707712122495E-5, 0.0032070771212249502, 0.027777757388132252, 0.002116670900008467, 0.08333393471475656, 0.08333360936202543, 0.08333363670249329, 7.055569666694889E-4, 0.027777978238252184, 0.02777786978734181, 0.0277778789008311, 1.578285984854798E-5, 3.982260288807614E-9, 0.08333329519399664, 0.027777833333444447, 0.0012626287878838385, 0.0012626287878838385, 0.027777894089993198, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.4141542424499E-6, 1.28283084848998E-5, 2.56566169697996E-5, 6.773346880027095E-4, 0.0010160020320040641, 0.0020320040640081282, 0.0040640081280162565, 0.008128016256032513, 0.027777894089993198, 0.0012626315495451457, 0.0012626315495451457, 0.0, 0.025400050800101603, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {63360.0, 11.999976, 472.44, 11.999868338797999, 71.999856, 72913.23999999999, 39.37053529420499, 31181.039999999994, 311.81039999999996, 1.0, 2.5400050800101604E-5, 0.02777808255242262, 0.0012626401160192103, 0.12626401160192102, 7.055569666694889E-4, 0.002116670900008467, 3.20707712122495E-5, 0.0032070771212249502, 0.027777857636032056, 0.027777857636032056, 0.0012626298925469115, 0.12626298925469115, 7.055569666694889E-4, 0.002116670900008467, 3.20707712122495E-5, 0.0032070771212249502, 0.027777757388132252, 0.002116670900008467, 0.08333393471475656, 0.08333360936202543, 0.08333363670249329, 7.055569666694889E-4, 0.027777978238252184, 0.02777786978734181, 0.0277778789008311, 1.578285984854798E-5, 3.982260288807614E-9, 0.08333329519399664, 0.027777833333444447, 0.0012626287878838385, 0.0012626287878838385, 0.027777894089993198, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.4141542424499E-6, 1.28283084848998E-5, 2.56566169697996E-5, 6.773346880027095E-4, 0.0010160020320040641, 0.0020320040640081282, 0.0040640081280162565, 0.008128016256032513, 0.027777894089993198, 0.0012626315495451457, 0.0012626315495451457, 0.0, 0.025400050800101603, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1000.0, 0.3048, 12.0, 0.3047972654, 1.8288, 1852.0, 1.0000135965, 791.9999999999999, 7.92, 63360.0, 1.0, 1.0936231100888785, 0.0497101413676763, 4.9710141367676295, 0.027777777777777776, 0.08333333333333333, 0.0012626262626262627, 0.12626262626262627, 1.0936142551305819, 1.0936142551305819, 0.049709738869571904, 4.97097388695719, 0.027777777777777776, 0.08333333333333333, 0.0012626262626262627, 0.12626262626262627, 1.0936103083707667, 0.08333333333333333, 3.2808570097199654, 3.2808442005829406, 3.2808452769771606, 0.027777777777777776, 1.0936190032399884, 1.093614733527647, 1.0936150923257202, 6.213711922373339E-4, 1.5678158757035574E-7, 3.2808318317876473, 1.0936132983377078, 0.049709695378986715, 0.049709695378986715, 1.093615690323032, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.525252525252525E-4, 5.05050505050505E-4, 0.00101010101010101, 0.02666666666666667, 0.04, 0.08, 0.16, 0.32, 1.093615690323032, 0.04970980410559238, 0.04970980410559238, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.9143917962, 0.3048, 12.0, 0.3047972654, 1.8288, 1852.0, 1.0000135965, 791.9999999999999, 7.92, 63360.0, 1000.0, 1.0, 0.0497101413676763, 4.9710141367676295, 0.027777777777777776, 0.08333333333333333, 0.0012626262626262627, 0.12626262626262627, 1.0936142551305819, 1.0936142551305819, 0.049709738869571904, 4.97097388695719, 0.027777777777777776, 0.08333333333333333, 0.0012626262626262627, 0.12626262626262627, 1.0936103083707667, 0.08333333333333333, 3.2808570097199654, 3.2808442005829406, 3.2808452769771606, 0.027777777777777776, 1.0936190032399884, 1.093614733527647, 1.0936150923257202, 6.213711922373339E-4, 1.5678158757035574E-7, 3.2808318317876473, 1.0936132983377078, 0.049709695378986715, 0.049709695378986715, 1.093615690323032, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.525252525252525E-4, 5.05050505050505E-4, 0.00101010101010101, 0.02666666666666667, 0.04, 0.08, 0.16, 0.32, 1.093615690323032, 0.04970980410559238, 0.04970980410559238, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {20.1166195164, 0.3048, 12.0, 0.3047972654, 1.8288, 1852.0, 1.0000135965, 791.9999999999999, 7.92, 63360.0, 1000.0, 0.9143917962000001, 1.0, 4.9710141367676295, 0.027777777777777776, 0.08333333333333333, 0.0012626262626262627, 0.12626262626262627, 1.0936142551305819, 1.0936142551305819, 0.049709738869571904, 4.97097388695719, 0.027777777777777776, 0.08333333333333333, 0.0012626262626262627, 0.12626262626262627, 1.0936103083707667, 0.08333333333333333, 3.2808570097199654, 3.2808442005829406, 3.2808452769771606, 0.027777777777777776, 1.0936190032399884, 1.093614733527647, 1.0936150923257202, 6.213711922373339E-4, 1.5678158757035574E-7, 3.2808318317876473, 1.0936132983377078, 0.049709695378986715, 0.049709695378986715, 1.093615690323032, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.525252525252525E-4, 5.05050505050505E-4, 0.00101010101010101, 0.02666666666666667, 0.04, 0.08, 0.16, 0.32, 1.093615690323032, 0.04970980410559238, 0.04970980410559238, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.201166195164, 0.3048, 12.0, 0.3047972654, 1.8288, 1852.0, 1.0000135965, 791.9999999999999, 7.92, 63360.0, 1000.0, 0.9143917962000001, 20.1166195164, 1.0, 0.027777777777777776, 0.08333333333333333, 0.0012626262626262627, 0.12626262626262627, 1.0936142551305819, 1.0936142551305819, 0.049709738869571904, 4.97097388695719, 0.027777777777777776, 0.08333333333333333, 0.0012626262626262627, 0.12626262626262627, 1.0936103083707667, 0.08333333333333333, 3.2808570097199654, 3.2808442005829406, 3.2808452769771606, 0.027777777777777776, 1.0936190032399884, 1.093614733527647, 1.0936150923257202, 6.213711922373339E-4, 1.5678158757035574E-7, 3.2808318317876473, 1.0936132983377078, 0.049709695378986715, 0.049709695378986715, 1.093615690323032, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.525252525252525E-4, 5.05050505050505E-4, 0.00101010101010101, 0.02666666666666667, 0.04, 0.08, 0.16, 0.32, 1.093615690323032, 0.04970980410559238, 0.04970980410559238, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {36.0, 12.000020805600004, 472.4417640000001, 11.999913143996016, 72.00012483360001, 72913.512244, 39.37068229620369, 31181.156424, 311.81156424, 2494492.5139200003, 39370.147000000004, 35.99973943198805, 791.994267503737, 7.919942675037371, 1.0, 0.0021166629967963625, 3.2070651466611555E-5, 0.0032070651466611557, 0.02777775391924703, 0.02777775391924703, 0.0012626251781475922, 0.12626251781475922, 7.055543322654541E-4, 0.0021166629967963625, 3.2070651466611555E-5, 0.0032070651466611557, 0.027777653671721532, 0.0021166629967963625, 0.08333362356305057, 0.08333329821153423, 0.08333332555190003, 7.055543322654541E-4, 0.027777874521016856, 0.027777766070511415, 0.027777775183966676, 1.5782800918608045E-5, 3.9822454198699265E-9, 0.0833329840446785, 0.027777729616750166, 0.0012626240734886437, 0.0012626240734886437, 0.027777790373072063, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.414130293322311E-6, 1.2828260586644622E-5, 2.5656521173289244E-5, 6.77332158974836E-4, 0.001015998238462254, 0.002031996476924508, 0.004063992953849016, 0.008127985907698032, 0.027777790373072063, 0.0012626268351396395, 0.0012626268351396395, 0.0, 0.02539995596155635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {12.0, 12.000020805600004, 472.4417640000001, 11.999913143996016, 72.00012483360001, 72913.512244, 39.37068229620369, 31181.156424, 311.81156424, 2494492.5139200003, 39370.147000000004, 35.99973943198805, 791.994267503737, 7.919942675037371, 1417.3252920000002, 1.0, 3.2070651466611555E-5, 0.0032070651466611557, 0.02777775391924703, 0.02777775391924703, 0.0012626251781475922, 0.12626251781475922, 7.055543322654541E-4, 0.0021166629967963625, 3.2070651466611555E-5, 0.0032070651466611557, 0.027777653671721532, 0.0021166629967963625, 0.08333362356305057, 0.08333329821153423, 0.08333332555190003, 7.055543322654541E-4, 0.027777874521016856, 0.027777766070511415, 0.027777775183966676, 1.5782800918608045E-5, 3.9822454198699265E-9, 0.0833329840446785, 0.027777729616750166, 0.0012626240734886437, 0.0012626240734886437, 0.027777790373072063, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.414130293322311E-6, 1.2828260586644622E-5, 2.5656521173289244E-5, 6.77332158974836E-4, 0.001015998238462254, 0.002031996476924508, 0.004063992953849016, 0.008127985907698032, 0.027777790373072063, 0.0012626268351396395, 0.0012626268351396395, 0.0, 0.02539995596155635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {792.0, 12.000020805600004, 472.4417640000001, 11.999913143996016, 72.00012483360001, 72913.512244, 39.37068229620369, 31181.156424, 311.81156424, 2494492.5139200003, 39370.147000000004, 35.99973943198805, 791.994267503737, 7.919942675037371, 1417.3252920000002, 472.4417640000001, 1.0, 0.0032070651466611557, 0.02777775391924703, 0.02777775391924703, 0.0012626251781475922, 0.12626251781475922, 7.055543322654541E-4, 0.0021166629967963625, 3.2070651466611555E-5, 0.0032070651466611557, 0.027777653671721532, 0.0021166629967963625, 0.08333362356305057, 0.08333329821153423, 0.08333332555190003, 7.055543322654541E-4, 0.027777874521016856, 0.027777766070511415, 0.027777775183966676, 1.5782800918608045E-5, 3.9822454198699265E-9, 0.0833329840446785, 0.027777729616750166, 0.0012626240734886437, 0.0012626240734886437, 0.027777790373072063, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.414130293322311E-6, 1.2828260586644622E-5, 2.5656521173289244E-5, 6.77332158974836E-4, 0.001015998238462254, 0.002031996476924508, 0.004063992953849016, 0.008127985907698032, 0.027777790373072063, 0.0012626268351396395, 0.0012626268351396395, 0.0, 0.02539995596155635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {7.92, 12.000020805600004, 472.4417640000001, 11.999913143996016, 72.00012483360001, 72913.512244, 39.37068229620369, 31181.156424, 311.81156424, 2494492.5139200003, 39370.147000000004, 35.99973943198805, 791.994267503737, 7.919942675037371, 1417.3252920000002, 472.4417640000001, 31181.156424, 1.0, 0.02777775391924703, 0.02777775391924703, 0.0012626251781475922, 0.12626251781475922, 7.055543322654541E-4, 0.0021166629967963625, 3.2070651466611555E-5, 0.0032070651466611557, 0.027777653671721532, 0.0021166629967963625, 0.08333362356305057, 0.08333329821153423, 0.08333332555190003, 7.055543322654541E-4, 0.027777874521016856, 0.027777766070511415, 0.027777775183966676, 1.5782800918608045E-5, 3.9822454198699265E-9, 0.0833329840446785, 0.027777729616750166, 0.0012626240734886437, 0.0012626240734886437, 0.027777790373072063, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.414130293322311E-6, 1.2828260586644622E-5, 2.5656521173289244E-5, 6.77332158974836E-4, 0.001015998238462254, 0.002031996476924508, 0.004063992953849016, 0.008127985907698032, 0.027777790373072063, 0.0012626268351396395, 0.0012626268351396395, 0.0, 0.02539995596155635, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.9143992, 0.3048, 12.0, 0.3047972654, 1.8288, 1852.0, 1.0000135965, 791.9999999999999, 7.92, 63360.0, 1000.0, 0.9143917962000001, 20.1166195164, 0.201166195164, 36.0, 12.0, 791.9999999999999, 7.92, 1.0, 1.0936142551305819, 0.049709738869571904, 4.97097388695719, 0.027777777777777776, 0.08333333333333333, 0.0012626262626262627, 0.12626262626262627, 1.0936103083707667, 0.08333333333333333, 3.2808570097199654, 3.2808442005829406, 3.2808452769771606, 0.027777777777777776, 1.0936190032399884, 1.093614733527647, 1.0936150923257202, 6.213711922373339E-4, 1.5678158757035574E-7, 3.2808318317876473, 1.0936132983377078, 0.049709695378986715, 0.049709695378986715, 1.093615690323032, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.525252525252525E-4, 5.05050505050505E-4, 0.00101010101010101, 0.02666666666666667, 0.04, 0.08, 0.16, 0.32, 1.093615690323032, 0.04970980410559238, 0.04970980410559238, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.9143992, 0.9144000000000002, 36.0, 0.9143917962000001, 5.4864, 5556.0, 3.0000407895000003, 2376.0, 23.759999999999998, 190080.00000000003, 3000.0, 2.7431753886000005, 60.3498585492, 0.6034985854920001, 108.0, 36.0, 2376.0, 23.759999999999998, 2.7431976000000002, 1.0, 0.016569912956523967, 1.6569912956523967, 0.009259259259259259, 0.027777777777777776, 4.208754208754209E-4, 0.04208754208754209, 0.3645367694569222, 0.027777777777777776, 1.0936190032399884, 1.0936147335276467, 1.0936150923257202, 0.009259259259259259, 0.3645396677466628, 0.3645382445092156, 0.3645383641085734, 2.0712373074577796E-4, 5.2260529190118576E-8, 1.0936106105958823, 0.3645377661125693, 0.01656989845966224, 0.01656989845966224, 0.36453856344101065, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.417508417508417E-5, 1.6835016835016833E-4, 3.3670033670033666E-4, 0.008888888888888889, 0.013333333333333332, 0.026666666666666665, 0.05333333333333333, 0.10666666666666666, 0.36453856344101065, 0.016569934701864124, 0.016569934701864124, 0.0, 0.3333333333333333, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {20.1167824, 0.3048, 12.0, 0.3047972654, 1.8288, 1852.0, 1.0000135965, 791.9999999999999, 7.92, 63360.0, 1000.0, 0.9143917962000001, 20.1166195164, 0.201166195164, 36.0, 12.0, 791.9999999999999, 7.92, 0.9143992000000001, 0.9143992000000001, 1.0, 4.97097388695719, 0.027777777777777776, 0.08333333333333333, 0.0012626262626262627, 0.12626262626262627, 1.0936103083707667, 0.08333333333333333, 3.2808570097199654, 3.2808442005829406, 3.2808452769771606, 0.027777777777777776, 1.0936190032399884, 1.093614733527647, 1.0936150923257202, 6.213711922373339E-4, 1.5678158757035574E-7, 3.2808318317876473, 1.0936132983377078, 0.049709695378986715, 0.049709695378986715, 1.093615690323032, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.525252525252525E-4, 5.05050505050505E-4, 0.00101010101010101, 0.02666666666666667, 0.04, 0.08, 0.16, 0.32, 1.093615690323032, 0.04970980410559238, 0.04970980410559238, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.201167824, 0.3048, 12.0, 0.3047972654, 1.8288, 1852.0, 1.0000135965, 791.9999999999999, 7.92, 63360.0, 1000.0, 0.9143917962000001, 20.1166195164, 0.201166195164, 36.0, 12.0, 791.9999999999999, 7.92, 0.9143992000000001, 0.9143992000000001, 20.1167824, 1.0, 0.027777777777777776, 0.08333333333333333, 0.0012626262626262627, 0.12626262626262627, 1.0936103083707667, 0.08333333333333333, 3.2808570097199654, 3.2808442005829406, 3.2808452769771606, 0.027777777777777776, 1.0936190032399884, 1.093614733527647, 1.0936150923257202, 6.213711922373339E-4, 1.5678158757035574E-7, 3.2808318317876473, 1.0936132983377078, 0.049709695378986715, 0.049709695378986715, 1.093615690323032, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.525252525252525E-4, 5.05050505050505E-4, 0.00101010101010101, 0.02666666666666667, 0.04, 0.08, 0.16, 0.32, 1.093615690323032, 0.04970980410559238, 0.04970980410559238, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {36.0, 12.000010442400002, 472.4413560000001, 11.999902780888991, 72.00006265440001, 72913.449276, 39.37064829574141, 31181.129495999998, 311.81129496, 2494490.35968, 39370.113000000005, 35.99970834266698, 791.9935835386734, 7.919935835386735, 1417.3240680000001, 472.4413560000001, 31181.129495999998, 311.81129496, 35.999999831109605, 35.999999831109605, 791.9999962844113, 7.919999962844114, 1.0, 0.002116664824744936, 3.2070679162802064E-5, 0.0032070679162802063, 0.02777767766048237, 0.002116664824744936, 0.08333369552990526, 0.08333337017810795, 0.08333339751849735, 7.055549415816453E-4, 0.02777789850996842, 0.02777779005936932, 0.02777779917283245, 1.578281454862306E-5, 3.982248858934079E-9, 0.08333305601098089, 0.027777753605576588, 0.001262625163889845, 0.001262625163889845, 0.027777814361950953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.414135832560412E-6, 1.2828271665120824E-5, 2.5656543330241648E-5, 6.773327439183796E-4, 0.0010159991158775693, 0.0020319982317551387, 0.004063996463510277, 0.008127992927020555, 0.027777814361950953, 0.0012626279255432255, 0.0012626279255432255, 0.0, 0.025399977896939232, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {12.0, 12.000010442400002, 472.4413560000001, 11.999902780888991, 72.00006265440001, 72913.449276, 39.37064829574141, 31181.129495999998, 311.81129496, 2494490.35968, 39370.113000000005, 35.99970834266698, 791.9935835386734, 7.919935835386735, 1417.3240680000001, 472.4413560000001, 31181.129495999998, 311.81129496, 35.999999831109605, 35.999999831109605, 791.9999962844113, 7.919999962844114, 1417.3240680000001, 1.0, 3.2070679162802064E-5, 0.0032070679162802063, 0.02777767766048237, 0.002116664824744936, 0.08333369552990526, 0.08333337017810795, 0.08333339751849735, 7.055549415816453E-4, 0.02777789850996842, 0.02777779005936932, 0.02777779917283245, 1.578281454862306E-5, 3.982248858934079E-9, 0.08333305601098089, 0.027777753605576588, 0.001262625163889845, 0.001262625163889845, 0.027777814361950953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.414135832560412E-6, 1.2828271665120824E-5, 2.5656543330241648E-5, 6.773327439183796E-4, 0.0010159991158775693, 0.0020319982317551387, 0.004063996463510277, 0.008127992927020555, 0.027777814361950953, 0.0012626279255432255, 0.0012626279255432255, 0.0, 0.025399977896939232, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {792.0, 12.000010442400002, 472.4413560000001, 11.999902780888991, 72.00006265440001, 72913.449276, 39.37064829574141, 31181.129495999998, 311.81129496, 2494490.35968, 39370.113000000005, 35.99970834266698, 791.9935835386734, 7.919935835386735, 1417.3240680000001, 472.4413560000001, 31181.129495999998, 311.81129496, 35.999999831109605, 35.999999831109605, 791.9999962844113, 7.919999962844114, 1417.3240680000001, 472.4413560000001, 1.0, 0.0032070679162802063, 0.02777767766048237, 0.002116664824744936, 0.08333369552990526, 0.08333337017810795, 0.08333339751849735, 7.055549415816453E-4, 0.02777789850996842, 0.02777779005936932, 0.02777779917283245, 1.578281454862306E-5, 3.982248858934079E-9, 0.08333305601098089, 0.027777753605576588, 0.001262625163889845, 0.001262625163889845, 0.027777814361950953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.414135832560412E-6, 1.2828271665120824E-5, 2.5656543330241648E-5, 6.773327439183796E-4, 0.0010159991158775693, 0.0020319982317551387, 0.004063996463510277, 0.008127992927020555, 0.027777814361950953, 0.0012626279255432255, 0.0012626279255432255, 0.0, 0.025399977896939232, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {7.92, 12.000010442400002, 472.4413560000001, 11.999902780888991, 72.00006265440001, 72913.449276, 39.37064829574141, 31181.129495999998, 311.81129496, 2494490.35968, 39370.113000000005, 35.99970834266698, 791.9935835386734, 7.919935835386735, 1417.3240680000001, 472.4413560000001, 31181.129495999998, 311.81129496, 35.999999831109605, 35.999999831109605, 791.9999962844113, 7.919999962844114, 1417.3240680000001, 472.4413560000001, 31181.129495999998, 1.0, 0.02777767766048237, 0.002116664824744936, 0.08333369552990526, 0.08333337017810795, 0.08333339751849735, 7.055549415816453E-4, 0.02777789850996842, 0.02777779005936932, 0.02777779917283245, 1.578281454862306E-5, 3.982248858934079E-9, 0.08333305601098089, 0.027777753605576588, 0.001262625163889845, 0.001262625163889845, 0.027777814361950953, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.414135832560412E-6, 1.2828271665120824E-5, 2.5656543330241648E-5, 6.773327439183796E-4, 0.0010159991158775693, 0.0020319982317551387, 0.004063996463510277, 0.008127992927020555, 0.027777814361950953, 0.0012626279255432255, 0.0012626279255432255, 0.0, 0.025399977896939232, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.9144025, 0.9144000000000002, 36.0, 0.9143917962000001, 5.4864, 5556.0, 3.0000407895000003, 2376.0, 23.759999999999998, 190080.00000000003, 3000.0, 2.7431753886000005, 60.3498585492, 0.6034985854920001, 108.0, 36.0, 2376.0, 23.759999999999998, 2.7431976000000002, 2.7431976000000002, 60.35034720000001, 0.6035034720000001, 108.0, 36.0, 2376.0, 23.759999999999998, 1.0, 0.027777777777777776, 1.0936190032399884, 1.0936147335276467, 1.0936150923257202, 0.009259259259259259, 0.3645396677466628, 0.3645382445092156, 0.3645383641085734, 2.0712373074577796E-4, 5.2260529190118576E-8, 1.0936106105958823, 0.3645377661125693, 0.01656989845966224, 0.01656989845966224, 0.36453856344101065, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.417508417508417E-5, 1.6835016835016833E-4, 3.3670033670033666E-4, 0.008888888888888889, 0.013333333333333332, 0.026666666666666665, 0.05333333333333333, 0.10666666666666666, 0.36453856344101065, 0.016569934701864124, 0.016569934701864124, 0.0, 0.3333333333333333, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {12.0, 12.000019281600002, 472.4417040000001, 11.999911620009689, 72.0001156896, 72913.502984, 39.37067729613571, 31181.152464, 311.81152464, 2494492.19712, 39370.142, 35.999734860029065, 791.9941669206394, 7.919941669206395, 1417.3251120000002, 472.4417040000001, 31181.152464, 311.81152464, 36.000026348686404, 36.000026348686404, 792.0005796711009, 7.920005796711008, 1417.3251120000002, 472.4417040000001, 31181.152464, 311.81152464, 36.000156270155, 1.0, 0.08333363414640377, 0.08333330879484611, 0.08333333613521537, 7.055544218707104E-4, 0.027777878048801254, 0.02777776959828204, 0.027777778711738456, 1.5782802923020544E-5, 3.9822459256142824E-9, 0.08333299462795046, 0.027777733144516162, 0.0012626242338416435, 0.0012626242338416435, 0.02777779390084577, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.41413110791555E-6, 1.28282622158311E-5, 2.56565244316622E-5, 6.773322449958821E-4, 0.001015998367493823, 0.002031996734987646, 0.004063993469975292, 0.008127986939950585, 0.02777779390084577, 0.0012626269954929899, 0.0012626269954929899, 0.0, 0.025399959187345576, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.30479841, 0.3048, 12.0, 0.3047972654, 1.8288, 1852.0, 1.0000135965, 791.9999999999999, 7.92, 63360.0, 1000.0, 0.9143917962000001, 20.1166195164, 0.201166195164, 36.0, 12.0, 791.9999999999999, 7.92, 0.9143992000000001, 0.9143992000000001, 20.1167824, 0.20116782400000002, 36.0, 12.0, 791.9999999999999, 7.92, 0.9144025, 12.0, 1.0, 3.2808442005829406, 3.2808452769771606, 0.027777777777777776, 1.0936190032399884, 1.093614733527647, 1.0936150923257202, 6.213711922373339E-4, 1.5678158757035574E-7, 3.2808318317876473, 1.0936132983377078, 0.049709695378986715, 0.049709695378986715, 1.093615690323032, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.525252525252525E-4, 5.05050505050505E-4, 0.00101010101010101, 0.02666666666666667, 0.04, 0.08, 0.16, 0.32, 1.093615690323032, 0.04970980410559238, 0.04970980410559238, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.3047996, 0.3048, 12.0, 0.3047972654, 1.8288, 1852.0, 1.0000135965, 791.9999999999999, 7.92, 63360.0, 1000.0, 0.9143917962000001, 20.1166195164, 0.201166195164, 36.0, 12.0, 791.9999999999999, 7.92, 0.9143992000000001, 0.9143992000000001, 20.1167824, 0.20116782400000002, 36.0, 12.0, 791.9999999999999, 7.92, 0.9144025, 12.0, 0.30479841, 1.0, 3.2808452769771606, 0.027777777777777776, 1.0936190032399884, 1.093614733527647, 1.0936150923257202, 6.213711922373339E-4, 1.5678158757035574E-7, 3.2808318317876473, 1.0936132983377078, 0.049709695378986715, 0.049709695378986715, 1.093615690323032, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.525252525252525E-4, 5.05050505050505E-4, 0.00101010101010101, 0.02666666666666667, 0.04, 0.08, 0.16, 0.32, 1.093615690323032, 0.04970980410559238, 0.04970980410559238, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.3047995, 0.3048, 12.0, 0.3047972654, 1.8288, 1852.0, 1.0000135965, 791.9999999999999, 7.92, 63360.0, 1000.0, 0.9143917962000001, 20.1166195164, 0.201166195164, 36.0, 12.0, 791.9999999999999, 7.92, 0.9143992000000001, 0.9143992000000001, 20.1167824, 0.20116782400000002, 36.0, 12.0, 791.9999999999999, 7.92, 0.9144025, 12.0, 0.30479841, 0.3047996, 1.0, 0.027777777777777776, 1.0936190032399884, 1.093614733527647, 1.0936150923257202, 6.213711922373339E-4, 1.5678158757035574E-7, 3.2808318317876473, 1.0936132983377078, 0.049709695378986715, 0.049709695378986715, 1.093615690323032, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.525252525252525E-4, 5.05050505050505E-4, 0.00101010101010101, 0.02666666666666667, 0.04, 0.08, 0.16, 0.32, 1.093615690323032, 0.04970980410559238, 0.04970980410559238, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {36.0, 12.000019281600002, 472.4417040000001, 11.999911620009689, 72.0001156896, 72913.502984, 39.37067729613571, 31181.152464, 311.81152464, 2494492.19712, 39370.142, 35.999734860029065, 791.9941669206394, 7.919941669206395, 1417.3251120000002, 472.4417040000001, 31181.152464, 311.81152464, 36.000026348686404, 36.000026348686404, 792.0005796711009, 7.920005796711008, 1417.3251120000002, 472.4417040000001, 31181.152464, 311.81152464, 36.000156270155, 472.4417040000001, 11.99995668307422, 12.0000035335432, 11.999999596529, 1.0, 0.027777878048801254, 0.02777776959828204, 0.027777778711738456, 1.5782802923020544E-5, 3.9822459256142824E-9, 0.08333299462795046, 0.027777733144516162, 0.0012626242338416435, 0.0012626242338416435, 0.02777779390084577, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.41413110791555E-6, 1.28282622158311E-5, 2.56565244316622E-5, 6.773322449958821E-4, 0.001015998367493823, 0.002031996734987646, 0.004063993469975292, 0.008127986939950585, 0.02777779390084577, 0.0012626269954929899, 0.0012626269954929899, 0.0, 0.025399959187345576, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.91439523, 0.3048, 12.0, 0.3047972654, 1.8288, 1852.0, 1.0000135965, 791.9999999999999, 7.92, 63360.0, 1000.0, 0.9143917962000001, 20.1166195164, 0.201166195164, 36.0, 12.0, 791.9999999999999, 7.92, 0.9143992000000001, 0.9143992000000001, 20.1167824, 0.20116782400000002, 36.0, 12.0, 791.9999999999999, 7.92, 0.9144025, 12.0, 0.30479841, 0.3047996, 0.3047995, 36.0, 1.0, 1.093614733527647, 1.0936150923257202, 6.213711922373339E-4, 1.5678158757035574E-7, 3.2808318317876473, 1.0936132983377078, 0.049709695378986715, 0.049709695378986715, 1.093615690323032, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.525252525252525E-4, 5.05050505050505E-4, 0.00101010101010101, 0.02666666666666667, 0.04, 0.08, 0.16, 0.32, 1.093615690323032, 0.04970980410559238, 0.04970980410559238, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.9143988, 0.3048, 12.0, 0.3047972654, 1.8288, 1852.0, 1.0000135965, 791.9999999999999, 7.92, 63360.0, 1000.0, 0.9143917962000001, 20.1166195164, 0.201166195164, 36.0, 12.0, 791.9999999999999, 7.92, 0.9143992000000001, 0.9143992000000001, 20.1167824, 0.20116782400000002, 36.0, 12.0, 791.9999999999999, 7.92, 0.9144025, 12.0, 0.30479841, 0.3047996, 0.3047995, 36.0, 0.9143952300000001, 1.0, 1.0936150923257202, 6.213711922373339E-4, 1.5678158757035574E-7, 3.2808318317876473, 1.0936132983377078, 0.049709695378986715, 0.049709695378986715, 1.093615690323032, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.525252525252525E-4, 5.05050505050505E-4, 0.00101010101010101, 0.02666666666666667, 0.04, 0.08, 0.16, 0.32, 1.093615690323032, 0.04970980410559238, 0.04970980410559238, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.9143985, 0.3048, 12.0, 0.3047972654, 1.8288, 1852.0, 1.0000135965, 791.9999999999999, 7.92, 63360.0, 1000.0, 0.9143917962000001, 20.1166195164, 0.201166195164, 36.0, 12.0, 791.9999999999999, 7.92, 0.9143992000000001, 0.9143992000000001, 20.1167824, 0.20116782400000002, 36.0, 12.0, 791.9999999999999, 7.92, 0.9144025, 12.0, 0.30479841, 0.3047996, 0.3047995, 36.0, 0.9143952300000001, 0.9143987999999998, 1.0, 6.213711922373339E-4, 1.5678158757035574E-7, 3.2808318317876473, 1.0936132983377078, 0.049709695378986715, 0.049709695378986715, 1.093615690323032, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.525252525252525E-4, 5.05050505050505E-4, 0.00101010101010101, 0.02666666666666667, 0.04, 0.08, 0.16, 0.32, 1.093615690323032, 0.04970980410559238, 0.04970980410559238, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1609.344, 0.3048, 12.0, 0.3047972654, 1.8288, 1852.0, 1.0000135965, 791.9999999999999, 7.92, 63360.0, 1000.0, 0.9143917962000001, 20.1166195164, 0.201166195164, 36.0, 12.0, 791.9999999999999, 7.92, 0.9143992000000001, 0.9143992000000001, 20.1167824, 0.20116782400000002, 36.0, 12.0, 791.9999999999999, 7.92, 0.9144025, 12.0, 0.30479841, 0.3047996, 0.3047995, 36.0, 0.9143952300000001, 0.9143987999999998, 0.9143985, 1.0, 1.5678158757035574E-7, 3.2808318317876473, 1.0936132983377078, 0.049709695378986715, 0.049709695378986715, 1.093615690323032, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.525252525252525E-4, 5.05050505050505E-4, 0.00101010101010101, 0.02666666666666667, 0.04, 0.08, 0.16, 0.32, 1.093615690323032, 0.04970980410559238, 0.04970980410559238, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {6378300.0, 6378306.064800001, 2.51114412E8, 6378248.840010746, 3.82698363888E7, 3.8755324252E10, 2.0926485523091897E7, 1.6573551191999998E10, 1.6573551192E8, 1.32588409536E12, 2.0926201E10, 1.913474652003224E7, 4.209644234407092E8, 4209644.234407092, 7.53343236E8, 2.51114412E8, 1.6573551191999998E10, 1.6573551192E8, 1.9134901453439202E7, 1.9134901453439202E7, 4.2096783197566247E8, 4209678.319756624, 7.53343236E8, 2.51114412E8, 1.6573551191999998E10, 1.6573551192E8, 1.9134970509902503E7, 2.51114412E8, 6378272.79214041, 6378297.6943196, 6378295.601699499, 7.53343236E8, 1.913481837642123E7, 1.91348930829588E7, 1.91348868050985E7, 3.3677456022144E10, 1.0, 1.567810531776717E-7, 5.226047949829536E-8, 2.375476340831607E-9, 2.375476340831607E-9, 5.226059380405608E-8, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.2067419811424563E-11, 2.4134839622849126E-11, 4.826967924569825E-11, 1.274319532086434E-9, 1.911479298129651E-9, 3.822958596259302E-9, 7.645917192518604E-9, 1.529183438503721E-8, 5.226059380405608E-8, 2.375481536548004E-9, 2.375481536548004E-9, 0.0, 4.778698245324127E-8, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.3048007491, 0.3048, 12.0, 0.3047972654, 1.8288, 1852.0, 1.0000135965, 791.9999999999999, 7.92, 63360.0, 1000.0, 0.9143917962000001, 20.1166195164, 0.201166195164, 36.0, 12.0, 791.9999999999999, 7.92, 0.9143992000000001, 0.9143992000000001, 20.1167824, 0.20116782400000002, 36.0, 12.0, 791.9999999999999, 7.92, 0.9144025, 12.0, 0.30479841, 0.3047996, 0.3047995, 36.0, 0.9143952300000001, 0.9143987999999998, 0.9143985, 1609.344, 6378300.0, 1.0, 1.0936132983377078, 0.049709695378986715, 0.049709695378986715, 1.093615690323032, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.525252525252525E-4, 5.05050505050505E-4, 0.00101010101010101, 0.02666666666666667, 0.04, 0.08, 0.16, 0.32, 1.093615690323032, 0.04970980410559238, 0.04970980410559238, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.9144, 0.3048, 12.0, 0.3047972654, 1.8288, 1852.0, 1.0000135965, 791.9999999999999, 7.92, 63360.0, 1000.0, 0.9143917962000001, 20.1166195164, 0.201166195164, 36.0, 12.0, 791.9999999999999, 7.92, 0.9143992000000001, 0.9143992000000001, 20.1167824, 0.20116782400000002, 36.0, 12.0, 791.9999999999999, 7.92, 0.9144025, 12.0, 0.30479841, 0.3047996, 0.3047995, 36.0, 0.9143952300000001, 0.9143987999999998, 0.9143985, 1609.344, 6378300.0, 0.3048007491, 1.0, 0.049709695378986715, 0.049709695378986715, 1.093615690323032, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.525252525252525E-4, 5.05050505050505E-4, 0.00101010101010101, 0.02666666666666667, 0.04, 0.08, 0.16, 0.32, 1.093615690323032, 0.04970980410559238, 0.04970980410559238, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {20.1168, 0.3048, 12.0, 0.3047972654, 1.8288, 1852.0, 1.0000135965, 791.9999999999999, 7.92, 63360.0, 1000.0, 0.9143917962000001, 20.1166195164, 0.201166195164, 36.0, 12.0, 791.9999999999999, 7.92, 0.9143992000000001, 0.9143992000000001, 20.1167824, 0.20116782400000002, 36.0, 12.0, 791.9999999999999, 7.92, 0.9144025, 12.0, 0.30479841, 0.3047996, 0.3047995, 36.0, 0.9143952300000001, 0.9143987999999998, 0.9143985, 1609.344, 6378300.0, 0.3048007491, 0.9144, 1.0, 0.049709695378986715, 1.093615690323032, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.525252525252525E-4, 5.05050505050505E-4, 0.00101010101010101, 0.02666666666666667, 0.04, 0.08, 0.16, 0.32, 1.093615690323032, 0.04970980410559238, 0.04970980410559238, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {20.1168, 30.48, 1200.0, 30.479726539999998, 182.88, 185200.0, 100.00135965000001, 79199.99999999999, 791.9999999999999, 6336000.0, 99999.99999999999, 91.43917962, 2011.6619516399999, 20.1166195164, 3600.0, 1200.0, 79199.99999999999, 791.9999999999999, 91.43992000000001, 91.43992000000001, 2011.6782400000002, 20.1167824, 3600.0, 1200.0, 79199.99999999999, 791.9999999999999, 91.44025, 1200.0, 30.479841, 30.47996, 30.479949999999995, 3600.0, 91.439523, 91.43987999999999, 91.43984999999999, 160934.40000000002, 6.3783E8, 30.48007491, 91.44, 2011.6800000000003, 1.0, 0.010936156903230321, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.5252525252525253E-6, 5.050505050505051E-6, 1.0101010101010101E-5, 2.666666666666667E-4, 4.0E-4, 8.0E-4, 0.0016, 0.0032, 0.010936156903230321, 4.970980410559238E-4, 4.970980410559238E-4, 0.0, 0.01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.914398, 0.3048, 12.0, 0.3047972654, 1.8288, 1852.0, 1.0000135965, 791.9999999999999, 7.92, 63360.0, 1000.0, 0.9143917962000001, 20.1166195164, 0.201166195164, 36.0, 12.0, 791.9999999999999, 7.92, 0.9143992000000001, 0.9143992000000001, 20.1167824, 0.20116782400000002, 36.0, 12.0, 791.9999999999999, 7.92, 0.9144025, 12.0, 0.30479841, 0.3047996, 0.3047995, 36.0, 0.9143952300000001, 0.9143987999999998, 0.9143985, 1609.344, 6378300.0, 0.3048007491, 0.9144, 20.1168, 20.1168, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.525252525252525E-4, 5.05050505050505E-4, 0.00101010101010101, 0.02666666666666667, 0.04, 0.08, 0.16, 0.32, 1.093615690323032, 0.04970980410559238, 0.04970980410559238, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.005555555555555556, 9.259259259259259E-5, 1.5432098765432098E-6, 0.005, 0.005, 0.0, 0.0, 1.0E-6, 0.0, 0.0, 5.0E-5, 5.0E-7, 3.125E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.005555555555555556, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.14159265358979, 1.0, 0.0017683882565766168, 0.0017683882565766168, 0.0017683882565766168, 0.0017683882565766168, 0.0, 0.0, 0.005555555555555556, 0.0, 0.0, 0.0017683882565766168, 0.0017683882565766168, 0.0017683882565766168, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0017683882565766168, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.14159265358979, 33929.20065876973, 1.0, 2.9473137609610278E-5, 2.9473137609610278E-5, 2.9473137609610278E-5, 0.0, 0.0, 9.259259259259259E-5, 0.0, 0.0, 2.9473137609610278E-5, 2.9473137609610278E-5, 2.9473137609610278E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.9473137609610278E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.14159265358979, 2035752.0395261839, 2035752.0395261839, 1.0, 4.912189601601713E-7, 4.912189601601713E-7, 0.0, 0.0, 1.5432098765432098E-6, 0.0, 0.0, 4.912189601601713E-7, 4.912189601601713E-7, 4.912189601601713E-7, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.912189601601713E-7, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.14159265358979, 628.318530717958, 628.318530717958, 628.318530717958, 1.0, 0.001591549430918955, 0.0, 0.0, 0.005, 0.0, 0.0, 0.001591549430918955, 0.001591549430918955, 0.001591549430918955, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.001591549430918955, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.14159265358979, 628.318530717958, 628.318530717958, 628.318530717958, 628.318530717958, 1.0, 0.0, 0.0, 0.005, 0.0, 0.0, 0.001591549430918955, 0.001591549430918955, 0.001591549430918955, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.001591549430918955, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 3141592.6535897898, 3141592.6535897898, 3141592.6535897898, 3141592.6535897898, 3141592.6535897898, 0.0, 0.0, 1.0, 0.0, 0.0, 3.18309886183791E-7, 3.18309886183791E-7, 3.18309886183791E-7, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.18309886183791E-7, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.14159265358979, 62831.8530717958, 62831.8530717958, 62831.8530717958, 62831.8530717958, 62831.8530717958, 0.0, 0.0, 20000.0, 0.0, 0.0, 1.0, 1.591549430918955E-5, 1.591549430918955E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.591549430918955E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.14159265358979, 6283185.3071795795, 6283185.3071795795, 6283185.3071795795, 6283185.3071795795, 6283185.3071795795, 0.0, 0.0, 2000000.0, 0.0, 0.0, 6283185.3071795795, 1.0, 1.591549430918955E-7, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.591549430918955E-7, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.14159265358979, 10053.096491487328, 10053.096491487328, 10053.096491487328, 10053.096491487328, 10053.096491487328, 0.0, 0.0, 3200.0, 0.0, 0.0, 10053.096491487328, 10053.096491487328, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.947183943243469E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.14159265358979, 565.4866776461622, 565.4866776461622, 565.4866776461622, 565.4866776461622, 565.4866776461622, 0.0, 0.0, 180.0, 0.0, 0.0, 565.4866776461622, 565.4866776461622, 565.4866776461622, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0E-6, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0E-6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {3960.0, 11.999976, 472.44, 11.999868338797999, 71.999856, 72913.23999999999, 39.37053529420499, 31181.039999999994, 311.81039999999996, 2494483.1999999997, 39369.99999999999, 35.999605016394, 791.9913103606679, 7.919913103606679, 1417.32, 472.44, 31181.039999999994, 311.81039999999996, 35.999896504, 35.999896504, 791.9977230879999, 7.91997723088, 1417.32, 472.44, 31181.039999999994, 311.81039999999996, 36.000026424999994, 472.44, 11.999913401699999, 11.999960251999997, 11.999956314999999, 1417.32, 35.9997402051, 35.99988075599999, 35.99986894499999, 63359.87328, 2.5111367099999994E8, 12.000005492066997, 35.999928, 791.9984159999999, 791.9984159999999, 35.99984926, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.28283084848998E-5, 2.56566169697996E-5, 6.773346880027095E-4, 0.0010160020320040641, 0.0020320040640081282, 0.0040640081280162565, 0.008128016256032513, 0.027777894089993198, 0.0012626315495451457, 0.0012626315495451457, 0.0, 0.025400050800101603, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1980.0, 11.999976, 472.44, 11.999868338797999, 71.999856, 72913.23999999999, 39.37053529420499, 31181.039999999994, 311.81039999999996, 2494483.1999999997, 39369.99999999999, 35.999605016394, 791.9913103606679, 7.919913103606679, 1417.32, 472.44, 31181.039999999994, 311.81039999999996, 35.999896504, 35.999896504, 791.9977230879999, 7.91997723088, 1417.32, 472.44, 31181.039999999994, 311.81039999999996, 36.000026424999994, 472.44, 11.999913401699999, 11.999960251999997, 11.999956314999999, 1417.32, 35.9997402051, 35.99988075599999, 35.99986894499999, 63359.87328, 2.5111367099999994E8, 12.000005492066997, 35.999928, 791.9984159999999, 791.9984159999999, 35.99984926, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 155905.19999999998, 1.0, 2.56566169697996E-5, 6.773346880027095E-4, 0.0010160020320040641, 0.0020320040640081282, 0.0040640081280162565, 0.008128016256032513, 0.027777894089993198, 0.0012626315495451457, 0.0012626315495451457, 0.0, 0.025400050800101603, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {990.0, 11.999976, 472.44, 11.999868338797999, 71.999856, 72913.23999999999, 39.37053529420499, 31181.039999999994, 311.81039999999996, 2494483.1999999997, 39369.99999999999, 35.999605016394, 791.9913103606679, 7.919913103606679, 1417.32, 472.44, 31181.039999999994, 311.81039999999996, 35.999896504, 35.999896504, 791.9977230879999, 7.91997723088, 1417.32, 472.44, 31181.039999999994, 311.81039999999996, 36.000026424999994, 472.44, 11.999913401699999, 11.999960251999997, 11.999956314999999, 1417.32, 35.9997402051, 35.99988075599999, 35.99986894499999, 63359.87328, 2.5111367099999994E8, 12.000005492066997, 35.999928, 791.9984159999999, 791.9984159999999, 35.99984926, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 155905.19999999998, 77952.59999999999, 1.0, 6.773346880027095E-4, 0.0010160020320040641, 0.0020320040640081282, 0.0040640081280162565, 0.008128016256032513, 0.027777894089993198, 0.0012626315495451457, 0.0012626315495451457, 0.0, 0.025400050800101603, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {37.5, 0.3048, 12.0, 0.3047972654, 1.8288, 1852.0, 1.0000135965, 791.9999999999999, 7.92, 63360.0, 1000.0, 0.9143917962000001, 20.1166195164, 0.201166195164, 36.0, 12.0, 791.9999999999999, 7.92, 0.9143992000000001, 0.9143992000000001, 20.1167824, 0.20116782400000002, 36.0, 12.0, 791.9999999999999, 7.92, 0.9144025, 12.0, 0.30479841, 0.3047996, 0.3047995, 36.0, 0.9143952300000001, 0.9143987999999998, 0.9143985, 1609.344, 6378300.0, 0.3048007491, 0.9144, 20.1168, 20.1168, 0.9143980000000002, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3960.0, 1980.0, 990.0, 1.0, 0.04, 0.08, 0.16, 0.32, 1.093615690323032, 0.04970980410559238, 0.04970980410559238, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {25.0, 0.3048, 12.0, 0.3047972654, 1.8288, 1852.0, 1.0000135965, 791.9999999999999, 7.92, 63360.0, 1000.0, 0.9143917962000001, 20.1166195164, 0.201166195164, 36.0, 12.0, 791.9999999999999, 7.92, 0.9143992000000001, 0.9143992000000001, 20.1167824, 0.20116782400000002, 36.0, 12.0, 791.9999999999999, 7.92, 0.9144025, 12.0, 0.30479841, 0.3047996, 0.3047995, 36.0, 0.9143952300000001, 0.9143987999999998, 0.9143985, 1609.344, 6378300.0, 0.3048007491, 0.9144, 20.1168, 20.1168, 0.9143980000000002, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3960.0, 1980.0, 990.0, 37.5, 1.0, 0.08, 0.16, 0.32, 1.093615690323032, 0.04970980410559238, 0.04970980410559238, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {12.5, 0.3048, 12.0, 0.3047972654, 1.8288, 1852.0, 1.0000135965, 791.9999999999999, 7.92, 63360.0, 1000.0, 0.9143917962000001, 20.1166195164, 0.201166195164, 36.0, 12.0, 791.9999999999999, 7.92, 0.9143992000000001, 0.9143992000000001, 20.1167824, 0.20116782400000002, 36.0, 12.0, 791.9999999999999, 7.92, 0.9144025, 12.0, 0.30479841, 0.3047996, 0.3047995, 36.0, 0.9143952300000001, 0.9143987999999998, 0.9143985, 1609.344, 6378300.0, 0.3048007491, 0.9144, 20.1168, 20.1168, 0.9143980000000002, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3960.0, 1980.0, 990.0, 37.5, 25.0, 1.0, 0.16, 0.32, 1.093615690323032, 0.04970980410559238, 0.04970980410559238, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {6.25, 0.3048, 12.0, 0.3047972654, 1.8288, 1852.0, 1.0000135965, 791.9999999999999, 7.92, 63360.0, 1000.0, 0.9143917962000001, 20.1166195164, 0.201166195164, 36.0, 12.0, 791.9999999999999, 7.92, 0.9143992000000001, 0.9143992000000001, 20.1167824, 0.20116782400000002, 36.0, 12.0, 791.9999999999999, 7.92, 0.9144025, 12.0, 0.30479841, 0.3047996, 0.3047995, 36.0, 0.9143952300000001, 0.9143987999999998, 0.9143985, 1609.344, 6378300.0, 0.3048007491, 0.9144, 20.1168, 20.1168, 0.9143980000000002, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3960.0, 1980.0, 990.0, 37.5, 25.0, 12.5, 1.0, 0.32, 1.093615690323032, 0.04970980410559238, 0.04970980410559238, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {3.125, 0.3048, 12.0, 0.3047972654, 1.8288, 1852.0, 1.0000135965, 791.9999999999999, 7.92, 63360.0, 1000.0, 0.9143917962000001, 20.1166195164, 0.201166195164, 36.0, 12.0, 791.9999999999999, 7.92, 0.9143992000000001, 0.9143992000000001, 20.1167824, 0.20116782400000002, 36.0, 12.0, 791.9999999999999, 7.92, 0.9144025, 12.0, 0.30479841, 0.3047996, 0.3047995, 36.0, 0.9143952300000001, 0.9143987999999998, 0.9143985, 1609.344, 6378300.0, 0.3048007491, 0.9144, 20.1168, 20.1168, 0.9143980000000002, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3960.0, 1980.0, 990.0, 37.5, 25.0, 12.5, 6.25, 1.0, 1.093615690323032, 0.04970980410559238, 0.04970980410559238, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.914398, 0.9144000000000002, 36.0, 0.9143917962000001, 5.4864, 5556.0, 3.0000407895000003, 2376.0, 23.759999999999998, 190080.00000000003, 3000.0, 2.7431753886000005, 60.3498585492, 0.6034985854920001, 108.0, 36.0, 2376.0, 23.759999999999998, 2.7431976000000002, 2.7431976000000002, 60.35034720000001, 0.6035034720000001, 108.0, 36.0, 2376.0, 23.759999999999998, 2.7432075, 36.0, 0.9143952300000001, 0.9143988000000001, 0.9143985, 108.0, 2.7431856900000002, 2.7431964, 2.7431955, 4828.032000000001, 1.91349E7, 0.9144022473000001, 2.7432, 60.3504, 60.3504, 2.743194000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11880.000000000002, 5940.000000000001, 2970.0000000000005, 112.5, 75.0, 37.5, 18.75, 9.375, 1.0, 0.016569934701864124, 0.016569934701864124, 0.0, 0.3333333333333333, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {20.116756, 0.3048, 12.0, 0.3047972654, 1.8288, 1852.0, 1.0000135965, 791.9999999999999, 7.92, 63360.0, 1000.0, 0.9143917962000001, 20.1166195164, 0.201166195164, 36.0, 12.0, 791.9999999999999, 7.92, 0.9143992000000001, 0.9143992000000001, 20.1167824, 0.20116782400000002, 36.0, 12.0, 791.9999999999999, 7.92, 0.9144025, 12.0, 0.30479841, 0.3047996, 0.3047995, 36.0, 0.9143952300000001, 0.9143987999999998, 0.9143985, 1609.344, 6378300.0, 0.3048007491, 0.9144, 20.1168, 20.1168, 0.9143980000000002, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3960.0, 1980.0, 990.0, 37.5, 25.0, 12.5, 6.25, 3.125, 0.9143980000000002, 1.0, 0.04970980410559238, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {20.116756, 30.48, 1200.0, 30.479726539999998, 182.88, 185200.0, 100.00135965000001, 79199.99999999999, 791.9999999999999, 6336000.0, 99999.99999999999, 91.43917962, 2011.6619516399999, 20.1166195164, 3600.0, 1200.0, 79199.99999999999, 791.9999999999999, 91.43992000000001, 91.43992000000001, 2011.6782400000002, 20.1167824, 3600.0, 1200.0, 79199.99999999999, 791.9999999999999, 91.44025, 1200.0, 30.479841, 30.47996, 30.479949999999995, 3600.0, 91.439523, 91.43987999999999, 91.43984999999999, 160934.40000000002, 6.3783E8, 30.48007491, 91.44, 2011.6800000000003, 2011.6800000000003, 91.4398, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 396000.0, 198000.0, 99000.0, 3750.0, 2500.0, 1250.0, 625.0, 312.5, 91.4398, 2011.6755999999996, 1.0, 0.0, 0.01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 304.80000000000007, 12000.0, 304.7972654, 1828.8, 1852000.0, 1000.0135965000001, 792000.0, 7920.0, 6.336E7, 1000000.0, 914.3917962, 20116.619516400002, 201.16619516400002, 36000.0, 12000.0, 792000.0, 7920.0, 914.3992, 914.3992, 20116.7824, 201.16782400000002, 36000.0, 12000.0, 792000.0, 7920.0, 914.4025, 12000.0, 304.79841, 304.7996, 304.79949999999997, 36000.0, 914.39523, 914.3987999999998, 914.3984999999999, 1609344.0, 6.3783E9, 304.80074909999996, 914.4, 20116.800000000003, 20116.800000000003, 914.3980000000001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3960000.0, 1980000.0, 990000.0, 37499.99999999999, 24999.999999999996, 12499.999999999998, 6249.999999999999, 3124.9999999999995, 914.3980000000001, 20116.755999999998, 20116.755999999998, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1000.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 60.0, 1.0, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 60.0, 1.0}};
    }

    /*
     * Opcode count of 31421 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static void populateTableB() {
        conversionMatrixB = new double[][]{{1.0, 3.280839895013123, 0.08333333333333333, 3.2808693302666354, 0.5468066491688539, 5.399568034557236E-4, 0.9999864036848622, 0.0012626262626262627, 0.12626262626262627, 1.5782828282828283E-5, 0.001, 1.0936231100888785, 0.0497101413676763, 4.9710141367676295, 0.027777777777777776, 0.08333333333333333, 0.0012626262626262627, 0.12626262626262627, 1.0936142551305819, 1.0936142551305819, 0.049709738869571904, 4.97097388695719, 0.027777777777777776, 0.08333333333333333, 0.0012626262626262627, 0.12626262626262627, 1.0936103083707667, 0.08333333333333333, 3.2808570097199654, 3.2808442005829406, 3.2808452769771606, 0.027777777777777776, 1.0936190032399884, 1.093614733527647, 1.0936150923257202, 6.213711922373339E-4, 1.5678158757035574E-7, 3.2808318317876473, 1.0936132983377078, 0.049709695378986715, 0.049709695378986715, 1.093615690323032, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.525252525252525E-4, 5.05050505050505E-4, 0.00101010101010101, 0.02666666666666667, 0.04, 0.08, 0.16, 0.32, 1.093615690323032, 0.04970980410559238, 0.04970980410559238, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 1.0, 0.08333350000033334, 3.280839895013123, 3.280839895013123, 3.280839895013123, 3.280839895013123, 0.08333350000033334, 0.08333350000033334, 0.08333350000033334, 3.280839895013123, 3.280839895013123, 3.280839895013123, 3.280839895013123, 0.08333318885025048, 0.08333318885025048, 0.08333318885025048, 0.08333318885025048, 3.280839895013123, 1.0936132983377076, 3.280839895013123, 3.280839895013123, 0.08333326081672976, 0.08333326081672976, 0.08333326081672976, 0.08333326081672976, 1.0936132983377076, 0.08333319943354847, 3.280839895013123, 3.280839895013123, 3.280839895013123, 0.08333319943354847, 3.280839895013123, 3.280839895013123, 3.280839895013123, 3.280839895013123, 1.5678143849488605E-7, 3.280839895013123, 3.280839895013123, 3.280839895013123, 0.03280839895013123, 3.280839895013123, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.08333350000033334, 0.08333350000033334, 0.08333350000033334, 3.280839895013123, 3.280839895013123, 3.280839895013123, 3.280839895013123, 3.280839895013123, 1.0936132983377076, 3.280839895013123, 0.03280839895013123, 0.0, 0.003280839895013123, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {39.37, 12.0, 1.0, 0.08333333333333333, 0.08333333333333333, 0.08333333333333333, 0.08333333333333333, 0.002116670900008467, 0.002116670900008467, 0.002116670900008467, 0.08333333333333333, 0.08333333333333333, 0.08333333333333333, 0.08333333333333333, 0.0021166629967963625, 0.0021166629967963625, 0.0021166629967963625, 0.0021166629967963625, 0.08333333333333333, 0.027777777777777776, 0.08333333333333333, 0.08333333333333333, 0.002116664824744936, 0.002116664824744936, 0.002116664824744936, 0.002116664824744936, 0.027777777777777776, 0.002116663265612131, 0.08333333333333333, 0.08333333333333333, 0.08333333333333333, 0.002116663265612131, 0.08333333333333333, 0.08333333333333333, 0.08333333333333333, 0.08333333333333333, 3.982248537770106E-9, 0.08333333333333333, 0.08333333333333333, 0.08333333333333333, 8.333333333333333E-4, 0.08333333333333333, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.002116670900008467, 0.002116670900008467, 0.002116670900008467, 0.08333333333333333, 0.08333333333333333, 0.08333333333333333, 0.08333333333333333, 0.08333333333333333, 0.027777777777777776, 0.08333333333333333, 8.333333333333333E-4, 0.0, 8.333333333333333E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 0.3047972654, 11.999868338797999, 1.0, 3.2808693302666354, 3.2808693302666354, 3.2808693302666354, 0.08333424765726787, 0.08333424765726787, 0.08333424765726787, 3.2808693302666354, 3.2808693302666354, 3.2808693302666354, 3.2808693302666354, 0.08333393650439341, 0.08333393650439341, 0.08333393650439341, 0.08333393650439341, 3.2808693302666354, 1.0936231100888785, 3.2808693302666354, 3.2808693302666354, 0.08333400847151837, 0.08333400847151837, 0.08333400847151837, 0.08333400847151837, 1.0936231100888785, 0.08333394708778635, 3.2808693302666354, 3.2808693302666354, 3.2808693302666354, 0.08333394708778635, 3.2808693302666354, 3.2808693302666354, 3.2808693302666354, 3.2808693302666354, 1.5678284511682914E-7, 3.2808693302666354, 3.2808693302666354, 3.2808693302666354, 0.03280869330266636, 3.2808693302666354, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.08333424765726787, 0.08333424765726787, 0.08333424765726787, 3.2808693302666354, 3.2808693302666354, 3.2808693302666354, 3.2808693302666354, 3.2808693302666354, 1.0936231100888785, 3.2808693302666354, 0.03280869330266636, 0.0, 0.0032808693302666353, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 1.8288, 71.999856, 1.8288, 1.0, 0.5468066491688539, 0.5468066491688539, 0.013888916666722224, 0.013888916666722224, 0.013888916666722224, 0.5468066491688539, 0.5468066491688539, 0.5468066491688539, 0.5468066491688539, 0.013888864808375083, 0.013888864808375083, 0.013888864808375083, 0.013888864808375083, 0.5468066491688539, 0.18226888305628464, 0.5468066491688539, 0.5468066491688539, 0.013888876802788294, 0.013888876802788294, 0.013888876802788294, 0.013888876802788294, 0.18226888305628464, 0.013888866572258081, 0.5468066491688539, 0.5468066491688539, 0.5468066491688539, 0.013888866572258081, 0.5468066491688539, 0.5468066491688539, 0.5468066491688539, 0.5468066491688539, 2.613023974914768E-8, 0.5468066491688539, 0.5468066491688539, 0.5468066491688539, 0.0054680664916885394, 0.5468066491688539, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.013888916666722224, 0.013888916666722224, 0.013888916666722224, 0.5468066491688539, 0.5468066491688539, 0.5468066491688539, 0.5468066491688539, 0.5468066491688539, 0.18226888305628464, 0.5468066491688539, 0.0054680664916885394, 0.0, 5.468066491688539E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 1852.0, 72913.23999999999, 1852.0, 1852.0, 1.0, 5.399568034557236E-4, 1.3714930237635856E-5, 1.3714930237635856E-5, 1.3714930237635856E-5, 5.399568034557236E-4, 5.399568034557236E-4, 5.399568034557236E-4, 5.399568034557236E-4, 1.3714879028918117E-5, 1.3714879028918117E-5, 1.3714879028918117E-5, 1.3714879028918117E-5, 5.399568034557236E-4, 1.7998560115190784E-4, 5.399568034557236E-4, 5.399568034557236E-4, 1.371489087307734E-5, 1.371489087307734E-5, 1.371489087307734E-5, 1.371489087307734E-5, 1.7998560115190784E-4, 1.3714880770704955E-5, 5.399568034557236E-4, 5.399568034557236E-4, 5.399568034557236E-4, 1.3714880770704955E-5, 5.399568034557236E-4, 5.399568034557236E-4, 5.399568034557236E-4, 5.399568034557236E-4, 2.580290629224691E-11, 5.399568034557236E-4, 5.399568034557236E-4, 5.399568034557236E-4, 5.399568034557236E-6, 5.399568034557236E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.3714930237635856E-5, 1.3714930237635856E-5, 1.3714930237635856E-5, 5.399568034557236E-4, 5.399568034557236E-4, 5.399568034557236E-4, 5.399568034557236E-4, 5.399568034557236E-4, 1.7998560115190784E-4, 5.399568034557236E-4, 5.399568034557236E-6, 0.0, 5.399568034557235E-7, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 1.0000135965, 39.37053529420499, 1.0000135965, 1.0000135965, 1.0000135965, 1.0, 0.025399705453006412, 0.025399705453006412, 0.025399705453006412, 0.9999864036848622, 0.9999864036848622, 0.9999864036848622, 0.9999864036848622, 0.025399610615750613, 0.025399610615750613, 0.025399610615750613, 0.025399610615750613, 0.9999864036848622, 0.3333288012282874, 0.9999864036848622, 0.9999864036848622, 0.025399632550835254, 0.025399632550835254, 0.025399632550835254, 0.025399632550835254, 0.3333288012282874, 0.02539961384149598, 0.9999864036848622, 0.9999864036848622, 0.9999864036848622, 0.02539961384149598, 0.9999864036848622, 0.9999864036848622, 0.9999864036848622, 0.9999864036848622, 4.7786332726368354E-8, 0.9999864036848622, 0.9999864036848622, 0.9999864036848622, 0.009999864036848622, 0.9999864036848622, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.025399705453006412, 0.025399705453006412, 0.025399705453006412, 0.9999864036848622, 0.9999864036848622, 0.9999864036848622, 0.9999864036848622, 0.9999864036848622, 0.3333288012282874, 0.9999864036848622, 0.009999864036848622, 0.0, 9.999864036848622E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {39.37, 791.9999999999999, 31181.039999999994, 791.9999999999999, 791.9999999999999, 791.9999999999999, 791.9999999999999, 1.0, 3.20707712122495E-5, 3.20707712122495E-5, 0.0012626262626262627, 0.0012626262626262627, 0.0012626262626262627, 0.0012626262626262627, 3.2070651466611555E-5, 3.2070651466611555E-5, 3.2070651466611555E-5, 3.2070651466611555E-5, 0.0012626262626262627, 4.208754208754209E-4, 0.0012626262626262627, 0.0012626262626262627, 3.2070679162802064E-5, 3.2070679162802064E-5, 3.2070679162802064E-5, 3.2070679162802064E-5, 4.208754208754209E-4, 3.207065553957775E-5, 0.0012626262626262627, 0.0012626262626262627, 0.0012626262626262627, 3.207065553957775E-5, 0.0012626262626262627, 0.0012626262626262627, 0.0012626262626262627, 0.0012626262626262627, 6.033709905712283E-11, 0.0012626262626262627, 0.0012626262626262627, 0.0012626262626262627, 1.2626262626262628E-5, 0.0012626262626262627, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.20707712122495E-5, 3.20707712122495E-5, 3.20707712122495E-5, 0.0012626262626262627, 0.0012626262626262627, 0.0012626262626262627, 0.0012626262626262627, 0.0012626262626262627, 4.208754208754209E-4, 0.0012626262626262627, 1.2626262626262628E-5, 0.0, 1.2626262626262627E-6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {39.37, 7.92, 311.81039999999996, 7.92, 7.92, 7.92, 7.92, 311.81039999999996, 1.0, 0.0032070771212249502, 0.12626262626262627, 0.12626262626262627, 0.12626262626262627, 0.12626262626262627, 0.0032070651466611557, 0.0032070651466611557, 0.0032070651466611557, 0.0032070651466611557, 0.12626262626262627, 0.04208754208754209, 0.12626262626262627, 0.12626262626262627, 0.0032070679162802063, 0.0032070679162802063, 0.0032070679162802063, 0.0032070679162802063, 0.04208754208754209, 0.003207065553957775, 0.12626262626262627, 0.12626262626262627, 0.12626262626262627, 0.003207065553957775, 0.12626262626262627, 0.12626262626262627, 0.12626262626262627, 0.12626262626262627, 6.0337099057122825E-9, 0.12626262626262627, 0.12626262626262627, 0.12626262626262627, 0.0012626262626262627, 0.12626262626262627, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0032070771212249502, 0.0032070771212249502, 0.0032070771212249502, 0.12626262626262627, 0.12626262626262627, 0.12626262626262627, 0.12626262626262627, 0.12626262626262627, 0.04208754208754209, 0.12626262626262627, 0.0012626262626262627, 0.0, 1.2626262626262626E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {39.37, 63360.0, 2494483.1999999997, 63360.0, 63360.0, 63360.0, 63360.0, 2494483.1999999997, 2494483.1999999997, 1.0, 1.5782828282828283E-5, 1.5782828282828283E-5, 1.5782828282828283E-5, 1.5782828282828283E-5, 4.0088314333264444E-7, 4.0088314333264444E-7, 4.0088314333264444E-7, 4.0088314333264444E-7, 1.5782828282828283E-5, 5.26094276094276E-6, 1.5782828282828283E-5, 1.5782828282828283E-5, 4.0088348953502574E-7, 4.0088348953502574E-7, 4.0088348953502574E-7, 4.0088348953502574E-7, 5.26094276094276E-6, 4.0088319424472187E-7, 1.5782828282828283E-5, 1.5782828282828283E-5, 1.5782828282828283E-5, 4.0088319424472187E-7, 1.5782828282828283E-5, 1.5782828282828283E-5, 1.5782828282828283E-5, 1.5782828282828283E-5, 7.542137382140352E-13, 1.5782828282828283E-5, 1.5782828282828283E-5, 1.5782828282828283E-5, 1.5782828282828283E-7, 1.5782828282828283E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.0088464015311875E-7, 4.0088464015311875E-7, 4.0088464015311875E-7, 1.5782828282828283E-5, 1.5782828282828283E-5, 1.5782828282828283E-5, 1.5782828282828283E-5, 1.5782828282828283E-5, 5.26094276094276E-6, 1.5782828282828283E-5, 1.5782828282828283E-7, 0.0, 1.5782828282828283E-8, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 1000.0, 39369.99999999999, 1000.0, 1000.0, 1000.0, 1000.0, 39369.99999999999, 39369.99999999999, 39369.99999999999, 1.0, 0.001, 0.001, 0.001, 2.539995596155635E-5, 2.539995596155635E-5, 2.539995596155635E-5, 2.539995596155635E-5, 0.001, 3.333333333333333E-4, 0.001, 0.001, 2.5399977896939232E-5, 2.5399977896939232E-5, 2.5399977896939232E-5, 2.5399977896939232E-5, 3.333333333333333E-4, 2.5399959187345577E-5, 0.001, 0.001, 0.001, 2.5399959187345577E-5, 0.001, 0.001, 0.001, 0.001, 4.7786982453241274E-11, 0.001, 0.001, 0.001, 1.0E-5, 0.001, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.5400050800101604E-5, 2.5400050800101604E-5, 2.5400050800101604E-5, 0.001, 0.001, 0.001, 0.001, 0.001, 3.333333333333333E-4, 0.001, 1.0E-5, 0.0, 1.0E-6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 0.9143917962000001, 35.999605016394, 0.9143917962000001, 0.9143917962000001, 0.9143917962000001, 0.9143917962000001, 35.999605016394, 35.999605016394, 35.999605016394, 0.9143917962000001, 1.0, 1.0936231100888785, 1.0936231100888785, 0.027777978834797806, 0.027777978834797806, 0.027777978834797806, 0.027777978834797806, 1.0936231100888785, 0.3645410366962928, 1.0936231100888785, 1.0936231100888785, 0.027778002823839455, 0.027778002823839455, 0.027778002823839455, 0.027778002823839455, 0.3645410366962928, 0.02777798236259545, 1.0936231100888785, 1.0936231100888785, 1.0936231100888785, 0.02777798236259545, 1.0936231100888785, 1.0936231100888785, 1.0936231100888785, 1.0936231100888785, 5.2260948372276384E-8, 1.0936231100888785, 1.0936231100888785, 1.0936231100888785, 0.010936231100888785, 1.0936231100888785, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.02777808255242262, 0.02777808255242262, 0.02777808255242262, 1.0936231100888785, 1.0936231100888785, 1.0936231100888785, 1.0936231100888785, 1.0936231100888785, 0.3645410366962928, 1.0936231100888785, 0.010936231100888785, 0.0, 0.0010936231100888785, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 20.1166195164, 791.9913103606679, 20.1166195164, 20.1166195164, 20.1166195164, 20.1166195164, 791.9913103606679, 791.9913103606679, 791.9913103606679, 20.1166195164, 20.1166195164, 1.0, 0.0497101413676763, 0.0012626354015817186, 0.0012626354015817186, 0.0012626354015817186, 0.0012626354015817186, 0.0497101413676763, 0.016570047122558766, 0.0497101413676763, 0.0497101413676763, 0.0012626364919927026, 0.0012626364919927026, 0.0012626364919927026, 0.0012626364919927026, 0.016570047122558766, 0.001262635561936157, 0.0497101413676763, 0.0497101413676763, 0.0497101413676763, 0.001262635561936157, 0.0497101413676763, 0.0497101413676763, 0.0497101413676763, 0.0497101413676763, 2.3754976532852905E-9, 0.0497101413676763, 0.0497101413676763, 0.0497101413676763, 4.97101413676763E-4, 0.0497101413676763, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0012626401160192103, 0.0012626401160192103, 0.0012626401160192103, 0.0497101413676763, 0.0497101413676763, 0.0497101413676763, 0.0497101413676763, 0.0497101413676763, 0.016570047122558766, 0.0497101413676763, 4.97101413676763E-4, 0.0, 4.97101413676763E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 0.201166195164, 7.919913103606679, 0.201166195164, 0.201166195164, 0.201166195164, 0.201166195164, 7.919913103606679, 7.919913103606679, 7.919913103606679, 0.201166195164, 0.201166195164, 0.201166195164, 1.0, 0.12626354015817184, 0.12626354015817184, 0.12626354015817184, 0.12626354015817184, 4.9710141367676295, 1.6570047122558764, 4.9710141367676295, 4.9710141367676295, 0.12626364919927024, 0.12626364919927024, 0.12626364919927024, 0.12626364919927024, 1.6570047122558764, 0.12626355619361568, 4.9710141367676295, 4.9710141367676295, 4.9710141367676295, 0.12626355619361568, 4.9710141367676295, 4.9710141367676295, 4.9710141367676295, 4.9710141367676295, 2.37549765328529E-7, 4.9710141367676295, 4.9710141367676295, 4.9710141367676295, 0.0497101413676763, 4.9710141367676295, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.12626401160192102, 0.12626401160192102, 0.12626401160192102, 4.9710141367676295, 4.9710141367676295, 4.9710141367676295, 4.9710141367676295, 4.9710141367676295, 1.6570047122558764, 4.9710141367676295, 0.0497101413676763, 0.0, 0.0049710141367676295, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {39.370147, 36.0, 1417.32, 36.0, 36.0, 36.0, 36.0, 1417.32, 1417.32, 1417.32, 36.0, 36.0, 36.0, 36.0, 1.0, 7.055543322654541E-4, 7.055543322654541E-4, 7.055543322654541E-4, 0.027777777777777776, 0.009259259259259259, 0.027777777777777776, 0.027777777777777776, 7.055549415816453E-4, 7.055549415816453E-4, 7.055549415816453E-4, 7.055549415816453E-4, 0.009259259259259259, 7.055544218707104E-4, 0.027777777777777776, 0.027777777777777776, 0.027777777777777776, 7.055544218707104E-4, 0.027777777777777776, 0.027777777777777776, 0.027777777777777776, 0.027777777777777776, 1.327416179256702E-9, 0.027777777777777776, 0.027777777777777776, 0.027777777777777776, 2.777777777777778E-4, 0.027777777777777776, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.055569666694889E-4, 7.055569666694889E-4, 7.055569666694889E-4, 0.027777777777777776, 0.027777777777777776, 0.027777777777777776, 0.027777777777777776, 0.027777777777777776, 0.009259259259259259, 0.027777777777777776, 2.777777777777778E-4, 0.0, 2.7777777777777776E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {39.370147, 12.0, 472.44, 12.0, 12.0, 12.0, 12.0, 472.44, 472.44, 472.44, 12.0, 12.0, 12.0, 12.0, 472.4417640000001, 1.0, 0.0021166629967963625, 0.0021166629967963625, 0.08333333333333333, 0.027777777777777776, 0.08333333333333333, 0.08333333333333333, 0.002116664824744936, 0.002116664824744936, 0.002116664824744936, 0.002116664824744936, 0.027777777777777776, 0.002116663265612131, 0.08333333333333333, 0.08333333333333333, 0.08333333333333333, 0.002116663265612131, 0.08333333333333333, 0.08333333333333333, 0.08333333333333333, 0.08333333333333333, 3.982248537770106E-9, 0.08333333333333333, 0.08333333333333333, 0.08333333333333333, 8.333333333333333E-4, 0.08333333333333333, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.002116670900008467, 0.002116670900008467, 0.002116670900008467, 0.08333333333333333, 0.08333333333333333, 0.08333333333333333, 0.08333333333333333, 0.08333333333333333, 0.027777777777777776, 0.08333333333333333, 8.333333333333333E-4, 0.0, 8.333333333333333E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {39.370147, 791.9999999999999, 31181.039999999994, 791.9999999999999, 791.9999999999999, 791.9999999999999, 791.9999999999999, 31181.039999999994, 31181.039999999994, 31181.039999999994, 791.9999999999999, 791.9999999999999, 791.9999999999999, 791.9999999999999, 31181.156424, 31181.156424, 1.0, 3.2070651466611555E-5, 0.0012626262626262627, 4.208754208754209E-4, 0.0012626262626262627, 0.0012626262626262627, 3.2070679162802064E-5, 3.2070679162802064E-5, 3.2070679162802064E-5, 3.2070679162802064E-5, 4.208754208754209E-4, 3.207065553957775E-5, 0.0012626262626262627, 0.0012626262626262627, 0.0012626262626262627, 3.207065553957775E-5, 0.0012626262626262627, 0.0012626262626262627, 0.0012626262626262627, 0.0012626262626262627, 6.033709905712283E-11, 0.0012626262626262627, 0.0012626262626262627, 0.0012626262626262627, 1.2626262626262628E-5, 0.0012626262626262627, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.20707712122495E-5, 3.20707712122495E-5, 3.20707712122495E-5, 0.0012626262626262627, 0.0012626262626262627, 0.0012626262626262627, 0.0012626262626262627, 0.0012626262626262627, 4.208754208754209E-4, 0.0012626262626262627, 1.2626262626262628E-5, 0.0, 1.2626262626262627E-6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {39.370147, 7.92, 311.81039999999996, 7.92, 7.92, 7.92, 7.92, 311.81039999999996, 311.81039999999996, 311.81039999999996, 7.92, 7.92, 7.92, 7.92, 311.81156424, 311.81156424, 311.81156424, 1.0, 0.12626262626262627, 0.04208754208754209, 0.12626262626262627, 0.12626262626262627, 0.0032070679162802063, 0.0032070679162802063, 0.0032070679162802063, 0.0032070679162802063, 0.04208754208754209, 0.003207065553957775, 0.12626262626262627, 0.12626262626262627, 0.12626262626262627, 0.003207065553957775, 0.12626262626262627, 0.12626262626262627, 0.12626262626262627, 0.12626262626262627, 6.0337099057122825E-9, 0.12626262626262627, 0.12626262626262627, 0.12626262626262627, 0.0012626262626262627, 0.12626262626262627, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0032070771212249502, 0.0032070771212249502, 0.0032070771212249502, 0.12626262626262627, 0.12626262626262627, 0.12626262626262627, 0.12626262626262627, 0.12626262626262627, 0.04208754208754209, 0.12626262626262627, 0.0012626262626262627, 0.0, 1.2626262626262626E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 0.9143992000000001, 35.999896504, 0.9143992000000001, 0.9143992000000001, 0.9143992000000001, 0.9143992000000001, 35.999896504, 35.999896504, 35.999896504, 0.9143992000000001, 0.9143992000000001, 0.9143992000000001, 0.9143992000000001, 36.000030920682406, 36.000030920682406, 36.000030920682406, 36.000030920682406, 1.0, 0.36453808504352725, 1.0936142551305819, 1.0936142551305819, 0.02777777790809444, 0.02777777790809444, 0.02777777790809444, 0.02777777790809444, 0.36453808504352725, 0.027777757447016112, 1.0936142551305819, 1.0936142551305819, 1.0936142551305819, 0.027777757447016112, 1.0936142551305819, 1.0936142551305819, 1.0936142551305819, 1.0936142551305819, 5.226052522053964E-8, 1.0936142551305819, 1.0936142551305819, 1.0936142551305819, 0.010936142551305818, 1.0936142551305819, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.027777857636032056, 0.027777857636032056, 0.027777857636032056, 1.0936142551305819, 1.0936142551305819, 1.0936142551305819, 1.0936142551305819, 1.0936142551305819, 0.36453808504352725, 1.0936142551305819, 0.010936142551305818, 0.0, 0.001093614255130582, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {3.0, 0.9143992000000001, 35.999896504, 0.9143992000000001, 0.9143992000000001, 0.9143992000000001, 0.9143992000000001, 35.999896504, 35.999896504, 35.999896504, 0.9143992000000001, 0.9143992000000001, 0.9143992000000001, 0.9143992000000001, 36.000030920682406, 36.000030920682406, 36.000030920682406, 36.000030920682406, 0.9143992000000001, 1.0, 1.0936142551305819, 1.0936142551305819, 0.02777777790809444, 0.02777777790809444, 0.02777777790809444, 0.02777777790809444, 0.36453808504352725, 0.027777757447016112, 1.0936142551305819, 1.0936142551305819, 1.0936142551305819, 0.027777757447016112, 1.0936142551305819, 1.0936142551305819, 1.0936142551305819, 1.0936142551305819, 5.226052522053964E-8, 1.0936142551305819, 1.0936142551305819, 1.0936142551305819, 0.010936142551305818, 1.0936142551305819, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.027777857636032056, 0.027777857636032056, 0.027777857636032056, 1.0936142551305819, 1.0936142551305819, 1.0936142551305819, 1.0936142551305819, 1.0936142551305819, 0.36453808504352725, 1.0936142551305819, 0.010936142551305818, 0.0, 0.001093614255130582, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 20.1167824, 791.9977230879999, 20.1167824, 20.1167824, 20.1167824, 20.1167824, 791.9977230879999, 791.9977230879999, 791.9977230879999, 20.1167824, 20.1167824, 20.1167824, 20.1167824, 792.000680255013, 792.000680255013, 792.000680255013, 792.000680255013, 20.1167824, 60.35034720000001, 1.0, 0.049709738869571904, 0.0012626262685497473, 0.0012626262685497473, 0.0012626262685497473, 0.0012626262685497473, 0.016569912956523967, 0.0012626253385007323, 0.049709738869571904, 0.049709738869571904, 0.049709738869571904, 0.0012626253385007323, 0.049709738869571904, 0.049709738869571904, 0.049709738869571904, 0.049709738869571904, 2.375478419115438E-9, 0.049709738869571904, 0.049709738869571904, 0.049709738869571904, 4.97097388695719E-4, 0.049709738869571904, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0012626298925469115, 0.0012626298925469115, 0.0012626298925469115, 0.049709738869571904, 0.049709738869571904, 0.049709738869571904, 0.049709738869571904, 0.049709738869571904, 0.016569912956523967, 0.049709738869571904, 4.97097388695719E-4, 0.0, 4.9709738869571905E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 0.20116782400000002, 7.91997723088, 0.20116782400000002, 0.20116782400000002, 0.20116782400000002, 0.20116782400000002, 7.91997723088, 7.91997723088, 7.91997723088, 0.20116782400000002, 0.20116782400000002, 0.20116782400000002, 0.20116782400000002, 7.92000680255013, 7.92000680255013, 7.92000680255013, 7.92000680255013, 0.20116782400000002, 0.6035034720000001, 0.20116782400000002, 1.0, 0.12626262685497472, 0.12626262685497472, 0.12626262685497472, 0.12626262685497472, 1.6569912956523967, 0.12626253385007324, 4.97097388695719, 4.97097388695719, 4.97097388695719, 0.12626253385007324, 4.97097388695719, 4.97097388695719, 4.97097388695719, 4.97097388695719, 2.375478419115438E-7, 4.97097388695719, 4.97097388695719, 4.97097388695719, 0.049709738869571904, 4.97097388695719, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.12626298925469115, 0.12626298925469115, 0.12626298925469115, 4.97097388695719, 4.97097388695719, 4.97097388695719, 4.97097388695719, 4.97097388695719, 1.6569912956523967, 4.97097388695719, 0.049709738869571904, 0.0, 0.00497097388695719, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {39.370113, 36.0, 1417.32, 36.0, 36.0, 36.0, 36.0, 1417.32, 1417.32, 1417.32, 36.0, 36.0, 36.0, 36.0, 1417.3252920000002, 1417.3252920000002, 1417.3252920000002, 1417.3252920000002, 36.0, 108.0, 36.0, 36.0, 1.0, 7.055549415816453E-4, 7.055549415816453E-4, 7.055549415816453E-4, 0.009259259259259259, 7.055544218707104E-4, 0.027777777777777776, 0.027777777777777776, 0.027777777777777776, 7.055544218707104E-4, 0.027777777777777776, 0.027777777777777776, 0.027777777777777776, 0.027777777777777776, 1.327416179256702E-9, 0.027777777777777776, 0.027777777777777776, 0.027777777777777776, 2.777777777777778E-4, 0.027777777777777776, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.055569666694889E-4, 7.055569666694889E-4, 7.055569666694889E-4, 0.027777777777777776, 0.027777777777777776, 0.027777777777777776, 0.027777777777777776, 0.027777777777777776, 0.009259259259259259, 0.027777777777777776, 2.777777777777778E-4, 0.0, 2.7777777777777776E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {39.370113, 12.0, 472.44, 12.0, 12.0, 12.0, 12.0, 472.44, 472.44, 472.44, 12.0, 12.0, 12.0, 12.0, 472.4417640000001, 472.4417640000001, 472.4417640000001, 472.4417640000001, 12.0, 36.0, 12.0, 12.0, 472.4413560000001, 1.0, 0.002116664824744936, 0.002116664824744936, 0.027777777777777776, 0.002116663265612131, 0.08333333333333333, 0.08333333333333333, 0.08333333333333333, 0.002116663265612131, 0.08333333333333333, 0.08333333333333333, 0.08333333333333333, 0.08333333333333333, 3.982248537770106E-9, 0.08333333333333333, 0.08333333333333333, 0.08333333333333333, 8.333333333333333E-4, 0.08333333333333333, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.002116670900008467, 0.002116670900008467, 0.002116670900008467, 0.08333333333333333, 0.08333333333333333, 0.08333333333333333, 0.08333333333333333, 0.08333333333333333, 0.027777777777777776, 0.08333333333333333, 8.333333333333333E-4, 0.0, 8.333333333333333E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {39.370113, 791.9999999999999, 31181.039999999994, 791.9999999999999, 791.9999999999999, 791.9999999999999, 791.9999999999999, 31181.039999999994, 31181.039999999994, 31181.039999999994, 791.9999999999999, 791.9999999999999, 791.9999999999999, 791.9999999999999, 31181.156424, 31181.156424, 31181.156424, 31181.156424, 791.9999999999999, 2376.0, 791.9999999999999, 791.9999999999999, 31181.129495999998, 31181.129495999998, 1.0, 3.2070679162802064E-5, 4.208754208754209E-4, 3.207065553957775E-5, 0.0012626262626262627, 0.0012626262626262627, 0.0012626262626262627, 3.207065553957775E-5, 0.0012626262626262627, 0.0012626262626262627, 0.0012626262626262627, 0.0012626262626262627, 6.033709905712283E-11, 0.0012626262626262627, 0.0012626262626262627, 0.0012626262626262627, 1.2626262626262628E-5, 0.0012626262626262627, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.20707712122495E-5, 3.20707712122495E-5, 3.20707712122495E-5, 0.0012626262626262627, 0.0012626262626262627, 0.0012626262626262627, 0.0012626262626262627, 0.0012626262626262627, 4.208754208754209E-4, 0.0012626262626262627, 1.2626262626262628E-5, 0.0, 1.2626262626262627E-6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {39.370113, 7.92, 311.81039999999996, 7.92, 7.92, 7.92, 7.92, 311.81039999999996, 311.81039999999996, 311.81039999999996, 7.92, 7.92, 7.92, 7.92, 311.81156424, 311.81156424, 311.81156424, 311.81156424, 7.92, 23.759999999999998, 7.92, 7.92, 311.81129496, 311.81129496, 311.81129496, 1.0, 0.04208754208754209, 0.003207065553957775, 0.12626262626262627, 0.12626262626262627, 0.12626262626262627, 0.003207065553957775, 0.12626262626262627, 0.12626262626262627, 0.12626262626262627, 0.12626262626262627, 6.0337099057122825E-9, 0.12626262626262627, 0.12626262626262627, 0.12626262626262627, 0.0012626262626262627, 0.12626262626262627, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0032070771212249502, 0.0032070771212249502, 0.0032070771212249502, 0.12626262626262627, 0.12626262626262627, 0.12626262626262627, 0.12626262626262627, 0.12626262626262627, 0.04208754208754209, 0.12626262626262627, 0.0012626262626262627, 0.0, 1.2626262626262626E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {3.0, 0.9144025, 36.000026424999994, 0.9144025, 0.9144025, 0.9144025, 0.9144025, 36.000026424999994, 36.000026424999994, 36.000026424999994, 0.9144025, 0.9144025, 0.9144025, 0.9144025, 36.00016084216751, 36.00016084216751, 36.00016084216751, 36.00016084216751, 0.9144025, 2.7432075, 0.9144025, 0.9144025, 36.00012975248251, 36.00012975248251, 36.00012975248251, 36.00012975248251, 1.0, 0.027777657199477883, 1.0936103083707667, 1.0936103083707667, 1.0936103083707667, 0.027777657199477883, 1.0936103083707667, 1.0936103083707667, 1.0936103083707667, 1.0936103083707667, 5.22603366167976E-8, 1.0936103083707667, 1.0936103083707667, 1.0936103083707667, 0.010936103083707667, 1.0936103083707667, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.027777757388132252, 0.027777757388132252, 0.027777757388132252, 1.0936103083707667, 1.0936103083707667, 1.0936103083707667, 1.0936103083707667, 1.0936103083707667, 0.3645367694569222, 1.0936103083707667, 0.010936103083707667, 0.0, 0.0010936103083707667, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {39.370142, 12.0, 472.44, 12.0, 12.0, 12.0, 12.0, 472.44, 472.44, 472.44, 12.0, 12.0, 12.0, 12.0, 472.4417640000001, 472.4417640000001, 472.4417640000001, 472.4417640000001, 12.0, 36.0, 12.0, 12.0, 472.4413560000001, 472.4413560000001, 472.4413560000001, 472.4413560000001, 36.0, 1.0, 0.08333333333333333, 0.08333333333333333, 0.08333333333333333, 0.002116663265612131, 0.08333333333333333, 0.08333333333333333, 0.08333333333333333, 0.08333333333333333, 3.982248537770106E-9, 0.08333333333333333, 0.08333333333333333, 0.08333333333333333, 8.333333333333333E-4, 0.08333333333333333, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.002116670900008467, 0.002116670900008467, 0.002116670900008467, 0.08333333333333333, 0.08333333333333333, 0.08333333333333333, 0.08333333333333333, 0.08333333333333333, 0.027777777777777776, 0.08333333333333333, 8.333333333333333E-4, 0.0, 8.333333333333333E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 0.30479841, 11.999913401699999, 0.30479841, 0.30479841, 0.30479841, 0.30479841, 11.999913401699999, 11.999913401699999, 11.999913401699999, 0.30479841, 0.30479841, 0.30479841, 0.30479841, 11.999958207066271, 11.999958207066271, 11.999958207066271, 11.999958207066271, 0.30479841, 0.9143952300000001, 0.30479841, 0.30479841, 11.999947843920332, 11.999947843920332, 11.999947843920332, 11.999947843920332, 0.9143952300000001, 11.99995668307422, 1.0, 3.2808570097199654, 3.2808570097199654, 0.08333363414640377, 3.2808570097199654, 3.2808570097199654, 3.2808570097199654, 3.2808570097199654, 1.5678225635508162E-7, 3.2808570097199654, 3.2808570097199654, 3.2808570097199654, 0.03280857009719965, 3.2808570097199654, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.08333393471475656, 0.08333393471475656, 0.08333393471475656, 3.2808570097199654, 3.2808570097199654, 3.2808570097199654, 3.2808570097199654, 3.2808570097199654, 1.0936190032399884, 3.2808570097199654, 0.03280857009719965, 0.0, 0.0032808570097199656, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 0.3047996, 11.999960251999997, 0.3047996, 0.3047996, 0.3047996, 0.3047996, 11.999960251999997, 11.999960251999997, 11.999960251999997, 0.3047996, 0.3047996, 0.3047996, 0.3047996, 12.000005057541202, 12.000005057541202, 12.000005057541202, 12.000005057541202, 0.3047996, 0.9143988000000001, 0.3047996, 0.3047996, 11.9999946943548, 11.9999946943548, 11.9999946943548, 11.9999946943548, 0.9143988000000001, 12.0000035335432, 0.3047996, 1.0, 3.2808442005829406, 0.08333330879484611, 3.2808442005829406, 3.2808442005829406, 3.2808442005829406, 3.2808442005829406, 1.5678164424507536E-7, 3.2808442005829406, 3.2808442005829406, 3.2808442005829406, 0.03280844200582941, 3.2808442005829406, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.08333360936202543, 0.08333360936202543, 0.08333360936202543, 3.2808442005829406, 3.2808442005829406, 3.2808442005829406, 3.2808442005829406, 3.2808442005829406, 1.0936147335276467, 3.2808442005829406, 0.03280844200582941, 0.0, 0.0032808442005829407, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 0.3047995, 11.999956314999999, 0.3047995, 0.3047995, 0.3047995, 0.3047995, 11.999956314999999, 11.999956314999999, 11.999956314999999, 0.3047995, 0.3047995, 0.3047995, 0.3047995, 12.000001120526502, 12.000001120526502, 12.000001120526502, 12.000001120526502, 0.3047995, 0.9143985, 0.3047995, 0.3047995, 11.9999907573435, 11.9999907573435, 11.9999907573435, 11.9999907573435, 0.9143985, 11.999999596529, 0.3047995, 0.3047995, 1.0, 0.08333333613521537, 3.2808452769771606, 3.2808452769771606, 3.2808452769771606, 3.2808452769771606, 1.5678169568270709E-7, 3.2808452769771606, 3.2808452769771606, 3.2808452769771606, 0.03280845276977161, 3.2808452769771606, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.08333363670249329, 0.08333363670249329, 0.08333363670249329, 3.2808452769771606, 3.2808452769771606, 3.2808452769771606, 3.2808452769771606, 3.2808452769771606, 1.0936150923257202, 3.2808452769771606, 0.03280845276977161, 0.0, 0.0032808452769771605, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {39.370142, 36.0, 1417.32, 36.0, 36.0, 36.0, 36.0, 1417.32, 1417.32, 1417.32, 36.0, 36.0, 36.0, 36.0, 1417.3252920000002, 1417.3252920000002, 1417.3252920000002, 1417.3252920000002, 36.0, 108.0, 36.0, 36.0, 1417.3240680000001, 1417.3240680000001, 1417.3240680000001, 1417.3240680000001, 108.0, 1417.3251120000002, 36.0, 36.0, 36.0, 1.0, 0.027777777777777776, 0.027777777777777776, 0.027777777777777776, 0.027777777777777776, 1.327416179256702E-9, 0.027777777777777776, 0.027777777777777776, 0.027777777777777776, 2.777777777777778E-4, 0.027777777777777776, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.055569666694889E-4, 7.055569666694889E-4, 7.055569666694889E-4, 0.027777777777777776, 0.027777777777777776, 0.027777777777777776, 0.027777777777777776, 0.027777777777777776, 0.009259259259259259, 0.027777777777777776, 2.777777777777778E-4, 0.0, 2.7777777777777776E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 0.9143952300000001, 35.9997402051, 0.9143952300000001, 0.9143952300000001, 0.9143952300000001, 0.9143952300000001, 35.9997402051, 35.9997402051, 35.9997402051, 0.9143952300000001, 0.9143952300000001, 0.9143952300000001, 0.9143952300000001, 35.99987462119882, 35.99987462119882, 35.99987462119882, 35.99987462119882, 0.9143952300000001, 2.7431856900000002, 0.9143952300000001, 0.9143952300000001, 35.999843531760995, 35.999843531760995, 35.999843531760995, 35.999843531760995, 2.7431856900000002, 35.999870049222665, 0.9143952300000001, 0.9143952300000001, 0.9143952300000001, 35.999870049222665, 1.0, 1.0936190032399884, 1.0936190032399884, 1.0936190032399884, 5.2260752118360534E-8, 1.0936190032399884, 1.0936190032399884, 1.0936190032399884, 0.010936190032399885, 1.0936190032399884, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.027777978238252184, 0.027777978238252184, 0.027777978238252184, 1.0936190032399884, 1.0936190032399884, 1.0936190032399884, 1.0936190032399884, 1.0936190032399884, 0.3645396677466628, 1.0936190032399884, 0.010936190032399885, 0.0, 0.0010936190032399885, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 0.9143987999999998, 35.99988075599999, 0.9143987999999998, 0.9143987999999998, 0.9143987999999998, 0.9143987999999998, 35.99988075599999, 35.99988075599999, 35.99988075599999, 0.9143987999999998, 0.9143987999999998, 0.9143987999999998, 0.9143987999999998, 36.0000151726236, 36.0000151726236, 36.0000151726236, 36.0000151726236, 0.9143987999999998, 2.7431964, 0.9143987999999998, 0.9143987999999998, 35.9999840830644, 35.9999840830644, 35.9999840830644, 35.9999840830644, 2.7431964, 36.0000106006296, 0.9143987999999998, 0.9143987999999998, 0.9143987999999998, 36.0000106006296, 0.9143987999999998, 1.0, 1.093614733527647, 1.093614733527647, 5.22605480816918E-8, 1.093614733527647, 1.093614733527647, 1.093614733527647, 0.01093614733527647, 1.093614733527647, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.02777786978734181, 0.02777786978734181, 0.02777786978734181, 1.093614733527647, 1.093614733527647, 1.093614733527647, 1.093614733527647, 1.093614733527647, 0.3645382445092156, 1.093614733527647, 0.01093614733527647, 0.0, 0.001093614733527647, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 0.9143985, 35.99986894499999, 0.9143985, 0.9143985, 0.9143985, 0.9143985, 35.99986894499999, 35.99986894499999, 35.99986894499999, 0.9143985, 0.9143985, 0.9143985, 0.9143985, 36.0000033615795, 36.0000033615795, 36.0000033615795, 36.0000033615795, 0.9143985, 2.7431955, 0.9143985, 0.9143985, 35.999972272030504, 35.999972272030504, 35.999972272030504, 35.999972272030504, 2.7431955, 35.999998789587, 0.9143985, 0.9143985, 0.9143985, 35.999998789587, 0.9143985, 0.9143985, 1.0, 1.0936150923257202, 5.2260565227569024E-8, 1.0936150923257202, 1.0936150923257202, 1.0936150923257202, 0.010936150923257202, 1.0936150923257202, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0277778789008311, 0.0277778789008311, 0.0277778789008311, 1.0936150923257202, 1.0936150923257202, 1.0936150923257202, 1.0936150923257202, 1.0936150923257202, 0.3645383641085734, 1.0936150923257202, 0.010936150923257202, 0.0, 0.0010936150923257202, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 1609.344, 63359.87328, 1609.344, 1609.344, 1609.344, 1609.344, 63359.87328, 63359.87328, 63359.87328, 1609.344, 1609.344, 1609.344, 1609.344, 63360.10985356802, 63360.10985356802, 63360.10985356802, 63360.10985356802, 1609.344, 4828.032000000001, 1609.344, 1609.344, 63360.05513587201, 63360.05513587201, 63360.05513587201, 63360.05513587201, 4828.032000000001, 63360.10180684801, 1609.344, 1609.344, 1609.344, 63360.10180684801, 1609.344, 1609.344, 1609.344, 1.0, 2.9693454260395087E-11, 6.213711922373339E-4, 6.213711922373339E-4, 6.213711922373339E-4, 6.213711922373339E-6, 6.213711922373339E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.578285984854798E-5, 1.578285984854798E-5, 1.578285984854798E-5, 6.213711922373339E-4, 6.213711922373339E-4, 6.213711922373339E-4, 6.213711922373339E-4, 6.213711922373339E-4, 2.0712373074577796E-4, 6.213711922373339E-4, 6.213711922373339E-6, 0.0, 6.21371192237334E-7, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {2.0926201E7, 6378300.0, 2.5111367099999994E8, 6378300.0, 6378300.0, 6378300.0, 6378300.0, 2.5111367099999994E8, 2.5111367099999994E8, 2.5111367099999994E8, 6378300.0, 6378300.0, 6378300.0, 6378300.0, 2.511146086101E8, 2.511146086101E8, 2.511146086101E8, 2.511146086101E8, 6378300.0, 1.91349E7, 6378300.0, 6378300.0, 2.5111439174789998E8, 2.5111439174789998E8, 2.5111439174789998E8, 2.5111439174789998E8, 1.91349E7, 2.511145767186E8, 6378300.0, 6378300.0, 6378300.0, 2.511145767186E8, 6378300.0, 6378300.0, 6378300.0, 6378300.0, 1.0, 1.5678158757035574E-7, 1.5678158757035574E-7, 1.5678158757035574E-7, 1.5678158757035574E-9, 1.5678158757035574E-7, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.982260288807614E-9, 3.982260288807614E-9, 3.982260288807614E-9, 1.5678158757035574E-7, 1.5678158757035574E-7, 1.5678158757035574E-7, 1.5678158757035574E-7, 1.5678158757035574E-7, 5.2260529190118576E-8, 1.5678158757035574E-7, 1.5678158757035574E-9, 0.0, 1.5678158757035573E-10, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 0.3048007491, 12.000005492066997, 0.3048007491, 0.3048007491, 0.3048007491, 0.3048007491, 12.000005492066997, 12.000005492066997, 12.000005492066997, 0.3048007491, 0.3048007491, 0.3048007491, 0.3048007491, 12.000050297777118, 12.000050297777118, 12.000050297777118, 12.000050297777118, 0.3048007491, 0.9144022473000001, 0.3048007491, 0.3048007491, 12.00003993455165, 12.00003993455165, 12.00003993455165, 12.00003993455165, 0.9144022473000001, 12.000048773773372, 0.3048007491, 0.3048007491, 0.3048007491, 12.000048773773372, 0.3048007491, 0.3048007491, 0.3048007491, 0.3048007491, 6378321.740617169, 1.0, 3.2808318317876473, 3.2808318317876473, 0.03280831831787647, 3.2808318317876473, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.08333329519399664, 0.08333329519399664, 0.08333329519399664, 3.2808318317876473, 3.2808318317876473, 3.2808318317876473, 3.2808318317876473, 3.2808318317876473, 1.0936106105958823, 3.2808318317876473, 0.03280831831787647, 0.0, 0.003280831831787647, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 0.9144, 35.999928, 0.9144, 0.9144, 0.9144, 0.9144, 35.999928, 35.999928, 35.999928, 0.9144, 0.9144, 0.9144, 0.9144, 36.000062416800006, 36.000062416800006, 36.000062416800006, 36.000062416800006, 0.9144, 2.7432, 0.9144, 0.9144, 36.000031327200006, 36.000031327200006, 36.000031327200006, 36.000031327200006, 2.7432, 36.0000578448, 0.9144, 0.9144, 0.9144, 36.0000578448, 0.9144, 0.9144, 0.9144, 0.9144, 1.91349181944E7, 0.9144, 1.0, 1.0936132983377078, 0.010936132983377079, 1.0936132983377078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.027777833333444447, 0.027777833333444447, 0.027777833333444447, 1.0936132983377078, 1.0936132983377078, 1.0936132983377078, 1.0936132983377078, 1.0936132983377078, 0.3645377661125693, 1.0936132983377078, 0.010936132983377079, 0.0, 0.0010936132983377078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 20.1168, 791.9984159999999, 20.1168, 20.1168, 20.1168, 20.1168, 791.9984159999999, 791.9984159999999, 791.9984159999999, 20.1168, 20.1168, 20.1168, 20.1168, 792.0013731696001, 792.0013731696001, 792.0013731696001, 792.0013731696001, 20.1168, 60.3504, 20.1168, 20.1168, 792.0006891984001, 792.0006891984001, 792.0006891984001, 792.0006891984001, 60.3504, 792.0012725856001, 20.1168, 20.1168, 20.1168, 792.0012725856001, 20.1168, 20.1168, 20.1168, 20.1168, 4.2096820027680004E8, 20.1168, 20.1168, 1.0, 4.970969537898671E-4, 0.049709695378986715, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0012626287878838385, 0.0012626287878838385, 0.0012626287878838385, 0.049709695378986715, 0.049709695378986715, 0.049709695378986715, 0.049709695378986715, 0.049709695378986715, 0.01656989845966224, 0.049709695378986715, 4.970969537898671E-4, 0.0, 4.9709695378986714E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {100.0, 20.1168, 791.9984159999999, 20.1168, 20.1168, 20.1168, 20.1168, 791.9984159999999, 791.9984159999999, 791.9984159999999, 20.1168, 20.1168, 20.1168, 20.1168, 792.0013731696001, 792.0013731696001, 792.0013731696001, 792.0013731696001, 20.1168, 60.3504, 20.1168, 20.1168, 792.0006891984001, 792.0006891984001, 792.0006891984001, 792.0006891984001, 60.3504, 792.0012725856001, 20.1168, 20.1168, 20.1168, 792.0012725856001, 20.1168, 20.1168, 20.1168, 20.1168, 4.2096820027680004E8, 20.1168, 20.1168, 20.1168, 1.0, 0.049709695378986715, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0012626287878838385, 0.0012626287878838385, 0.0012626287878838385, 0.049709695378986715, 0.049709695378986715, 0.049709695378986715, 0.049709695378986715, 0.049709695378986715, 0.01656989845966224, 0.049709695378986715, 4.970969537898671E-4, 0.0, 4.9709695378986714E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 0.9143980000000002, 35.99984926, 0.9143980000000002, 0.9143980000000002, 0.9143980000000002, 0.9143980000000002, 35.99984926, 35.99984926, 35.99984926, 0.9143980000000002, 0.9143980000000002, 0.9143980000000002, 0.9143980000000002, 35.999983676506005, 35.999983676506005, 35.999983676506005, 35.999983676506005, 0.9143980000000002, 2.743194000000001, 0.9143980000000002, 0.9143980000000002, 35.99995258697401, 35.99995258697401, 35.99995258697401, 35.99995258697401, 2.743194000000001, 35.99997910451601, 0.9143980000000002, 0.9143980000000002, 0.9143980000000002, 35.99997910451601, 0.9143980000000002, 0.9143980000000002, 0.9143980000000002, 0.9143980000000002, 1.9134876341998003E7, 0.9143980000000002, 0.9143980000000002, 0.9143980000000002, 91.4398, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.027777894089993198, 0.027777894089993198, 0.027777894089993198, 1.093615690323032, 1.093615690323032, 1.093615690323032, 1.093615690323032, 1.093615690323032, 0.36453856344101065, 1.093615690323032, 0.010936156903230321, 0.0, 0.001093615690323032, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.318309886183791, 0.318309886183791, 0.318309886183791, 0.318309886183791, 0.318309886183791, 0.0, 0.0, 1.0, 0.0, 0.0, 0.318309886183791, 0.318309886183791, 0.318309886183791, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.318309886183791, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 180.0, 1.0, 2.9473137609610278E-5, 4.912189601601713E-7, 0.001591549430918955, 0.001591549430918955, 0.0, 0.0, 3.18309886183791E-7, 0.0, 0.0, 1.591549430918955E-5, 1.591549430918955E-7, 9.947183943243469E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0017683882565766168, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10800.0, 565.4866776461622, 1.0, 4.912189601601713E-7, 0.001591549430918955, 0.001591549430918955, 0.0, 0.0, 3.18309886183791E-7, 0.0, 0.0, 1.591549430918955E-5, 1.591549430918955E-7, 9.947183943243469E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0017683882565766168, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 648000.0, 565.4866776461622, 33929.20065876973, 1.0, 0.001591549430918955, 0.001591549430918955, 0.0, 0.0, 3.18309886183791E-7, 0.0, 0.0, 1.591549430918955E-5, 1.591549430918955E-7, 9.947183943243469E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0017683882565766168, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 200.0, 565.4866776461622, 33929.20065876973, 2035752.0395261839, 1.0, 0.001591549430918955, 0.0, 0.0, 3.18309886183791E-7, 0.0, 0.0, 1.591549430918955E-5, 1.591549430918955E-7, 9.947183943243469E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0017683882565766168, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 200.0, 565.4866776461622, 33929.20065876973, 2035752.0395261839, 628.318530717958, 1.0, 0.0, 0.0, 3.18309886183791E-7, 0.0, 0.0, 1.591549430918955E-5, 1.591549430918955E-7, 9.947183943243469E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0017683882565766168, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1000000.0, 180.0, 10800.0, 648000.0, 200.0, 200.0, 0.0, 0.0, 1.0, 0.0, 0.0, 5.0E-5, 5.0E-7, 3.125E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.005555555555555556, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 20000.0, 565.4866776461622, 33929.20065876973, 2035752.0395261839, 628.318530717958, 628.318530717958, 0.0, 0.0, 3141592.6535897898, 0.0, 0.0, 1.0, 1.591549430918955E-7, 9.947183943243469E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0017683882565766168, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2000000.0, 565.4866776461622, 33929.20065876973, 2035752.0395261839, 628.318530717958, 628.318530717958, 0.0, 0.0, 3141592.6535897898, 0.0, 0.0, 62831.8530717958, 1.0, 9.947183943243469E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0017683882565766168, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3200.0, 565.4866776461622, 33929.20065876973, 2035752.0395261839, 628.318530717958, 628.318530717958, 0.0, 0.0, 3141592.6535897898, 0.0, 0.0, 62831.8530717958, 6283185.3071795795, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0017683882565766168, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 180.0, 565.4866776461622, 33929.20065876973, 2035752.0395261839, 628.318530717958, 628.318530717958, 0.0, 0.0, 3141592.6535897898, 0.0, 0.0, 62831.8530717958, 6283185.3071795795, 10053.096491487328, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1000000.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1000000.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {39.37, 3960.0, 155905.19999999998, 3960.0, 3960.0, 3960.0, 3960.0, 155905.19999999998, 155905.19999999998, 155905.19999999998, 3960.0, 3960.0, 3960.0, 3960.0, 155905.78212000002, 155905.78212000002, 155905.78212000002, 155905.78212000002, 3960.0, 11880.000000000002, 3960.0, 3960.0, 155905.64748, 155905.64748, 155905.64748, 155905.64748, 11880.000000000002, 155905.76232, 3960.0, 3960.0, 3960.0, 155905.76232, 3960.0, 3960.0, 3960.0, 3960.0, 8.286775596E10, 3960.0, 3960.0, 3960.0, 396000.0, 3960.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 6.4141542424499E-6, 6.4141542424499E-6, 2.525252525252525E-4, 2.525252525252525E-4, 2.525252525252525E-4, 2.525252525252525E-4, 2.525252525252525E-4, 8.417508417508417E-5, 2.525252525252525E-4, 2.5252525252525253E-6, 0.0, 2.525252525252525E-7, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {39.37, 1980.0, 77952.59999999999, 1980.0, 1980.0, 1980.0, 1980.0, 77952.59999999999, 77952.59999999999, 77952.59999999999, 1980.0, 1980.0, 1980.0, 1980.0, 77952.89106000001, 77952.89106000001, 77952.89106000001, 77952.89106000001, 1980.0, 5940.000000000001, 1980.0, 1980.0, 77952.82374, 77952.82374, 77952.82374, 77952.82374, 5940.000000000001, 77952.88116, 1980.0, 1980.0, 1980.0, 77952.88116, 1980.0, 1980.0, 1980.0, 1980.0, 4.143387798E10, 1980.0, 1980.0, 1980.0, 198000.0, 1980.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 77952.59999999999, 1.0, 1.28283084848998E-5, 5.05050505050505E-4, 5.05050505050505E-4, 5.05050505050505E-4, 5.05050505050505E-4, 5.05050505050505E-4, 1.6835016835016833E-4, 5.05050505050505E-4, 5.050505050505051E-6, 0.0, 5.05050505050505E-7, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {39.37, 990.0, 38976.299999999996, 990.0, 990.0, 990.0, 990.0, 38976.299999999996, 38976.299999999996, 38976.299999999996, 990.0, 990.0, 990.0, 990.0, 38976.445530000005, 38976.445530000005, 38976.445530000005, 38976.445530000005, 990.0, 2970.0000000000005, 990.0, 990.0, 38976.41187, 38976.41187, 38976.41187, 38976.41187, 2970.0000000000005, 38976.44058, 990.0, 990.0, 990.0, 38976.44058, 990.0, 990.0, 990.0, 990.0, 2.071693899E10, 990.0, 990.0, 990.0, 99000.0, 990.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 38976.299999999996, 38976.299999999996, 1.0, 0.00101010101010101, 0.00101010101010101, 0.00101010101010101, 0.00101010101010101, 0.00101010101010101, 3.3670033670033666E-4, 0.00101010101010101, 1.0101010101010101E-5, 0.0, 1.01010101010101E-6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 37.5, 1476.3749999999995, 37.5, 37.5, 37.5, 37.5, 1476.3749999999995, 1476.3749999999995, 1476.3749999999995, 37.5, 37.5, 37.5, 37.5, 1476.3805125000001, 1476.3805125000001, 1476.3805125000001, 1476.3805125000001, 37.5, 112.5, 37.5, 37.5, 1476.3792375, 1476.3792375, 1476.3792375, 1476.3792375, 112.5, 1476.3803249999999, 37.5, 37.5, 37.5, 1476.3803249999999, 37.5, 37.5, 37.5, 37.5, 7.847325375E8, 37.5, 37.5, 37.5, 3750.0, 37.5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1476.3749999999995, 1476.3749999999995, 1476.3749999999995, 1.0, 0.02666666666666667, 0.02666666666666667, 0.02666666666666667, 0.02666666666666667, 0.008888888888888889, 0.02666666666666667, 2.666666666666667E-4, 0.0, 2.666666666666667E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 25.0, 984.2499999999999, 25.0, 25.0, 25.0, 25.0, 984.2499999999999, 984.2499999999999, 984.2499999999999, 25.0, 25.0, 25.0, 25.0, 984.2536750000002, 984.2536750000002, 984.2536750000002, 984.2536750000002, 25.0, 75.0, 25.0, 25.0, 984.252825, 984.252825, 984.252825, 984.252825, 75.0, 984.25355, 25.0, 25.0, 25.0, 984.25355, 25.0, 25.0, 25.0, 25.0, 5.23155025E8, 25.0, 25.0, 25.0, 2500.0, 25.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 984.2499999999999, 984.2499999999999, 984.2499999999999, 25.0, 1.0, 0.04, 0.04, 0.04, 0.013333333333333332, 0.04, 4.0E-4, 0.0, 4.0E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 12.5, 492.12499999999994, 12.5, 12.5, 12.5, 12.5, 492.12499999999994, 492.12499999999994, 492.12499999999994, 12.5, 12.5, 12.5, 12.5, 492.1268375000001, 492.1268375000001, 492.1268375000001, 492.1268375000001, 12.5, 37.5, 12.5, 12.5, 492.1264125, 492.1264125, 492.1264125, 492.1264125, 37.5, 492.126775, 12.5, 12.5, 12.5, 492.126775, 12.5, 12.5, 12.5, 12.5, 2.615775125E8, 12.5, 12.5, 12.5, 1250.0, 12.5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 492.12499999999994, 492.12499999999994, 492.12499999999994, 12.5, 12.5, 1.0, 0.08, 0.08, 0.026666666666666665, 0.08, 8.0E-4, 0.0, 8.0E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 6.25, 246.06249999999997, 6.25, 6.25, 6.25, 6.25, 246.06249999999997, 246.06249999999997, 246.06249999999997, 6.25, 6.25, 6.25, 6.25, 246.06341875000004, 246.06341875000004, 246.06341875000004, 246.06341875000004, 6.25, 18.75, 6.25, 6.25, 246.06320625, 246.06320625, 246.06320625, 246.06320625, 18.75, 246.0633875, 6.25, 6.25, 6.25, 246.0633875, 6.25, 6.25, 6.25, 6.25, 1.3078875625E8, 6.25, 6.25, 6.25, 625.0, 6.25, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 246.06249999999997, 246.06249999999997, 246.06249999999997, 6.25, 6.25, 6.25, 1.0, 0.16, 0.05333333333333333, 0.16, 0.0016, 0.0, 1.6E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 3.125, 123.03124999999999, 3.125, 3.125, 3.125, 3.125, 123.03124999999999, 123.03124999999999, 123.03124999999999, 3.125, 3.125, 3.125, 3.125, 123.03170937500002, 123.03170937500002, 123.03170937500002, 123.03170937500002, 3.125, 9.375, 3.125, 3.125, 123.031603125, 123.031603125, 123.031603125, 123.031603125, 9.375, 123.03169375, 3.125, 3.125, 3.125, 123.03169375, 3.125, 3.125, 3.125, 3.125, 6.5394378125E7, 3.125, 3.125, 3.125, 312.5, 3.125, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 123.03124999999999, 123.03124999999999, 123.03124999999999, 3.125, 3.125, 3.125, 3.125, 1.0, 0.10666666666666666, 0.32, 0.0032, 0.0, 3.2E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {3.0, 0.9143980000000002, 35.99984926, 0.9143980000000002, 0.9143980000000002, 0.9143980000000002, 0.9143980000000002, 35.99984926, 35.99984926, 35.99984926, 0.9143980000000002, 0.9143980000000002, 0.9143980000000002, 0.9143980000000002, 35.999983676506005, 35.999983676506005, 35.999983676506005, 35.999983676506005, 0.9143980000000002, 2.743194000000001, 0.9143980000000002, 0.9143980000000002, 35.99995258697401, 35.99995258697401, 35.99995258697401, 35.99995258697401, 2.743194000000001, 35.99997910451601, 0.9143980000000002, 0.9143980000000002, 0.9143980000000002, 35.99997910451601, 0.9143980000000002, 0.9143980000000002, 0.9143980000000002, 0.9143980000000002, 1.9134876341998003E7, 0.9143980000000002, 0.9143980000000002, 0.9143980000000002, 91.4398, 0.9143980000000002, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 35.99984926, 35.99984926, 35.99984926, 0.9143980000000002, 0.9143980000000002, 0.9143980000000002, 0.9143980000000002, 0.9143980000000002, 1.0, 1.093615690323032, 0.010936156903230321, 0.0, 0.001093615690323032, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 20.116756, 791.9966837199999, 20.116756, 20.116756, 20.116756, 20.116756, 791.9966837199999, 791.9966837199999, 791.9966837199999, 20.116756, 20.116756, 20.116756, 20.116756, 791.999640883132, 791.999640883132, 791.999640883132, 791.999640883132, 20.116756, 60.350268, 20.116756, 20.116756, 791.998956913428, 791.998956913428, 791.998956913428, 791.998956913428, 60.350268, 791.999540299352, 20.116756, 20.116756, 20.116756, 791.999540299352, 20.116756, 20.116756, 20.116756, 20.116756, 4.2096727952395594E8, 20.116756, 20.116756, 20.116756, 2011.6755999999996, 20.116756, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 791.9966837199999, 791.9966837199999, 791.9966837199999, 20.116756, 20.116756, 20.116756, 20.116756, 20.116756, 60.350268, 1.0, 4.970980410559238E-4, 0.0, 4.970980410559238E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {100.0, 20.116756, 791.9966837199999, 20.116756, 20.116756, 20.116756, 20.116756, 791.9966837199999, 791.9966837199999, 791.9966837199999, 20.116756, 20.116756, 20.116756, 20.116756, 791.999640883132, 791.999640883132, 791.999640883132, 791.999640883132, 20.116756, 60.350268, 20.116756, 20.116756, 791.998956913428, 791.998956913428, 791.998956913428, 791.998956913428, 60.350268, 791.999540299352, 20.116756, 20.116756, 20.116756, 791.999540299352, 20.116756, 20.116756, 20.116756, 20.116756, 4.2096727952395594E8, 20.116756, 20.116756, 20.116756, 2011.6755999999996, 20.116756, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 791.9966837199999, 791.9966837199999, 791.9966837199999, 20.116756, 20.116756, 20.116756, 20.116756, 20.116756, 60.350268, 20.116756, 1.0, 0.0, 4.970980410559238E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1000.0, 1.0, 39.37, 1.0, 1.0, 1.0, 1.0, 39.37, 39.37, 39.37, 1.0, 1.0, 1.0, 1.0, 39.370147, 39.370147, 39.370147, 39.370147, 1.0, 3.0, 1.0, 1.0, 39.370113, 39.370113, 39.370113, 39.370113, 3.0, 39.370142, 1.0, 1.0, 1.0, 39.370142, 1.0, 1.0, 1.0, 1.0, 2.0926201E7, 1.0, 1.0, 1.0, 100.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 39.37, 39.37, 39.37, 1.0, 1.0, 1.0, 1.0, 1.0, 3.0, 1.0, 100.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.001, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.016666666666666666, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.016666666666666666}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0}};
    }

    static {
        populate = true;
        lookupMap = new HashMap();
        conversionMatrixA = null;
        conversionMatrixB = null;
    }
}

