/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.parser.autogen;

import com.metsci.glimpse.charts.vector.parser.ENCAttributeInterpreter;
import com.metsci.glimpse.charts.vector.parser.ENCObjectInterpreter;
import com.metsci.glimpse.charts.vector.parser.ENCUnitInterpreter;
import com.metsci.glimpse.charts.vector.parser.attributes.ENCAttributeClass;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ENCLibraryMaker {
    public static String location = "/path/to/location";
    public static String encPackageLocation = "com.metsci.glimpse.charts.vector.parser";
    public static String packageName = "com.metsci.glimpse.charts.vector.parser.autogen";
    public static String instanceLocation = "/path/to/instanceLocation";
    public static String instancePackageName = "com.metsci.glimpse.charts.vector.parser.autogen.instance";
    public static String accessLocation = "/path/to/accessLocation";
    public static String accessPackageName = "com.metsci.glimpse.charts.vector.parser.autogen.access";
    public static String abstractObjectInstance = "obj";
    public static String abstractObjectName = "ENCAbstractObject";
    public static String abstractAttributeName = "ENCAbstractAttribute";

    public static void generateENCLibrary(ENCObjectInterpreter objInterp, ENCAttributeInterpreter attributeInterp, ENCUnitInterpreter uInterp) throws IOException {
        BufferedWriter _fout = null;
        Iterator<Integer> _iterator = null;
        File _mainLocation = new File(location);
        File _instanceLocation = new File(instanceLocation);
        File _accessLocation = new File(accessLocation);
        _mainLocation.mkdirs();
        _instanceLocation.mkdirs();
        _accessLocation.mkdirs();
        _iterator = objInterp.getObjectHeaders().keySet().iterator();
        while (_iterator.hasNext()) {
            ENCLibraryMaker.generateObject(objInterp.getHeader_byCode(_iterator.next()), attributeInterp);
        }
        _iterator = attributeInterp.getAttributeHeaders().keySet().iterator();
        while (_iterator.hasNext()) {
            ENCLibraryMaker.generateEnumeratedAttribute(attributeInterp.getHeader_byCode(_iterator.next()));
        }
        _fout = new BufferedWriter(new FileWriter(location + "/ENCObjectType.java"));
        _fout.write("package " + packageName + ";\n\n");
        _fout.write("import java.util.HashMap;\n");
        _fout.write("import java.io.DataInputStream;\n");
        _fout.write("import java.io.DataOutputStream;\n");
        _fout.write("import java.io.IOException;\n");
        ENCLibraryMaker.generateObjectList(_fout, objInterp);
        _fout.close();
        _fout = new BufferedWriter(new FileWriter(location + "/ENCAttributeType.java"));
        _fout.write("package " + packageName + ";\n\n");
        _fout.write("import java.util.HashMap;\n");
        _fout.write("import java.io.DataInputStream;\n");
        _fout.write("import java.io.DataOutputStream;\n");
        _fout.write("import java.io.IOException;\n");
        _fout.write("import " + encPackageLocation + ".*;\n\n");
        ENCLibraryMaker.generateAttributeList(_fout, attributeInterp);
        _fout.close();
        _fout = new BufferedWriter(new FileWriter(location + "/ENCAttributeValues.java"));
        _fout.write("package " + packageName + ";\n\n");
        _fout.write("import java.util.HashMap;\n");
        _fout.write("import java.io.DataInputStream;\n");
        _fout.write("import java.io.DataOutputStream;\n");
        _fout.write("import java.io.IOException;\n");
        _fout.write("import " + encPackageLocation + ".*;\n\n");
        ENCLibraryMaker.generateUniversalAttribute(_fout, attributeInterp);
        _fout.close();
        _fout = new BufferedWriter(new FileWriter(location + "/ENCUnit.java"));
        _fout.write("package " + packageName + ";\n\n");
        _fout.write("import java.util.HashMap;\n");
        _fout.write("import java.io.DataInputStream;\n");
        _fout.write("import java.io.DataOutputStream;\n");
        _fout.write("import java.io.IOException;\n");
        ENCLibraryMaker.generateUniversalUnit(_fout, uInterp);
        _fout.close();
        _iterator = objInterp.getObjectHeaders().keySet().iterator();
        while (_iterator.hasNext()) {
            ENCObjectInterpreter.ENCObjectHeader _currentHeader = objInterp.getHeader_byCode(_iterator.next());
            String _className = ENCLibraryMaker.formatString(_currentHeader.objectClass, StringFormatType.OBJECTNAME);
            String _subClassName = ENCLibraryMaker.formatString(_currentHeader.objectSubclass, StringFormatType.OBJECTNAME);
            if (_subClassName != null && _subClassName.length() > 0) {
                _className = _className + "_" + _subClassName;
            }
            _fout = new BufferedWriter(new FileWriter(accessLocation + "/" + _className + ".java"));
            _fout.write("package " + accessPackageName + ";\n\n");
            _fout.write("import java.util.HashMap;\n");
            _fout.write("import " + packageName + ".*;\n");
            _fout.write("import " + encPackageLocation + ".*;\n\n");
            ENCLibraryMaker.generateObjectAttributes(_fout, _currentHeader, attributeInterp);
            _fout.close();
        }
    }

    private static void generateObject(ENCObjectInterpreter.ENCObjectHeader header, ENCAttributeInterpreter attributeInterp) throws IOException {
        int i;
        String _className = ENCLibraryMaker.formatString(header.objectClass, StringFormatType.OBJECTNAME);
        String _subClassName = ENCLibraryMaker.formatString(header.objectSubclass, StringFormatType.OBJECTNAME);
        ArrayList<String> _attributeClassNames = new ArrayList<String>();
        ArrayList<String> _attributeInstanceNames = new ArrayList<String>();
        ArrayList<ValuationType> _attributeValutationList = new ArrayList<ValuationType>();
        if (_subClassName != null && _subClassName.length() > 0) {
            _className = _className + "_" + _subClassName;
        }
        for (String _currentAttributeName : header.objectAttributes) {
            ENCAttributeInterpreter.ENCAttributeHeader _aHeader = attributeInterp.getHeader_byAcronym(_currentAttributeName);
            switch (_aHeader.attributeClass) {
                case Enumerated: {
                    _attributeClassNames.add(ENCLibraryMaker.formatString(_aHeader.attributeName, StringFormatType.OBJECTNAME));
                    _attributeValutationList.add(ValuationType.SingleParam);
                    break;
                }
                case Free: {
                    _attributeClassNames.add("String");
                    _attributeValutationList.add(ValuationType.SingleParam);
                    break;
                }
                case Float: {
                    _attributeClassNames.add("float");
                    _attributeValutationList.add(ValuationType.SingleParam);
                    break;
                }
                case Integer: {
                    _attributeClassNames.add("int");
                    _attributeValutationList.add(ValuationType.SingleParam);
                    break;
                }
                case List: {
                    _attributeClassNames.add(ENCLibraryMaker.formatString(_aHeader.attributeName, StringFormatType.OBJECTNAME));
                    _attributeValutationList.add(ValuationType.ListParam);
                    break;
                }
                case Coded: {
                    _attributeClassNames.add("String");
                    _attributeValutationList.add(ValuationType.SingleParam);
                }
            }
            _attributeInstanceNames.add(ENCLibraryMaker.formatString(_aHeader.attributeName, StringFormatType.INSTANCE));
        }
        BufferedWriter _fout = new BufferedWriter(new FileWriter(location + "/" + _className + ".java"));
        _fout.write("package " + packageName + ";\n\n");
        _fout.write("import " + encPackageLocation + ";\n\n");
        _fout.write("public class" + _className + " { \n\n");
        _fout.write("\t public " + _className + "(" + abstractObjectName + abstractObjectInstance + ")\n");
        int n = _attributeClassNames.size();
        for (i = 0; i < n; ++i) {
            _fout.write("\t\t // Evaluate: " + (String)_attributeClassNames.get(i) + " \n");
            _fout.write(ENCLibraryMaker.abstractEvaluation(attributeInterp.getHeader_byAcronym(header.objectAttributes.get(i)), (String)_attributeClassNames.get(i), (String)_attributeInstanceNames.get(i)));
        }
        _fout.write("\t }\n\n");
        _fout.write("\n\n\n\n\t // Attributes\n\n");
        n = _attributeClassNames.size();
        for (i = 0; i < n; ++i) {
            if (_attributeValutationList.get(i) == ValuationType.ListParam) {
                _fout.write("\t public final " + (String)_attributeClassNames.get(i) + "[]\t\t" + (String)_attributeInstanceNames.get(i) + "\n");
                continue;
            }
            _fout.write("\t public final" + (String)_attributeClassNames.get(i) + "\t\t" + (String)_attributeInstanceNames.get(i) + "\n");
        }
        _fout.write("\n }");
        _fout.close();
    }

    private static String abstractEvaluation(ENCAttributeInterpreter.ENCAttributeHeader header, String className, String instanceName) {
        String _retVal = "";
        _retVal = _retVal + "// Evaluate only if the value will not be null\n";
        _retVal = _retVal + "\t\t if(!" + abstractObjectInstance + ".attributeMap.get(\"" + header.attributeAcronym + "\").value.equals(\"(null)\")){\n";
        switch (header.attributeClass) {
            case Enumerated: {
                _retVal = _retVal + "\t\t\t " + instanceName + " = ";
                _retVal = _retVal + className + ".getInstance(";
                _retVal = _retVal + "Integer.valueOf(" + abstractObjectInstance + ".attributeMap.get(\"" + header.attributeAcronym + "\").value));\n";
                break;
            }
            case Free: {
                _retVal = _retVal + "\t\t\t " + instanceName + " = ";
                _retVal = _retVal + abstractObjectInstance + ".attributeMap.get(\"" + header.attributeAcronym + "\").value;\n";
                break;
            }
            case Float: {
                _retVal = _retVal + "\t\t\t " + instanceName + " = ";
                _retVal = _retVal + "Float.valueOf(" + abstractObjectInstance + ".attributeMap.get(\"" + header.attributeAcronym + "\").value);\n";
                break;
            }
            case Integer: {
                _retVal = _retVal + "\t\t\t " + instanceName + " = ";
                _retVal = _retVal + "Integer.valueOf(" + abstractObjectInstance + ".attributeMap.get(\"" + header.attributeAcronym + "\").value);\n";
                break;
            }
            case List: {
                _retVal = _retVal + "\t\t\t String[] _temp = " + abstractObjectInstance + ".attributeMap.get(\"" + header.attributeAcronym + "\").value.split(\",\");\n";
                _retVal = _retVal + "\t\t\t " + instanceName + "= new " + className + "[_temp.length]";
                _retVal = _retVal + "\t\t\t for(int i = 0, n = _temp.length; i < n; i++){";
                _retVal = _retVal + "\t\t\t\t " + instanceName + "[i] = " + className + ".getInstance(" + "Integer.valueOf(" + abstractObjectInstance + ".attributeMap.get(\"" + header.attributeAcronym + "\").value));\n";
                _retVal = _retVal + "\t\t\t }";
                break;
            }
        }
        _retVal = _retVal + "\t\t }\n\n";
        return _retVal;
    }

    private static void generateEnumeratedAttribute(ENCAttributeInterpreter.ENCAttributeHeader header) throws IOException {
        if (header.attributeClass != ENCAttributeClass.Enumerated && header.attributeClass != ENCAttributeClass.List) {
            return;
        }
        if (header.valueTable == null) {
            System.out.println("Attribute: " + header.attributeAcronym + "[" + String.valueOf(header.attributeCode) + "] has no lookup table.");
            return;
        }
        String _attributeClassName = ENCLibraryMaker.formatString(header.attributeName, StringFormatType.OBJECTNAME);
        BufferedWriter _fout = new BufferedWriter(new FileWriter(location + "/" + _attributeClassName + ".java"));
        _fout.write("package " + packageName + "\n\n");
        _fout.write("// Autogenerated ENC Enumerated Attribute File \n");
        _fout.write("public enum " + _attributeClassName + " { \n\n");
        Iterator<Integer> _iterator = header.valueTable.keySet().iterator();
        boolean _hasStarted = true;
        while (_iterator.hasNext()) {
            int _currentValueID = _iterator.next();
            String _value = header.valueTable.get(_currentValueID);
            _value = ENCLibraryMaker.formatString(_value, StringFormatType.OBJECTNAME);
            if (!_hasStarted) {
                _fout.write(",\n");
            } else {
                _hasStarted = false;
            }
            _fout.write("\t" + _value + "\t (" + String.valueOf(_currentValueID) + ")");
        }
        _fout.write(";\n\n");
        _fout.write("\t private int id;\n\n");
        _fout.write("\t" + _attributeClassName + "(int value){this.id = int;} \n");
        _fout.write("\t public int getID(){return id;}\n");
        _fout.write("\t public static" + _attributeClassName + " getInstance(int val) throws Exception{ \n");
        _fout.write("\t \t for(" + _attributeClassName + " p : " + _attributeClassName + ".values()){\n");
        _fout.write("\t \t \t if(p.getID() == val){return p;}}\n");
        _fout.write("\t throw new Exception(\"Invalid input code: \" + String.valueOf(value));}");
        _fout.write("}\n");
        _fout.close();
    }

    private static void generateObjectList(BufferedWriter fout, ENCObjectInterpreter objInterp) throws IOException {
        fout.write("public enum ENCObjectType{\n");
        Iterator<Integer> _iterator = objInterp.getObjectHeaders().keySet().iterator();
        while (_iterator.hasNext()) {
            int _currentCode = _iterator.next();
            ENCObjectInterpreter.ENCObjectHeader _currentHeader = objInterp.getHeader_byCode(_currentCode);
            String _className = ENCLibraryMaker.formatString(_currentHeader.objectClass, StringFormatType.OBJECTNAME);
            String _subClassName = ENCLibraryMaker.formatString(_currentHeader.objectSubclass, StringFormatType.OBJECTNAME);
            if (_subClassName != null && _subClassName.length() > 0) {
                _className = _className + "_" + _subClassName;
            }
            fout.write("\t " + _className + " (" + String.valueOf(_currentHeader.objectCode) + ")");
            if (_iterator.hasNext()) {
                fout.write(",\n");
                continue;
            }
            fout.write(";\n\n");
        }
        fout.write("\t public final int code;\n");
        fout.write("\t private static boolean populate = true;\n");
        fout.write("\t private static HashMap<Integer, ENCObjectType> lookupMap = new HashMap<Integer, ENCObjectType>();\n\n");
        fout.write("\t ENCObjectType(int c){\n");
        fout.write("\t\t code = c;\n");
        fout.write("\t }\n\n");
        fout.write("\t public static ENCObjectType getInstance(int c){\n");
        fout.write("\t\t if(populate){\n");
        fout.write("\t\t\t for(ENCObjectType p : ENCObjectType.values())\n");
        fout.write("\t\t\t\t lookupMap.put(p.code, p);\n");
        fout.write("\t\t\t populate = false;\n");
        fout.write("\t\t }\n");
        fout.write("\t\t return lookupMap.get(c);\n");
        fout.write("\t }\n\n");
        fout.write("\t public static void write(DataOutputStream fout, ENCObjectType obj) throws IOException{\n");
        fout.write("\t\t fout.writeInt(obj.code);\n");
        fout.write("\t }\n\n");
        fout.write("\t public static ENCObjectType read(DataInputStream fin) throws IOException{\n");
        fout.write("\t\t return getInstance(fin.readInt());\n");
        fout.write("\t }\n\n");
        fout.write("}\n\n");
    }

    private static void generateAttributeList(BufferedWriter fout, ENCAttributeInterpreter attribInterp) throws IOException {
        fout.write("public enum ENCAttributeType{\n");
        Iterator<Integer> _iterator = attribInterp.getAttributeHeaders().keySet().iterator();
        while (_iterator.hasNext()) {
            int _currentCode = _iterator.next();
            ENCAttributeInterpreter.ENCAttributeHeader _currentHeader = attribInterp.getHeader_byCode(_currentCode);
            String _attributeName = ENCLibraryMaker.formatString(_currentHeader.attributeName, StringFormatType.OBJECTNAME);
            fout.write("\t " + _attributeName + " (" + String.valueOf(_currentHeader.attributeCode) + ")");
            if (_iterator.hasNext()) {
                fout.write(",\n");
                continue;
            }
            fout.write(";\n\n");
        }
        fout.write("\t private int code;\n");
        fout.write("\t private static boolean populate = true;\n");
        fout.write("\t private static HashMap<Integer, ENCAttributeType> lookupMap = new HashMap<Integer, ENCAttributeType>();\n\n");
        fout.write("\t ENCAttributeType(int c){\n");
        fout.write("\t\t code = c;\n");
        fout.write("\t }\n\n");
        fout.write("\t public static ENCAttributeType getInstance(int c){\n");
        fout.write("\t\t if(populate){\n");
        fout.write("\t\t\t for(ENCAttributeType p : ENCAttributeType.values())\n");
        fout.write("\t\t\t\t lookupMap.put(p.code, p);\n");
        fout.write("\t\t\t populate = false;\n");
        fout.write("\t\t }\n");
        fout.write("\t\t return lookupMap.get(c);\n");
        fout.write("\t }\n\n");
        fout.write("\t public static ENCAttributeType read(DataInputStream fin) throws IOException{\n");
        fout.write("\t\t return getInstance(fin.readInt());\n");
        fout.write("\t }\n\n");
        fout.write("\t public static void write(DataOutputStream fout, ENCAttributeType attrib) throws IOException{\n");
        fout.write("\t\t fout.writeInt(attrib.code);\n");
        fout.write("\t }\n\n");
        fout.write("}\n\n");
    }

    private static void generateUniversalAttribute(BufferedWriter fout, ENCAttributeInterpreter attribInterp) throws IOException {
        fout.write("public enum ENCAttributeValues{\n");
        Iterator<Integer> _iterator = attribInterp.getAttributeHeaders().keySet().iterator();
        boolean _hasStarted = true;
        int _blankCounter = 0;
        while (_iterator.hasNext()) {
            int _currentCode = _iterator.next();
            ENCAttributeInterpreter.ENCAttributeHeader _currentHeader = attribInterp.getHeader_byCode(_currentCode);
            if (_currentHeader.valueTable == null || _currentHeader.valueTable.size() == 0) continue;
            String _attributeName = ENCLibraryMaker.formatString(_currentHeader.attributeName, StringFormatType.OBJECTNAME);
            for (int _currentValue : _currentHeader.valueTable.keySet()) {
                String _valueName = ENCLibraryMaker.formatString(_currentHeader.valueTable.get(_currentValue), StringFormatType.OBJECTNAME);
                if (_valueName.length() == 0) {
                    _valueName = "BLANK" + String.valueOf(++_blankCounter);
                }
                if (!_hasStarted) {
                    fout.write(",\n");
                } else {
                    _hasStarted = false;
                }
                fout.write("\t " + _attributeName + "_" + _valueName + "  (" + String.valueOf(_currentCode) + ", " + String.valueOf(_currentValue) + ")");
            }
        }
        fout.write(";\n\n");
        fout.write("\t private int attributeID;\n");
        fout.write("\t private int attributeValueID;\n");
        fout.write("\t private static boolean populate = true;\n");
        fout.write("\t private static HashMap<Long, ENCAttributeValues> lookupMap = new HashMap<Long, ENCAttributeValues>();\n\n");
        fout.write("\t ENCAttributeValues(int aid, int avid){\n");
        fout.write("\t\t attributeID = aid;\n");
        fout.write("\t\t attributeValueID = avid;\n");
        fout.write("\t }\n\n");
        fout.write("\t public static ENCAttributeValues getInstance(int aid, int avid){\n");
        fout.write("\t\t long v1 = aid;\n");
        fout.write("\t\t long v2 = avid;\n");
        fout.write("\t\t if(populate){\n");
        fout.write("\t\t\t for(ENCAttributeValues p : ENCAttributeValues.values())\n");
        fout.write("\t\t\t\t lookupMap.put(((long)p.attributeID << 32) + (long)p.attributeValueID, p);\n");
        fout.write("\t\t\t populate = false;\n");
        fout.write("\t\t }\n");
        fout.write("\t\t return lookupMap.get((v1 << 32) + v2);\n");
        fout.write("\t }\n\n");
        fout.write("\t public static void write(DataOutputStream fout, ENCAttributeValues attrib) throws IOException{\n");
        fout.write("\t\t fout.writeInt(attrib.attributeID);\n");
        fout.write("\t\t fout.writeInt(attrib.attributeValueID);\n");
        fout.write("\t }\n\n");
        fout.write("\t public static ENCAttributeValues read(DataInputStream fin) throws IOException{\n");
        fout.write("\t\t int _id  = fin.readInt();\n");
        fout.write("\t\t int _vid = fin.readInt();\n");
        fout.write("\t\t return getInstance(_id, _vid);");
        fout.write("\t }\n\n");
        fout.write("}\n\n");
    }

    private static void generateObjectAttributes(BufferedWriter fout, ENCObjectInterpreter.ENCObjectHeader header, ENCAttributeInterpreter attribInterp) throws IOException {
        ENCAttributeInterpreter.ENCAttributeHeader _currentAttributeHeader;
        String _className = ENCLibraryMaker.formatString(header.objectClass, StringFormatType.OBJECTNAME);
        String _subClassName = ENCLibraryMaker.formatString(header.objectSubclass, StringFormatType.OBJECTNAME);
        if (_subClassName != null && _subClassName.length() > 0) {
            _className = _className + "_" + _subClassName;
        }
        fout.write("public interface " + _className + "{\n");
        fout.write("\t public enum Attributes{\n");
        Iterator<String> _iterator = header.objectAttributes.iterator();
        while (_iterator.hasNext()) {
            _currentAttributeHeader = attribInterp.getHeader_byAcronym(_iterator.next());
            String _currentAttributeName = ENCLibraryMaker.formatString(_currentAttributeHeader.attributeName, StringFormatType.OBJECTNAME);
            fout.write("\t\t " + _currentAttributeName + "_" + _currentAttributeHeader.attributeClass.getTypeCode() + "(){\n");
            fout.write("\t\t\t @Override\n");
            fout.write("\t\t\t public ENCAttributeType lift(){\n");
            fout.write("\t\t\t\t return ENCAttributeType." + _currentAttributeName + ";\n");
            fout.write("\t\t\t }}");
            if (_iterator.hasNext()) {
                fout.write(",\n");
                continue;
            }
            fout.write(";\n\n");
        }
        fout.write("\t\t public abstract ENCAttributeType lift();\n\n");
        fout.write("\t}\n\n");
        _iterator = header.objectAttributes.iterator();
        while (_iterator.hasNext()) {
            _currentAttributeHeader = attribInterp.getHeader_byAcronym(_iterator.next());
            String _currentAttributeClass = ENCLibraryMaker.formatString(_currentAttributeHeader.attributeName, StringFormatType.OBJECTNAME);
            String _currentAttributeName = ENCLibraryMaker.formatString(_currentAttributeHeader.attributeName, StringFormatType.OBJECTNAME);
            if (_currentAttributeHeader.valueTable == null || _currentAttributeHeader.valueTable.size() == 0) continue;
            Iterator<Integer> _valueIterator = _currentAttributeHeader.valueTable.keySet().iterator();
            fout.write("\t public enum " + _currentAttributeClass + "{\n");
            while (_valueIterator.hasNext()) {
                int _currentValue = _valueIterator.next();
                String _currentValueName = ENCLibraryMaker.formatString(_currentAttributeHeader.valueTable.get(_currentValue), StringFormatType.OBJECTNAME);
                fout.write("\t\t " + _currentValueName + "(){\n");
                fout.write("\t\t\t @Override\n");
                fout.write("\t\t\t public ENCAttributeValues lift(){\n");
                fout.write("\t\t\t\t return ENCAttributeValues." + _currentAttributeName + "_" + _currentValueName + ";\n");
                fout.write("\t\t\t }}\n");
                if (_valueIterator.hasNext()) {
                    fout.write(",\n");
                    continue;
                }
                fout.write(";\n\n");
            }
            fout.write("\t\t public abstract ENCAttributeValues lift();\n\n");
            fout.write("\t}");
        }
        fout.write("}\n\n");
    }

    private static void generateUniversalUnit(BufferedWriter fout, ENCUnitInterpreter unitInterp) throws IOException {
        int j;
        int i;
        ArrayList<ENCUnitInterpreter.ENCUnitHeader> _headerList = unitInterp.getUnitHeaders();
        HashMap<Integer, Integer> _globalToLocalIdx = new HashMap<Integer, Integer>();
        int n = _headerList.size();
        for (int i2 = 0; i2 < n; ++i2) {
            _globalToLocalIdx.put(_headerList.get((int)i2).code, i2);
        }
        double[][] _conversionMatrixA = unitInterp.getAMatrix();
        double[][] _conversionMatrixB = unitInterp.getBMatrix();
        fout.write("public enum ENCUnit{\n");
        int n2 = _headerList.size();
        for (i = 0; i < n2; ++i) {
            if (i != 0) {
                fout.write(",\n");
            }
            fout.write("\t " + ENCLibraryMaker.formatString(_headerList.get((int)i).name, StringFormatType.OBJECTNAME) + "_" + ENCLibraryMaker.formatString(_headerList.get((int)i).type, StringFormatType.OBJECTNAME) + "(" + String.valueOf(i) + ", " + String.valueOf(_headerList.get((int)i).code) + ")");
        }
        fout.write(";\n\n\n");
        fout.write("\t private int localID;\n");
        fout.write("\t private int ENCID;\n");
        fout.write("\t private static boolean populate = true;\n");
        fout.write("\t private static HashMap<Integer, ENCUnit> lookupMap = new HashMap<Integer, ENCUnit>();\n");
        fout.write("\t private static double[][] conversionMatrixA = null;\n");
        fout.write("\t private static double[][] conversionMatrixB = null;\n\n");
        fout.write("\t ENCUnit(int lid, int gid){\n");
        fout.write("\t\t localID = lid; \n");
        fout.write("\t\t ENCID   = gid; \n");
        fout.write("\t }\n\n");
        fout.write("\t public static ENCUnit getInstance(int gid){\n");
        fout.write("\t\t if(populate){\n");
        fout.write("\t\t\t for(ENCUnit p : ENCUnit.values())\n");
        fout.write("\t\t\t\t lookupMap.put(p.ENCID, p);\n");
        fout.write("\t\t\t populate = false;\n");
        fout.write("\t\t\t }\n");
        fout.write("\t\t // There are conflicting numbering schemes -- this is a fix\n");
        fout.write("\t\t int _adjValue = (gid % 9000) + 9000;\n");
        fout.write("\t\t return lookupMap.get(_adjValue);\n");
        fout.write("\t }\n\n");
        fout.write("\t public static ENCUnit read(DataInputStream fin) throws IOException{\n");
        fout.write("\t\t return getInstance(fin.readInt());\n");
        fout.write("\t }\n\n");
        fout.write("\t public static void write(DataOutputStream fout, ENCUnit unit) throws IOException{\n");
        fout.write("\t\t fout.writeInt(unit.ENCID);\n");
        fout.write("\t }\n\n");
        fout.write("\t public double convertTo(double value, ENCUnit type) throws Exception{\n");
        fout.write("\t\t if(conversionMatrixA == null){populateTableA(); populateTableB();}\n");
        fout.write("\t\t if(conversionMatrixA[this.localID][type.localID] == 0)\n");
        fout.write("\t\t\t throw new Exception(\"Cannot perform conversion.\"); \n");
        fout.write("\t\t return conversionMatrixB[this.localID][type.localID] * value / conversionMatrixA[this.localID][type.localID];\n");
        fout.write("\t }\n\n");
        fout.write("\t public double convertFrom(double value, ENCUnit type) throws Exception{\n");
        fout.write("\t\t if(conversionMatrixA == null){populateTableA(); populateTableB();}\n");
        fout.write("\t\t if(conversionMatrixA[type.localID][this.localID] == 0)\n");
        fout.write("\t\t\t throw new Exception(\"Cannot perform conversion.\"); \n");
        fout.write("\t\t return conversionMatrixB[type.localID][this.localID] * value / conversionMatrixA[type.localID][this.localID];\n");
        fout.write("\t }\n\n");
        fout.write("\t private static void populateTableA(){\n");
        fout.write("\t\t conversionMatrixA = new double[][]{\n");
        n2 = _conversionMatrixA.length;
        for (i = 0; i < n2; ++i) {
            fout.write("\t\t\t{");
            for (j = 0; j < n2; ++j) {
                fout.write(String.valueOf(_conversionMatrixA[i][j]));
                if (j == n2 - 1) continue;
                fout.write(", ");
            }
            if (i != n2 - 1) {
                fout.write("},\n");
                continue;
            }
            fout.write("}\n");
        }
        fout.write("\t\t};\n");
        fout.write("\t}\n\n");
        fout.write("\t private static void populateTableB(){\n");
        fout.write("\t\t conversionMatrixB = new double[][]{\n");
        n2 = _conversionMatrixB[i].length;
        for (i = 0; i < n2; ++i) {
            fout.write("\t\t\t{");
            for (j = 0; j < n2; ++j) {
                fout.write(String.valueOf(_conversionMatrixB[i][j]));
                if (j == n2 - 1) continue;
                fout.write(", ");
            }
            if (i != n2 - 1) {
                fout.write("},\n");
                continue;
            }
            fout.write("}\n");
        }
        fout.write("\t\t};\n");
        fout.write("\t}");
        fout.write("}");
    }

    private static String formatString(String value, StringFormatType type) {
        String _retVal;
        block10: {
            int i;
            String[] _contents;
            block11: {
                block9: {
                    if (value == null || value.length() == 0) {
                        return value;
                    }
                    _retVal = new String(value);
                    char[] _valArray = null;
                    _retVal = _retVal.toLowerCase();
                    _valArray = _retVal.toCharArray();
                    int n = _valArray.length;
                    for (int i2 = 0; i2 < n; ++i2) {
                        if (_valArray[i2] == '\'' || _valArray[i2] == '`') {
                            for (int j = i2; j < _valArray.length - 1; ++j) {
                                _valArray[j] = _valArray[j + 1];
                            }
                            _valArray[_valArray.length - 1] = 32;
                            continue;
                        }
                        if (_valArray[i2] >= 'a' && _valArray[i2] <= 'z' || _valArray[i2] >= '0' && _valArray[i2] <= '9') continue;
                        _valArray[i2] = 32;
                    }
                    _retVal = new String(_valArray);
                    _contents = _retVal.split(" ");
                    _retVal = "";
                    if (type != StringFormatType.OBJECTNAME) break block9;
                    for (i = 0; i < _contents.length; ++i) {
                        if (_contents[i].length() <= 0) continue;
                        String _firstLetter = "";
                        _firstLetter = _firstLetter + _contents[i].charAt(0);
                        _firstLetter = _firstLetter.toUpperCase();
                        _firstLetter = _firstLetter + _contents[i].substring(1);
                        _retVal = _retVal + _firstLetter;
                    }
                    break block10;
                }
                if (type != StringFormatType.ENUMVALUE) break block11;
                for (i = 0; i < _contents.length; ++i) {
                    if (_contents[i].length() <= 0) continue;
                    if (i != 0) {
                        _retVal = _retVal + '_';
                    }
                    _retVal = _retVal + _contents[i];
                }
                _retVal = _retVal.toUpperCase();
                break block10;
            }
            if (type != StringFormatType.INSTANCE) break block10;
            for (i = 0; i < _contents.length; ++i) {
                if (_contents[i].length() <= 0) continue;
                if (i > 0 && _retVal.length() > 0) {
                    String _firstLetter = "";
                    _firstLetter = _firstLetter + _contents[i].charAt(0);
                    _firstLetter = _firstLetter.toUpperCase();
                    _firstLetter = _firstLetter + _contents[i].substring(1);
                    _retVal = _retVal + _firstLetter;
                    continue;
                }
                _retVal = _retVal + _contents[i];
            }
        }
        return _retVal;
    }

    public static void main(String[] args) {
        try {
            ENCUnitInterpreter _uint = new ENCUnitInterpreter();
            ENCAttributeInterpreter _aint = new ENCAttributeInterpreter(_uint);
            ENCObjectInterpreter _oint = new ENCObjectInterpreter(_aint);
            ENCLibraryMaker.generateENCLibrary(_oint, _aint, _uint);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static enum StringFormatType {
        ENUMVALUE,
        OBJECTNAME,
        INSTANCE;

    }

    private static enum ValuationType {
        SingleParam,
        ListParam,
        CodedParam;

    }
}

