/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.parser.attributes;

import com.metsci.glimpse.charts.vector.parser.attributes.ENCAbstractAttribute;
import com.metsci.glimpse.charts.vector.parser.attributes.ENCAttributeClass;
import com.metsci.glimpse.charts.vector.parser.autogen.ENCAttributeType;
import com.metsci.glimpse.charts.vector.parser.autogen.ENCUnit;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public class ENCFloatAttribute
extends ENCAbstractAttribute {
    private float attributeValue;
    private ENCUnit attributeUnit = null;

    public float getENCAttributeValue() {
        return this.attributeValue;
    }

    public ENCUnit getENCAttributeValueUnit() {
        return this.attributeUnit;
    }

    public void setENCAttributeValue(float value, ENCUnit unit) {
        this.attributeValue = value;
        this.attributeUnit = unit;
    }

    @Override
    public ENCAttributeClass getAttributeClass() {
        return ENCAttributeClass.Float;
    }

    @Override
    public Object getAttributeValueAsObject() {
        return Float.valueOf(this.attributeValue);
    }

    @Override
    public String getAttributeValueAsString() {
        if (this.attributeUnit != null) {
            return this.attributeValue + " " + this.attributeUnit.name();
        }
        return this.attributeValue + "";
    }

    @Override
    protected void write0(DataOutputStream fout) throws IOException {
        ENCAttributeType.write(fout, this.getAttributeType());
        if (this.attributeUnit == null) {
            fout.writeBoolean(false);
        } else {
            fout.writeBoolean(true);
            fout.writeFloat(this.getENCAttributeValue());
            ENCUnit.write(fout, this.getENCAttributeValueUnit());
        }
    }

    public static ENCFloatAttribute read(DataInput fin) throws IOException {
        ENCFloatAttribute _retVal = new ENCFloatAttribute();
        _retVal.setAttributeType(ENCAttributeType.read(fin));
        boolean _haveValue = fin.readBoolean();
        if (_haveValue) {
            _retVal.setENCAttributeValue(fin.readFloat(), ENCUnit.read(fin));
        }
        _retVal.isNull = !_haveValue;
        return _retVal;
    }
}

