/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.parser.attributes;

import com.metsci.glimpse.charts.vector.parser.attributes.DNCAbstractAttribute;
import com.metsci.glimpse.charts.vector.parser.attributes.DNCAttributeClass;
import com.metsci.glimpse.charts.vector.parser.objects.DNCAttributeType;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public class DNCIntAttribute
extends DNCAbstractAttribute {
    private final int attributeValue;

    public DNCIntAttribute(DNCAttributeType type) {
        super(type, true);
        this.attributeValue = Integer.MIN_VALUE;
    }

    public DNCIntAttribute(DNCAttributeType type, int attributeValue) {
        super(type, false);
        this.attributeValue = attributeValue;
    }

    public DNCIntAttribute(DNCAttributeType type, String attributeValueText) {
        super(type, false);
        this.attributeValue = Integer.valueOf(attributeValueText);
    }

    public int getAttributeValue() {
        return this.attributeValue;
    }

    @Override
    public DNCAttributeClass getAttributeClass() {
        return DNCAttributeClass.Integer;
    }

    @Override
    public Object getAttributeValueAsObject() {
        return this.attributeValue;
    }

    @Override
    public String getAttributeValueAsString() {
        return this.attributeValue + "";
    }

    @Override
    protected void write0(DataOutputStream fout) throws IOException {
        if (this.isNullValued()) {
            fout.writeBoolean(false);
        } else {
            fout.writeBoolean(true);
            fout.writeInt(this.getAttributeValue());
        }
    }

    public static DNCIntAttribute read(DataInput fin) throws IOException {
        DNCAttributeType attributeType = DNCAttributeType.read(fin);
        boolean haveValue = fin.readBoolean();
        if (!haveValue) {
            return new DNCIntAttribute(attributeType);
        }
        int attributeValue = fin.readInt();
        return new DNCIntAttribute(attributeType, attributeValue);
    }
}

