/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.parser.attributes;

import com.metsci.glimpse.charts.vector.parser.attributes.DNCAbstractAttribute;
import com.metsci.glimpse.charts.vector.parser.attributes.DNCAttributeClass;
import com.metsci.glimpse.charts.vector.parser.objects.DNCAttributeType;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public class DNCFreeAttribute
extends DNCAbstractAttribute {
    private final String attributeValue;

    public DNCFreeAttribute(DNCAttributeType type) {
        super(type, true);
        this.attributeValue = null;
    }

    public DNCFreeAttribute(DNCAttributeType type, String attributeValue) {
        super(type, false);
        this.attributeValue = attributeValue;
    }

    public String getAttributeValue() {
        return this.attributeValue;
    }

    @Override
    public Object getAttributeValueAsObject() {
        return this.attributeValue;
    }

    @Override
    public String getAttributeValueAsString() {
        return this.attributeValue == null ? null : this.attributeValue;
    }

    @Override
    public DNCAttributeClass getAttributeClass() {
        return DNCAttributeClass.Free;
    }

    @Override
    protected void write0(DataOutputStream fout) throws IOException {
        if (this.attributeValue == null) {
            fout.writeBoolean(false);
        } else {
            fout.writeBoolean(true);
            fout.writeUTF(this.attributeValue);
        }
    }

    public static DNCFreeAttribute read(DataInput fin) throws IOException {
        DNCAttributeType attributeName = DNCAttributeType.read(fin);
        boolean haveValue = fin.readBoolean();
        if (!haveValue) {
            return new DNCFreeAttribute(attributeName);
        }
        String attributeValue = fin.readUTF().intern();
        return new DNCFreeAttribute(attributeName, attributeValue);
    }
}

