/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.parser.attributes;

import com.metsci.glimpse.charts.vector.parser.attributes.DNCAbstractAttribute;
import com.metsci.glimpse.charts.vector.parser.attributes.DNCAttributeClass;
import com.metsci.glimpse.charts.vector.parser.objects.DNCAttributeType;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public class DNCFloatAttribute
extends DNCAbstractAttribute {
    private final float attributeValue;

    public DNCFloatAttribute(DNCAttributeType type) {
        super(type, true);
        this.attributeValue = Float.NaN;
    }

    public DNCFloatAttribute(DNCAttributeType type, float attributeValue) {
        super(type, false);
        this.attributeValue = attributeValue;
    }

    public DNCFloatAttribute(DNCAttributeType type, String attributeValueText) {
        super(type, false);
        this.attributeValue = attributeValueText.endsWith("nan") ? Float.NaN : Float.valueOf(attributeValueText).floatValue();
    }

    public float getAttributeValue() {
        return this.attributeValue;
    }

    @Override
    public DNCAttributeClass getAttributeClass() {
        return DNCAttributeClass.Float;
    }

    @Override
    public Object getAttributeValueAsObject() {
        return Float.valueOf(this.attributeValue);
    }

    @Override
    public String getAttributeValueAsString() {
        return this.attributeValue + "";
    }

    @Override
    protected void write0(DataOutputStream fout) throws IOException {
        if (this.isNullValued()) {
            fout.writeBoolean(false);
        } else {
            fout.writeBoolean(true);
            fout.writeFloat(this.getAttributeValue());
        }
    }

    public static DNCFloatAttribute read(DataInput fin) throws IOException {
        DNCAttributeType attributeType = DNCAttributeType.read(fin);
        boolean haveValue = fin.readBoolean();
        if (!haveValue) {
            return new DNCFloatAttribute(attributeType);
        }
        float attributeValue = fin.readFloat();
        return new DNCFloatAttribute(attributeType, attributeValue);
    }
}

