/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.parser;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ResourceLister {
    public static String[] getResourceListing(String path) throws URISyntaxException, IOException {
        return ResourceLister.getResourceListing(ResourceLister.class, path, new DefaultResourceFilter(true, true));
    }

    public static String[] getResourceListing(String path, ResourceFilter filter) throws URISyntaxException, IOException {
        return ResourceLister.getResourceListing(ResourceLister.class, path, filter);
    }

    public static String[] getResourceListing(Class clazz, String path) throws URISyntaxException, IOException {
        return ResourceLister.getResourceListing(clazz, path, new DefaultResourceFilter(true, true));
    }

    public static String[] getResourceListing(Class clazz, String path, ResourceFilter filter) throws URISyntaxException, IOException {
        URL dirURL = clazz.getClassLoader().getResource(path);
        if (dirURL != null && dirURL.getProtocol().equals("file")) {
            return new File(dirURL.toURI()).list(new FilenameFilterAdapter(filter));
        }
        File file = new File(path);
        if (file.exists() && file.isDirectory()) {
            return file.list(new FilenameFilterAdapter(filter));
        }
        if (dirURL == null) {
            String me = clazz.getName().replace(".", "/") + ".class";
            dirURL = clazz.getClassLoader().getResource(me);
        }
        if (dirURL.getProtocol().equals("jar")) {
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            Enumeration<JarEntry> entries = jar.entries();
            HashSet<String> result = new HashSet<String>();
            while (entries.hasMoreElements()) {
                String name;
                JarEntry jarEntry = entries.nextElement();
                String fullJarPathName = jarEntry.getName();
                if (!fullJarPathName.startsWith(path) || (name = fullJarPathName.substring(path.length() + 1)).isEmpty()) continue;
                int checkSubdir = name.indexOf("/");
                if (checkSubdir >= 0) {
                    if (name.lastIndexOf(47) != checkSubdir) continue;
                    name = name.substring(0, checkSubdir);
                }
                if (jarEntry.isDirectory()) {
                    if (!filter.acceptDirResource(name)) continue;
                    result.add(name);
                    continue;
                }
                if (!filter.acceptFileResource(name)) continue;
                result.add(name);
            }
            return result.toArray(new String[result.size()]);
        }
        return null;
    }

    private static List<String> walkFile(File dir, ResourceFilter filter, List<String> foundList) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            String filePath = file.getPath();
            if (file.isDirectory()) {
                if (filter.acceptDirResource(filePath)) {
                    foundList.add(filePath);
                }
                ResourceLister.walkFile(file, filter, foundList);
                continue;
            }
            if (!filter.acceptFileResource(filePath)) continue;
            foundList.add(filePath);
        }
        return foundList;
    }

    public static String[] getRecursiveResourceListing(String path) throws URISyntaxException, IOException {
        return ResourceLister.getRecursiveResourceListing(ResourceLister.class, path);
    }

    public static String[] getRecursiveResourceListing(String path, ResourceFilter filter) throws URISyntaxException, IOException {
        return ResourceLister.getRecursiveResourceListing(ResourceLister.class, path, filter);
    }

    public static String[] getRecursiveResourceListing(Class clazz, String path) throws URISyntaxException, IOException {
        return ResourceLister.getRecursiveResourceListing(clazz, path, new DefaultResourceFilter(true, true));
    }

    public static String[] getRecursiveResourceListing(Class clazz, String path, ResourceFilter filter) throws URISyntaxException, IOException {
        URL dirURL = clazz.getClassLoader().getResource(path);
        if (dirURL != null && dirURL.getProtocol().equals("file")) {
            List<String> fileList = ResourceLister.walkFile(new File(dirURL.toURI()), filter, new ArrayList<String>());
            return fileList.toArray(new String[fileList.size()]);
        }
        File file = new File(path);
        if (file.exists()) {
            if (file.isDirectory()) {
                List<String> fileList = ResourceLister.walkFile(file, filter, new ArrayList<String>());
                return fileList.toArray(new String[fileList.size()]);
            }
            if (file.getName().toLowerCase().endsWith(".zip")) {
                ZipFile zip = new ZipFile(file);
                Enumeration<? extends ZipEntry> entries = zip.entries();
                HashSet<String> result = new HashSet<String>();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (entry.isDirectory()) {
                        if (!filter.acceptDirResource(name)) continue;
                        result.add(name);
                        continue;
                    }
                    if (!filter.acceptFileResource(name)) continue;
                    result.add(name);
                }
                return result.toArray(new String[result.size()]);
            }
        }
        if (dirURL == null) {
            String me = clazz.getName().replace(".", "/") + ".class";
            dirURL = clazz.getClassLoader().getResource(me);
        }
        if (dirURL.getProtocol().equals("jar")) {
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            Enumeration<JarEntry> entries = jar.entries();
            HashSet<String> result = new HashSet<String>();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(path)) continue;
                if (entry.isDirectory()) {
                    if (!filter.acceptDirResource(name)) continue;
                    result.add(name);
                    continue;
                }
                if (!filter.acceptFileResource(name)) continue;
                result.add(name);
            }
            return result.toArray(new String[result.size()]);
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            String start = "data";
            if (args.length > 0) {
                start = args[0];
            }
            System.out.println("start: " + start);
            Object[] resources = ResourceLister.getResourceListing(ResourceLister.class, start);
            System.out.println("resources: " + Arrays.toString(resources));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static class FilenameFilterAdapter
    implements FilenameFilter {
        private ResourceFilter innerFilter;

        public FilenameFilterAdapter(ResourceFilter filter) {
            this.innerFilter = filter;
        }

        @Override
        public boolean accept(File dir, String name) {
            File file = new File(dir, name);
            if (file.isDirectory()) {
                return this.innerFilter.acceptDirResource(name);
            }
            return this.innerFilter.acceptFileResource(name);
        }
    }

    public static class DefaultResourceFilter
    implements ResourceFilter {
        private boolean acceptAllDirs;
        private boolean acceptAllFiles;

        public DefaultResourceFilter(boolean acceptDirs, boolean acceptFiles) {
            this.acceptAllDirs = acceptDirs;
            this.acceptAllFiles = acceptFiles;
        }

        @Override
        public boolean acceptFileResource(String name) {
            return this.acceptAllFiles;
        }

        @Override
        public boolean acceptDirResource(String name) {
            return this.acceptAllDirs;
        }
    }

    public static interface ResourceFilter {
        public boolean acceptFileResource(String var1);

        public boolean acceptDirResource(String var1);
    }
}

