/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.parser;

import com.metsci.glimpse.charts.vector.parser.ENCAbstractBinder;
import com.metsci.glimpse.charts.vector.parser.ENCAttributeInterpreter;
import com.metsci.glimpse.charts.vector.parser.ENCObjectInterpreter;
import com.metsci.glimpse.charts.vector.parser.ENCUnitInterpreter;
import com.metsci.glimpse.charts.vector.parser.objects.ENCObject;
import com.metsci.glimpse.charts.vector.parser.objects.GenericObject;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OGRToENCParser {
    private static Logger logger = Logger.getLogger(OGRToENCParser.class.toString());
    private ENCObjectInterpreter objectInterpreter;
    private ENCUnitInterpreter unitInterpreter = new ENCUnitInterpreter();
    private ENCAttributeInterpreter attributeInterpreter = new ENCAttributeInterpreter(this.unitInterpreter);
    private ENCAbstractBinder binder;

    public OGRToENCParser() throws IOException {
        this.objectInterpreter = new ENCObjectInterpreter(this.attributeInterpreter);
        this.binder = new ENCAbstractBinder();
    }

    public void parseENC(String encSourceDataDir, List<GenericObject> objList, List<ENCObject> encList) {
        try {
            this.binder.resolveDependency(objList, encSourceDataDir);
            GenericObject.clearMetaObjects();
            this.binder.resolveMetaObjects(objList);
            this.writeENCObjects(objList, encList, true);
            GenericObject.clearMetaObjects();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeENCObjects(List<GenericObject> objList, List<ENCObject> encList, boolean deleteGeneric) throws IOException {
        Iterator<GenericObject> _iterator = objList.iterator();
        while (_iterator.hasNext()) {
            GenericObject _currentObject = _iterator.next();
            try {
                ENCObject encObject = this.objectInterpreter.convertObject(_currentObject);
                encList.add(encObject);
                if (!deleteGeneric) continue;
                _iterator.remove();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Conversion failed -- Generic Object Entry:" + _currentObject.toString(), e);
                System.exit(0);
            }
        }
    }
}

