/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.parser;

import com.metsci.glimpse.charts.vector.parser.DNCAttributeInterpreter;
import com.metsci.glimpse.charts.vector.parser.DNCObjectInterpreter;
import com.metsci.glimpse.charts.vector.parser.objects.DNCObject;
import com.metsci.glimpse.charts.vector.parser.objects.GenericObject;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OGRToDNCParser {
    private static Logger logger = Logger.getLogger(OGRToDNCParser.class.toString());
    private DNCObjectInterpreter objectInterpreter;
    private DNCAttributeInterpreter attributeInterpreter = new DNCAttributeInterpreter();

    public OGRToDNCParser() throws IOException {
        this.objectInterpreter = new DNCObjectInterpreter(this.attributeInterpreter);
    }

    public void parseDNC(String dncSourceDataDir, List<GenericObject> objList, List<DNCObject> dncList) {
        try {
            this.writeDNCObjects(objList, dncList, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeDNCObjects(List<GenericObject> objList, List<DNCObject> dncList, boolean deleteGeneric) throws IOException {
        Iterator<GenericObject> _iterator = objList.iterator();
        while (_iterator.hasNext()) {
            GenericObject _currentObject = _iterator.next();
            try {
                DNCObject dncObject = this.objectInterpreter.convertObject(_currentObject);
                if (dncObject != null) {
                    dncList.add(dncObject);
                }
                if (!deleteGeneric) continue;
                _iterator.remove();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Conversion failed -- Generic Object Entry:" + _currentObject.toString(), e);
                System.exit(0);
            }
        }
    }
}

