/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.parser;

import com.metsci.glimpse.charts.vector.parser.GenericShape;
import com.metsci.glimpse.charts.vector.parser.attributes.GenericAttribute;
import com.metsci.glimpse.charts.vector.parser.objects.GenericObject;
import com.metsci.glimpse.util.io.StreamOpener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class OGRReader {
    private static String[] shapes = new String[]{"POINT", "POLYGON", "LINESTRING", "MULTIPOINT"};
    private static Set<String> shapeSet = new HashSet<String>(Arrays.asList(shapes));

    public static List<GenericObject> read(File file) throws IOException {
        BufferedReader _fin = new BufferedReader(new FileReader(file));
        return OGRReader.read(_fin);
    }

    public static List<GenericObject> read(String resource) throws IOException {
        InputStream inputStream = StreamOpener.fileThenResource.openForRead(resource);
        BufferedReader _fin = new BufferedReader(new InputStreamReader(inputStream));
        return OGRReader.read(_fin);
    }

    public static List<GenericObject> read(BufferedReader reader) throws IOException {
        LinkedList<GenericObject> objectList = new LinkedList<GenericObject>();
        GenericObject currentObject = null;
        String currentLine = null;
        int lineNo = 0;
        String featureLine = null;
        String priorLine = null;
        while ((currentLine = reader.readLine()) != null) {
            ++lineNo;
            try {
                if (currentLine.contains("OGRFeature")) {
                    featureLine = currentLine;
                    currentObject = new GenericObject();
                    objectList.add(currentObject);
                    ArrayList<String> _attributes = new ArrayList<String>();
                    currentLine = reader.readLine();
                    while (currentLine != null && !currentLine.isEmpty()) {
                        _attributes.add(new String(currentLine));
                        currentLine = reader.readLine();
                    }
                    try {
                        OGRReader.appendAttributes(currentObject, _attributes);
                    }
                    catch (ArrayIndexOutOfBoundsException aie) {
                        System.out.println("OGRReader exception on line: " + lineNo);
                        System.out.println("For feature: " + featureLine);
                        System.out.println("Prior line: " + priorLine);
                        System.out.println("For object: " + currentObject);
                        throw aie;
                    }
                }
                priorLine = currentLine;
            }
            catch (NumberFormatException nfe) {
                System.out.println("caught and ignoring: ");
                nfe.printStackTrace();
            }
        }
        reader.close();
        return objectList;
    }

    private static void appendAttributes(GenericObject obj, List<String> attributes) {
        GenericAttribute lastAttribute = null;
        int n = attributes.size();
        for (int i = 0; i < n; ++i) {
            int _startPoint;
            String _currentLine = attributes.get(i);
            String[] _entries = _currentLine.split(" ");
            if (_entries.length < 3) {
                if (_currentLine.trim().isEmpty()) {
                    System.out.println("ignoring blank line");
                    continue;
                }
                if (lastAttribute != null && lastAttribute.getType().equals("(String)")) {
                    boolean hasEquals;
                    boolean bl = hasEquals = _currentLine.indexOf("=") >= 0;
                    if (hasEquals) continue;
                    lastAttribute.appendValue(_currentLine);
                    System.out.println("Assuming " + _currentLine + " is multiline.  Added to make " + lastAttribute.getValue());
                    continue;
                }
                throw new IllegalStateException("Attribute line missing key value entries: " + _currentLine + ", priorLine: " + attributes.get(i - 1));
            }
            boolean isShape = OGRReader.isItAShape(_entries[2]);
            if (!isShape) {
                GenericAttribute _newAttribute;
                boolean hasEquals;
                boolean bl = hasEquals = _currentLine.indexOf("=") >= 0;
                if (!hasEquals && lastAttribute != null && lastAttribute.getType().equals("(String)")) {
                    lastAttribute.appendValue(_currentLine);
                    System.out.println("Assuming " + _currentLine + " is multiline.  Added to make " + lastAttribute.getValue());
                    continue;
                }
                if (_entries.length < 4) {
                    throw new IllegalStateException("non shape attribute with less than 3 key value entries: " + _currentLine + ", Entries: " + _entries);
                }
                String _name = _entries[2];
                String _type = _entries[3];
                String[] _splitAtEquals = _currentLine.split(" = ");
                String _value = "";
                if (_splitAtEquals.length > 1) {
                    _value = _splitAtEquals[1];
                }
                lastAttribute = _newAttribute = new GenericAttribute(_type, _name, _value);
                obj.addAttribute(_newAttribute);
                continue;
            }
            String _shapeType = _entries[2];
            StringBuilder _lineBuilder = new StringBuilder();
            for (int j = i; j < n; ++j) {
                _lineBuilder.append(attributes.get(j));
            }
            String _allLines = _lineBuilder.toString();
            char[] _allChars = _allLines.toCharArray();
            for (_startPoint = 0; _startPoint < _allChars.length; ++_startPoint) {
                if (_allChars[_startPoint] != '(') continue;
                ++_startPoint;
                break;
            }
            int _endPoint = _allChars.length - 1;
            OGRReader.parseShape(obj, _shapeType, _allLines.substring(_startPoint, _endPoint));
        }
    }

    private static void parseShape(GenericObject obj, String type, String value) {
        char[] _allChars = value.toCharArray();
        boolean _mayHaveMultipleParts = false;
        int n = _allChars.length;
        for (int i = 0; i < n; ++i) {
            if (_allChars[i] != '(') continue;
            _mayHaveMultipleParts = true;
            break;
        }
        if (_mayHaveMultipleParts) {
            for (int _counter = 0; _counter < _allChars.length; ++_counter) {
                if (_allChars[_counter] != '(') continue;
                int _startPoint = _counter + 1;
                while (_allChars[++_counter] != ')') {
                }
                int _endPoint = _counter;
                GenericShape _newShape = new GenericShape(type, value.substring(_startPoint, _endPoint));
                obj.addShape(_newShape);
            }
        } else {
            GenericShape _newShape = new GenericShape(type, value);
            obj.addShape(_newShape);
        }
    }

    private static boolean isItAShape(String value) {
        return shapeSet.contains(value);
    }
}

