/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.parser;

import com.metsci.glimpse.charts.vector.parser.OGRReader;
import com.metsci.glimpse.charts.vector.parser.objects.GenericObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.logging.Logger;

public class OGRInfo {
    private static Logger logger = Logger.getLogger(OGRInfo.class.toString());
    private static final String s57parserLocation = "/usr/bin/ogrinfo";
    private File gdalConsoleFile;
    private BufferedReader gdalConsoleOutputReader;
    private BufferedWriter gdalConsoleOutputWriter;

    public OGRInfo() throws IOException {
        this(File.createTempFile("ogrinfoconsolelog", "txt"));
        this.gdalConsoleFile.deleteOnExit();
    }

    public OGRInfo(File gdalConsoleFile) {
        this.gdalConsoleFile = gdalConsoleFile;
    }

    public List<GenericObject> addGeoSourceAndParse(String geoSourceFile) throws IOException, InterruptedException {
        this.addGeoSource(geoSourceFile);
        return this.parse();
    }

    public List<GenericObject> addZippedGeoSourceAndParse(String zipFilePath, String geoLogicalPath) throws IOException, InterruptedException {
        this.addZippedGeoSource(zipFilePath, geoLogicalPath);
        return this.parse();
    }

    public void addGeoSource(String geoSourceFile) throws IOException, InterruptedException {
        this.internalAddGeoSource(geoSourceFile);
    }

    public void addZippedGeoSource(String zipFilePath, String geoLogicalPath) throws IOException, InterruptedException {
        String geoSourceFile = "/vsizip/" + zipFilePath + "/" + geoLogicalPath;
        this.internalAddGeoSource(geoSourceFile);
    }

    public void addDNCGeoSource(String geoSourceFile) throws IOException, InterruptedException {
        geoSourceFile = "gltp:/vrf/" + geoSourceFile;
        this.internalAddGeoSource(geoSourceFile);
    }

    public boolean internalAddGeoSource(String geoSourceFile) throws IOException, InterruptedException {
        if (this.gdalConsoleOutputWriter == null) {
            this.gdalConsoleOutputWriter = new BufferedWriter(new FileWriter(this.gdalConsoleFile));
        }
        String command = "/usr/bin/ogrinfo -ro -al  " + geoSourceFile;
        logger.info(">" + command);
        Process exec = Runtime.getRuntime().exec(command);
        BufferedReader inputReader = new BufferedReader(new InputStreamReader(exec.getInputStream()));
        String line = inputReader.readLine();
        while (line != null) {
            this.gdalConsoleOutputWriter.write(line + "\n");
            line = inputReader.readLine();
        }
        inputReader.close();
        exec.waitFor();
        return exec.exitValue() != 139;
    }

    public void closeOutputWriter() throws IOException {
        if (this.gdalConsoleOutputWriter != null) {
            this.gdalConsoleOutputWriter.flush();
            this.gdalConsoleOutputWriter.close();
        }
    }

    public List<GenericObject> parse() throws IOException {
        this.closeOutputWriter();
        if (this.gdalConsoleOutputReader == null) {
            this.gdalConsoleOutputReader = new BufferedReader(new FileReader(this.gdalConsoleFile));
        }
        return OGRReader.read(this.gdalConsoleOutputReader);
    }
}

