/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.parser;

import com.metsci.glimpse.charts.vector.iteration.DNCObjectLoader;
import com.metsci.glimpse.charts.vector.iteration.ENCObjectLoader;
import com.metsci.glimpse.charts.vector.iteration.GeoFilterableRecordList;
import com.metsci.glimpse.charts.vector.iteration.GeoRecordListForStream;
import com.metsci.glimpse.charts.vector.iteration.StreamToGeoObjectConverter;
import com.metsci.glimpse.charts.vector.parser.GeoReader;
import com.metsci.glimpse.charts.vector.parser.objects.DNCObject;
import com.metsci.glimpse.charts.vector.parser.objects.ENCObject;
import com.metsci.glimpse.charts.vector.parser.objects.GeoObject;
import com.metsci.glimpse.util.io.StreamOpener;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class MetsciGeoReader<V extends GeoObject>
implements GeoReader<V> {
    private List<V> recordList;

    public static MetsciGeoReader<ENCObject> createENCReader(String resourceName) throws IOException {
        return new MetsciGeoReader<ENCObject>(new ENCObjectLoader(), resourceName);
    }

    public static MetsciGeoReader<DNCObject> createDNCReader(String resourceName) throws IOException {
        return new MetsciGeoReader<DNCObject>(new DNCObjectLoader(), resourceName);
    }

    public MetsciGeoReader(StreamToGeoObjectConverter<V> loader, String resourceName) throws IOException {
        DataInputStream encStream = new DataInputStream(StreamOpener.fileThenResource.openForRead(resourceName));
        this.recordList = new ArrayList<V>();
        MetsciGeoReader.readInFile(loader, encStream, this.recordList);
        encStream.close();
    }

    public MetsciGeoReader(StreamToGeoObjectConverter<V> loader, InputStream stream) throws IOException {
        DataInputStream encStream = new DataInputStream(stream);
        this.recordList = new ArrayList<V>();
        MetsciGeoReader.readInFile(loader, encStream, this.recordList);
    }

    @Override
    public GeoFilterableRecordList<V> getGeoFilterableRecordList() {
        return new GeoRecordListForStream<V>(this.recordList);
    }

    @Override
    public Collection<V> getCollection() {
        return Collections.unmodifiableCollection(this.recordList);
    }

    private static <T extends GeoObject> void readInFile(StreamToGeoObjectConverter<T> loader, DataInputStream dncStream, List<T> recordList) throws IOException {
        while (dncStream.available() > 0) {
            T geo = loader.readNext(dncStream);
            recordList.add(geo);
        }
    }
}

