/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.parser;

import com.metsci.glimpse.charts.vector.iteration.GeoFilterableRecordList;
import com.metsci.glimpse.charts.vector.iteration.GeoRecordListForStream;
import com.metsci.glimpse.charts.vector.parser.GeoReader;
import com.metsci.glimpse.charts.vector.parser.objects.ENCObject;
import com.metsci.glimpse.util.io.StreamOpener;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class MetsciENCReader
implements GeoReader<ENCObject> {
    private List<ENCObject> recordList;

    public MetsciENCReader(String resourceName) throws IOException {
        DataInputStream encStream = new DataInputStream(StreamOpener.fileThenResource.openForRead(resourceName));
        this.recordList = new ArrayList<ENCObject>();
        MetsciENCReader.readInFile(encStream, this.recordList);
        encStream.close();
    }

    public MetsciENCReader(InputStream stream) throws IOException {
        DataInputStream encStream = new DataInputStream(stream);
        this.recordList = new ArrayList<ENCObject>();
        MetsciENCReader.readInFile(encStream, this.recordList);
    }

    @Override
    public GeoFilterableRecordList<ENCObject> getGeoFilterableRecordList() {
        return new GeoRecordListForStream<ENCObject>(this.recordList);
    }

    @Override
    public Collection<ENCObject> getCollection() {
        return Collections.unmodifiableCollection(this.recordList);
    }

    private static void readInFile(DataInputStream encStream, List<ENCObject> recordList) throws IOException {
        while (encStream.available() > 0) {
            ENCObject encObject = ENCObject.read(encStream);
            recordList.add(encObject);
        }
    }
}

