/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.parser;

import com.metsci.glimpse.charts.vector.iteration.GeoFilterableRecordList;
import com.metsci.glimpse.charts.vector.iteration.GeoRecordListForStream;
import com.metsci.glimpse.charts.vector.parser.GeoReader;
import com.metsci.glimpse.charts.vector.parser.objects.DNCObject;
import com.metsci.glimpse.util.io.StreamOpener;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class MetsciDNCReader
implements GeoReader<DNCObject> {
    private List<DNCObject> recordList;

    public MetsciDNCReader(String resourceName) throws IOException {
        DataInputStream encStream = new DataInputStream(StreamOpener.fileThenResource.openForRead(resourceName));
        this.recordList = new ArrayList<DNCObject>();
        MetsciDNCReader.readInFile(encStream, this.recordList);
        encStream.close();
    }

    public MetsciDNCReader(InputStream stream) throws IOException {
        DataInputStream encStream = new DataInputStream(stream);
        this.recordList = new ArrayList<DNCObject>();
        MetsciDNCReader.readInFile(encStream, this.recordList);
    }

    @Override
    public GeoFilterableRecordList<DNCObject> getGeoFilterableRecordList() {
        return new GeoRecordListForStream<DNCObject>(this.recordList);
    }

    @Override
    public Collection<DNCObject> getCollection() {
        return Collections.unmodifiableCollection(this.recordList);
    }

    private static void readInFile(DataInputStream dncStream, List<DNCObject> recordList) throws IOException {
        while (dncStream.available() > 0) {
            DNCObject dncObject = DNCObject.read(dncStream);
            recordList.add(dncObject);
        }
    }
}

