/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.parser;

import com.metsci.glimpse.charts.vector.parser.CsvTokenizer;
import com.metsci.glimpse.charts.vector.parser.attributes.GenericAttribute;
import com.metsci.glimpse.charts.vector.parser.autogen.ENCUnit;
import com.metsci.glimpse.charts.vector.parser.objects.GenericObject;
import com.metsci.glimpse.util.io.StreamOpener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;

public class ENCUnitInterpreter {
    private double[][] conversionMatrixA;
    private double[][] conversionMatrixB;
    private HashMap<Integer, ENCUnitHeader> unitMap = new HashMap();
    private ArrayList<ENCUnitHeader> unitList = new ArrayList();
    private TreeMap<String, ArrayList<ENCUnitHeader>> unitTypeMap = new TreeMap();
    private TreeMap<Integer, String> attributeUnitBinding = new TreeMap();
    private TreeMap<Integer, Integer> attributeFixedUnit = new TreeMap();
    private static String unitOfMeasurementFile = "enc/unit_of_measure.csv";
    private static String unitBindingFile = "enc/s57_unitvalues.txt";

    public ENCUnitInterpreter() {
        try {
            this.buildClassInformation();
            this.buildBindingInformation();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.buildConversionMatrices();
    }

    public ArrayList<ENCUnitHeader> getUnitHeaders() {
        return this.unitList;
    }

    public ENCUnit resolveUnitType(int attributeCode, GenericObject obj) throws UnitInterpreterException {
        if (this.attributeFixedUnit.containsKey(attributeCode)) {
            Integer fixedUnitKey = this.attributeFixedUnit.get(attributeCode);
            if (fixedUnitKey == null) {
                throw new UnitInterpreterException("Cannot resolve unit type: Code = " + String.valueOf(attributeCode));
            }
            ENCUnitHeader unitHeader = this.unitMap.get(fixedUnitKey);
            if (unitHeader == null) {
                throw new UnitInterpreterException("Cannot resolve unit type: Code = " + String.valueOf(attributeCode) + ", unitKey: " + fixedUnitKey);
            }
            return ENCUnit.getInstance(unitHeader.code);
        }
        if (this.attributeUnitBinding.containsKey(attributeCode)) {
            GenericAttribute _metaAttribute = GenericObject.getMetaAttribute(this.attributeUnitBinding.get(attributeCode));
            if (_metaAttribute == null) {
                throw new UnitInterpreterException("ENCUnitInterpreter -- Insufficient metadata for library.");
            }
            return ENCUnit.getInstance(Integer.valueOf(_metaAttribute.getValue()));
        }
        throw new UnitInterpreterException("Cannot resolve unit type: Code = " + String.valueOf(attributeCode));
    }

    public double[][] getAMatrix() {
        return this.conversionMatrixA;
    }

    public double[][] getBMatrix() {
        return this.conversionMatrixB;
    }

    private void buildConversionMatrices() {
        int i;
        HashMap<Integer, Integer> _globalToLocalIdx = new HashMap<Integer, Integer>();
        boolean[] _convertableList = new boolean[this.unitList.size()];
        int n = this.unitList.size();
        for (int i2 = 0; i2 < n; ++i2) {
            _globalToLocalIdx.put(this.unitList.get((int)i2).code, i2);
            _convertableList[i2] = this.unitList.get((int)i2).convertable;
        }
        double[][] _conversionMatrixA = new double[this.unitList.size()][this.unitList.size()];
        double[][] _conversionMatrixB = new double[this.unitList.size()][this.unitList.size()];
        int n2 = this.unitList.size();
        for (i = 0; i < n2; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (i == j && _convertableList[i]) {
                    _conversionMatrixA[i][j] = 1.0;
                    _conversionMatrixB[i][j] = 1.0;
                    continue;
                }
                _conversionMatrixA[i][j] = 0.0;
                _conversionMatrixB[i][j] = 0.0;
            }
        }
        n2 = this.unitList.size();
        for (i = 0; i < n2; ++i) {
            if (!_convertableList[i]) continue;
            ENCUnitHeader _currentHeader = this.unitList.get(i);
            _conversionMatrixA[i][((Integer)_globalToLocalIdx.get((Object)Integer.valueOf((int)_currentHeader.targetCode))).intValue()] = _currentHeader.aFactor;
            _conversionMatrixB[i][((Integer)_globalToLocalIdx.get((Object)Integer.valueOf((int)_currentHeader.targetCode))).intValue()] = _currentHeader.bFactor;
        }
        boolean _hasChanged = true;
        while (_hasChanged) {
            _hasChanged = false;
            int n3 = this.unitList.size();
            for (int i3 = 0; i3 < n3; ++i3) {
                if (!_convertableList[i3]) continue;
                block6: for (int j = 0; j < n3; ++j) {
                    if (!_convertableList[j] || _conversionMatrixA[i3][j] != 0.0) continue;
                    if (_conversionMatrixA[j][i3] != 0.0) {
                        _conversionMatrixA[i3][j] = 1.0 / _conversionMatrixB[j][i3];
                        _conversionMatrixB[i3][j] = 1.0 / _conversionMatrixA[j][i3];
                        _hasChanged = true;
                        continue;
                    }
                    for (int k = 0; k < n3; ++k) {
                        if (!_convertableList[k] || _conversionMatrixA[k][j] == 0.0 || _conversionMatrixA[k][i3] == 0.0) continue;
                        _conversionMatrixA[i3][j] = _conversionMatrixA[k][i3] * _conversionMatrixB[k][j];
                        _conversionMatrixB[i3][j] = _conversionMatrixA[k][j] * _conversionMatrixB[k][i3];
                        _hasChanged = true;
                        continue block6;
                    }
                }
            }
        }
        this.conversionMatrixA = _conversionMatrixA;
        this.conversionMatrixB = _conversionMatrixB;
    }

    private void buildClassInformation() throws IOException {
        InputStream unitOfMeasureStream = StreamOpener.fileThenResource.openForRead(unitOfMeasurementFile);
        BufferedReader _fin = new BufferedReader(new InputStreamReader(unitOfMeasureStream));
        String _line = _fin.readLine();
        CsvTokenizer csvTokenizer = new CsvTokenizer(_fin);
        ArrayList<String> _contents = new ArrayList<String>();
        try {
            while (csvTokenizer.readStringList(_contents)) {
                ENCUnitHeader _currentUnit = null;
                try {
                    _currentUnit = new ENCUnitHeader(Integer.valueOf((String)_contents.get(0)), (String)_contents.get(1), (String)_contents.get(2), Integer.valueOf((String)_contents.get(3)), Double.valueOf((String)_contents.get(4)), Double.valueOf((String)_contents.get(5)));
                }
                catch (NumberFormatException e) {
                    System.out.println("Unconvertable Line at line " + csvTokenizer.getLineNumber() + " - " + ((Object)_contents).toString());
                    System.out.println("-- Creating unconvertable object");
                    _currentUnit = new ENCUnitHeader(Integer.valueOf((String)_contents.get(0)), (String)_contents.get(1), (String)_contents.get(2));
                }
                this.unitList.add(_currentUnit);
                this.unitMap.put(_currentUnit.code, _currentUnit);
                ArrayList<Object> _currentHeaderList = null;
                if (this.unitTypeMap.containsKey(_currentUnit.type)) {
                    _currentHeaderList = this.unitTypeMap.get(_currentUnit.type);
                } else {
                    _currentHeaderList = new ArrayList();
                    this.unitTypeMap.put(_currentUnit.type, _currentHeaderList);
                }
                _currentHeaderList.add(_currentUnit);
            }
        }
        catch (ParseException pe) {
            throw new IOException(null, pe);
        }
        _fin.close();
    }

    private void buildBindingInformation() throws IOException {
        InputStream inputStream = StreamOpener.fileThenResource.openForRead(unitBindingFile);
        BufferedReader _fin = new BufferedReader(new InputStreamReader(inputStream));
        String _line = null;
        while ((_line = _fin.readLine()) != null) {
            String[] _contents = _line.split(",");
            if (_contents.length == 2) {
                this.attributeFixedUnit.put(Integer.valueOf(_contents[0]), Integer.valueOf(_contents[1]));
                continue;
            }
            this.attributeUnitBinding.put(Integer.valueOf(_contents[0]), _contents[2] + "_" + _contents[3]);
        }
        _fin.close();
    }

    public class UnitInterpreterException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public UnitInterpreterException(String s) {
            super(s);
        }
    }

    public class ENCUnitHeader {
        public int code;
        public String name;
        public String type;
        public boolean convertable;
        public int targetCode;
        public double aFactor;
        public double bFactor;

        public ENCUnitHeader(int c, String n, String t, int tc, double afac, double bfac) {
            this.code = c;
            this.name = n;
            this.type = t;
            this.targetCode = tc;
            this.aFactor = afac;
            this.bFactor = bfac;
            this.convertable = true;
        }

        public ENCUnitHeader(int c, String n, String t) {
            this.code = c;
            this.name = n;
            this.type = t;
            this.convertable = false;
        }
    }
}

