/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.parser;

import com.metsci.glimpse.charts.vector.parser.ENCAttributeInterpreter;
import com.metsci.glimpse.charts.vector.parser.GenericShape;
import com.metsci.glimpse.charts.vector.parser.attributes.GenericAttribute;
import com.metsci.glimpse.charts.vector.parser.objects.ENCObject;
import com.metsci.glimpse.charts.vector.parser.objects.ENCObjectType;
import com.metsci.glimpse.charts.vector.parser.objects.ENCShape;
import com.metsci.glimpse.charts.vector.parser.objects.GenericObject;
import com.metsci.glimpse.charts.vector.parser.objects.GeoShapeType;
import com.metsci.glimpse.util.io.StreamOpener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;

public class ENCObjectInterpreter {
    private TreeMap<String, ENCObjectHeader> classList_byAcronym = new TreeMap();
    private HashMap<Integer, ENCObjectHeader> classList_byCode = new HashMap();
    private final ENCAttributeInterpreter attributeInterpreter;
    private String s57ObjectClassList = "enc/s57objectclasses.csv";

    public ENCObjectInterpreter(ENCAttributeInterpreter attribInterp) throws IOException {
        this.attributeInterpreter = attribInterp;
        this.buildClassInformation();
    }

    public HashMap<Integer, ENCObjectHeader> getObjectHeaders() {
        return this.classList_byCode;
    }

    public ENCObjectHeader getHeader_byCode(int code) {
        return this.classList_byCode.get(code);
    }

    public ENCObjectHeader getHeader_byAcronym(String acronym) {
        return this.classList_byAcronym.get(acronym);
    }

    public ENCObject convertObject(GenericObject obj) throws Exception {
        GenericAttribute rcnmAttrib;
        if (!obj.hasAttribute("OBJL")) {
            return null;
        }
        ENCObject _retVal = new ENCObject();
        _retVal.setObjectType(ENCObjectType.getInstance(Integer.valueOf(obj.getAttribute("OBJL").getValue())));
        GenericAttribute rcidAttrib = obj.getAttribute("RCID");
        if (rcidAttrib != null) {
            _retVal.setRcid(Integer.valueOf(rcidAttrib.getValue()));
        }
        if ((rcnmAttrib = obj.getAttribute("RCNM")) != null) {
            _retVal.setRcnm(Integer.valueOf(rcnmAttrib.getValue()));
        }
        for (GenericAttribute _currentAttribute : obj.getAttributes()) {
            if (!this.attributeInterpreter.isValidAcronym(_currentAttribute.getName())) continue;
            _retVal.addAttribute(this.attributeInterpreter.convertAttribute(_currentAttribute, obj));
        }
        for (GenericShape shape : obj.getShapes()) {
            _retVal.addShape(this.convertShape(shape));
        }
        return _retVal;
    }

    public ENCShape convertShape(GenericShape shape) throws Exception {
        ENCShape _retVal = new ENCShape();
        if (shape.getType().equals("POINT")) {
            _retVal.setShapeType(GeoShapeType.Point);
        } else if (shape.getType().equals("POLYGON")) {
            _retVal.setShapeType(GeoShapeType.Polygon);
        } else if (shape.getType().equals("MULTIPOINT")) {
            _retVal.setShapeType(GeoShapeType.Multipoint);
        } else if (shape.getType().equals("LINESTRING")) {
            _retVal.setShapeType(GeoShapeType.Linestring);
        } else {
            throw new Exception("ENCShape -- Unknown primitive type");
        }
        if (!shape.isEmpty()) {
            _retVal.setPointSize(shape.getPointSize());
            double[] _values = new double[shape.getPointSize() * shape.numCoordinates()];
            int _currentIndex = 0;
            for (int i = 0; i < shape.numCoordinates(); ++i) {
                double[] shapeCoordinate = shape.getCoordinate(i);
                for (int j = 0; j < shapeCoordinate.length; ++j) {
                    _values[_currentIndex] = shapeCoordinate[j];
                    ++_currentIndex;
                }
            }
            _retVal.setVertexPoints(_values);
        }
        return _retVal;
    }

    private void buildClassInformation() throws IOException {
        InputStream inputStream = StreamOpener.fileThenResource.openForRead(this.s57ObjectClassList);
        BufferedReader _fin = new BufferedReader(new InputStreamReader(inputStream));
        String _line = _fin.readLine();
        while ((_line = _fin.readLine()) != null) {
            ENCObjectHeader _objId = new ENCObjectHeader();
            int _currentIndex = 0;
            String[] _contentsSections = _line.split(",");
            _objId.objectCode = Integer.valueOf(_contentsSections[_currentIndex]);
            if (_contentsSections[++_currentIndex].toCharArray()[0] == '\"') {
                _objId.objectClass = _contentsSections[_currentIndex].substring(1, _contentsSections[_currentIndex].length());
                _objId.objectSubclass = _contentsSections[++_currentIndex].substring(1, _contentsSections[_currentIndex].length() - 1);
                ++_currentIndex;
            } else {
                _objId.objectClass = _contentsSections[_currentIndex];
                ++_currentIndex;
            }
            _objId.objectAcronym = _contentsSections[_currentIndex];
            int n = _contentsSections.length;
            for (int i = ++_currentIndex; i < n; ++i) {
                String[] _sectionValues = _contentsSections[i].split(";");
                if (i == n - 2 && _objId.objectCode < 400 || i == n - 1 && _objId.objectCode >= 400) {
                    if (_objId.objectCode < 300) {
                        _objId.classType = ENCClassType.Geographical;
                        continue;
                    }
                    if (_objId.objectCode < 400) {
                        _objId.classType = ENCClassType.Meta;
                        continue;
                    }
                    if (_objId.objectCode < 500) {
                        _objId.classType = ENCClassType.Carteographic;
                        continue;
                    }
                    _objId.classType = ENCClassType.Symbolic;
                    continue;
                }
                if (i == n - 1 && _objId.objectCode < 400) {
                    int _value = 0;
                    for (int j = 0; j < _sectionValues.length; ++j) {
                        if (_sectionValues[j].equals("Point")) {
                            _value |= 1;
                            continue;
                        }
                        if (_sectionValues[j].equals("Line")) {
                            _value |= 2;
                            continue;
                        }
                        if (!_sectionValues[j].equals("Area")) continue;
                        _value |= 4;
                    }
                    _objId.primitiveType = _value;
                    continue;
                }
                for (int j = 0; j < _sectionValues.length; ++j) {
                    if (_sectionValues[j].equals("")) continue;
                    _objId.objectAttributes.add(_sectionValues[j]);
                    _objId.attributeMap.put(_sectionValues[j], _objId.objectAttributes.size() - 1);
                }
            }
            this.classList_byAcronym.put(_objId.objectAcronym, _objId);
            this.classList_byCode.put(_objId.objectCode, _objId);
        }
        _fin.close();
    }

    public static enum ENCClassType {
        Meta,
        Geographical,
        Carteographic,
        Symbolic;

    }

    public class ENCObjectHeader {
        public int objectCode;
        public int primitiveType;
        public String objectClass;
        public String objectSubclass;
        public String objectAcronym;
        public ENCClassType classType;
        public ArrayList<String> objectAttributes = new ArrayList();
        public TreeMap<String, Integer> attributeMap = new TreeMap();

        public String toString() {
            String _retVal = "";
            _retVal = _retVal + this.objectAcronym + "(" + String.valueOf(this.objectCode) + ")\n";
            _retVal = _retVal + this.objectClass + " -- " + this.objectSubclass + "\n";
            _retVal = _retVal + "Attributes: ";
            for (int i = 0; i < this.objectAttributes.size(); ++i) {
                _retVal = _retVal + this.objectAttributes.get(i) + " ";
            }
            _retVal = _retVal + "\n";
            _retVal = _retVal + "Primitive Code: " + String.valueOf(this.primitiveType);
            return _retVal;
        }
    }
}

