/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.parser;

import com.metsci.glimpse.charts.vector.parser.OGRInfo;
import com.metsci.glimpse.charts.vector.parser.OGRToENCParser;
import com.metsci.glimpse.charts.vector.parser.ResourceLister;
import com.metsci.glimpse.charts.vector.parser.objects.ENCObject;
import com.metsci.glimpse.charts.vector.parser.objects.GenericObject;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ENCHarvest {
    private static Logger logger = Logger.getLogger(ENCHarvest.class.toString());
    private OGRToENCParser encConverter = new OGRToENCParser();
    private boolean clearDumpLocation = true;

    public boolean recursivelyConvertEncFiles(File topLevelOutputDir, String dataHome) throws IOException, URISyntaxException {
        ArrayList encDirList = new ArrayList();
        System.out.println("datahome: " + dataHome);
        String[] resources = ResourceLister.getRecursiveResourceListing(ENCHarvest.class, dataHome, new ResourceLister.DefaultResourceFilter(true, false){

            @Override
            public boolean acceptFileResource(String name) {
                return name.endsWith(".000");
            }
        });
        if (resources != null) {
            boolean isZip = new File(dataHome).isFile() && dataHome.length() > 4 && dataHome.substring(dataHome.length() - 4).toLowerCase().equals(".zip");
            for (String enc000File : resources) {
                if (isZip) {
                    this.convertEncFile(topLevelOutputDir, dataHome, enc000File);
                    continue;
                }
                this.convertEncFile(topLevelOutputDir, enc000File);
            }
            return true;
        }
        return false;
    }

    public void convertEncFile(File topLevelOutputDir, String enc000Path) throws IOException, URISyntaxException {
        this.convertEncFile(topLevelOutputDir, null, enc000Path);
    }

    public void convertEncFile(File topLevelOutputDir, String zipPath, String enc000Path) throws IOException, URISyntaxException {
        Object encRootResource = null;
        logger.fine("Started ENC Repository Parsing: " + new Date(System.currentTimeMillis()).toString());
        String encDir = ".";
        String name = enc000Path;
        int lastSeparator = enc000Path.lastIndexOf("/");
        if (lastSeparator > 0) {
            encDir = enc000Path.substring(0, lastSeparator);
            name = enc000Path.substring(lastSeparator + 1);
        }
        String encTitle = name.substring(0, name.length() - 4);
        File dataLevelOutputDir = new File(topLevelOutputDir, "/" + encTitle);
        System.out.println("outputdir: " + dataLevelOutputDir);
        this.prepareOutputDir(dataLevelOutputDir, this.clearDumpLocation);
        OGRInfo ogrInfo = new OGRInfo(new File(dataLevelOutputDir, encTitle + ".txt"));
        try {
            List<GenericObject> geoObjects = null;
            geoObjects = zipPath != null ? ogrInfo.addZippedGeoSourceAndParse(zipPath, enc000Path) : ogrInfo.addGeoSourceAndParse(enc000Path);
            LinkedList<ENCObject> encObjects = new LinkedList<ENCObject>();
            this.encConverter.parseENC(encDir, geoObjects, encObjects);
            File metsciOutFile = new File(dataLevelOutputDir, encTitle + ".enc");
            System.out.println("outputFile: " + metsciOutFile);
            DataOutputStream metsciOutStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(metsciOutFile)));
            this.writeENCObjectsToFile(metsciOutStream, encObjects);
            metsciOutStream.close();
        }
        catch (InterruptedException ex) {
            logger.log(Level.WARNING, null, ex);
        }
    }

    public void goodconvertEncFile(File topLevelOutputDir, String encRootResource) throws IOException, URISyntaxException {
        logger.fine("Started ENC Repository Parsing: " + new Date(System.currentTimeMillis()).toString());
        String[] encRootSubDirs = ResourceLister.getResourceListing(OGRInfo.class, encRootResource, new ResourceLister.DefaultResourceFilter(true, false));
        for (int i = 0; i < encRootSubDirs.length; ++i) {
            String encRootSubDirPath = encRootResource + '/' + encRootSubDirs[i];
            String[] enc000Files = ResourceLister.getResourceListing(OGRInfo.class, encRootSubDirPath, new ResourceLister.DefaultResourceFilter(false, true){

                @Override
                public boolean acceptFileResource(String name) {
                    return name.endsWith("000");
                }
            });
            String encSubDirPath = encRootResource + "/" + encRootSubDirs[i];
            for (int j = 0; j < enc000Files.length; ++j) {
                System.out.println(enc000Files[j]);
            }
        }
    }

    private void writeENCObjectsToFile(DataOutputStream stream, List<ENCObject> encObjects) throws IOException {
        for (ENCObject enc : encObjects) {
            ENCObject.write(stream, enc);
        }
    }

    private void prepareOutputDir(File outputDir, boolean clearLocation) throws IOException {
        boolean dirAlreadyExists = outputDir.exists();
        if (!dirAlreadyExists) {
            outputDir.mkdirs();
        }
        if (!outputDir.exists()) {
            throw new IOException("Output folder doesn't exist and can't be created: " + outputDir.getPath());
        }
        if (clearLocation && dirAlreadyExists) {
            File[] _rmContents = outputDir.listFiles();
            for (int i = 0; i < _rmContents.length; ++i) {
                if (_rmContents[i].isDirectory()) continue;
                _rmContents[i].delete();
            }
        }
    }

    public static void main(String[] args) {
        String dataDir = null;
        if (args.length == 0) {
            System.out.println("USAGE: java " + ENCHarvest.class.toString() + " dir");
            System.exit(1);
        } else {
            dataDir = args[0];
        }
        System.out.println("starting from " + dataDir);
        File topLevelOutputDir = new File("output");
        System.out.println("output: " + topLevelOutputDir.getAbsolutePath());
        try {
            ENCHarvest harvest = new ENCHarvest();
            boolean success = harvest.recursivelyConvertEncFiles(topLevelOutputDir, dataDir);
            if (!success) {
                logger.severe("No resources to convert");
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, null, ex);
            System.exit(1);
        }
    }
}

