/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.parser;

import com.metsci.glimpse.charts.vector.parser.ENCMetaObject;
import com.metsci.glimpse.charts.vector.parser.attributes.GenericAttribute;
import com.metsci.glimpse.charts.vector.parser.objects.GenericObject;
import com.metsci.glimpse.util.io.StreamOpener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;

public class ENCAbstractBinder {
    private NavigableMap<String, String> attachments = new TreeMap<String, String>();

    public void resolveDependency(List<GenericObject> objList, String directory) throws IOException {
        Iterator<GenericObject> _iterator = objList.iterator();
        while (_iterator.hasNext()) {
            this.resolveFileDependency(_iterator.next(), directory);
        }
    }

    public void resolveMetaObjects(List<GenericObject> objList) {
        ArrayList<GenericObject> _toRemove = new ArrayList<GenericObject>();
        for (GenericObject _currentObject : objList) {
            if (_currentObject.hasAttribute("OBJL")) continue;
            _toRemove.add(_currentObject);
        }
        for (GenericObject _currentObject : _toRemove) {
            objList.remove(_currentObject);
            System.out.println("creating meta from generic object " + _currentObject);
            GenericObject.linkMetaObject(_currentObject.createMetaObject());
        }
    }

    public List<ENCMetaObject> resolveMetaObjects2(List<GenericObject> objList) {
        ArrayList<ENCMetaObject> metaObjects = new ArrayList<ENCMetaObject>(50);
        Iterator<GenericObject> _iterator = objList.iterator();
        while (_iterator.hasNext()) {
            GenericObject _currentObject = _iterator.next();
            if (_currentObject.hasAttribute("OBJL")) continue;
            metaObjects.add(_currentObject.createMetaObject());
            _iterator.remove();
        }
        return metaObjects;
    }

    private void resolveFileDependency(GenericObject obj, String directory) throws IOException {
        for (GenericAttribute _currentAttribute : obj.getAttributes()) {
            if (!_currentAttribute.getValue().endsWith(".TXT")) continue;
            if (this.attachments.containsKey(_currentAttribute.getValue())) {
                _currentAttribute.setValue((String)this.attachments.get(_currentAttribute.getValue()));
                continue;
            }
            String resource = directory + "/" + _currentAttribute.getValue();
            InputStream inputStream = StreamOpener.fileThenResource.openForRead(resource);
            BufferedReader _fin = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder _fileContents = new StringBuilder();
            String _line = "";
            while ((_line = _fin.readLine()) != null) {
                _fileContents.append(_line + "\n");
            }
            _fin.close();
            this.attachments.put(_currentAttribute.getValue(), _fileContents.toString());
            _currentAttribute.setValue((String)this.attachments.get(_currentAttribute.getValue()));
        }
    }
}

