/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.parser;

import com.metsci.glimpse.charts.vector.parser.DNCAttributeInterpreter;
import com.metsci.glimpse.charts.vector.parser.GenericShape;
import com.metsci.glimpse.charts.vector.parser.attributes.GenericAttribute;
import com.metsci.glimpse.charts.vector.parser.objects.DNCFeatureCode;
import com.metsci.glimpse.charts.vector.parser.objects.DNCObject;
import com.metsci.glimpse.charts.vector.parser.objects.DNCShape;
import com.metsci.glimpse.charts.vector.parser.objects.GenericObject;
import com.metsci.glimpse.charts.vector.parser.objects.GeoShapeType;
import java.io.IOException;

public class DNCObjectInterpreter {
    private final DNCAttributeInterpreter attributeInterpreter;

    public DNCObjectInterpreter(DNCAttributeInterpreter attribInterp) throws IOException {
        this.attributeInterpreter = attribInterp;
    }

    public DNCObject convertObject(GenericObject obj) {
        GenericAttribute attribute = obj.getAttribute("f_code");
        if (attribute == null) {
            return null;
        }
        DNCFeatureCode featureCode = DNCFeatureCode.fromKey(attribute.getValue());
        DNCObject dncObject = new DNCObject(featureCode);
        for (GenericAttribute _currentAttribute : obj.getAttributes()) {
            dncObject.addAttribute(this.attributeInterpreter.convertAttribute(_currentAttribute, obj));
        }
        for (GenericShape shape : obj.getShapes()) {
            dncObject.addShape(this.convertShape(shape));
        }
        return dncObject;
    }

    public DNCShape convertShape(GenericShape shape) {
        DNCShape _retVal = new DNCShape();
        if (shape.getType().equals("POINT")) {
            _retVal.setShapeType(GeoShapeType.Point);
        } else if (shape.getType().equals("POLYGON")) {
            _retVal.setShapeType(GeoShapeType.Polygon);
        } else if (shape.getType().equals("MULTIPOINT")) {
            _retVal.setShapeType(GeoShapeType.Multipoint);
        } else if (shape.getType().equals("LINESTRING")) {
            _retVal.setShapeType(GeoShapeType.Linestring);
        } else {
            throw new IllegalStateException("DNCShape -- Unknown primitive type");
        }
        if (!shape.isEmpty()) {
            _retVal.setPointSize(shape.getPointSize());
            double[] _values = new double[shape.getPointSize() * shape.numCoordinates()];
            int _currentIndex = 0;
            for (int i = 0; i < shape.numCoordinates(); ++i) {
                double[] shapeCoordinate = shape.getCoordinate(i);
                for (int j = 0; j < shapeCoordinate.length; ++j) {
                    _values[_currentIndex] = shapeCoordinate[j];
                    ++_currentIndex;
                }
            }
            _retVal.setVertexPoints(_values);
        }
        return _retVal;
    }
}

