/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.parser;

import com.metsci.glimpse.charts.vector.iteration.DNCComparatorByFeatureName;
import com.metsci.glimpse.charts.vector.parser.OGRInfo;
import com.metsci.glimpse.charts.vector.parser.OGRReader;
import com.metsci.glimpse.charts.vector.parser.OGRToDNCParser;
import com.metsci.glimpse.charts.vector.parser.ResourceLister;
import com.metsci.glimpse.charts.vector.parser.objects.DNCObject;
import com.metsci.glimpse.charts.vector.parser.objects.GenericObject;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DNCHarvest {
    private static Logger logger = Logger.getLogger(DNCHarvest.class.toString());
    private static String consoleLogSuffix = "-console.txt";
    private static LibraryType[] allLibraryTypes = LibraryType.values();
    private OGRToDNCParser dncConverter = new OGRToDNCParser();
    private boolean clearDumpLocation = false;

    public boolean recursivelyConvertDncFiles(File topLevelOutputDir, String dataHome) throws IOException, URISyntaxException, InterruptedException {
        System.out.println("dataHome: " + dataHome);
        String[] resources = ResourceLister.getRecursiveResourceListing(DNCHarvest.class, dataHome, new ResourceLister.DefaultResourceFilter(false, true){

            @Override
            public boolean acceptFileResource(String name) {
                return name.endsWith("lat");
            }
        });
        if (resources != null) {
            for (String latFile : resources) {
                int slashIndex = latFile.lastIndexOf("/");
                if (slashIndex == -1) continue;
                String dncDir = latFile.substring(0, slashIndex);
                this.convertDncDB(topLevelOutputDir, dncDir);
            }
            return true;
        }
        return false;
    }

    public void convertDncDB(File topLevelOutputDir, String dncRootResource) throws IOException, URISyntaxException, InterruptedException {
        this.convertDncFile(topLevelOutputDir, dncRootResource, LibraryType.values());
    }

    public void convertDncFile(File topLevelOutputDir, String dncRootResource, LibraryType ... libraryTypes) throws IOException, URISyntaxException, InterruptedException {
        int slashIndex = dncRootResource.lastIndexOf("/");
        if (slashIndex == -1) {
            return;
        }
        String outputSubDirName = dncRootResource.substring(slashIndex + 1);
        File dataLevelOutputDir = new File(topLevelOutputDir, outputSubDirName);
        this.prepareOutputDir(dataLevelOutputDir, this.clearDumpLocation);
        String outputFileRootName = this.createDNCOutputFileRootName(outputSubDirName, libraryTypes);
        File gdalDumpFile = new File(dataLevelOutputDir, outputFileRootName + consoleLogSuffix);
        System.out.println("writing to " + gdalDumpFile.getAbsolutePath());
        OGRInfo ogrInfo = new OGRInfo(gdalDumpFile);
        LibraryResourceFilter filter = new LibraryResourceFilter(libraryTypes);
        String[] dncRootSubDirs = ResourceLister.getResourceListing(OGRInfo.class, dncRootResource, filter);
        HashSet<String> filesDumpedSet = new HashSet<String>(dncRootSubDirs.length);
        for (int i = 0; i < dncRootSubDirs.length; ++i) {
            String dncRootSubDirCanonicalPath;
            boolean newToProcess;
            String dncRootSubDirPath = dncRootResource + '/' + dncRootSubDirs[i];
            File dncRootSubDirFile = new File(dncRootSubDirPath);
            if (dncRootSubDirFile.exists() && !(newToProcess = filesDumpedSet.add(dncRootSubDirCanonicalPath = dncRootSubDirFile.getCanonicalPath()))) continue;
            ogrInfo.addDNCGeoSource(dncRootSubDirPath);
        }
        List<GenericObject> obList = ogrInfo.parse();
        ArrayList<DNCObject> dncObjects = new ArrayList<DNCObject>(obList.size());
        this.dncConverter.parseDNC(null, obList, dncObjects);
        File metsciOutFile = new File(dataLevelOutputDir, outputFileRootName + ".dnc");
        DataOutputStream metsciOutStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(metsciOutFile)));
        this.writeDNCObjectsToFile(metsciOutStream, dncObjects);
        metsciOutStream.close();
    }

    public void createDNCFileFromOGRInfoConsoleFile(File gdalConsoleFile) throws IOException {
        String consoleLogName = gdalConsoleFile.getName();
        String dncFileName = null;
        dncFileName = consoleLogName.endsWith(consoleLogSuffix) ? consoleLogName.substring(0, consoleLogName.length() - consoleLogSuffix.length()) + ".dnc" : gdalConsoleFile + ".dnc";
        File metsciOutFile = new File(gdalConsoleFile.getParentFile(), dncFileName);
        this.createDNCFileFromOGRInfoConsoleFile(gdalConsoleFile, metsciOutFile);
    }

    public void createDNCFileFromOGRInfoConsoleFile(File gdalConsoleFile, File metsciOutFile) throws IOException {
        List<GenericObject> genericObjects = OGRReader.read(gdalConsoleFile);
        ArrayList<DNCObject> dncObjects = new ArrayList<DNCObject>(genericObjects.size());
        this.dncConverter.parseDNC(null, genericObjects, dncObjects);
        DataOutputStream metsciOutStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(metsciOutFile)));
        this.writeDNCObjectsToFile(metsciOutStream, dncObjects);
        metsciOutStream.close();
    }

    private String createDNCOutputFileRootName(String outputSubDirName, LibraryType[] libraryTypes) {
        StringBuilder sb = new StringBuilder();
        EnumSet<LibraryType> librariesIncluded = EnumSet.noneOf(LibraryType.class);
        for (LibraryType type : libraryTypes) {
            boolean added = librariesIncluded.add(type);
            if (!added) continue;
            sb.append("-");
            sb.append(type.name().toLowerCase());
        }
        if (librariesIncluded.size() == allLibraryTypes.length) {
            return outputSubDirName + "-all";
        }
        return outputSubDirName + sb.toString();
    }

    private void writeDNCObjectsToFile(DataOutputStream stream, List<DNCObject> dncObjects) throws IOException {
        Collections.sort(dncObjects, new DNCComparatorByFeatureName());
        for (DNCObject DNC : dncObjects) {
            DNCObject.write(stream, DNC);
        }
    }

    private void prepareOutputDir(File outputDir, boolean clearLocation) throws IOException {
        boolean dirAlreadyExists = outputDir.exists();
        if (!dirAlreadyExists) {
            outputDir.mkdirs();
        }
        if (!outputDir.exists()) {
            throw new IOException("Output folder doesn't exist and can't be created: " + outputDir.getPath());
        }
        if (clearLocation && dirAlreadyExists) {
            File[] _rmContents = outputDir.listFiles();
            for (int i = 0; i < _rmContents.length; ++i) {
                if (_rmContents[i].isDirectory()) continue;
                _rmContents[i].delete();
            }
        }
    }

    public static void specialBatch() {
        String topLevelDataDir = "/home/john/Downloads/dnc/";
        System.out.println("starting from " + topLevelDataDir);
        File topLevelOutputDir = new File("output");
        System.out.println("output: " + topLevelOutputDir.getAbsolutePath());
        for (int i = 9; i < 12; ++i) {
            if (i == 10) continue;
            String dataDir = String.format("%sdnc%02d", topLevelDataDir, i);
            for (LibraryType libraryType : LibraryType.values()) {
                try {
                    System.out.println("==> working on " + (Object)((Object)libraryType) + " @" + dataDir);
                    DNCHarvest harvest = new DNCHarvest();
                    harvest.convertDncFile(topLevelOutputDir, dataDir, libraryType);
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, null, ex);
                    System.exit(1);
                }
            }
        }
    }

    public static void main(String[] args) {
        String dataDir = null;
        dataDir = args.length == 0 ? "/home/john/Downloads/dnc/dnc10" : args[0];
        System.out.println("starting from " + dataDir);
        File topLevelOutputDir = new File("output");
        System.out.println("output: " + topLevelOutputDir.getAbsolutePath());
        try {
            DNCHarvest harvest = new DNCHarvest();
            harvest.convertDncFile(topLevelOutputDir, dataDir, LibraryType.Harbor);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, null, ex);
            System.exit(1);
        }
    }

    static class LibraryResourceFilter
    extends ResourceLister.DefaultResourceFilter
    implements ResourceLister.ResourceFilter {
        private LibraryType[] libraries;

        public LibraryResourceFilter(LibraryType ... libraries) {
            super(true, false);
            this.libraries = libraries;
        }

        @Override
        public boolean acceptDirResource(String name) {
            for (LibraryType libraryType : this.libraries) {
                if (!libraryType.qualify(name)) continue;
                return true;
            }
            return false;
        }
    }

    public static enum LibraryType {
        Harbor("h", 7),
        Coastal("coa", 3),
        General("gen", 2, 3),
        Approach("a", 7);

        private String prefix;
        private int nonPrefixMinLength;
        private int nonPrefixMaxLength;

        private LibraryType(String prefix, int nonprefixLength) {
            this(prefix, nonprefixLength, nonprefixLength);
        }

        private LibraryType(String prefix, int nonPrefixMinLength, int nonPrefixMaxLength) {
            this.prefix = prefix;
            this.nonPrefixMinLength = nonPrefixMinLength;
            this.nonPrefixMaxLength = nonPrefixMaxLength;
        }

        public boolean qualify(String candidate) {
            if (candidate.isEmpty()) {
                return false;
            }
            int candidateNonprefixLength = candidate.length() - this.prefix.length();
            if (candidateNonprefixLength < this.nonPrefixMinLength || candidateNonprefixLength > this.nonPrefixMaxLength) {
                return false;
            }
            String candidatePrefix = candidate.substring(0, this.prefix.length());
            return candidatePrefix.equalsIgnoreCase(this.prefix);
        }
    }
}

