/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.parser;

import com.metsci.glimpse.charts.vector.parser.attributes.DNCAbstractAttribute;
import com.metsci.glimpse.charts.vector.parser.attributes.DNCFloatAttribute;
import com.metsci.glimpse.charts.vector.parser.attributes.DNCFreeAttribute;
import com.metsci.glimpse.charts.vector.parser.attributes.DNCIntAttribute;
import com.metsci.glimpse.charts.vector.parser.attributes.GenericAttribute;
import com.metsci.glimpse.charts.vector.parser.objects.DNCAttributeType;
import com.metsci.glimpse.charts.vector.parser.objects.GenericObject;
import java.util.logging.Logger;

public class DNCAttributeInterpreter {
    private static Logger logger = Logger.getLogger(DNCAttributeInterpreter.class.toString());

    public DNCAbstractAttribute convertAttribute(GenericAttribute attrib, GenericObject obj) {
        DNCAttributeType attributeType = DNCAttributeType.getInstance(attrib.getName());
        String value = this.getNullAdjValue(attrib.getValue());
        DNCAbstractAttribute attribute = null;
        if (attrib.getType().equals("(Integer)")) {
            attribute = new DNCIntAttribute(attributeType, value);
        } else if (attrib.getType().equals("(String)")) {
            attribute = new DNCFreeAttribute(attributeType, value);
        } else if (attrib.getType().equals("(Real)")) {
            attribute = new DNCFloatAttribute(attributeType, value);
        } else {
            throw new IllegalStateException("Unknown type for attribute " + attrib);
        }
        return attribute;
    }

    private String getNullAdjValue(String value) {
        if (value == null) {
            return null;
        }
        if (value.equals("(null)")) {
            return null;
        }
        return value;
    }
}

