/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.parser;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.text.ParseException;
import java.util.List;

public class CsvTokenizer {
    LineNumberReader lnr;
    StringBuilder sb = null;

    public CsvTokenizer(Reader stream) {
        this.lnr = new LineNumberReader(stream);
        this.sb = new StringBuilder(500);
    }

    private static void addSpaces(StringBuilder sb, int spaces) {
        for (int i = 0; i < spaces; ++i) {
            sb.append(" ");
        }
    }

    public void close() throws IOException {
        this.lnr.close();
    }

    public int getLineNumber() {
        return this.lnr.getLineNumber();
    }

    public boolean readStringList(List<String> result) throws IOException, ParseException {
        String line;
        result.clear();
        PARSERSTATE state = PARSERSTATE.NORMAL;
        int quote = 34;
        int delim = 44;
        do {
            if ((line = this.lnr.readLine()) != null) continue;
            return false;
        } while (line.length() == 0);
        line = line + "\n";
        this.sb.delete(0, this.sb.length());
        int p = 0;
        int linenoQuoteState = -1;
        int potentialSpaces = 0;
        while (true) {
            char c = line.charAt(p);
            switch (state) {
                case NORMAL: {
                    if (c == ',') {
                        result.add(this.sb.toString());
                        this.sb.delete(0, this.sb.length());
                        potentialSpaces = 0;
                        break;
                    }
                    if (c == ' ') {
                        if (this.sb.length() <= 0) break;
                        ++potentialSpaces;
                        break;
                    }
                    if (c == '\n') {
                        result.add(this.sb.toString());
                        return true;
                    }
                    if (c == '\"') {
                        if (this.sb.length() == 0) {
                            state = PARSERSTATE.QUOTESCOPE;
                            linenoQuoteState = this.getLineNumber();
                            break;
                        }
                        if (line.charAt(p + 1) == '\"' && this.sb.length() > 0) {
                            CsvTokenizer.addSpaces(this.sb, potentialSpaces);
                            potentialSpaces = 0;
                            this.sb.append(c);
                            ++p;
                            break;
                        }
                        if (line.charAt(p + 1) == '\"') break;
                        state = PARSERSTATE.QUOTESCOPE;
                        linenoQuoteState = this.getLineNumber();
                        CsvTokenizer.addSpaces(this.sb, potentialSpaces);
                        potentialSpaces = 0;
                        break;
                    }
                    CsvTokenizer.addSpaces(this.sb, potentialSpaces);
                    potentialSpaces = 0;
                    this.sb.append(c);
                    break;
                }
                case QUOTESCOPE: {
                    if (c == '\n') {
                        this.sb.append('\n');
                        p = -1;
                        line = this.lnr.readLine();
                        if (line == null) {
                            throw new ParseException("File ended unexpectedly while reading a quoted cell starting on line ", linenoQuoteState);
                        }
                        line = line + '\n';
                        break;
                    }
                    if (c == '\"') {
                        if (line.charAt(p + 1) == '\"') {
                            this.sb.append(c);
                            ++p;
                            break;
                        }
                        state = PARSERSTATE.NORMAL;
                        break;
                    }
                    this.sb.append(c);
                    break;
                }
                default: {
                    throw new RuntimeException("this can never happen!");
                }
            }
            ++p;
        }
    }

    static enum PARSERSTATE {
        NORMAL,
        QUOTESCOPE;

    }
}

