/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.painter;

import com.metsci.glimpse.charts.vector.display.xmlgen.ColorSpec;
import com.metsci.glimpse.charts.vector.display.xmlgen.FeatureSpec;
import com.metsci.glimpse.charts.vector.display.xmlgen.PainterSpec;
import com.metsci.glimpse.charts.vector.display.xmlgen.PolygonPainterSpec;
import com.metsci.glimpse.charts.vector.display.xmlgen.ShapeSpec;
import com.metsci.glimpse.charts.vector.display.xmlgen.ShapeTypeSpec;
import com.metsci.glimpse.charts.vector.display.xmlgen.TrackPainterSpec;
import com.metsci.glimpse.charts.vector.parser.objects.ENCObject;
import com.metsci.glimpse.charts.vector.parser.objects.ENCShape;
import com.metsci.glimpse.charts.vector.parser.objects.GeoObject;
import com.metsci.glimpse.charts.vector.parser.objects.GeoShape;
import com.metsci.glimpse.painter.track.Point;
import com.metsci.glimpse.support.polygon.Polygon;
import com.metsci.glimpse.util.geo.LatLonGeo;
import com.metsci.glimpse.util.geo.projection.GeoProjection;
import com.metsci.glimpse.util.vector.Vector2d;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class EncPainterUtils {
    private static Logger logger = Logger.getLogger(EncPainterUtils.class.toString());

    private EncPainterUtils() {
        throw new IllegalStateException();
    }

    public static float[][] convertEncVertexesToLonLatFloatVertexes(double[] encVertexes, boolean connectLastToFirst) {
        assert (encVertexes.length % 2 == 0);
        int dimSize = encVertexes.length / 2;
        if (connectLastToFirst) {
            ++dimSize;
        }
        float[] x = new float[dimSize];
        float[] y = new float[dimSize];
        int j = 0;
        int i = 1;
        while (i < encVertexes.length) {
            x[j] = (float)encVertexes[i - 1];
            y[j] = (float)encVertexes[i];
            i += 2;
            ++j;
        }
        if (connectLastToFirst) {
            x[j] = (float)encVertexes[0];
            y[j] = (float)encVertexes[1];
        }
        return new float[][]{x, y};
    }

    public static boolean validateLongitude(double longitude) {
        return Math.abs(longitude) < 182.0;
    }

    public static boolean validateLatitude(double latitude) {
        return Math.abs(latitude) < 91.0;
    }

    public static float[][] convertEncVertexesToXYVertexes(GeoProjection projection, ENCShape shape) {
        assert (shape.passSanityCheck());
        if (!shape.passSanityCheck()) {
            return new float[0][0];
        }
        int numCoords = shape.getNumCoordinates();
        float[] x = new float[numCoords];
        float[] y = new float[numCoords];
        for (int i = 0; i < numCoords; ++i) {
            double lon = shape.getVertex(0, i);
            if (!EncPainterUtils.validateLongitude(lon)) {
                logger.info("Ignoring bad longitude " + lon);
                continue;
            }
            double lat = shape.getVertex(1, i);
            if (!EncPainterUtils.validateLatitude(lat)) {
                logger.info("Ignoring bad latitude " + lat);
                continue;
            }
            Vector2d vector = projection.project(LatLonGeo.fromDeg((double)lat, (double)lon));
            x[i] = (float)vector.getX();
            y[i] = (float)vector.getY();
        }
        return new float[][]{x, y};
    }

    public static double[] convertEncVertexesToSingleXYArray(GeoProjection projection, ENCShape shape) {
        assert (shape.passSanityCheck());
        if (!shape.passSanityCheck()) {
            return new double[0];
        }
        int numVertexes = shape.getNumCoordinates();
        double[] xy = new double[numVertexes * 2];
        int xyIndex = 0;
        for (int vertexIndex = 0; vertexIndex < numVertexes; ++vertexIndex) {
            double lon = shape.getVertex(0, vertexIndex);
            if (!EncPainterUtils.validateLongitude(lon)) {
                logger.info("Ignoring bad longitude " + lon);
                continue;
            }
            double lat = shape.getVertex(1, vertexIndex);
            if (!EncPainterUtils.validateLatitude(lat)) {
                logger.info("Ignoring bad latitude " + lat);
                continue;
            }
            Vector2d vector = projection.project(LatLonGeo.fromDeg((double)lat, (double)lon));
            xy[xyIndex++] = vector.getX();
            xy[xyIndex++] = vector.getY();
        }
        return xy;
    }

    public static double[] convertGeoVertexesToSingleXYArray(GeoProjection projection, GeoShape shape) {
        int numVertexes = shape.getNumCoordinates();
        double[] xy = new double[numVertexes * 2];
        int xyIndex = 0;
        for (int vertexIndex = 0; vertexIndex < numVertexes; ++vertexIndex) {
            double lon = shape.getVertex(0, vertexIndex);
            if (!EncPainterUtils.validateLongitude(lon)) {
                logger.info("Ignoring bad longitude " + lon);
                continue;
            }
            double lat = shape.getVertex(1, vertexIndex);
            if (!EncPainterUtils.validateLatitude(lat)) {
                logger.info("Ignoring bad latitude " + lat);
                continue;
            }
            Vector2d vector = projection.project(LatLonGeo.fromDeg((double)lat, (double)lon));
            xy[xyIndex++] = vector.getX();
            xy[xyIndex++] = vector.getY();
        }
        return xy;
    }

    public static Polygon convertEncVertexesToPolgon(GeoProjection projection, ENCObject object) {
        Polygon p = new Polygon();
        List<ENCShape> shapeList = object.getShapeList();
        if (shapeList.isEmpty()) {
            return p;
        }
        ENCShape outerShape = shapeList.get(0);
        int outerVertexCount = outerShape.getNumCoordinates();
        Polygon.Loop.LoopBuilder loopBuilder1 = new Polygon.Loop.LoopBuilder();
        double[] outerXYVertices = EncPainterUtils.convertEncVertexesToSingleXYArray(projection, outerShape);
        loopBuilder1.addVertices(outerXYVertices, outerVertexCount);
        p.add(loopBuilder1.complete(Polygon.Interior.onLeft));
        for (int shapeIndex = 1; shapeIndex < shapeList.size(); ++shapeIndex) {
            ENCShape innerShape = shapeList.get(shapeIndex);
            int innerVertexCount = innerShape.getNumCoordinates();
            Polygon.Loop.LoopBuilder loopBuilder2 = new Polygon.Loop.LoopBuilder();
            double[] innerXYVertices = EncPainterUtils.convertEncVertexesToSingleXYArray(projection, innerShape);
            loopBuilder2.addVertices(EncPainterUtils.reverseXYArray(innerXYVertices), innerVertexCount);
            p.add(loopBuilder2.complete(Polygon.Interior.onLeft));
        }
        return p;
    }

    public static Polygon convertGeoVertexesToPolgon(GeoProjection projection, GeoObject object) {
        Polygon p = new Polygon();
        Collection<? extends GeoShape> shapeList = object.getGeoShapes();
        if (shapeList.isEmpty()) {
            return p;
        }
        Iterator<? extends GeoShape> shapeIt = shapeList.iterator();
        GeoShape outerShape = shapeIt.next();
        int outerVertexCount = outerShape.getNumCoordinates();
        Polygon.Loop.LoopBuilder loopBuilder1 = new Polygon.Loop.LoopBuilder();
        double[] outerXYVertices = EncPainterUtils.convertGeoVertexesToSingleXYArray(projection, outerShape);
        loopBuilder1.addVertices(outerXYVertices, outerVertexCount);
        p.add(loopBuilder1.complete(Polygon.Interior.onLeft));
        while (shapeIt.hasNext()) {
            GeoShape innerShape = shapeIt.next();
            int innerVertexCount = innerShape.getNumCoordinates();
            Polygon.Loop.LoopBuilder loopBuilder2 = new Polygon.Loop.LoopBuilder();
            double[] innerXYVertices = EncPainterUtils.convertGeoVertexesToSingleXYArray(projection, innerShape);
            loopBuilder2.addVertices(EncPainterUtils.reverseXYArray(innerXYVertices), innerVertexCount);
            p.add(loopBuilder2.complete(Polygon.Interior.onLeft));
        }
        return p;
    }

    private static double[] reverseXYArray(double[] array) {
        double[] reversed = new double[array.length];
        int j = array.length - 1;
        int i = 1;
        while (i < array.length) {
            reversed[i - 1] = array[j - 1];
            reversed[i] = array[j];
            i += 2;
            j -= 2;
        }
        return reversed;
    }

    public static List<Point> convertEncVertexesToPoints(GeoProjection projection, ENCShape shape, int trackId) {
        assert (shape.passSanityCheck());
        if (!shape.passSanityCheck()) {
            return Collections.emptyList();
        }
        int numCoords = shape.getNumCoordinates();
        ArrayList<Point> points = new ArrayList<Point>(numCoords + 1);
        for (int i = 0; i < numCoords; ++i) {
            double lon = shape.getVertex(0, i);
            if (!EncPainterUtils.validateLongitude(lon)) {
                logger.info("Ignoring bad longitude " + lon);
                continue;
            }
            double lat = shape.getVertex(1, i);
            if (!EncPainterUtils.validateLatitude(lat)) {
                logger.info("Ignoring bad latitude " + lat);
                continue;
            }
            Vector2d vector = projection.project(LatLonGeo.fromDeg((double)lat, (double)lon));
            points.add(new Point(trackId, i, vector.getX(), vector.getY(), (long)i));
        }
        return points;
    }

    public static List<Point> convertGeoVertexesToPoints(GeoProjection projection, GeoShape shape, int trackId) {
        int numCoords = shape.getNumCoordinates();
        ArrayList<Point> points = new ArrayList<Point>(numCoords + 1);
        for (int i = 0; i < numCoords; ++i) {
            double lon = shape.getVertex(0, i);
            if (!EncPainterUtils.validateLongitude(lon)) {
                logger.info("Ignoring bad longitude " + lon);
                continue;
            }
            double lat = shape.getVertex(1, i);
            if (!EncPainterUtils.validateLatitude(lat)) {
                logger.info("Ignoring bad latitude " + lat);
                continue;
            }
            Vector2d vector = projection.project(LatLonGeo.fromDeg((double)lat, (double)lon));
            points.add(new Point(trackId, i, vector.getX(), vector.getY(), (long)i));
        }
        return points;
    }

    public static float[] convertColorSpecToFloatArray(ColorSpec color) {
        if (color.getR() > 1.0f || color.getG() > 1.0f || color.getB() > 1.0f || color.getA() > 1.0f) {
            return new float[]{color.getR() / 255.0f, color.getG() / 255.0f, color.getB() / 255.0f, color.getA() / 255.0f};
        }
        return new float[]{color.getR(), color.getG(), color.getB(), color.getA()};
    }

    public static ColorSpec convertFloatsToColorSpec(float r, float g, float b, float a) {
        ColorSpec color = new ColorSpec();
        color.setR(r);
        color.setG(g);
        color.setB(b);
        color.setA(a);
        return color;
    }

    public static ColorSpec convertFloatArrayToColorSpec(float[] rgba) {
        ColorSpec color = new ColorSpec();
        color.setR(rgba[0]);
        color.setG(rgba[1]);
        color.setB(rgba[2]);
        color.setA(rgba[3]);
        return color;
    }

    public static FeatureSpec createEnc(String objectType, ShapeSpec polyShape, ShapeSpec ... shapes) {
        FeatureSpec enc = new FeatureSpec();
        List<String> objectTypeList = enc.getFeaturetype();
        objectTypeList.add(objectType);
        List<ShapeSpec> shapeList = enc.getShapespec();
        shapeList.addAll(Arrays.asList(shapes));
        return enc;
    }

    public static FeatureSpec createEnc(String[] featureTypes, ShapeSpec polyShape, ShapeSpec ... shapes) {
        FeatureSpec enc = new FeatureSpec();
        List<String> objectTypeList = enc.getFeaturetype();
        objectTypeList.addAll(Arrays.asList(featureTypes));
        List<ShapeSpec> shapeList = enc.getShapespec();
        shapeList.addAll(Arrays.asList(shapes));
        return enc;
    }

    public static ShapeSpec createShape(ShapeTypeSpec shapeType, TrackPainterSpec trackSpec) {
        PainterSpec painterSpec = new PainterSpec();
        painterSpec.getPolygonpainterspecOrTrackpainterspecOrAnnotationpainterspec().add(trackSpec);
        ShapeSpec shape = new ShapeSpec();
        shape.setShapetypespec(shapeType);
        shape.setPainterspec(painterSpec);
        return shape;
    }

    public static ShapeSpec createShape(ShapeTypeSpec shapeType, PolygonPainterSpec polySpec) {
        PainterSpec painterSpec = new PainterSpec();
        painterSpec.getPolygonpainterspecOrTrackpainterspecOrAnnotationpainterspec().add(polySpec);
        ShapeSpec shape = new ShapeSpec();
        shape.setShapetypespec(shapeType);
        shape.setPainterspec(painterSpec);
        return shape;
    }
}

