/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.painter;

import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.charts.vector.display.ContentHandler;
import com.metsci.glimpse.charts.vector.display.GeoContext;
import com.metsci.glimpse.charts.vector.display.Skin;
import com.metsci.glimpse.charts.vector.parser.GeoReader;
import com.metsci.glimpse.charts.vector.parser.objects.GeoObject;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.base.GlimpsePainter2D;
import com.metsci.glimpse.painter.base.GlimpsePainterImpl;
import com.metsci.glimpse.painter.group.DelegatePainter;
import com.metsci.glimpse.painter.info.AnnotationPainter;
import com.metsci.glimpse.painter.shape.PolygonPainter;
import com.metsci.glimpse.painter.track.TrackPainter;
import com.metsci.glimpse.support.settings.LookAndFeel;
import com.metsci.glimpse.util.geo.LatLonGeo;
import com.metsci.glimpse.util.geo.projection.GeoProjection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class EncChartPainter<V extends GeoObject>
extends GlimpsePainter2D {
    private static final double metersToNauticalMiles = 5.39E-4;
    private static final double[] defaultAnnotationZoomRangesInNM = new double[]{0.0, 40.0, 60.0, 80.0, 100.0};
    private GeoProjection projection;
    private PolygonPainter polygonPainter;
    private TrackPainter trackPainter;
    private AnnotationPaintersByZoomLevel annotationPainters;
    private List<Skin<V>> skins;
    private GeoContext encContext;
    private boolean zoomAdjustDisplay = true;
    private DelegatePainter delegate;

    public EncChartPainter(GeoProjection projection, Skin<V> skin) {
        this(projection, defaultAnnotationZoomRangesInNM, Collections.singletonList(skin));
    }

    public EncChartPainter(GeoProjection projection, final Skin<V> skin1, final Skin<V> skin2) {
        this(projection, defaultAnnotationZoomRangesInNM, new ArrayList<Skin<V>>(){
            {
                this.add(skin1);
                this.add(skin2);
            }
        });
    }

    public EncChartPainter(GeoProjection projection, List<Skin<V>> skins) {
        this(projection, defaultAnnotationZoomRangesInNM, skins);
    }

    public EncChartPainter(GeoProjection projection, double[] annotationZoomRangesInNM, List<Skin<V>> skins) {
        this.skins = skins;
        this.delegate = new DelegatePainter();
        this.polygonPainter = new PolygonPainter();
        this.addPainter((GlimpsePainter)this.polygonPainter);
        this.trackPainter = new TrackPainter();
        this.addPainter((GlimpsePainter)this.trackPainter);
        this.annotationPainters = new AnnotationPaintersByZoomLevel(this.delegate, annotationZoomRangesInNM);
        this.encContext = new GeoContext(projection, this.polygonPainter, this.trackPainter, null);
        this.projection = projection;
    }

    public void addPainter(GlimpsePainter painter) {
        this.delegate.addPainter(painter);
    }

    public void removePainter(GlimpsePainter painter) {
        this.delegate.removePainter(painter);
    }

    public void setLookAndFeel(LookAndFeel laf) {
        super.setLookAndFeel(laf);
        this.delegate.setLookAndFeel(laf);
    }

    public void paintTo(GlimpseContext context, GlimpseBounds bounds, Axis2D axis) {
        double viewLevel = this.determineViewLevel(axis);
        this.annotationPainters.setPainterVisibilityAtViewLevel(viewLevel);
        this.delegate.paintTo(context);
    }

    public void clearAll() {
        this.polygonPainter.deleteAll();
        this.trackPainter.deleteAll();
        this.annotationPainters.clearPainterData();
        for (Skin<V> skin : this.skins) {
            skin.reset();
        }
    }

    public void changeSkins(Iterator<V> encIterator, List<Skin<V>> skins) throws Exception {
        this.clearAll();
        this.skins = skins;
        this.addENCObjects(encIterator);
    }

    public void addENCObjects(GeoReader<V> reader) {
        Collection<V> encCollection = reader.getCollection();
        for (GeoObject encObject : encCollection) {
            this.addENCObject(encObject);
        }
    }

    public void addENCObjects(Iterator<V> encIterator) throws Exception {
        while (encIterator.hasNext()) {
            GeoObject encObject = (GeoObject)encIterator.next();
            this.addENCObject(encObject);
        }
    }

    public void addENCObject(V encObject) {
        List<Object> contentHandlers = Collections.emptyList();
        for (int skinIndex = 0; skinIndex < this.skins.size() && contentHandlers.isEmpty(); ++skinIndex) {
            contentHandlers = this.skins.get(skinIndex).getHandlersForGeoObject(encObject);
        }
        for (ContentHandler contentHandler : contentHandlers) {
            AnnotationPainter annotationPainter;
            Integer scaledMin = contentHandler.getScaleMin(encObject);
            Double scaledMinDouble = null;
            if (scaledMin != null) {
                scaledMinDouble = scaledMin.doubleValue() / 100000.0;
            }
            if ((annotationPainter = (AnnotationPainter)this.annotationPainters.getPainterAtViewLevel(scaledMinDouble)) == null) continue;
            this.encContext.setAnnotationPainter(annotationPainter);
            contentHandler.paintEnc(this.encContext, encObject);
        }
    }

    public void dispose(GlimpseContext context) {
        super.dispose(context);
        this.delegate.dispose(context);
        this.polygonPainter.dispose(context);
        this.trackPainter.dispose(context);
        this.annotationPainters.dispose(context);
    }

    public void setZoomAdjustedDisplay(boolean enable) {
        this.zoomAdjustDisplay = enable;
    }

    private double determineViewLevel(Axis2D axis) {
        if (!this.zoomAdjustDisplay) {
            return 1.0E-5;
        }
        LatLonGeo maxLL = this.projection.unproject(axis.getAxisX().getMax(), axis.getAxisY().getMax());
        LatLonGeo minLL = this.projection.unproject(axis.getAxisX().getMin(), axis.getAxisY().getMin());
        double distNM = maxLL.getDistanceTo(minLL) * 5.39E-4;
        return distNM;
    }

    private static abstract class PaintersByZoomLevel<V extends GlimpsePainterImpl> {
        private NavigableMap<Double, V> painterMap = new TreeMap<Double, V>();

        public PaintersByZoomLevel(DelegatePainter parent, double[] viewLevelsInNM) {
            for (double lowerZoomRange : viewLevelsInNM) {
                V painter = this.instantiatePainter();
                parent.addPainter(painter);
                this.painterMap.put(lowerZoomRange, painter);
            }
        }

        public void setPainterVisibilityAtViewLevel(double viewLevelInNM) {
            Double visibleThreshold = this.painterMap.lowerKey(viewLevelInNM);
            NavigableMap<Double, V> visiblePainterMap = this.painterMap.tailMap(visibleThreshold, true);
            this.internalSetVisibility(visiblePainterMap.values(), true);
            NavigableMap<Double, V> nonVisiblePainterMap = this.painterMap.headMap(visibleThreshold, false);
            this.internalSetVisibility(nonVisiblePainterMap.values(), false);
        }

        public V getPainterAtViewLevel(Double viewLevelInNM) {
            Map.Entry<Double, V> entry = null;
            entry = viewLevelInNM == null ? this.painterMap.lastEntry() : this.painterMap.lowerEntry(viewLevelInNM);
            GlimpsePainterImpl painter = null;
            if (entry != null) {
                painter = (GlimpsePainterImpl)entry.getValue();
            }
            return (V)painter;
        }

        public void clearPainterData() {
            for (GlimpsePainterImpl painter : this.painterMap.values()) {
                this.clearPainterData(painter);
            }
        }

        public void dispose(GlimpseContext context) {
            for (GlimpsePainterImpl painter : this.painterMap.values()) {
                painter.dispose(context);
            }
        }

        private void internalSetVisibility(Collection<V> painters, boolean visible) {
            for (GlimpsePainterImpl painter : painters) {
                painter.setVisible(visible);
            }
        }

        protected abstract V instantiatePainter();

        protected abstract void clearPainterData(V var1);
    }

    private static class AnnotationPaintersByZoomLevel
    extends PaintersByZoomLevel<AnnotationPainter> {
        public AnnotationPaintersByZoomLevel(DelegatePainter parent, double[] viewLevelsInNM) {
            super(parent, viewLevelsInNM);
        }

        @Override
        protected AnnotationPainter instantiatePainter() {
            return new AnnotationPainter();
        }

        @Override
        protected void clearPainterData(AnnotationPainter annotationPainter) {
            annotationPainter.clearAnnotations();
        }
    }
}

