/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.iteration;

import com.metsci.glimpse.charts.vector.iteration.GeoFilter;
import com.metsci.glimpse.charts.vector.iteration.GeoObjectIterator;
import com.metsci.glimpse.charts.vector.iteration.StreamToGeoObjectConverter;
import com.metsci.glimpse.charts.vector.iteration.UncheckedIOException;
import com.metsci.glimpse.charts.vector.parser.objects.GeoObject;
import com.metsci.glimpse.util.io.StreamOpener;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class GeoStreamIterator<V extends GeoObject>
implements GeoObjectIterator<V>,
Iterator<V> {
    private static final Logger logger = Logger.getLogger(GeoStreamIterator.class.getName());
    private List<InputStream> sourceStreamList;
    private List<GeoFilter<V>> filterList;
    private DataInputStream dis;
    private V next = null;
    private int fileIndex = -1;
    private int recordIndex = -1;
    private StreamToGeoObjectConverter<V> streamConverter;

    public GeoStreamIterator(String resources, StreamToGeoObjectConverter<V> loader) throws IOException {
        BufferedInputStream inputStream = new BufferedInputStream(StreamOpener.fileThenResource.openForRead(resources));
        this.sourceStreamList = Collections.singletonList(inputStream);
        this.filterList = new ArrayList<GeoFilter<V>>();
        this.streamConverter = loader;
        this.init();
    }

    public GeoStreamIterator(InputStream inputStream, StreamToGeoObjectConverter<V> loader) throws IOException {
        this.sourceStreamList = Collections.singletonList(inputStream);
        this.filterList = new ArrayList<GeoFilter<V>>();
        this.streamConverter = loader;
        this.init();
    }

    public GeoStreamIterator(StreamToGeoObjectConverter<V> loader, InputStream ... streams) throws IOException {
        this.sourceStreamList = new ArrayList<InputStream>(streams.length);
        this.filterList = new ArrayList<GeoFilter<V>>();
        this.streamConverter = loader;
        this.init();
    }

    public void addFilter(GeoFilter<V> filter) {
        this.filterList.add(filter);
    }

    public void clearFilters() {
        this.filterList.clear();
    }

    public void init() throws IOException {
        this.next = null;
        this.fileIndex = -1;
        this.recordIndex = -1;
        this.nextFile();
        this.next = this.internalNext();
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public V next() {
        try {
            V current = this.next;
            this.next = this.internalNext();
            return current;
        }
        catch (IOException ie) {
            throw new UncheckedIOException(ie);
        }
    }

    @Override
    public V nextGeo() throws IOException {
        V current = this.next;
        this.next = this.internalNext();
        return current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported");
    }

    private V internalNext() throws IOException {
        boolean success;
        V enc = this.nextGeoInFile();
        while (enc == null && (success = this.nextFile())) {
            enc = this.nextGeoInFile();
        }
        return enc;
    }

    private boolean nextFile() throws IOException {
        if (this.dis != null) {
            this.dis.close();
        }
        ++this.fileIndex;
        this.recordIndex = -1;
        if (this.fileIndex >= this.sourceStreamList.size()) {
            return false;
        }
        this.dis = new DataInputStream(this.sourceStreamList.get(this.fileIndex));
        return true;
    }

    private V nextGeoInFile() throws IOException {
        try {
            int available = this.dis.available();
            while (available > 0) {
                ++this.recordIndex;
                V encObject = this.streamConverter.readNext(this.dis);
                if (this.passFilter(encObject)) {
                    return encObject;
                }
                available = this.dis.available();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return null;
    }

    private boolean passFilter(V object) {
        for (GeoFilter<V> filter : this.filterList) {
            if (filter.passGeoFilter(object)) continue;
            return false;
        }
        return true;
    }
}

