/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.iteration;

import com.metsci.glimpse.charts.vector.iteration.GeoFilter;
import com.metsci.glimpse.charts.vector.iteration.GeoFilterableRecordList;
import com.metsci.glimpse.charts.vector.iteration.GeoObjectIterator;
import com.metsci.glimpse.charts.vector.iteration.StreamToGeoObjectConverter;
import com.metsci.glimpse.charts.vector.parser.objects.GeoObject;
import com.metsci.glimpse.util.io.StreamOpener;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class GeoRecordListForStream<V extends GeoObject>
implements GeoFilterableRecordList<V> {
    private static final Logger logger = Logger.getLogger(GeoRecordListForStream.class.getName());
    private List<V> filteredRecordList;
    private List<V> recordList;

    public GeoRecordListForStream(StreamToGeoObjectConverter<V> streamConverter, String resourceName) throws IOException {
        DataInputStream geoStream = new DataInputStream(new BufferedInputStream(StreamOpener.fileThenResource.openForRead(resourceName)));
        this.recordList = new ArrayList<V>();
        GeoRecordListForStream.readInFile(streamConverter, geoStream, this.recordList);
        this.filteredRecordList = this.recordList;
        geoStream.close();
    }

    public GeoRecordListForStream(StreamToGeoObjectConverter<V> streamConverter, InputStream stream) throws IOException {
        DataInputStream encStream = new DataInputStream(stream);
        this.recordList = new ArrayList<V>();
        GeoRecordListForStream.readInFile(streamConverter, encStream, this.recordList);
        this.filteredRecordList = this.recordList;
    }

    public GeoRecordListForStream(List<V> recordList) {
        this.recordList = recordList;
        this.filteredRecordList = recordList;
    }

    public void add(List<V> newRecordList) {
        this.recordList.addAll(newRecordList);
    }

    public void add(StreamToGeoObjectConverter<V> streamConverter, InputStream stream) throws IOException {
        DataInputStream geoStream = new DataInputStream(stream);
        GeoRecordListForStream.readInFile(streamConverter, geoStream, this.recordList);
    }

    public void add(StreamToGeoObjectConverter<V> streamConverter, String resourceName) throws IOException {
        DataInputStream geoStream = new DataInputStream(new BufferedInputStream(StreamOpener.fileThenResource.openForRead(resourceName)));
        GeoRecordListForStream.readInFile(streamConverter, geoStream, this.recordList);
        this.filteredRecordList = this.recordList;
        geoStream.close();
    }

    @Override
    public void applyFilter(GeoFilter<V> filter, boolean clobber) {
        List<V> listToFilter = clobber ? this.recordList : this.filteredRecordList;
        this.filteredRecordList = GeoRecordListForStream.filterList(filter, listToFilter, null);
    }

    @Override
    public void clearAllFilters() {
        this.filteredRecordList = this.recordList;
    }

    @Override
    public int size() {
        return this.filteredRecordList.size();
    }

    @Override
    public V get(int index) throws IOException {
        return (V)((GeoObject)this.filteredRecordList.get(index));
    }

    @Override
    public Iterator<V> iterator() {
        return new Iterator<V>(){
            private int recordIndex = -1;
            private V next = this.internalNext();

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public V next() {
                Object current = this.next;
                this.next = this.internalNext();
                return current;
            }

            private V internalNext() {
                if (this.recordIndex + 1 < GeoRecordListForStream.this.filteredRecordList.size()) {
                    return (GeoObject)GeoRecordListForStream.this.filteredRecordList.get(++this.recordIndex);
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported");
            }
        };
    }

    @Override
    public GeoObjectIterator geoObjectIterator() throws IOException {
        return new GeoObjectIterator(){
            private int recordIndex = -1;
            private V next = this.internalNext();

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public V nextGeo() {
                Object current = this.next;
                this.next = this.internalNext();
                return current;
            }

            private V internalNext() {
                if (this.recordIndex + 1 < GeoRecordListForStream.this.filteredRecordList.size()) {
                    return (GeoObject)GeoRecordListForStream.this.filteredRecordList.get(++this.recordIndex);
                }
                return null;
            }
        };
    }

    private static <T extends GeoObject> void readInFile(StreamToGeoObjectConverter<T> loader, DataInputStream geoStream, List<T> recordList) throws IOException {
        while (geoStream.available() > 0) {
            recordList.add(loader.readNext(geoStream));
        }
    }

    private static <T extends GeoObject> List<T> filterList(GeoFilter filter, List<T> recordList, List<T> filteredRecordList) {
        if (filteredRecordList == null) {
            filteredRecordList = new ArrayList<T>(recordList.size());
        }
        for (GeoObject object : recordList) {
            if (!filter.passGeoFilter(object)) continue;
            filteredRecordList.add(object);
        }
        return filteredRecordList;
    }
}

