/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.iteration;

import com.metsci.glimpse.charts.vector.iteration.GeoFilter;
import com.metsci.glimpse.charts.vector.parser.attributes.ENCIntAttribute;
import com.metsci.glimpse.charts.vector.parser.attributes.GeoIntAttribute;
import com.metsci.glimpse.charts.vector.parser.autogen.ENCAttributeType;
import com.metsci.glimpse.charts.vector.parser.objects.ENCObject;
import com.metsci.glimpse.charts.vector.parser.objects.GeoAttributeType;
import com.metsci.glimpse.charts.vector.parser.objects.GeoObject;

public class GeoIntAttributeFilter<V extends GeoObject>
implements GeoFilter<V> {
    private GeoAttributeType intAttributeKey;
    private Operator operator;
    private int comparisonValue;
    private boolean nullsAreTrue;

    public GeoIntAttributeFilter(GeoAttributeType intAttributeKey, Operator operator, int comparisonValue) {
        this(intAttributeKey, operator, comparisonValue, false);
    }

    public GeoIntAttributeFilter(GeoAttributeType intAttributeKey, Operator operator, int comparisonValue, boolean nullsAreTrue) {
        this.intAttributeKey = intAttributeKey;
        this.operator = operator;
        this.comparisonValue = comparisonValue;
        this.nullsAreTrue = nullsAreTrue;
    }

    @Override
    public boolean passGeoFilter(GeoObject geoObject) {
        GeoIntAttribute intAttrib = geoObject.getGeoIntAttribute(this.intAttributeKey);
        if (intAttrib == null || intAttrib.isNullValued()) {
            return this.nullsAreTrue;
        }
        return this.operator.operate(intAttrib.getAttributeValue(), this.comparisonValue);
    }

    public static enum Operator {
        lessThan{

            @Override
            protected boolean operate(int attribValue, int comparisonValue) {
                return attribValue < comparisonValue;
            }
        }
        ,
        lessThanEqualTo{

            @Override
            protected boolean operate(int attribValue, int comparisonValue) {
                return attribValue <= comparisonValue;
            }
        }
        ,
        equalTo{

            @Override
            protected boolean operate(int attribValue, int comparisonValue) {
                return attribValue == comparisonValue;
            }
        }
        ,
        greaterThan{

            @Override
            protected boolean operate(int attribValue, int comparisonValue) {
                return attribValue > comparisonValue;
            }
        }
        ,
        greaterThanEqualTo{

            @Override
            protected boolean operate(int attribValue, int comparisonValue) {
                return attribValue >= comparisonValue;
            }
        }
        ,
        nonNull{

            @Override
            protected boolean operate(int attribValue, int comparisonValue) {
                return true;
            }
        };


        private static ENCIntAttribute extract(ENCObject object, ENCAttributeType intAttribKey) {
            return object.getIntAttribute(intAttribKey);
        }

        protected abstract boolean operate(int var1, int var2);
    }
}

