/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.iteration;

import com.metsci.glimpse.charts.vector.iteration.GeoFilter;
import com.metsci.glimpse.charts.vector.parser.objects.ENCObject;
import com.metsci.glimpse.charts.vector.parser.objects.ENCObjectType;
import com.metsci.glimpse.charts.vector.parser.objects.GeoFeatureType;
import com.metsci.glimpse.charts.vector.parser.objects.GeoObject;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;

public class GeoFilterByFeatureCode<V extends GeoObject>
implements GeoFilter<V> {
    private Set<? extends GeoFeatureType> objectTypeSet;

    protected GeoFilterByFeatureCode(Set<? extends ENCObjectType> objectTypeSet) {
        this.objectTypeSet = objectTypeSet;
    }

    @Override
    public boolean passGeoFilter(V geoObj) {
        return this.objectTypeSet.contains(geoObj.getGeoFeatureType());
    }

    public static class ENCFilterBuilder {
        private Set<ENCObjectType> objectTypeSet;

        public static ENCFilterBuilder allOff() {
            EnumSet<ENCObjectType> objectTypeSet = EnumSet.allOf(ENCObjectType.class);
            return new ENCFilterBuilder(objectTypeSet);
        }

        public static ENCFilterBuilder noneOff() {
            EnumSet<ENCObjectType> objectTypeSet = EnumSet.noneOf(ENCObjectType.class);
            return new ENCFilterBuilder(objectTypeSet);
        }

        public ENCFilterBuilder(Set<ENCObjectType> objectTypeSet) {
            this.objectTypeSet = objectTypeSet;
        }

        public GeoFilterByFeatureCode<ENCObject> build() {
            return new GeoFilterByFeatureCode<ENCObject>(this.objectTypeSet);
        }

        public ENCFilterBuilder addType(ENCObjectType type) {
            this.objectTypeSet.add(type);
            return this;
        }

        public ENCFilterBuilder addTypes(ENCObjectType ... types) {
            this.objectTypeSet.addAll(Arrays.asList(types));
            return this;
        }

        public ENCFilterBuilder removeType(ENCObjectType type) {
            this.objectTypeSet.remove(type);
            return this;
        }

        public ENCFilterBuilder removeTypes(ENCObjectType ... types) {
            this.objectTypeSet.removeAll(Arrays.asList(types));
            return this;
        }
    }
}

