/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.display.examplesupport;

import com.metsci.glimpse.charts.raster.BsbRasterData;
import com.metsci.glimpse.charts.vector.display.examplesupport.MapInfo;
import com.metsci.glimpse.charts.vector.iteration.DNCObjectLoader;
import com.metsci.glimpse.charts.vector.iteration.ENCObjectLoader;
import com.metsci.glimpse.charts.vector.iteration.GeoObjectIterator;
import com.metsci.glimpse.charts.vector.iteration.GeoStreamIterator;
import com.metsci.glimpse.charts.vector.iteration.StreamToGeoObjectConverter;
import com.metsci.glimpse.charts.vector.parser.objects.DNCObject;
import com.metsci.glimpse.charts.vector.parser.objects.ENCObject;
import com.metsci.glimpse.charts.vector.parser.objects.GeoObject;
import com.metsci.glimpse.util.io.StreamOpener;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;

public class ResourceBasedMapInfo<V extends GeoObject>
implements MapInfo<V> {
    private StreamOpener streamOpener = StreamOpener.fileThenResource;
    private String encResource;
    private String ndgcResource;
    private String bsbResource;
    private StreamToGeoObjectConverter<V> converter;

    public static MapInfo<ENCObject> createENCMapInfo(String resourceRoot, String resourcePath) {
        return new ResourceBasedMapInfo<ENCObject>(new ENCObjectLoader(), new String[]{".enc", "_bin.txt"}, resourceRoot, resourcePath);
    }

    public static MapInfo<DNCObject> createDNCMapInfo(String resourceRoot, String resourcePath) {
        return new ResourceBasedMapInfo<DNCObject>(new DNCObjectLoader(), new String[]{".dnc"}, resourceRoot, resourcePath);
    }

    public ResourceBasedMapInfo(StreamToGeoObjectConverter<V> converter, String[] fileSuffixes, String resourceRoot, String resourcePath) {
        String bsbResource;
        String ndgcResource;
        this.converter = converter;
        String prefix = "";
        if (resourcePath != null) {
            prefix = resourcePath + "/";
        }
        String geoResource = null;
        for (String fileSuffix : fileSuffixes) {
            geoResource = prefix + resourceRoot + fileSuffix;
            if (this.doesResourceExist(geoResource)) break;
            geoResource = null;
        }
        if (!this.doesResourceExist(ndgcResource = prefix + resourceRoot + ".ndgc")) {
            ndgcResource = null;
        }
        if (!this.doesResourceExist(bsbResource = prefix + resourceRoot + ".KAP")) {
            bsbResource = null;
        }
        this.commonConstructor(resourceRoot, null, geoResource, ndgcResource, bsbResource);
    }

    public void commonConstructor(String publicName, Rectangle2D coverageRect, String encResource, String ndgcResource, String bsbResource) {
        this.encResource = encResource;
        this.ndgcResource = ndgcResource;
        this.bsbResource = bsbResource;
    }

    @Override
    public boolean hasGeoIterator() {
        return this.encResource != null;
    }

    @Override
    public GeoObjectIterator<V> getGeoIterator() throws IOException {
        if (this.encResource != null) {
            return new GeoStreamIterator<V>(this.encResource, this.converter);
        }
        return null;
    }

    @Override
    public boolean hasBsbRasterData() {
        return this.bsbResource != null;
    }

    @Override
    public BsbRasterData getBsbRasterData() throws IOException {
        if (this.bsbResource != null) {
            return BsbRasterData.readImage(this.streamOpener.openForRead(this.bsbResource));
        }
        return null;
    }

    @Override
    public String getNdgcResourceName() throws IOException {
        return this.ndgcResource;
    }

    private boolean doesResourceExist(String resourceName) {
        try {
            InputStream stream = this.streamOpener.openForRead(resourceName);
            stream.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }
}

