/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.display.examplesupport;

import com.metsci.glimpse.charts.vector.display.examplesupport.SelectedShapeChange;
import com.metsci.glimpse.charts.vector.display.examplesupport.UpdateListener;
import com.metsci.glimpse.charts.vector.display.examplesupport.UpdatePublisher;
import com.metsci.glimpse.charts.vector.iteration.GeoRecordList;
import com.metsci.glimpse.charts.vector.parser.objects.GeoObject;
import com.metsci.glimpse.charts.vector.parser.objects.GeoShape;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ObjectSelectPanel<V extends GeoObject>
extends JPanel {
    private static Logger logger = Logger.getLogger(ObjectSelectPanel.class.toString());
    private JList list;
    private AListModel listModel;
    private GeoRecordList<V> recordList;
    private boolean dontpublish = false;
    private boolean iAmPublishing = false;

    public ObjectSelectPanel(final UpdatePublisher<SelectedShapeChange<V>> publisher) {
        this.setLayout(new BorderLayout());
        this.listModel = new AListModel();
        this.list = new JList(this.listModel);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (ObjectSelectPanel.this.dontpublish) {
                    return;
                }
                try {
                    ObjectSelectPanel.this.iAmPublishing = true;
                    int selectedIndex = ObjectSelectPanel.this.list.getSelectedIndex();
                    publisher.notifyUpdateOccurred(new SelectedShapeChange(selectedIndex, ObjectSelectPanel.this.recordList.get(selectedIndex)));
                    ObjectSelectPanel.this.iAmPublishing = false;
                }
                catch (IOException ex) {
                    logger.log(Level.WARNING, null, ex);
                }
            }
        });
        JScrollPane scroll = new JScrollPane(this.list);
        this.add((Component)scroll, "Center");
    }

    public void setList(GeoRecordList<V> recordList) throws IOException {
        this.recordList = recordList;
        String[] textDescription = new String[recordList.size()];
        int size = recordList.size();
        for (int i = 0; i < size; ++i) {
            V geoObject = recordList.get(i);
            StringBuilder sb = new StringBuilder();
            sb.append(i);
            sb.append(": ");
            sb.append(geoObject.getGeoFeatureType().name());
            sb.append(": ");
            for (GeoShape geoShape : geoObject.getGeoShapes()) {
                sb.append(' ');
                sb.append(geoShape.getShapeType().name());
            }
            textDescription[i] = sb.toString();
        }
        this.listModel.setTextDescription(textDescription);
    }

    private void selectObject(int indexInFile, V encObject) {
        this.dontpublish = true;
        this.list.setSelectedIndex(indexInFile);
        this.list.ensureIndexIsVisible(indexInFile);
        this.dontpublish = false;
    }

    public UpdateListener<SelectedShapeChange<V>> getSelectedShapeListener() {
        return new UpdateListener<SelectedShapeChange<V>>(){

            @Override
            public void updateOccurred(SelectedShapeChange<V> ssc) {
                if (!ObjectSelectPanel.this.iAmPublishing) {
                    ObjectSelectPanel.this.selectObject(ssc.getIndexInFile(), ssc.getGeoObject());
                }
            }
        };
    }

    private static class AListModel
    extends AbstractListModel {
        private String[] textDescription;

        public AListModel() {
            this(new String[0]);
        }

        public AListModel(String[] textDescription) {
            this.setTextDescription(textDescription);
        }

        @Override
        public int getSize() {
            return this.textDescription.length;
        }

        @Override
        public Object getElementAt(int index) {
            return this.textDescription[index];
        }

        public void setTextDescription(String[] textDescription) {
            this.textDescription = textDescription;
            this.fireContentsChanged(this, 0, textDescription.length - 1);
        }
    }
}

