/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.charts.vector.display.examplesupport;

import com.metsci.glimpse.axis.UpdateMode;
import com.metsci.glimpse.canvas.SwingGlimpseCanvas;
import com.metsci.glimpse.charts.vector.display.BasicSkin;
import com.metsci.glimpse.charts.vector.display.BasicSkinHelper;
import com.metsci.glimpse.charts.vector.display.ColorPalette;
import com.metsci.glimpse.charts.vector.display.ContentHandler;
import com.metsci.glimpse.charts.vector.display.DummySkin;
import com.metsci.glimpse.charts.vector.display.Skin;
import com.metsci.glimpse.charts.vector.display.examplesupport.BoundingBox;
import com.metsci.glimpse.charts.vector.display.examplesupport.SelectableComboItem;
import com.metsci.glimpse.charts.vector.display.examplesupport.SelectedShapeChange;
import com.metsci.glimpse.charts.vector.display.examplesupport.UpdateListener;
import com.metsci.glimpse.charts.vector.iteration.GeoFilterableRecordList;
import com.metsci.glimpse.charts.vector.painter.EncChartPainter;
import com.metsci.glimpse.charts.vector.painter.EncPainterUtils;
import com.metsci.glimpse.charts.vector.parser.objects.GeoObject;
import com.metsci.glimpse.charts.vector.parser.objects.GeoShape;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.decoration.CopyrightPainter;
import com.metsci.glimpse.painter.info.MeasurementPainter;
import com.metsci.glimpse.plot.MapPlot2D;
import com.metsci.glimpse.util.geo.LatLonGeo;
import com.metsci.glimpse.util.geo.projection.GeoProjection;
import com.metsci.glimpse.util.units.Length;
import com.metsci.glimpse.util.vector.Vector2d;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.xml.bind.JAXBException;
import org.xml.sax.SAXException;

public class ENCDisplayPanel<V extends GeoObject> {
    private static Logger logger = Logger.getLogger(ENCDisplayPanel.class.toString());
    private SwingGlimpseCanvas canvas;
    private GeoProjection projection;
    private GeoFilterableRecordList<V> encList;
    private BasicSkinHelper<V> skinHelper;
    private String skinResource;
    private MapPlot2D geoplot;
    private EncChartPainter<V> backgroundEncPainter;
    private EncChartPainter<V> foregroundEncPainter;
    private V encOnDisplay;
    private List<Skin<V>> selectedForegroundSkins;
    private List<Skin<V>> selectedBackgroundSkins;
    private DelegateSkin<V> normalSkin;
    private DelegateSkin<V> grayscaleSkin;
    private DelegateSkin<V> redHighlightSkin;
    private boolean autoRezoom = false;

    public ENCDisplayPanel(SwingGlimpseCanvas canvas, GeoProjection projection, GeoFilterableRecordList<V> sourceENCList, String skinResource, BasicSkinHelper<V> skinHelper) throws Exception {
        this.canvas = canvas;
        this.projection = projection;
        this.encList = sourceENCList;
        this.skinHelper = skinHelper;
        this.skinResource = skinResource;
        this.loadSkins();
        GlimpseLayout plot = this.buildGeoPlot(projection);
        this.canvas.addLayout(plot);
        this.backgroundEncPainter.addENCObjects(sourceENCList.iterator());
        this.canvas.setPreferredSize(new Dimension(500, 500));
    }

    public void displayForegroundPainter(boolean isVisible) {
        this.foregroundEncPainter.setVisible(isVisible);
    }

    public void setAutoRezoom(boolean auto_rezoom) {
        this.autoRezoom = auto_rezoom;
    }

    private void loadSkins() throws JAXBException, IOException, SAXException {
        logger.fine("loading skin resource " + this.skinResource);
        this.normalSkin = new DelegateSkin<V>(new BasicSkin<V>(this.skinHelper, this.skinResource));
        this.grayscaleSkin = new DelegateSkin<V>(this.skinHelper.createDefaultHardCodedSkin(ColorPalette.createGrayscaleColorPalette()));
        this.redHighlightSkin = new DelegateSkin(new DummySkin(Color.red));
    }

    public void reloadSkins() throws Exception {
        this.normalSkin.setSkin(new BasicSkin<V>(this.skinHelper, this.skinResource));
        this.grayscaleSkin.setSkin(this.skinHelper.createDefaultHardCodedSkin(ColorPalette.createGrayscaleColorPalette()));
        this.redHighlightSkin.setSkin(new DummySkin(Color.red));
        this.backgroundEncPainter.changeSkins(this.encList.iterator(), this.selectedBackgroundSkins);
        if (this.encOnDisplay == null) {
            this.foregroundEncPainter.changeSkins(Collections.emptyList().iterator(), this.selectedForegroundSkins);
        } else {
            this.foregroundEncPainter.changeSkins(Collections.singletonList(this.encOnDisplay).iterator(), this.selectedForegroundSkins);
        }
    }

    public void newENCSource(GeoFilterableRecordList<V> encList) throws Exception {
        this.encList = encList;
        this.backgroundEncPainter.clearAll();
        this.backgroundEncPainter.addENCObjects(encList.iterator());
        this.foregroundEncPainter.clearAll();
        this.encOnDisplay = null;
    }

    public void populateListenBackgroundCombo(JComboBox backgroundCombo) {
        List tmpSelectedBackgroundSkins;
        backgroundCombo.addItem(new SelectableComboItem<List<Skin<V>>>("Color Skin", this.sugar((Skin<V>)this.normalSkin)));
        backgroundCombo.addItem(new SelectableComboItem<List<Skin<V>>>("Grayscale Skin", this.sugar((Skin<V>)this.grayscaleSkin)));
        backgroundCombo.setSelectedIndex(0);
        this.selectedBackgroundSkins = tmpSelectedBackgroundSkins = (List)((SelectableComboItem)backgroundCombo.getSelectedItem()).getItem();
        backgroundCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox combo = (JComboBox)e.getSource();
                SelectableComboItem selectedItem = (SelectableComboItem)combo.getSelectedItem();
                ENCDisplayPanel.this.selectedBackgroundSkins = (List)selectedItem.getItem();
                try {
                    ENCDisplayPanel.this.backgroundEncPainter.changeSkins(ENCDisplayPanel.this.encList.iterator(), ENCDisplayPanel.this.selectedBackgroundSkins);
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, null, ex);
                    JOptionPane.showMessageDialog((Component)ENCDisplayPanel.this.canvas, ex.getMessage());
                }
            }
        });
    }

    public void populateListenForegroundCombo(JComboBox foregroundCombo) {
        List tmpSelectedForegroundSkins;
        foregroundCombo.addItem(new SelectableComboItem<List<Skin<V>>>("Red Highlight Skin", this.sugar((Skin<V>)this.redHighlightSkin)));
        foregroundCombo.addItem(new SelectableComboItem<List<Skin<V>>>("Color Skin", this.sugar((Skin<V>)this.normalSkin)));
        foregroundCombo.addItem(new SelectableComboItem<List<Skin<V>>>("Color 1st, Red 2nd", this.sugar((Skin<V>)this.normalSkin, (Skin<V>)this.redHighlightSkin)));
        foregroundCombo.setSelectedIndex(0);
        this.selectedForegroundSkins = tmpSelectedForegroundSkins = (List)((SelectableComboItem)foregroundCombo.getSelectedItem()).getItem();
        foregroundCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox foregroundCombo = (JComboBox)e.getSource();
                SelectableComboItem selectedItem = (SelectableComboItem)foregroundCombo.getSelectedItem();
                ENCDisplayPanel.this.selectedForegroundSkins = (List)selectedItem.getItem();
                try {
                    ENCDisplayPanel.this.foregroundEncPainter.changeSkins(Collections.singleton(ENCDisplayPanel.this.encOnDisplay).iterator(), ENCDisplayPanel.this.selectedForegroundSkins);
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, null, ex);
                    JOptionPane.showMessageDialog((Component)ENCDisplayPanel.this.canvas, ex.getMessage());
                }
            }
        });
    }

    public void positionAxisOnMapCenter() throws IOException {
        Object enc;
        int i;
        int size = this.encList.size();
        if (size == 0) {
            return;
        }
        V bestBoundaryObject = null;
        V secondBestBoundaryObject = null;
        int bestNumVertexes = -1;
        for (i = size - 1; i >= 0; --i) {
            int numVertexes;
            enc = this.encList.get(i);
            if (this.skinHelper.isBestBoundaryType(enc)) {
                bestBoundaryObject = enc;
                break;
            }
            if (!this.skinHelper.isSecondBestBoundaryType(enc) || enc.getGeoShapes().isEmpty() || (numVertexes = enc.getFirstGeoShape().getNumCoordinates()) <= bestNumVertexes) continue;
            secondBestBoundaryObject = enc;
            bestNumVertexes = numVertexes;
        }
        if (bestBoundaryObject != null) {
            this.positionAxisAroundObject(bestBoundaryObject);
        } else if (secondBestBoundaryObject != null) {
            this.positionAxisAroundObject(secondBestBoundaryObject);
        } else {
            int applyCount;
            for (i = size - 1; i >= 0 && (applyCount = this.positionAxisAroundObject(enc = this.encList.get(i))) <= 1; --i) {
            }
        }
    }

    public int positionAxisAroundObject(V object) {
        BoundingBox box = new BoundingBox();
        Collection<? extends GeoShape> shapeList = object.getGeoShapes();
        int applyCount = 0;
        for (GeoShape geoShape : shapeList) {
            int numCoords = geoShape.getNumCoordinates();
            for (int i = 0; i < numCoords; ++i) {
                double currLon = geoShape.getVertex(0, i);
                double currLat = geoShape.getVertex(1, i);
                if (!EncPainterUtils.validateLongitude(currLat) || !EncPainterUtils.validateLatitude(currLat)) continue;
                Vector2d xy = this.projection.project(LatLonGeo.fromDeg((double)currLat, (double)currLon));
                box.applyPoint(xy.getX(), xy.getY());
                ++applyCount;
            }
        }
        if (applyCount == 0) {
            return applyCount;
        }
        double xDist = box.getMaxX() - box.getMinX();
        if (xDist == 0.0) {
            xDist = Length.fromNauticalMiles((double)60.0);
        }
        double minX = box.getMinX() - xDist * 0.1;
        double maxX = box.getMaxX() + xDist * 0.1;
        double yDist = box.getMaxY() - box.getMinY();
        if (yDist == 0.0) {
            yDist = Length.fromNauticalMiles((double)60.0);
        }
        double minY = box.getMinY() - yDist * 0.1;
        double maxY = box.getMaxY() + yDist * 0.1;
        this.geoplot.getAxisX().setMin(minX);
        this.geoplot.getAxisY().setMin(minY);
        this.geoplot.getAxisX().setMax(maxX);
        this.geoplot.getAxisY().setMax(maxY);
        this.geoplot.validate();
        return applyCount;
    }

    public void drawObject(V enc) {
        if (this.encOnDisplay != null) {
            this.foregroundEncPainter.clearAll();
        }
        this.encOnDisplay = enc;
        this.foregroundEncPainter.addENCObject(this.encOnDisplay);
        if (this.autoRezoom) {
            this.positionAxisAroundObject(this.encOnDisplay);
        }
    }

    public JPanel getPanel() {
        return this.canvas;
    }

    public void setZoomAdjustedDisplay(boolean zoomAdjust) {
        this.backgroundEncPainter.setZoomAdjustedDisplay(zoomAdjust);
    }

    private GlimpseLayout buildGeoPlot(GeoProjection project) throws Exception {
        this.geoplot = new MapPlot2D(project);
        this.backgroundEncPainter = new EncChartPainter(project, Collections.singletonList(this.normalSkin));
        this.geoplot.addPainter(this.backgroundEncPainter);
        this.foregroundEncPainter = new EncChartPainter(project, Collections.singletonList(this.redHighlightSkin));
        this.foregroundEncPainter.setZoomAdjustedDisplay(false);
        this.geoplot.addPainter(this.foregroundEncPainter);
        this.geoplot.addPainter((GlimpsePainter)new CopyrightPainter());
        this.geoplot.addPainter((GlimpsePainter)new MeasurementPainter("m"));
        this.geoplot.lockAspectRatioXY(1.0);
        this.geoplot.setUpdateModeXY(UpdateMode.CenterScale);
        this.geoplot.setTitle(this.skinHelper.geoName() + " Object viewer");
        this.geoplot.getCrosshairPainter().setVisible(false);
        return this.geoplot;
    }

    private Skin<V>[] sugar(Skin<V> ... skins) {
        return skins;
    }

    private List<Skin<V>> sugar(Skin<V> skin) {
        return Collections.singletonList(skin);
    }

    private List<Skin<V>> sugar(Skin<V> skin, Skin<V> skin2) {
        ArrayList<Skin<V>> skinList = new ArrayList<Skin<V>>();
        skinList.add(skin);
        skinList.add(skin2);
        return skinList;
    }

    public UpdateListener<SelectedShapeChange<V>> getSelectedShapeListener() {
        return new UpdateListener<SelectedShapeChange<V>>(){

            @Override
            public void updateOccurred(SelectedShapeChange<V> newShape) {
                ENCDisplayPanel.this.drawObject(newShape.getGeoObject());
            }
        };
    }

    private static class DelegateSkin<V extends GeoObject>
    implements Skin<V> {
        private Skin<V> innerSkin;

        public DelegateSkin(Skin<V> innerSkin) {
            this.innerSkin = innerSkin;
        }

        public void setSkin(Skin<V> innerSkin) {
            this.innerSkin = innerSkin;
        }

        @Override
        public List<ContentHandler<V>> getHandlersForGeoObject(V encObject) {
            return this.innerSkin.getHandlersForGeoObject(encObject);
        }

        @Override
        public void reset() {
            this.innerSkin.reset();
        }
    }
}

